/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.file.FileStatus;

public final class StatusInformation {
    private File file;
    private FileStatus status;
    private String workingRevision;
    private String repositoryRevision;
    private String repositoryFileName;
    private String stickyDate;
    private String stickyOptions;
    private String stickyTag;
    private List<SymName> tags;
    private StringBuffer symNamesBuffer;

    public StatusInformation() {
        this.setAllExistingTags(null);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileStatus getStatus() {
        return this.status;
    }

    public void setStatus(FileStatus status) {
        this.status = status;
    }

    private String getStatusString() {
        if (this.status == null) {
            return null;
        }
        return this.status.toString();
    }

    public void setStatusString(String statusString) {
        this.setStatus(FileStatus.getStatusForString(statusString));
    }

    public String getWorkingRevision() {
        return this.workingRevision;
    }

    public void setWorkingRevision(String workingRevision) {
        this.workingRevision = workingRevision;
    }

    public String getRepositoryRevision() {
        return this.repositoryRevision;
    }

    public void setRepositoryRevision(String repositoryRevision) {
        this.repositoryRevision = repositoryRevision;
    }

    public String getRepositoryFileName() {
        return this.repositoryFileName;
    }

    public void setRepositoryFileName(String repositoryFileName) {
        this.repositoryFileName = repositoryFileName;
    }

    public String getStickyTag() {
        return this.stickyTag;
    }

    public void setStickyTag(String stickyTag) {
        this.stickyTag = stickyTag;
    }

    public String getStickyDate() {
        return this.stickyDate;
    }

    public void setStickyDate(String stickyDate) {
        this.stickyDate = stickyDate;
    }

    public String getStickyOptions() {
        return this.stickyOptions;
    }

    public void setStickyOptions(String stickyOptions) {
        this.stickyOptions = stickyOptions;
    }

    public void addExistingTag(String tagName, String revisionNumber) {
        if (this.symNamesBuffer == null) {
            this.symNamesBuffer = new StringBuffer();
        }
        this.symNamesBuffer.append(tagName);
        this.symNamesBuffer.append(" ");
        this.symNamesBuffer.append(revisionNumber);
        this.symNamesBuffer.append("\n");
    }

    private void createSymNames() {
        this.tags = new LinkedList<SymName>();
        if (this.symNamesBuffer == null) {
            return;
        }
        int length = 0;
        int lastLength = 0;
        while (length < this.symNamesBuffer.length()) {
            while (length < this.symNamesBuffer.length() && this.symNamesBuffer.charAt(length) != '\n') {
                ++length;
            }
            if (length <= lastLength) continue;
            String line = this.symNamesBuffer.substring(lastLength, length);
            String symName = line.substring(0, line.indexOf(32));
            String revisionNumber = line.substring(line.indexOf(32) + 1);
            SymName newName = new SymName();
            newName.setTag(symName);
            newName.setRevision(revisionNumber);
            this.tags.add(newName);
            lastLength = length + 1;
            ++length;
        }
        this.symNamesBuffer = null;
    }

    public List<SymName> getAllExistingTags() {
        if (this.tags == null) {
            this.createSymNames();
        }
        return this.tags;
    }

    private void setAllExistingTags(List<SymName> tags) {
        this.tags = tags;
    }

    public List<SymName> getSymNamesForRevision(String revNumber) {
        if (this.tags == null) {
            this.createSymNames();
        }
        LinkedList<SymName> list = new LinkedList<SymName>();
        for (SymName item : this.tags) {
            if (!item.getRevision().equals(revNumber)) continue;
            list.add(item);
        }
        return list;
    }

    public SymName getSymNameForTag(String tagName) {
        if (this.tags == null) {
            this.createSymNames();
        }
        for (SymName item : this.tags) {
            if (!item.getTag().equals(tagName)) continue;
            return item;
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nFile: ");
        buf.append(this.file != null ? this.file.getAbsolutePath() : "null");
        buf.append("\nStatus is: ");
        buf.append(this.getStatusString());
        buf.append("\nWorking revision: ");
        buf.append(this.workingRevision);
        buf.append("\nRepository revision: ");
        buf.append("\nSticky date: ");
        buf.append(this.stickyDate);
        buf.append("\nSticky options: ");
        buf.append(this.stickyOptions);
        buf.append("\nSticky tag: ");
        buf.append(this.stickyTag);
        if (this.tags != null && !this.tags.isEmpty()) {
            buf.append("\nExisting Tags:");
            for (SymName tag : this.tags) {
                buf.append("\n  ");
                buf.append(tag.toString());
            }
        }
        return buf.toString();
    }

    public static final class SymName {
        private String tag;
        private String revision;

        private SymName() {
        }

        public String getTag() {
            return this.tag;
        }

        private void setTag(String symName) {
            this.tag = symName;
        }

        private void setRevision(String rev) {
            this.revision = rev;
        }

        public String getRevision() {
            return this.revision;
        }

        public String toString() {
            return this.getTag() + " : " + this.getRevision();
        }
    }
}

