/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeProvider;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitRebaseProcess.class);
    private final NotificationAction ABORT_ACTION;
    private final NotificationAction CONTINUE_ACTION;
    private final NotificationAction RETRY_ACTION;
    private final NotificationAction VIEW_STASH_ACTION;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitRebaseSpec myRebaseSpec;
    @Nullable
    private final GitRebaseResumeMode myCustomMode;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final ProgressManager myProgressManager;
    @NotNull
    private final VcsDirtyScopeManager myDirtyScopeManager;

    public GitRebaseProcess(@NotNull Project project, @NotNull GitRebaseSpec rebaseSpec, @Nullable GitRebaseResumeMode customMode) {
        if (project == null) {
            GitRebaseProcess.$$$reportNull$$$0(0);
        }
        if (rebaseSpec == null) {
            GitRebaseProcess.$$$reportNull$$$0(1);
        }
        this.ABORT_ACTION = NotificationAction.create((String)"Abort", (event, notification) -> {
            this.abort();
            notification.expire();
        });
        this.CONTINUE_ACTION = NotificationAction.create((String)"Continue", (event, notification) -> {
            this.retry("Continue Rebase Process...");
            notification.expire();
        });
        this.RETRY_ACTION = NotificationAction.create((String)"Retry", (event, notification) -> {
            this.retry("Retry Rebase Process...");
            notification.expire();
        });
        this.VIEW_STASH_ACTION = new NotificationAction("View Stash..."){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                GitRebaseProcess.this.mySaver.showSavedChanges();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "git4idea/rebase/GitRebaseProcess$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myProject = project;
        this.myRebaseSpec = rebaseSpec;
        this.myCustomMode = customMode;
        this.mySaver = rebaseSpec.getSaver();
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myProgressManager = ProgressManager.getInstance();
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
    }

    public void rebase() {
        new GitFreezingProcess(this.myProject, "rebase", this::doRebase).execute();
    }

    private void doRebase() {
        LOG.info("Started rebase");
        LOG.debug("Started rebase with the following spec: " + this.myRebaseSpec);
        LinkedHashMap statuses = ContainerUtil.newLinkedHashMap(this.myRebaseSpec.getStatuses());
        List<GitRepository> repositoriesToRebase = this.myRepositoryManager.sortByDependency(this.myRebaseSpec.getIncompleteRepositories());
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"Rebase");){
            GitRebaseStatus.Type latestStatus;
            if (!this.saveDirtyRootsInitially(repositoriesToRebase)) {
                return;
            }
            GitRepository latestRepository = null;
            for (GitRepository repository : repositoriesToRebase) {
                GitRebaseResumeMode customMode = null;
                if (repository == this.myRebaseSpec.getOngoingRebase()) {
                    customMode = this.myCustomMode == null ? GitRebaseResumeMode.CONTINUE : this.myCustomMode;
                }
                Collection<Change> changes = this.collectFutureChanges(repository);
                GitRebaseStatus rebaseStatus = this.rebaseSingleRoot(repository, customMode, GitRebaseProcess.getSuccessfulRepositories(statuses));
                repository.update();
                if (customMode == GitRebaseResumeMode.CONTINUE) {
                    this.myDirtyScopeManager.dirDirtyRecursively(repository.getRoot());
                }
                latestRepository = repository;
                statuses.put(repository, rebaseStatus);
                if (GitRebaseProcess.shouldBeRefreshed(rebaseStatus)) {
                    GitUtil.refreshVfs(repository.getRoot(), changes);
                }
                if (rebaseStatus.getType() == GitRebaseStatus.Type.SUCCESS) continue;
                break;
            }
            if ((latestStatus = ((GitRebaseStatus)statuses.get(latestRepository)).getType()) == GitRebaseStatus.Type.SUCCESS || latestStatus == GitRebaseStatus.Type.NOT_STARTED) {
                LOG.debug("Rebase completed successfully.");
                this.mySaver.load();
            }
            if (latestStatus == GitRebaseStatus.Type.SUCCESS) {
                this.notifySuccess(GitRebaseProcess.getSuccessfulRepositories(statuses), GitRebaseProcess.getSkippedCommits(statuses));
            }
            this.saveUpdatedSpec(statuses);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
            ExceptionUtil.rethrowUnchecked((Throwable)e);
        }
    }

    @Nullable
    private Collection<Change> collectFutureChanges(@NotNull GitRepository repository) {
        String rev2;
        String rev1;
        Collection<Change> changesFromRebase;
        GitRebaseParams params;
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(2);
        }
        if ((params = this.myRebaseSpec.getParams()) == null) {
            return null;
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        String branch = params.getBranch();
        if (branch != null) {
            Collection<Change> changesFromCheckout = GitChangeUtils.getDiff(repository, "HEAD", branch, false);
            if (changesFromCheckout == null) {
                return null;
            }
            changes.addAll(changesFromCheckout);
        }
        if ((changesFromRebase = GitChangeUtils.getDiff(repository, rev1 = (String)ObjectUtils.coalesce((Object)params.getNewBase(), (Object)branch, (Object)"HEAD"), rev2 = params.getUpstream(), false)) == null) {
            return null;
        }
        changes.addAll(changesFromRebase);
        return changes;
    }

    private void saveUpdatedSpec(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(3);
        }
        if (this.myRebaseSpec.shouldBeSaved()) {
            GitRebaseSpec newRebaseInfo = this.myRebaseSpec.cloneWithNewStatuses(statuses);
            this.myRepositoryManager.setOngoingRebaseSpec(newRebaseInfo);
        } else {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
        }
    }

    @NotNull
    private GitRebaseStatus rebaseSingleRoot(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode customMode, @NotNull Map<GitRepository, GitSuccessfulRebase> alreadyRebased) {
        GitRebaseStatus.Type type;
        boolean somethingRebased;
        GitCommandResult result2;
        MultiMap<GitRepository, GitRebaseUtils.CommitInfo> allSkippedCommits;
        ArrayList skippedCommits;
        String repoName;
        block22: {
            ResolveConflictResult resolveResult;
            if (repository == null) {
                GitRebaseProcess.$$$reportNull$$$0(4);
            }
            if (alreadyRebased == null) {
                GitRebaseProcess.$$$reportNull$$$0(5);
            }
            VirtualFile root = repository.getRoot();
            repoName = DvcsUtil.getShortRepositoryName((Repository)repository);
            LOG.info("Rebasing root " + repoName + ", mode: " + ObjectUtils.notNull((Object)((Object)customMode), (Object)"standard"));
            skippedCommits = ContainerUtilRt.newArrayList();
            allSkippedCommits = GitRebaseProcess.getSkippedCommits(alreadyRebased);
            boolean retryWhenDirty = false;
            while (true) {
                GitRebaseProblemDetector rebaseDetector = new GitRebaseProblemDetector();
                GitUntrackedFilesOverwrittenByOperationDetector untrackedDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitRebaseProgressListener progressListener = new GitRebaseProgressListener();
                GitRebaseCommandResult rebaseCommandResult = this.callRebase(repository, customMode, rebaseDetector, untrackedDetector, progressListener);
                result2 = rebaseCommandResult.getCommandResult();
                boolean bl = somethingRebased = customMode != null || progressListener.currentCommit > 1;
                if (rebaseCommandResult.wasCancelledInCommitList()) {
                    GitRebaseStatus gitRebaseStatus = GitRebaseStatus.notStarted();
                    if (gitRebaseStatus == null) {
                        GitRebaseProcess.$$$reportNull$$$0(6);
                    }
                    return gitRebaseStatus;
                }
                if (rebaseCommandResult.wasCancelledInCommitMessage()) {
                    this.showStoppedForEditingMessage();
                    GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
                    if (gitRebaseStatus == null) {
                        GitRebaseProcess.$$$reportNull$$$0(7);
                    }
                    return gitRebaseStatus;
                }
                if (result2.success()) {
                    if (rebaseDetector.hasStoppedForEditing()) {
                        this.showStoppedForEditingMessage();
                        GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
                        if (gitRebaseStatus == null) {
                            GitRebaseProcess.$$$reportNull$$$0(8);
                        }
                        return gitRebaseStatus;
                    }
                    LOG.debug("Successfully rebased " + repoName);
                    GitSuccessfulRebase gitSuccessfulRebase = GitSuccessfulRebase.parseFromOutput(result2.getOutput(), skippedCommits);
                    if (gitSuccessfulRebase == null) {
                        GitRebaseProcess.$$$reportNull$$$0(9);
                    }
                    return gitSuccessfulRebase;
                }
                if (rebaseDetector.isDirtyTree() && customMode == null && !retryWhenDirty) {
                    LOG.debug("Dirty tree detected in " + repoName);
                    String saveError = this.saveLocalChanges(Collections.singleton(repository.getRoot()));
                    if (saveError == null) {
                        retryWhenDirty = true;
                        continue;
                    }
                    LOG.warn("Couldn't " + this.mySaver.getOperationName() + " root " + repository.getRoot() + ": " + saveError);
                    this.showFatalError(saveError, repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                    GitRebaseStatus.Type type2 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type2, skippedCommits);
                    if (gitRebaseStatus == null) {
                        GitRebaseProcess.$$$reportNull$$$0(10);
                    }
                    return gitRebaseStatus;
                }
                if (untrackedDetector.wasMessageDetected()) {
                    LOG.info("Untracked files detected in " + repoName);
                    this.showUntrackedFilesError(untrackedDetector.getRelativeFilePaths(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                    type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type, skippedCommits);
                    if (gitRebaseStatus == null) {
                        GitRebaseProcess.$$$reportNull$$$0(11);
                    }
                    return gitRebaseStatus;
                }
                if (rebaseDetector.isNoChangeError()) {
                    LOG.info("'No changes' situation detected in " + repoName);
                    GitRebaseUtils.CommitInfo currentRebaseCommit = GitRebaseUtils.getCurrentRebaseCommit(this.myProject, root);
                    if (currentRebaseCommit != null) {
                        skippedCommits.add(currentRebaseCommit);
                    }
                    customMode = GitRebaseResumeMode.SKIP;
                    continue;
                }
                if (!rebaseDetector.isMergeConflict()) break block22;
                LOG.info("Merge conflict in " + repoName);
                resolveResult = this.showConflictResolver(repository, false);
                if (resolveResult != ResolveConflictResult.ALL_RESOLVED) break;
                customMode = GitRebaseResumeMode.CONTINUE;
            }
            if (resolveResult == ResolveConflictResult.NOTHING_TO_MERGE) {
                LOG.info("Unmerged changes while rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
                this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                GitRebaseStatus.Type type3 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type3, skippedCommits);
                if (gitRebaseStatus == null) {
                    GitRebaseProcess.$$$reportNull$$$0(12);
                }
                return gitRebaseStatus;
            }
            this.notifyNotAllConflictsResolved(repository, allSkippedCommits);
            GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
            if (gitRebaseStatus == null) {
                GitRebaseProcess.$$$reportNull$$$0(13);
            }
            return gitRebaseStatus;
        }
        LOG.info("Error rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
        this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
        type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
        GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type, skippedCommits);
        if (gitRebaseStatus == null) {
            GitRebaseProcess.$$$reportNull$$$0(14);
        }
        return gitRebaseStatus;
    }

    @NotNull
    private GitRebaseCommandResult callRebase(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode mode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(15);
        }
        if (listeners == null) {
            GitRebaseProcess.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            GitRebaseParams params = (GitRebaseParams)ObjectUtils.assertNotNull((Object)this.myRebaseSpec.getParams());
            GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebase(repository, params, listeners);
            if (gitRebaseCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(17);
            }
            return gitRebaseCommandResult;
        }
        if (mode == GitRebaseResumeMode.SKIP) {
            GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebaseSkip(repository, listeners);
            if (gitRebaseCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(18);
            }
            return gitRebaseCommandResult;
        }
        LOG.assertTrue(mode == GitRebaseResumeMode.CONTINUE, (Object)("Unexpected rebase mode: " + (Object)((Object)mode)));
        GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebaseContinue(repository, listeners);
        if (gitRebaseCommandResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(19);
        }
        return gitRebaseCommandResult;
    }

    @VisibleForTesting
    @NotNull
    protected Collection<GitRepository> getDirtyRoots(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(20);
        }
        Collection<GitRepository> collection = this.findRootsWithLocalChanges(repositories);
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(21);
        }
        return collection;
    }

    private static boolean shouldBeRefreshed(@NotNull GitRebaseStatus rebaseStatus) {
        if (rebaseStatus == null) {
            GitRebaseProcess.$$$reportNull$$$0(22);
        }
        return rebaseStatus.getType() != GitRebaseStatus.Type.SUCCESS || ((GitSuccessfulRebase)rebaseStatus).getSuccessType() != GitSuccessfulRebase.SuccessType.UP_TO_DATE;
    }

    private boolean saveDirtyRootsInitially(@NotNull List<GitRepository> repositories) {
        List repositoriesToSave;
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(23);
        }
        if ((repositoriesToSave = ContainerUtil.filter(repositories, repository -> !repository.equals(this.myRebaseSpec.getOngoingRebase()))).isEmpty()) {
            return true;
        }
        Collection<VirtualFile> rootsToSave = GitUtil.getRootsFromRepositories(this.getDirtyRoots(repositoriesToSave));
        String error = this.saveLocalChanges(rootsToSave);
        if (error != null) {
            this.myNotifier.notifyError("Rebase Not Started", error);
            return false;
        }
        return true;
    }

    @Nullable
    private String saveLocalChanges(@NotNull Collection<VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            GitRebaseProcess.$$$reportNull$$$0(24);
        }
        try {
            this.mySaver.saveLocalChanges(rootsToSave);
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return "Couldn't " + this.mySaver.getSaverName() + " local uncommitted changes:<br/>" + e.getMessage();
        }
    }

    private Collection<GitRepository> findRootsWithLocalChanges(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(25);
        }
        return ContainerUtil.filter(repositories, repository -> this.myChangeListManager.haveChangesUnder(repository.getRoot()) != ThreeState.NO);
    }

    protected void notifySuccess(@NotNull Map<GitRepository, GitSuccessfulRebase> successful, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        String baseBranch;
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(26);
        }
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(27);
        }
        String rebasedBranch = GitRebaseProcess.getCommonCurrentBranchNameIfAllTheSame(this.myRebaseSpec.getAllRepositories());
        List successTypes = ContainerUtil.map(successful.values(), GitSuccessfulRebase::getSuccessType);
        GitSuccessfulRebase.SuccessType commonType = GitRebaseProcess.getItemIfAllTheSame(successTypes, GitSuccessfulRebase.SuccessType.REBASED);
        GitRebaseParams params = this.myRebaseSpec.getParams();
        String string = baseBranch = params == null ? null : (String)ObjectUtils.notNull((Object)params.getNewBase(), (Object)params.getUpstream());
        if ("HEAD".equals(baseBranch)) {
            baseBranch = GitRebaseProcess.getItemIfAllTheSame(this.myRebaseSpec.getInitialBranchNames().values(), baseBranch);
        }
        String message = commonType.formatMessage(rebasedBranch, baseBranch, params != null && params.getBranch() != null);
        message = message + GitRebaseProcess.mentionSkippedCommits(skippedCommits);
        this.myNotifier.notifyMinorInfo("Rebase Successful", message, (NotificationListener)new RebaseNotificationListener(skippedCommits));
    }

    @Nullable
    private static String getCommonCurrentBranchNameIfAllTheSame(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(28);
        }
        return GitRebaseProcess.getItemIfAllTheSame(ContainerUtil.map(repositories, Repository::getCurrentBranchName), null);
    }

    @Contract(value="_, !null -> !null")
    private static <T> T getItemIfAllTheSame(@NotNull Collection<T> collection, @Nullable T defaultItem) {
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(29);
        }
        return (T)(ContainerUtil.newHashSet(collection).size() == 1 ? ContainerUtil.getFirstItem(collection) : defaultItem);
    }

    private void notifyNotAllConflictsResolved(@NotNull GitRepository conflictingRepository, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (conflictingRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(30);
        }
        String description = GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("Rebase Stopped Due to Conflicts", description, NotificationType.WARNING, (NotificationListener)new RebaseNotificationListener(skippedCommits));
        notification.addAction((AnAction)new ResolveAction(conflictingRepository));
        notification.addAction((AnAction)this.CONTINUE_ACTION);
        notification.addAction((AnAction)this.ABORT_ACTION);
        if (this.mySaver.wereChangesSaved()) {
            notification.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification);
    }

    @NotNull
    private ResolveConflictResult showConflictResolver(@NotNull GitRepository conflicting, boolean calledFromNotification) {
        if (conflicting == null) {
            GitRebaseProcess.$$$reportNull$$$0(31);
        }
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject).setMergeDialogCustomizer(new GitRebaseMergeDialogCustomizer(conflicting, this.myRebaseSpec)).setReverse(true);
        RebaseConflictResolver conflictResolver = new RebaseConflictResolver(this.myProject, this.myGit, conflicting, params, calledFromNotification);
        boolean allResolved = conflictResolver.merge();
        if (conflictResolver.myWasNothingToMerge) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.NOTHING_TO_MERGE;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(32);
            }
            return resolveConflictResult;
        }
        if (allResolved) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.ALL_RESOLVED;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(33);
            }
            return resolveConflictResult;
        }
        ResolveConflictResult resolveConflictResult = ResolveConflictResult.UNRESOLVED_REMAIN;
        if (resolveConflictResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(34);
        }
        return resolveConflictResult;
    }

    private void showStoppedForEditingMessage() {
        String description = "";
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("Rebase Stopped for Editing", description, NotificationType.INFORMATION, (NotificationListener)new RebaseNotificationListener((MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)MultiMap.empty()));
        notification.addAction((AnAction)this.CONTINUE_ACTION);
        notification.addAction((AnAction)this.ABORT_ACTION);
        this.myNotifier.notify(notification);
    }

    private void showFatalError(@NotNull String error, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (error == null) {
            GitRebaseProcess.$$$reportNull$$$0(35);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(36);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(37);
        }
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(38);
        }
        String repo = this.myRepositoryManager.moreThanOneRoot() ? DvcsUtil.getShortRepositoryName((Repository)currentRepository) + ": " : "";
        String description = repo + error + "<br/>" + GitRebaseProcess.mentionSkippedCommits(skippedCommits) + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        String title = this.myRebaseSpec.getOngoingRebase() == null ? "Rebase Failed" : "Continue Rebase Failed";
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, description, NotificationType.ERROR, (NotificationListener)new RebaseNotificationListener(skippedCommits));
        notification.addAction((AnAction)this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            notification.addAction((AnAction)this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            notification.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification);
    }

    private void showUntrackedFilesError(@NotNull Set<String> untrackedPaths, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (untrackedPaths == null) {
            GitRebaseProcess.$$$reportNull$$$0(39);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(40);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(41);
        }
        String message = GitRebaseProcess.mentionSkippedCommits(skippedCommits) + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        ArrayList<NotificationAction> actions = new ArrayList<NotificationAction>();
        actions.add(this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            actions.add(this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            actions.add(this.VIEW_STASH_ACTION);
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, currentRepository.getRoot(), untrackedPaths, "rebase", message, (NotificationListener)new RebaseNotificationListener(skippedCommits), actions.toArray(new NotificationAction[0]));
    }

    @NotNull
    private static String mentionSkippedCommits(@NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(42);
        }
        if (skippedCommits.isEmpty()) {
            if ("" == null) {
                GitRebaseProcess.$$$reportNull$$$0(43);
            }
            return "";
        }
        String message = "<br/>";
        message = skippedCommits.values().size() == 1 ? message + "The following commit was skipped during rebase:<br/>" : message + "The following commits were skipped during rebase:<br/>";
        String string = message = message + StringUtil.join((Collection)skippedCommits.values(), commitInfo -> {
            String commitMessage = StringUtil.shortenPathWithEllipsis((String)commitInfo.subject, (int)72, (boolean)true);
            String hash = commitInfo.revision.asString();
            String shortHash = DvcsUtil.getShortHash((String)commitInfo.revision.asString());
            return String.format("<a href='%s'>%s</a> %s", hash, shortHash, commitMessage);
        }, (String)"<br/>");
        if (string == null) {
            GitRebaseProcess.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    private static MultiMap<GitRepository, GitRebaseUtils.CommitInfo> getSkippedCommits(@NotNull Map<GitRepository, ? extends GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(45);
        }
        MultiMap map2 = MultiMap.create();
        for (GitRepository repository : statuses.keySet()) {
            map2.put((Object)repository, statuses.get(repository).getSkippedCommits());
        }
        MultiMap multiMap = map2;
        if (multiMap == null) {
            GitRebaseProcess.$$$reportNull$$$0(46);
        }
        return multiMap;
    }

    @NotNull
    private static Map<GitRepository, GitSuccessfulRebase> getSuccessfulRepositories(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(47);
        }
        LinkedHashMap map2 = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : statuses.keySet()) {
            GitRebaseStatus status = statuses.get(repository);
            if (!(status instanceof GitSuccessfulRebase)) continue;
            map2.put(repository, (GitSuccessfulRebase)status);
        }
        LinkedHashMap linkedHashMap = map2;
        if (linkedHashMap == null) {
            GitRebaseProcess.$$$reportNull$$$0(48);
        }
        return linkedHashMap;
    }

    private void abort() {
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, "Aborting Rebase Process..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.abort(this.myProject, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$2", "run"));
            }
        });
    }

    private void retry(@NotNull String processTitle) {
        if (processTitle == null) {
            GitRebaseProcess.$$$reportNull$$$0(49);
        }
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, processTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.continueRebase(this.myProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$3", "run"));
            }
        });
    }

    private void handlePossibleCommitLinks(@NotNull String href, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        GitRepository repository;
        if (href == null) {
            GitRebaseProcess.$$$reportNull$$$0(50);
        }
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(51);
        }
        if ((repository = GitRebaseProcess.findRootBySkippedCommit(href, skippedCommits)) != null) {
            GitUtil.showSubmittedFiles(this.myProject, href, repository.getRoot(), true, false);
        }
    }

    @Nullable
    private static GitRepository findRootBySkippedCommit(@NotNull String hash, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (hash == null) {
            GitRebaseProcess.$$$reportNull$$$0(52);
        }
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(53);
        }
        return (GitRepository)ContainerUtil.find((Iterable)skippedCommits.keySet(), repository -> {
            if (skippedCommits == null) {
                GitRebaseProcess.$$$reportNull$$$0(54);
            }
            if (hash == null) {
                GitRebaseProcess.$$$reportNull$$$0(55);
            }
            return ContainerUtil.exists((Iterable)skippedCommits.get(repository), info -> {
                if (hash == null) {
                    GitRebaseProcess.$$$reportNull$$$0(56);
                }
                return info.revision.asString().equals(hash);
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 46: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseSpec";
                break;
            }
            case 2: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statuses";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyRebased";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseStatus";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 26: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successful";
                break;
            }
            case 27: 
            case 38: 
            case 42: 
            case 51: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCommits";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictingRepository";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicting";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedPaths";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processTitle";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "href";
                break;
            }
            case 52: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseSingleRoot";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "callRebase";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyRoots";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "showConflictResolver";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "mentionSkippedCommits";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedCommits";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessfulRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectFutureChanges";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveUpdatedSpec";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSingleRoot";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 46: 
            case 48: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "callRebase";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyRoots";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeRefreshed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "saveDirtyRootsInitially";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "saveLocalChanges";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findRootsWithLocalChanges";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCurrentBranchNameIfAllTheSame";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getItemIfAllTheSame";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notifyNotAllConflictsResolved";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showConflictResolver";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showFatalError";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesError";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "mentionSkippedCommits";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSkippedCommits";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSuccessfulRepositories";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "retry";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "handlePossibleCommitLinks";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findRootBySkippedCommit";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRootBySkippedCommit$7";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GitRebaseProgressListener
    implements GitLineHandlerListener {
        private static final Pattern PROGRESS = Pattern.compile("^Rebasing \\((\\d+)/(\\d+)\\)$");
        private int currentCommit;

        private GitRebaseProgressListener() {
        }

        @Override
        public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
            Matcher matcher;
            if (line == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(1);
            }
            if ((matcher = PROGRESS.matcher(line)).matches()) {
                this.currentCommit = Integer.parseInt(matcher.group(1));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "line";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "git4idea/rebase/GitRebaseProcess$GitRebaseProgressListener";
            objectArray[2] = "onLineAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ResolveAction
    extends NotificationAction {
        @NotNull
        private final GitRepository myCurrentRepository;

        ResolveAction(GitRepository currentRepository) {
            if (currentRepository == null) {
                ResolveAction.$$$reportNull$$$0(0);
            }
            super("Resolve...");
            this.myCurrentRepository = currentRepository;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                ResolveAction.$$$reportNull$$$0(1);
            }
            if (notification == null) {
                ResolveAction.$$$reportNull$$$0(2);
            }
            GitRebaseProcess.this.showConflictResolver(this.myCurrentRepository, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentRepository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "git4idea/rebase/GitRebaseProcess$ResolveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RebaseNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final MultiMap<GitRepository, GitRebaseUtils.CommitInfo> mySkippedCommits;

        RebaseNotificationListener(MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
            if (skippedCommits == null) {
                RebaseNotificationListener.$$$reportNull$$$0(0);
            }
            this.mySkippedCommits = skippedCommits;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                RebaseNotificationListener.$$$reportNull$$$0(1);
            }
            if (e == null) {
                RebaseNotificationListener.$$$reportNull$$$0(2);
            }
            GitRebaseProcess.this.handlePossibleCommitLinks(e.getDescription(), (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)this.mySkippedCommits);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "skippedCommits";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ResolveConflictResult {
        ALL_RESOLVED,
        NOTHING_TO_MERGE,
        UNRESOLVED_REMAIN;

    }

    private class RebaseConflictResolver
    extends GitConflictResolver {
        private final boolean myCalledFromNotification;
        private boolean myWasNothingToMerge;

        RebaseConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, GitConflictResolver.Params params, boolean calledFromNotification) {
            if (project == null) {
                RebaseConflictResolver.$$$reportNull$$$0(0);
            }
            if (git == null) {
                RebaseConflictResolver.$$$reportNull$$$0(1);
            }
            if (repository == null) {
                RebaseConflictResolver.$$$reportNull$$$0(2);
            }
            if (params == null) {
                RebaseConflictResolver.$$$reportNull$$$0(3);
            }
            super(project, git, Collections.singleton(repository.getRoot()), params);
            this.myCalledFromNotification = calledFromNotification;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }

        @Override
        protected boolean proceedAfterAllMerged() {
            if (this.myCalledFromNotification) {
                GitRebaseProcess.this.retry("Continue Rebase Process...");
            }
            return true;
        }

        @Override
        protected boolean proceedIfNothingToMerge() {
            this.myWasNothingToMerge = true;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "git";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repository";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GitRebaseMergeDialogCustomizer
    extends MergeDialogCustomizer {
        @Nullable
        private String myRebasingBranch;
        @Nullable
        private String myBaseBranch;
        private boolean myOntoBranch;

        private GitRebaseMergeDialogCustomizer(@NotNull GitRepository repository, @NotNull GitRebaseSpec rebaseSpec) {
            if (repository == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(0);
            }
            if (rebaseSpec == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(1);
            }
            GitRebaseParams rebaseParams = rebaseSpec.getParams();
            if (rebaseParams != null) {
                String branch;
                String currentBranchAtTheStartOfRebase = rebaseSpec.getInitialBranchNames().get(repository);
                String upstream = rebaseParams.getUpstream();
                if (upstream.equals("HEAD")) {
                    upstream = currentBranchAtTheStartOfRebase;
                }
                if ((branch = rebaseParams.getBranch()) == null) {
                    branch = currentBranchAtTheStartOfRebase;
                }
                this.myRebasingBranch = branch;
                this.myBaseBranch = upstream;
                boolean bl = this.myOntoBranch = !this.myBaseBranch.matches("[a-fA-F0-9]{40}");
                if (!this.myOntoBranch) {
                    this.myBaseBranch = VcsLogUtil.getShortHash((String)this.myBaseBranch);
                }
            }
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            if (files == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(2);
            }
            if (this.myRebasingBranch == null || this.myBaseBranch == null) {
                String string = super.getMultipleFileMergeDescription(files);
                if (string == null) {
                    GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = GitDefaultMergeDialogCustomizerKt.getDescriptionForRebase(this.myRebasingBranch, this.myBaseBranch, this.myOntoBranch);
            if (string == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            if (file == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(5);
            }
            if (this.myRebasingBranch == null || this.myBaseBranch == null) {
                String string = super.getLeftPanelTitle(file);
                if (string == null) {
                    GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = GitDefaultMergeDialogCustomizerKt.getDefaultLeftPanelTitleForBranch(this.myRebasingBranch);
            if (string == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber) {
            if (file == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(8);
            }
            if (this.myRebasingBranch == null || this.myBaseBranch == null) {
                String string = super.getRightPanelTitle(file, revisionNumber);
                if (string == null) {
                    GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = GitDefaultMergeDialogCustomizerKt.getDefaultRightPanelTitleForBranch(this.myBaseBranch, revisionNumber, this.myOntoBranch);
            if (string == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Nullable
        public List<String> getColumnNames() {
            if (this.myRebasingBranch == null || this.myBaseBranch == null) {
                return null;
            }
            return Arrays.asList(GitMergeProvider.calcColumnName(false, this.myRebasingBranch), GitMergeProvider.calcColumnName(true, this.myBaseBranch));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rebaseSpec";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/rebase/GitRebaseProcess$GitRebaseMergeDialogCustomizer";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/rebase/GitRebaseProcess$GitRebaseMergeDialogCustomizer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMultipleFileMergeDescription";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeftPanelTitle";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRightPanelTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getMultipleFileMergeDescription";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeftPanelTitle";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getRightPanelTitle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

