/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class GraphBuilder<N, E>
extends UserDataHolderBase
implements UserDataHolder,
Disposable {
    @NonNls
    public static String GRAPH_BUILDER_KEY = "GRAPH_BUILDER_KEY";

    public abstract Project getProject();

    public abstract Graph2D getGraph();

    public abstract Graph2DView getView();

    public abstract GraphDataModel<N, E> getGraphDataModel();

    public abstract GraphPresentationModel<N, E> getGraphPresentationModel();

    public abstract void updateGraph();

    public abstract void updateDataModel();

    public abstract void updateView();

    public abstract void updateRealizers(boolean var1);

    public abstract void queueUpdate();

    public abstract void initialize();

    @Nullable
    public abstract String getNodeName(N var1);

    @Nullable
    public abstract String getEdgeName(E var1);

    @Nullable
    public abstract Node getNode(N var1);

    @Nullable
    public abstract Edge getEdge(E var1);

    @Nullable
    public abstract N getNodeObject(Node var1);

    @Nullable
    public abstract E getEdgeObject(Edge var1);

    public abstract void addCustomUpdater(CustomGraphUpdater var1);

    public abstract EditMode getEditMode();

    public abstract Collection<N> getNodeObjects();

    public abstract Collection<E> getEdgeObjects();

    public abstract boolean removeNode(N var1);

    public abstract boolean removeEdge(E var1);

    public abstract GraphBuilderEventManager getEventManager();
}

