/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class HTTPDateFormat
extends DateFormat {
    static final String[] DAYS_OF_WEEK;
    static final String[] MONTHS;

    public StringBuffer format(Date date, StringBuffer buf, FieldPosition field) {
        this.calendar.clear();
        this.calendar.setTime(date);
        buf.setLength(0);
        buf.append(DAYS_OF_WEEK[this.calendar.get(7)]);
        buf.append(',');
        buf.append(' ');
        int day = this.calendar.get(5);
        buf.append(Character.forDigit(day / 10, 10));
        buf.append(Character.forDigit(day % 10, 10));
        buf.append(' ');
        buf.append(MONTHS[this.calendar.get(2)]);
        buf.append(' ');
        int year = this.calendar.get(1);
        if (year < 1000) {
            buf.append('0');
            if (year < 100) {
                buf.append('0');
                if (year < 10) {
                    buf.append('0');
                }
            }
        }
        buf.append(Integer.toString(year));
        buf.append(' ');
        int hour = this.calendar.get(11);
        buf.append(Character.forDigit(hour / 10, 10));
        buf.append(Character.forDigit(hour % 10, 10));
        buf.append(':');
        int minute = this.calendar.get(12);
        buf.append(Character.forDigit(minute / 10, 10));
        buf.append(Character.forDigit(minute % 10, 10));
        buf.append(':');
        int second = this.calendar.get(13);
        buf.append(Character.forDigit(second / 10, 10));
        buf.append(Character.forDigit(second % 10, 10));
        buf.append(' ');
        int zoneOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        if (zoneOffset < 0) {
            zoneOffset = -zoneOffset;
            buf.append('-');
        } else {
            buf.append('+');
        }
        int tzhours = zoneOffset / 60;
        buf.append(Character.forDigit(tzhours / 10, 10));
        buf.append(Character.forDigit(tzhours % 10, 10));
        int tzminutes = zoneOffset % 60;
        buf.append(Character.forDigit(tzminutes / 10, 10));
        buf.append(Character.forDigit(tzminutes % 10, 10));
        field.setBeginIndex(0);
        field.setEndIndex(buf.length());
        return buf;
    }

    public Date parse(String text, ParsePosition pos) {
        int start = 0;
        int end = -1;
        int len = text.length();
        this.calendar.clear();
        pos.setIndex(start);
        try {
            int year;
            int second;
            int minute;
            int hour;
            int date;
            int month;
            if (Character.isLetter(text.charAt(start))) {
                start = this.skipNonWhitespace(text, start);
            }
            switch (start) {
                case 3: {
                    start = this.skipWhitespace(text, start);
                    pos.setIndex(start);
                    end = this.skipNonWhitespace(text, start + 1);
                    String monthText = text.substring(start, end);
                    month = -1;
                    int i = 0;
                    while (i < 12) {
                        if (MONTHS[i].equals(monthText)) {
                            month = i;
                            break;
                        }
                        ++i;
                    }
                    if (month == -1) {
                        pos.setErrorIndex(end);
                        return null;
                    }
                    start = this.skipWhitespace(text, end + 1);
                    pos.setIndex(start);
                    end = this.skipNonWhitespace(text, start + 1);
                    date = Integer.parseInt(text.substring(start, end));
                    start = this.skipWhitespace(text, end + 1);
                    pos.setIndex(start);
                    end = this.skipTo(text, start + 1, ':');
                    hour = Integer.parseInt(text.substring(start, end));
                    start = end + 1;
                    pos.setIndex(start);
                    end = this.skipTo(text, start + 1, ':');
                    minute = Integer.parseInt(text.substring(start, end));
                    start = end + 1;
                    pos.setIndex(start);
                    end = this.skipNonWhitespace(text, start + 1);
                    second = Integer.parseInt(text.substring(start, end));
                    start = this.skipWhitespace(text, end + 1);
                    pos.setIndex(start);
                    end = this.skipNonWhitespace(text, start + 1);
                    year = Integer.parseInt(text.substring(start, end));
                    break;
                }
                case 0: 
                case 4: {
                    start = this.skipWhitespace(text, start);
                    pos.setIndex(start);
                    end = this.skipNonWhitespace(text, start + 1);
                    date = Integer.parseInt(text.substring(start, end));
                    start = this.skipWhitespace(text, end + 1);
                    pos.setIndex(start);
                    end = this.skipNonWhitespace(text, start + 1);
                    String monthText = text.substring(start, end);
                    month = -1;
                    int i = 0;
                    while (i < 12) {
                        if (MONTHS[i].equals(monthText)) {
                            month = i;
                            break;
                        }
                        ++i;
                    }
                    if (month == -1) {
                        pos.setErrorIndex(end);
                        return null;
                    }
                    start = this.skipWhitespace(text, end + 1);
                    pos.setIndex(start);
                    end = this.skipNonWhitespace(text, start + 1);
                    year = Integer.parseInt(text.substring(start, end));
                    start = this.skipWhitespace(text, end + 1);
                    pos.setIndex(start);
                    end = this.skipTo(text, start + 1, ':');
                    hour = Integer.parseInt(text.substring(start, end));
                    start = end + 1;
                    pos.setIndex(start);
                    end = this.skipTo(text, start + 1, ':');
                    minute = Integer.parseInt(text.substring(start, end));
                    start = end + 1;
                    pos.setIndex(start);
                    end = start + 1;
                    while (end < len && !Character.isWhitespace(text.charAt(end))) {
                        ++end;
                    }
                    second = Integer.parseInt(text.substring(start, end));
                    break;
                }
                default: {
                    start = this.skipWhitespace(text, start);
                    pos.setIndex(start);
                    end = this.skipTo(text, start + 1, '-');
                    date = Integer.parseInt(text.substring(start, end));
                    start = end + 1;
                    pos.setIndex(start);
                    end = this.skipTo(text, start + 1, '-');
                    String monthText = text.substring(start, end);
                    month = -1;
                    int i = 0;
                    while (i < 12) {
                        if (MONTHS[i].equals(monthText)) {
                            month = i;
                            break;
                        }
                        ++i;
                    }
                    if (month == -1) {
                        pos.setErrorIndex(end);
                        return null;
                    }
                    start = end + 1;
                    pos.setIndex(start);
                    end = this.skipNonWhitespace(text, start + 1);
                    year = 1900 + Integer.parseInt(text.substring(start, end));
                    start = this.skipWhitespace(text, end + 1);
                    pos.setIndex(start);
                    end = this.skipTo(text, start + 1, ':');
                    hour = Integer.parseInt(text.substring(start, end));
                    start = end + 1;
                    pos.setIndex(start);
                    end = this.skipTo(text, start + 1, ':');
                    minute = Integer.parseInt(text.substring(start, end));
                    start = end + 1;
                    pos.setIndex(start);
                    end = start + 1;
                    while (end < len && !Character.isWhitespace(text.charAt(end))) {
                        ++end;
                    }
                    second = Integer.parseInt(text.substring(start, end));
                }
            }
            this.calendar.set(1, year);
            this.calendar.set(2, month);
            this.calendar.set(5, date);
            this.calendar.set(10, hour);
            this.calendar.set(12, minute);
            this.calendar.set(13, second);
            if (end != len) {
                start = this.skipWhitespace(text, end + 1);
                end = start + 1;
                while (end < len && !Character.isWhitespace(text.charAt(end))) {
                    ++end;
                }
                char pm = text.charAt(start);
                if (Character.isLetter(pm)) {
                    TimeZone tz = TimeZone.getTimeZone(text.substring(start, end));
                    this.calendar.set(15, tz.getRawOffset());
                } else {
                    int zoneOffset = 0;
                    zoneOffset += 600 * Character.digit(text.charAt(++start), 10);
                    zoneOffset += 60 * Character.digit(text.charAt(++start), 10);
                    zoneOffset += 10 * Character.digit(text.charAt(++start), 10);
                    zoneOffset += Character.digit(text.charAt(++start), 10);
                    zoneOffset *= 60000;
                    if ('-' == pm) {
                        zoneOffset = -zoneOffset;
                    }
                    this.calendar.set(15, zoneOffset);
                }
            }
            pos.setIndex(end);
            return this.calendar.getTime();
        }
        catch (NumberFormatException e) {
            pos.setErrorIndex(Math.max(start, end));
        }
        catch (StringIndexOutOfBoundsException e) {
            pos.setErrorIndex(Math.max(start, end));
        }
        return null;
    }

    private final int skipWhitespace(String text, int pos) {
        while (Character.isWhitespace(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private final int skipNonWhitespace(String text, int pos) {
        while (!Character.isWhitespace(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private final int skipTo(String text, int pos, char c) {
        while (text.charAt(pos) != c) {
            ++pos;
        }
        return pos;
    }

    public void setCalendar(Calendar newCalendar) {
        throw new UnsupportedOperationException();
    }

    public void setNumberFormat(NumberFormat newNumberFormat) {
        throw new UnsupportedOperationException();
    }

    public HTTPDateFormat() {
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.numberFormat = new DecimalFormat();
    }

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "Sun";
        stringArray[2] = "Mon";
        stringArray[3] = "Tue";
        stringArray[4] = "Wed";
        stringArray[5] = "Thu";
        stringArray[6] = "Fri";
        stringArray[7] = "Sat";
        DAYS_OF_WEEK = stringArray;
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    }
}

