/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanExpressionPattern
extends Pattern {
    private Expression expression;

    public BooleanExpressionPattern(Expression expression) {
        this.expression = expression;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.expression, nextFree, slotManager);
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.expression);
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(this.getItemType(), false);
        this.expression = visitor.typeCheck(this.expression, cit);
        return this;
    }

    @Override
    public boolean matches(Item item, XPathContext context) {
        XPathContextMinor c2 = context.newMinorContext();
        UnfailingIterator<Item> iter = SingletonIterator.makeIterator(item);
        iter.next();
        c2.setCurrentIterator(iter);
        try {
            return this.expression.effectiveBooleanValue(c2);
        }
        catch (XPathException e) {
            return false;
        }
    }

    @Override
    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public final double getDefaultPriority() {
        return 1.0;
    }

    @Override
    public int getNodeKind() {
        return -1;
    }

    @Override
    public int getFingerprint() {
        return -1;
    }

    @Override
    public String toString() {
        return "?{" + this.expression.toString() + "}";
    }

    public boolean equals(Object other) {
        return other instanceof BooleanExpressionPattern && ((BooleanExpressionPattern)other).expression.equals(this.expression);
    }

    public int hashCode() {
        return 0x7AEFFEA9 ^ this.expression.hashCode();
    }
}

