/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.ant.IvyDependencyArtifact;
import org.apache.ivy.ant.IvyDependencyConf;
import org.apache.ivy.ant.IvyDependencyExclude;
import org.apache.ivy.ant.IvyDependencyInclude;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.tools.ant.BuildException;

public class IvyDependency {
    private List confs = new ArrayList();
    private List artifacts = new ArrayList();
    private List excludes = new ArrayList();
    private List includes = new ArrayList();
    private String org;
    private String name;
    private String rev;
    private String branch;
    private String conf;
    private boolean changing;
    private boolean force;
    private boolean transitive = true;

    public IvyDependencyConf createConf() {
        IvyDependencyConf ivyDependencyConf = new IvyDependencyConf();
        this.confs.add(ivyDependencyConf);
        return ivyDependencyConf;
    }

    public IvyDependencyArtifact createArtifact() {
        IvyDependencyArtifact ivyDependencyArtifact = new IvyDependencyArtifact();
        this.artifacts.add(ivyDependencyArtifact);
        return ivyDependencyArtifact;
    }

    public IvyDependencyExclude createExclude() {
        IvyDependencyExclude ivyDependencyExclude = new IvyDependencyExclude();
        this.excludes.add(ivyDependencyExclude);
        return ivyDependencyExclude;
    }

    public IvyDependencyInclude createInclude() {
        IvyDependencyInclude ivyDependencyInclude = new IvyDependencyInclude();
        this.includes.add(ivyDependencyInclude);
        return ivyDependencyInclude;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String string) {
        this.org = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String string) {
        this.rev = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String string) {
        this.conf = string;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public void setChanging(boolean bl) {
        this.changing = bl;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean bl) {
        this.transitive = bl;
    }

    DependencyDescriptor asDependencyDescriptor(ModuleDescriptor moduleDescriptor, String string, IvySettings ivySettings) {
        if (this.org == null) {
            throw new BuildException("'org' is required on ");
        }
        if (this.name == null) {
            throw new BuildException("'name' is required when using inline mode");
        }
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(this.org, this.name, this.branch, this.rev);
        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(moduleDescriptor, moduleRevisionId, this.force, this.changing, this.transitive);
        if (this.conf != null) {
            defaultDependencyDescriptor.addDependencyConfiguration(string, this.conf);
        } else {
            defaultDependencyDescriptor.addDependencyConfiguration(string, "*");
        }
        for (Object object : this.confs) {
            ((IvyDependencyConf)object).addConf(defaultDependencyDescriptor, string);
        }
        for (Object object : this.artifacts) {
            ((IvyDependencyArtifact)object).addArtifact(defaultDependencyDescriptor, string);
        }
        for (Object object : this.excludes) {
            Object object2 = ((IvyDependencyExclude)object).asRule(ivySettings);
            defaultDependencyDescriptor.addExcludeRule(string, (ExcludeRule)object2);
        }
        for (Object object2 : this.includes) {
            DefaultIncludeRule defaultIncludeRule = ((IvyDependencyInclude)object2).asRule(ivySettings);
            defaultDependencyDescriptor.addIncludeRule(string, defaultIncludeRule);
        }
        return defaultDependencyDescriptor;
    }
}

