/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.bluecow.spectro.UndoManager;

public class UndoRedoAction
extends AbstractAction {
    private final boolean undo;
    private final UndoManager undoManager;
    private ChangeListener undoManagerChangeHandler = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            UndoRedoAction.this.updateEnabledness();
        }
    };

    public static UndoRedoAction createUndoInstance(UndoManager undoManager) {
        return new UndoRedoAction(undoManager, true);
    }

    public static UndoRedoAction createRedoInstance(UndoManager undoManager) {
        return new UndoRedoAction(undoManager, false);
    }

    public UndoRedoAction(UndoManager undoManager, boolean undo) {
        super(undo ? "Undo" : "Redo");
        this.undoManager = undoManager;
        this.undo = undo;
        undoManager.addChangeListener(this.undoManagerChangeHandler);
        this.updateEnabledness();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.undo) {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        } else if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    private void updateEnabledness() {
        if (this.undo) {
            this.setEnabled(this.undoManager.canUndo());
        } else {
            this.setEnabled(this.undoManager.canRedo());
        }
    }
}

