/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Insets;
import net.infonode.util.Direction;

public class InsetsUtil {
    public static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    private InsetsUtil() {
    }

    public static Insets getDiff(Insets insets, Insets insets2) {
        int n = insets2.top - insets.top;
        int n2 = insets2.left - insets.left;
        int n3 = insets2.bottom - insets.bottom;
        int n4 = insets2.right - insets.right;
        return new Insets(n > 0 ? n : 0, n2 > 0 ? n2 : 0, n3 > 0 ? n3 : 0, n4 > 0 ? n4 : 0);
    }

    public static Insets sub(Insets insets, Insets insets2) {
        return new Insets(insets.top - insets2.top, insets.left - insets2.left, insets.bottom - insets2.bottom, insets.right - insets2.right);
    }

    public static Insets add(Insets insets, Insets insets2) {
        return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
    }

    public static final Insets flip(Insets insets, boolean bl, boolean bl2) {
        return bl ? (bl2 ? new Insets(insets.bottom, insets.right, insets.top, insets.left) : new Insets(insets.top, insets.right, insets.bottom, insets.left)) : (bl2 ? new Insets(insets.bottom, insets.left, insets.top, insets.right) : insets);
    }

    public static final Insets rotate(Direction direction, Insets insets) {
        if (direction == Direction.LEFT) {
            return new Insets(insets.bottom, insets.right, insets.top, insets.left);
        }
        if (direction == Direction.DOWN) {
            return new Insets(insets.left, insets.bottom, insets.right, insets.top);
        }
        if (direction == Direction.UP) {
            return new Insets(insets.right, insets.top, insets.left, insets.bottom);
        }
        return (Insets)insets.clone();
    }

    public static Insets max(Insets insets, Insets insets2) {
        return new Insets(Math.max(insets.top, insets2.top), Math.max(insets.left, insets2.left), Math.max(insets.bottom, insets2.bottom), Math.max(insets.right, insets2.right));
    }

    public static int maxInset(Insets insets) {
        return Math.max(insets.top, Math.max(insets.bottom, Math.max(insets.left, insets.right)));
    }

    public static int getInset(Insets insets, Direction direction) {
        return direction == Direction.UP ? insets.top : (direction == Direction.LEFT ? insets.left : (direction == Direction.DOWN ? insets.bottom : insets.right));
    }

    public static Insets setInset(Insets insets, Direction direction, int n) {
        return direction == Direction.UP ? new Insets(n, insets.left, insets.bottom, insets.right) : (direction == Direction.LEFT ? new Insets(insets.top, n, insets.bottom, insets.right) : (direction == Direction.DOWN ? new Insets(insets.top, insets.left, n, insets.right) : new Insets(insets.top, insets.left, insets.bottom, n)));
    }

    public static Insets copy(Insets insets) {
        return insets == null ? null : new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static void addTo(Insets insets, Insets insets2) {
        insets.top += insets2.top;
        insets.bottom += insets2.bottom;
        insets.left += insets2.left;
        insets.right += insets2.right;
    }

    public static Insets flipHorizontal(Insets insets) {
        return new Insets(insets.top, insets.right, insets.bottom, insets.left);
    }

    public static Insets flipVertical(Insets insets) {
        return new Insets(insets.bottom, insets.left, insets.top, insets.right);
    }
}

