/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Point;
import java.util.Arrays;
import java.util.Vector;
import net.sourceforge.squirrel_sql.plugins.graph.FoldingPoint;
import net.sourceforge.squirrel_sql.plugins.graph.GraphLine;
import net.sourceforge.squirrel_sql.plugins.graph.Zoomer;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ConstraintGraphXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.FoldingPointXmlBean;

public class ConstraintGraph {
    private GraphLine[] _fkStubLines;
    private GraphLine[] _pkStubLines;
    private Point _fkGatherPoint;
    private Point _pkGatherPoint;
    private Vector<FoldingPoint> _foldingPoints = new Vector();
    private GraphLine _hitConnectLine;
    private boolean _isHitOnConnectLine;
    private FoldingPoint _hitFoldingPoint;

    public ConstraintGraph() {
    }

    public ConstraintGraph(ConstraintGraphXmlBean constraintGraphXmlBean, Zoomer zoomer) {
        for (int i = 0; i < constraintGraphXmlBean.getFoldingPointXmlBeans().length; ++i) {
            Point p = new Point();
            p.x = constraintGraphXmlBean.getFoldingPointXmlBeans()[i].getX();
            p.y = constraintGraphXmlBean.getFoldingPointXmlBeans()[i].getY();
            this._foldingPoints.add(new FoldingPoint(p, zoomer));
        }
    }

    public ConstraintGraphXmlBean getXmlBean() {
        ConstraintGraphXmlBean ret = new ConstraintGraphXmlBean();
        FoldingPointXmlBean[] foldPointXmlBeans = new FoldingPointXmlBean[this._foldingPoints.size()];
        for (int i = 0; i < this._foldingPoints.size(); ++i) {
            FoldingPoint point = this._foldingPoints.elementAt(i);
            foldPointXmlBeans[i] = new FoldingPointXmlBean();
            foldPointXmlBeans[i].setX(point.getUnZoomedPoint().x);
            foldPointXmlBeans[i].setY(point.getUnZoomedPoint().y);
        }
        ret.setFoldingPointXmlBeans(foldPointXmlBeans);
        return ret;
    }

    public void setFkStubLines(GraphLine[] fkStubLines) {
        this._fkStubLines = fkStubLines;
    }

    public void setPkStubLines(GraphLine[] pkStubLines) {
        this._pkStubLines = pkStubLines;
    }

    public void setFkGatherPoint(Point fkGatherPoint) {
        this._fkGatherPoint = fkGatherPoint;
    }

    public void setPkGatherPoint(Point pkGatherPoint) {
        this._pkGatherPoint = pkGatherPoint;
    }

    public GraphLine[] getAllLines() {
        Vector<GraphLine> ret = new Vector<GraphLine>();
        ret.addAll(Arrays.asList(this._fkStubLines));
        ret.addAll(Arrays.asList(this.getConnectLines()));
        ret.addAll(Arrays.asList(this._pkStubLines));
        return ret.toArray(new GraphLine[ret.size()]);
    }

    public GraphLine[] getLinesToArrow() {
        return this._pkStubLines;
    }

    public GraphLine[] getConnectLines() {
        if (0 == this._foldingPoints.size()) {
            return new GraphLine[]{new GraphLine(this._fkGatherPoint, this._pkGatherPoint)};
        }
        GraphLine[] ret = new GraphLine[this._foldingPoints.size() + 1];
        ret[0] = new GraphLine(this._fkGatherPoint, this._foldingPoints.get(0));
        for (int i = 0; i < this._foldingPoints.size() - 1; ++i) {
            ret[i + 1] = new GraphLine(this._foldingPoints.get(i), this._foldingPoints.get(i + 1));
        }
        ret[ret.length - 1] = new GraphLine(this._foldingPoints.lastElement(), this._pkGatherPoint);
        return ret;
    }

    public void setHitConnectLine(GraphLine line) {
        this._hitConnectLine = line;
        this._isHitOnConnectLine = true;
    }

    public void addFoldingPointToHitConnectLine(FoldingPoint lastPopupClickPoint) {
        if (this._fkGatherPoint.equals(this._hitConnectLine.getBegin())) {
            this._foldingPoints.insertElementAt(lastPopupClickPoint, 0);
            return;
        }
        for (int i = 0; i < this._foldingPoints.size() - 1; ++i) {
            FoldingPoint fp = this._foldingPoints.get(i);
            if (!this._hitConnectLine.getBegin().equals(fp.getZoomedPoint())) continue;
            this._foldingPoints.insertElementAt(lastPopupClickPoint, i + 1);
            return;
        }
        this._foldingPoints.add(lastPopupClickPoint);
    }

    public Vector<FoldingPoint> getFoldingPoints() {
        return this._foldingPoints;
    }

    public void setHitFoldingPoint(FoldingPoint foldingPoint) {
        this._isHitOnConnectLine = false;
        this._hitFoldingPoint = foldingPoint;
    }

    public boolean isHitOnConnectLine() {
        return this._isHitOnConnectLine;
    }

    public void removeHitFoldingPoint() {
        this._foldingPoints.remove(this._hitFoldingPoint);
    }

    public void moveLastHitFoldingPointTo(FoldingPoint point) {
        this._foldingPoints.indexOf(this._hitFoldingPoint);
        this._foldingPoints.set(this._foldingPoints.indexOf(this._hitFoldingPoint), point);
        this._hitFoldingPoint = point;
    }

    public void removeAllFoldingPoints() {
        this._foldingPoints.clear();
    }

    public FoldingPoint getFirstFoldingPoint() {
        if (0 == this._foldingPoints.size()) {
            return null;
        }
        return this._foldingPoints.get(0);
    }

    public FoldingPoint getLastFoldingPoint() {
        if (0 == this._foldingPoints.size()) {
            return null;
        }
        return this._foldingPoints.get(this._foldingPoints.size() - 1);
    }

    public GraphLine getMainLine() {
        if (0 == this._foldingPoints.size()) {
            return new GraphLine(this._pkGatherPoint, this._fkGatherPoint);
        }
        return new GraphLine(this._foldingPoints.get(0), this._fkGatherPoint);
    }
}

