/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.MemoryPanel;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewLogsCommand;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.fw.gui.ErrorDialog;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerListener;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class LogPanel
extends JPanel {
    private static final long serialVersionUID = -2886311809367056785L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MemoryPanel.class);
    private transient SquirrelResources _resources;
    private static final int LOG_TYPE_INFO = 0;
    private static final int LOG_TYPE_WARN = 1;
    private static final int LOG_TYPE_ERROR = 2;
    private JButton _btnLastLog = new JButton();
    private JLabel _lblLogInfo = new JLabel();
    private JButton _btnViewLogs = new JButton();
    private Timer _displayLastLogTimer;
    private Timer _whiteIconTimer;
    private final Vector<LogData> _logsDuringDisplayDelay = new Vector();
    private transient LogData _curlogToDisplay;
    private transient IApplication _app;
    private transient LogStatistics _statistics = new LogStatistics();

    public LogPanel(IApplication app) {
        this._app = app;
        this._resources = this._app.getResources();
        this.createGui();
        this.setIconForCurLogType();
        this._whiteIconTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this._btnLastLog.setIcon(LogPanel.this._resources.getIcon("white_gem"));
            }
        });
        this._whiteIconTimer.setRepeats(false);
        int displayDelay = 200;
        this._displayLastLogTimer = new Timer(displayDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.updatePanel();
            }
        });
        this._displayLastLogTimer.setRepeats(false);
        LoggerController.addLoggerListener(new ILoggerListener(){

            @Override
            public void info(Class<?> source, Object message) {
                LogPanel.this._statistics.setInfoCount(LogPanel.this._statistics._infoCount + 1);
                LogPanel.this.addLog(0, source.getName(), message, null);
            }

            @Override
            public void info(Class<?> source, Object message, Throwable th) {
                LogPanel.this._statistics.setInfoCount(LogPanel.this._statistics._infoCount + 1);
                LogPanel.this.addLog(0, source.getName(), message, th);
            }

            @Override
            public void warn(Class<?> source, Object message) {
                LogPanel.this._statistics.setWarnCount(LogPanel.this._statistics._warnCount + 1);
                LogPanel.this.addLog(1, source.getName(), message, null);
            }

            @Override
            public void warn(Class<?> source, Object message, Throwable th) {
                LogPanel.this._statistics.setWarnCount(LogPanel.this._statistics._warnCount + 1);
                LogPanel.this.addLog(1, source.getName(), message, th);
            }

            @Override
            public void error(Class<?> source, Object message) {
                LogPanel.this._statistics.setErrorCount(LogPanel.this._statistics._errorCount + 1);
                LogPanel.this.addLog(2, source.getName(), message, message instanceof Throwable ? (Throwable)message : null);
            }

            @Override
            public void error(Class<?> source, Object message, Throwable th) {
                LogPanel.this._statistics.setErrorCount(LogPanel.this._statistics._errorCount + 1);
                LogPanel.this.addLog(2, source.getName(), message, th);
            }
        });
        this._btnLastLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LogPanel.this.setIconForCurLogType();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!LogPanel.this._whiteIconTimer.isRunning()) {
                    LogPanel.this._btnLastLog.setIcon(LogPanel.this._resources.getIcon("white_gem"));
                }
            }
        });
        this._btnLastLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.showLogInDialog();
            }
        });
        this._btnViewLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ViewLogsCommand(LogPanel.this._app).execute();
            }
        });
    }

    private void createGui() {
        this.setLayout(new BorderLayout(5, 0));
        ImageIcon viewLogsIcon = this._resources.getIcon("logs");
        this._btnViewLogs.setIcon(viewLogsIcon);
        Dimension prefButtonSize = new Dimension(viewLogsIcon.getIconWidth(), viewLogsIcon.getIconHeight());
        this._btnLastLog.setPreferredSize(prefButtonSize);
        this._btnViewLogs.setPreferredSize(prefButtonSize);
        this._btnLastLog.setBorder(null);
        this._btnViewLogs.setBorder(null);
        JPanel pnlButtons = new JPanel(new GridLayout(1, 2, 3, 0));
        pnlButtons.add(this._btnLastLog);
        pnlButtons.add(this._btnViewLogs);
        this.add((Component)pnlButtons, "East");
        this.add((Component)this._lblLogInfo, "Center");
        this._btnLastLog.setToolTipText(s_stringMgr.getString("LogPanel.viewLastLog"));
        this._btnViewLogs.setToolTipText(s_stringMgr.getString("LogPanel.openLogs"));
    }

    private void showLogInDialog() {
        if (null != this._curlogToDisplay) {
            String title;
            Object[] params = new Object[]{this._curlogToDisplay.source, this._curlogToDisplay.logTime, this._curlogToDisplay.message};
            String extMsg = s_stringMgr.getString("LogPanel.logMsg", params);
            ErrorDialog errorDialog = new ErrorDialog((Frame)this._app.getMainFrame(), extMsg, this._curlogToDisplay.throwable);
            switch (this._curlogToDisplay.logType) {
                case 0: {
                    title = s_stringMgr.getString("LogPanel.titleInfo");
                    break;
                }
                case 1: {
                    title = s_stringMgr.getString("LogPanel.titleWarn");
                    break;
                }
                case 2: {
                    title = s_stringMgr.getString("LogPanel.titleError");
                    break;
                }
                default: {
                    title = s_stringMgr.getString("LogPanel.titleUnknown");
                }
            }
            errorDialog.setTitle(title);
            errorDialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLog(int logType, String source, Object message, Throwable t) {
        LogData log = new LogData();
        log.logType = logType;
        log.source = source;
        log.message = message;
        log.throwable = t;
        Vector<LogData> vector = this._logsDuringDisplayDelay;
        synchronized (vector) {
            this._logsDuringDisplayDelay.add(log);
        }
        this._displayLastLogTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePanel() {
        LogData[] logs;
        Vector<LogData> vector = this._logsDuringDisplayDelay;
        synchronized (vector) {
            logs = this._logsDuringDisplayDelay.toArray(new LogData[this._logsDuringDisplayDelay.size()]);
            this._logsDuringDisplayDelay.clear();
        }
        this._curlogToDisplay = null;
        for (int i = 0; i < logs.length; ++i) {
            if (null == this._curlogToDisplay) {
                this._curlogToDisplay = logs[i];
                continue;
            }
            if (this._curlogToDisplay.logType > logs[i].logType) continue;
            this._curlogToDisplay = logs[i];
        }
        this._lblLogInfo.setText(this._statistics.toString());
        this.setIconForCurLogType();
        this._whiteIconTimer.restart();
    }

    private void setIconForCurLogType() {
        if (null == this._curlogToDisplay) {
            this._btnLastLog.setIcon(this._resources.getIcon("white_gem"));
            return;
        }
        switch (this._curlogToDisplay.logType) {
            case 0: {
                this._btnLastLog.setIcon(this._resources.getIcon("green_gem"));
                break;
            }
            case 1: {
                this._btnLastLog.setIcon(this._resources.getIcon("yellow_gem"));
                break;
            }
            case 2: {
                this._btnLastLog.setIcon(this._resources.getIcon("red_gem"));
            }
        }
    }

    private static class LogStatistics {
        private int _errorCount;
        private int _warnCount;
        private int _infoCount;
        private String _toString = "";

        public LogStatistics() {
            this.updateToString();
        }

        public String toString() {
            return this._toString;
        }

        void setErrorCount(int errorCount) {
            this._errorCount = errorCount;
            this.updateToString();
        }

        private void updateToString() {
            Object[] params = new Integer[]{this._errorCount, this._warnCount, this._infoCount};
            this._toString = s_stringMgr.getString("LogPanel.logInfoLabel", params);
        }

        void setWarnCount(int warnCount) {
            this._warnCount = warnCount;
            this.updateToString();
        }

        void setInfoCount(int infoCount) {
            this._infoCount = infoCount;
            this.updateToString();
        }
    }

    private static class LogData {
        int logType = -1;
        Object message = null;
        Throwable throwable = null;
        String source;
        String logTime = DateFormat.getInstance().format(new Date());
    }
}

