
package TDS::AccessLog::Logging;
#$Id: Logging.pm,v 1.28.4.1 2001/02/13 00:48:09 tom Exp $
################################################################

=head1 NAME

TDS::AccessLog::Logging

=head1 SYNOPSIS

 use TDS::Status;
 use TDS::AccessLog::Logging;

 $s = new TDS::Status;
 $l = new TDS::AccessLog::Logging;
 $l->Add($s);

=head1 DESCRIPTION

logging
not get from robot nor author's access

=head1 MEMBER FUNCTIONS

=cut
    

################################################################
use strict;
use ObjectTemplate;
use CGI::Tools;

use TDS::AccessLog::Counter;
use TDS::AccessLog::DirInfo;

use vars qw(@ISA $RejectLogFlag $RobotLogFlag $UpdateLogFlag);
@ISA = qw(TDS::AccessLog::DirInfo);

attributes qw();
################################################################

$RejectLogFlag = 0 unless defined $RejectLogFlag;
$RobotLogFlag = 0 unless defined $RobotLogFlag;
$UpdateLogFlag = 1 unless defined $UpdateLogFlag;    # debug

=head2 $l->Add

add to log

=cut

sub Add($)
{
    my $self = shift;
    my $status = $TDS::Status;

    # don't get log if author's access
    return if $status->is_author;

    # increment counter
    my $prefix;
    my $counter = new TDS::AccessLog::Counter;
    if ($status->rejected){
	return unless $RejectLogFlag;
	$prefix = "reject";
    } elsif ($status->is_robot){
	return unless $RobotLogFlag;
	$prefix  = "robot";
    } else {
	$counter->Increment;
	$counter->Save;
    }
    my $filename = $self->GetLogFilename($status->start_time->year,
					 $status->start_time->month,
					 $prefix);

    add_to_logfile($filename, $counter->num->{all});

    return $counter;
}
sub add_to_logfile($;$)
{
    my ($filename, $counter) = @_;
    
    require DateTime::Format;
    require SimpleDB::Append;
    my $log = new SimpleDB::Append($filename);
    my $date_str = DateTime::Format::time2str("%Y/%m/%d %H:%M:%S %Z", time(), $TDS::System::TZ);
    my $status = $TDS::Status;
    
    $log->Append(sprintf("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%d\n",
			 $status->request_uri->uri,
			 $status->referer->uri,
			 $date_str,
			 $status->remote_host,
			 $status->user_agent->fullname,
			 $status->id->GetID(),
			 $status->id->GetTimes(),
			 $counter));

}
1;
