/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class DefaultApplyXSLProperties
extends ApplyXSLProperties {
    private final String DEFAULT_catalog;
    protected transient String localHost;

    public DefaultApplyXSLProperties() {
        this.DEFAULT_catalog = null;
        this.setLocalHost();
    }

    public DefaultApplyXSLProperties(ServletConfig servletConfig) {
        super(servletConfig);
        String string = servletConfig.getInitParameter("catalog");
        this.DEFAULT_catalog = string != null ? string : null;
        this.setLocalHost();
    }

    protected void setLocalHost() {
        try {
            this.localHost = InetAddress.getLocalHost().getHostName();
            return;
        }
        catch (Exception exception) {
            this.localHost = null;
            return;
        }
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public URL toSafeURL(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            try {
                return new URL("http", this.localHost, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new MalformedURLException("toSafeURL(): " + string + " did not map to local");
            }
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MalformedURLException("toSafeURL(): " + string + " not a valid URL");
        }
        try {
            return new URL(uRL.getProtocol(), this.localHost, uRL.getPort(), uRL.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            throw new MalformedURLException("toSafeURL(): " + string + " could not be converted to local host");
        }
    }

    public String getXMLurl(HttpServletRequest httpServletRequest) throws MalformedURLException {
        URL uRL = this.toSafeURL(this.getRequestParmString(httpServletRequest, "URL"));
        if (uRL == null) {
            return super.getXMLurl(null);
        }
        return uRL.toExternalForm();
    }

    public String getXSLRequestURL(HttpServletRequest httpServletRequest) throws MalformedURLException {
        URL uRL = this.toSafeURL(this.getRequestParmString(httpServletRequest, "xslURL"));
        if (uRL == null) {
            return null;
        }
        return uRL.toExternalForm();
    }

    public String getXSLurl(HttpServletRequest httpServletRequest) throws MalformedURLException {
        String string = this.getXSLRequestURL(httpServletRequest);
        if (string != null) {
            return string;
        }
        return super.getXSLurl(null);
    }

    public String[] getCatalog(HttpServletRequest httpServletRequest) {
        String[] stringArray = httpServletRequest.getParameterValues("catalog");
        if (this.DEFAULT_catalog == null) {
            return stringArray;
        }
        if (stringArray == null) {
            String[] stringArray2 = new String[]{this.DEFAULT_catalog};
            return stringArray2;
        }
        int n = stringArray.length + 1;
        String[] stringArray3 = new String[n];
        stringArray3[0] = this.DEFAULT_catalog;
        int n2 = 1;
        while (n2 < n) {
            stringArray3[n2] = stringArray[n2 - 1];
            ++n2;
        }
        return stringArray3;
    }
}

