/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import org.apache.cassandra.utils.Throwables;

public interface Transactional
extends AutoCloseable {
    public Throwable commit(Throwable var1);

    public Throwable abort(Throwable var1);

    public void prepareToCommit();

    @Override
    public void close();

    public static abstract class AbstractTransactional
    implements Transactional {
        private boolean permitRedundantTransitions;
        private State state = State.IN_PROGRESS;

        protected abstract Throwable doCommit(Throwable var1);

        protected abstract Throwable doAbort(Throwable var1);

        protected Throwable doPreCleanup(Throwable accumulate) {
            return accumulate;
        }

        protected Throwable doPostCleanup(Throwable accumulate) {
            return accumulate;
        }

        protected abstract void doPrepare();

        @Override
        public final Throwable commit(Throwable accumulate) {
            if (this.permitRedundantTransitions && this.state == State.COMMITTED) {
                return accumulate;
            }
            if (this.state != State.READY_TO_COMMIT) {
                throw new IllegalStateException("Cannot commit unless READY_TO_COMMIT; state is " + (Object)((Object)this.state));
            }
            accumulate = this.doCommit(accumulate);
            accumulate = this.doPostCleanup(accumulate);
            this.state = State.COMMITTED;
            return accumulate;
        }

        @Override
        public final Throwable abort(Throwable accumulate) {
            if (this.state == State.ABORTED) {
                return accumulate;
            }
            if (this.state == State.COMMITTED) {
                try {
                    throw new IllegalStateException("Attempted to abort a committed operation");
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge(accumulate, t);
                    return accumulate;
                }
            }
            this.state = State.ABORTED;
            accumulate = this.doPreCleanup(accumulate);
            accumulate = this.doAbort(accumulate);
            accumulate = this.doPostCleanup(accumulate);
            return accumulate;
        }

        @Override
        public final void close() {
            switch (this.state) {
                case COMMITTED: 
                case ABORTED: {
                    break;
                }
                default: {
                    this.abort();
                }
            }
        }

        @Override
        public final void prepareToCommit() {
            if (this.permitRedundantTransitions && this.state == State.READY_TO_COMMIT) {
                return;
            }
            if (this.state != State.IN_PROGRESS) {
                throw new IllegalStateException("Cannot prepare to commit unless IN_PROGRESS; state is " + (Object)((Object)this.state));
            }
            this.doPrepare();
            Throwables.maybeFail(this.doPreCleanup(null));
            this.state = State.READY_TO_COMMIT;
        }

        public Object finish() {
            this.prepareToCommit();
            this.commit();
            return this;
        }

        public final void abort() {
            Throwables.maybeFail(this.abort(null));
        }

        public final void commit() {
            Throwables.maybeFail(this.commit(null));
        }

        public final State state() {
            return this.state;
        }

        protected void permitRedundantTransitions() {
            this.permitRedundantTransitions = true;
        }

        public static enum State {
            IN_PROGRESS,
            READY_TO_COMMIT,
            COMMITTED,
            ABORTED;

        }
    }
}

