/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.activemq.apollo.util.FileSupport;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.sys.package$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSupport$
implements ScalaObject {
    public static final FileSupport$ MODULE$;

    static {
        new FileSupport$();
    }

    public FileSupport.RichFile to_rich_file(File file) {
        return new FileSupport.RichFile(file);
    }

    public File system_dir(String name) {
        String base_value = System.getProperty(name);
        if (base_value == null) {
            throw package$.MODULE$.error(Predef$.MODULE$.augmentString("The the %s system property is not set.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        File file = new File(base_value);
        if (file.isDirectory()) {
            return file;
        }
        throw package$.MODULE$.error(Predef$.MODULE$.augmentString("The the %s system property is not set to valid directory path %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, base_value})));
    }

    /*
     * WARNING - void declaration
     */
    public long copy(InputStream in, OutputStream out) {
        void var3_3;
        long bytesCopied = 0L;
        byte[] buffer = new byte[8192];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public <R, C extends Closeable> R using(C closable, Function1<C, R> proc) {
        void var3_3;
        Object exceptionResult1 = null;
        try {
            exceptionResult1 = proc.apply(closable);
        }
        finally {
            try {
                closable.close();
            }
            catch (Throwable throwable) {}
        }
        return var3_3;
    }

    public String read_text(InputStream in, String charset) {
        return new String(this.read_bytes(in), charset);
    }

    public String read_text$default$2() {
        return "UTF-8";
    }

    public byte[] read_bytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copy(in, out);
        return out.toByteArray();
    }

    public void write_text(OutputStream out, String value, String charset) {
        this.write_bytes(out, value.getBytes(charset));
    }

    public String write_text$default$3() {
        return "UTF-8";
    }

    public void write_bytes(OutputStream out, byte[] data) {
        this.copy(new ByteArrayInputStream(data), out);
    }

    private FileSupport$() {
        MODULE$ = this;
    }
}

