/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import java.util.ArrayList;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.AttributeSignature;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.ExceptionLoad;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.process.analyzer.classfile.visitor.AddCheckCastVisitor;
import jd.core.process.analyzer.classfile.visitor.SearchInstructionByOffsetVisitor;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.analyzer.util.InstructionUtil;
import jd.core.process.analyzer.variable.DefaultVariableNameGenerator;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableAnalyzer {
    private static final int UNDEFINED_TYPE = -1;
    private static final int NUMBER_TYPE = -2;
    private static final int OBJECT_TYPE = -3;

    public static void Analyze(ClassFile classFile, Method method, DefaultVariableNameGenerator variableNameGenerator, List<Instruction> list, List<Instruction> listForAnalyze) {
        ConstantPool constants = classFile.getConstantPool();
        variableNameGenerator.clearLocalNames();
        byte[] code = method.getCode();
        int codeLength = code == null ? 0 : code.length;
        LocalVariables localVariables = method.getLocalVariables();
        if (localVariables == null) {
            int nameIndex;
            localVariables = new LocalVariables();
            method.setLocalVariables(localVariables);
            if ((method.access_flags & 8) == 0) {
                nameIndex = constants.addConstantUtf8("this");
                int signatureIndex = constants.addConstantUtf8(classFile.getInternalClassName());
                LocalVariable lv = new LocalVariable(0, codeLength, nameIndex, signatureIndex, 0);
                localVariables.add(lv);
            }
            if (method.name_index == constants.instanceConstructorIndex && classFile.isAInnerClass() && (classFile.access_flags & 8) == 0) {
                nameIndex = constants.addConstantUtf8("this$1");
                String internalClassName = classFile.getInternalClassName();
                int lastInnerClassSeparatorIndex = internalClassName.lastIndexOf(36);
                String internalOuterClassName = String.valueOf(internalClassName.substring(0, lastInnerClassSeparatorIndex)) + ';';
                int signatureIndex = constants.addConstantUtf8(internalOuterClassName);
                LocalVariable lv = new LocalVariable(0, codeLength, nameIndex, signatureIndex, 1);
                localVariables.add(lv);
            }
            LocalVariableAnalyzer.AnalyzeMethodParameter(classFile, constants, method, localVariables, variableNameGenerator, codeLength);
            localVariables.setIndexOfFirstLocalVariable(localVariables.size());
            if (code != null) {
                LocalVariableAnalyzer.GenerateMissingMonitorLocalVariables(constants, localVariables, listForAnalyze);
            }
        } else {
            AttributeSignature as;
            String methodSignature;
            int indexOfFirstLocalVariable = ((method.access_flags & 8) == 0 ? 1 : 0) + SignatureUtil.GetParameterSignatureCount(methodSignature = constants.getConstantUtf8((as = method.getAttributeSignature()) == null ? method.descriptor_index : as.signature_index));
            if (indexOfFirstLocalVariable > localVariables.size()) {
                LocalVariableAnalyzer.AnalyzeMethodParameter(classFile, constants, method, localVariables, variableNameGenerator, codeLength);
            }
            localVariables.setIndexOfFirstLocalVariable(indexOfFirstLocalVariable);
            if (code != null) {
                LocalVariableAnalyzer.GenerateMissingMonitorLocalVariables(constants, localVariables, listForAnalyze);
                LocalVariableAnalyzer.CheckLocalVariableRanges(constants, code, localVariables, variableNameGenerator, listForAnalyze);
            }
        }
        if (code != null) {
            String returnedSignature = LocalVariableAnalyzer.GetReturnedSignature(classFile, method);
            LocalVariableAnalyzer.AnalyzeMethodCode(constants, localVariables, list, listForAnalyze, returnedSignature);
            LocalVariableAnalyzer.SetConstantTypes(classFile, constants, method, localVariables, list, listForAnalyze, returnedSignature);
            LocalVariableAnalyzer.InitialyzeExceptionLoad(listForAnalyze, localVariables);
        }
        LocalVariableAnalyzer.GenerateLocalVariableNames(constants, localVariables, variableNameGenerator);
    }

    private static void AnalyzeMethodParameter(ClassFile classFile, ConstantPool constants, Method method, LocalVariables localVariables, DefaultVariableNameGenerator variableNameGenerator, int codeLength) {
        AttributeSignature as = method.getAttributeSignature();
        boolean descriptorFlag = as == null;
        String methodSignature = constants.getConstantUtf8(descriptorFlag ? method.descriptor_index : as.signature_index);
        ArrayList<String> parameterTypes = SignatureUtil.GetParameterSignatures(methodSignature);
        if (parameterTypes != null) {
            boolean staticMethodFlag = (method.access_flags & 8) != 0;
            int variableIndex = staticMethodFlag ? 0 : 1;
            int firstVisibleParameterCounter = 0;
            if (method.name_index == constants.instanceConstructorIndex) {
                if ((classFile.access_flags & 0x4000) != 0) {
                    if (descriptorFlag) {
                        firstVisibleParameterCounter = 2;
                    } else {
                        variableIndex = 3;
                    }
                } else if (classFile.isAInnerClass() && (classFile.access_flags & 8) == 0) {
                    firstVisibleParameterCounter = 1;
                }
            }
            int anonymousClassDepth = 0;
            ClassFile anonymousClassFile = classFile;
            while (anonymousClassFile != null && anonymousClassFile.getInternalAnonymousClassName() != null) {
                ++anonymousClassDepth;
                anonymousClassFile = anonymousClassFile.getOuterClass();
            }
            int length = parameterTypes.size();
            int varargsParameterIndex = (method.access_flags & 0x80) == 0 ? Integer.MAX_VALUE : length - 1;
            int parameterIndex = 0;
            while (parameterIndex < length) {
                char firstChar;
                String signature = (String)parameterTypes.get(parameterIndex);
                if (localVariables.getLocalVariableWithIndexAndOffset(variableIndex, 0) == null) {
                    boolean appearsOnceFlag = LocalVariableAnalyzer.SignatureAppearsOnceInParameters(parameterTypes, firstVisibleParameterCounter, length, signature);
                    String name = variableNameGenerator.generateParameterNameFromSignature(signature, appearsOnceFlag, parameterIndex == varargsParameterIndex, anonymousClassDepth);
                    int nameIndex = constants.addConstantUtf8(name);
                    int signatureIndex = constants.addConstantUtf8(signature);
                    LocalVariable lv = new LocalVariable(0, codeLength, nameIndex, signatureIndex, variableIndex);
                    localVariables.add(lv);
                }
                variableIndex += (firstChar = signature.charAt(0)) == 'D' || firstChar == 'J' ? 2 : 1;
                ++parameterIndex;
            }
        }
    }

    private static void GenerateMissingMonitorLocalVariables(ConstantPool constants, LocalVariables localVariables, List<Instruction> listForAnalyze) {
        int length = listForAnalyze.size();
        int i = 1;
        while (i < length) {
            block8: {
                LocalVariable lv;
                ALoad al;
                int monitorLocalVariableLenght;
                int monitorLocalVariableOffset;
                int monitorLocalVariableIndex;
                Instruction instruction;
                block10: {
                    MonitorEnter mEnter;
                    block9: {
                        instruction = listForAnalyze.get(i);
                        if (instruction.opcode != 194) break block8;
                        mEnter = (MonitorEnter)instruction;
                        monitorLocalVariableIndex = 0;
                        monitorLocalVariableOffset = 0;
                        monitorLocalVariableLenght = 1;
                        if (mEnter.objectref.opcode != 263) break block9;
                        instruction = listForAnalyze.get(i - 1);
                        if (instruction.opcode != 58) break block8;
                        AStore astore = (AStore)instruction;
                        if (astore.valueref.opcode != 263) break block8;
                        DupLoad dupload1 = (DupLoad)mEnter.objectref;
                        DupLoad dupload2 = (DupLoad)astore.valueref;
                        if (dupload1.dupStore != dupload2.dupStore) break block8;
                        monitorLocalVariableIndex = astore.index;
                        monitorLocalVariableOffset = astore.offset;
                        break block10;
                    }
                    if (mEnter.objectref.opcode != 25) break block8;
                    ALoad aload = (ALoad)mEnter.objectref;
                    instruction = listForAnalyze.get(i - 1);
                    if (instruction.opcode != 58) break block8;
                    AStore astore = (AStore)instruction;
                    if (astore.index != aload.index) break block8;
                    monitorLocalVariableIndex = astore.index;
                    monitorLocalVariableOffset = astore.offset;
                }
                int monitorExitCount = 0;
                int j = i;
                while (++j < length) {
                    instruction = listForAnalyze.get(j);
                    if (instruction.opcode != 195 || ((MonitorExit)instruction).objectref.opcode != 25) continue;
                    al = (ALoad)((MonitorExit)instruction).objectref;
                    if (al.index != monitorLocalVariableIndex) continue;
                    monitorLocalVariableLenght = al.offset - monitorLocalVariableOffset;
                    ++monitorExitCount;
                }
                if (monitorExitCount == 1) {
                    j = i;
                    while (j-- > 0) {
                        instruction = listForAnalyze.get(j);
                        if (instruction.opcode != 195 || ((MonitorExit)instruction).objectref.opcode != 25) continue;
                        al = (ALoad)((MonitorExit)instruction).objectref;
                        if (al.index != monitorLocalVariableIndex) continue;
                        monitorLocalVariableLenght += monitorLocalVariableOffset - al.offset;
                        monitorLocalVariableOffset = al.offset;
                        ++monitorExitCount;
                        break;
                    }
                }
                if (monitorExitCount >= 2 && ((lv = localVariables.getLocalVariableWithIndexAndOffset(monitorLocalVariableIndex, monitorLocalVariableOffset)) == null || lv.start_pc + lv.length < monitorLocalVariableOffset + monitorLocalVariableLenght)) {
                    int signatureIndex = constants.addConstantUtf8("Ljava/lang/Object;");
                    localVariables.add(new LocalVariable(monitorLocalVariableOffset, monitorLocalVariableLenght, signatureIndex, signatureIndex, monitorLocalVariableIndex));
                }
            }
            ++i;
        }
    }

    private static void CheckLocalVariableRanges(ConstantPool constants, byte[] code, LocalVariables localVariables, DefaultVariableNameGenerator variableNameGenerator, List<Instruction> listForAnalyze) {
        int length = localVariables.size();
        int i = localVariables.getIndexOfFirstLocalVariable();
        while (i < length) {
            localVariables.getLocalVariableAt((int)i).length = 1;
            ++i;
        }
        length = listForAnalyze.size();
        i = 0;
        while (i < length) {
            Instruction instruction = listForAnalyze.get(i);
            switch (instruction.opcode) {
                case 277: 
                case 278: {
                    instruction = ((IncInstruction)instruction).value;
                    if (instruction.opcode != 21 && instruction.opcode != 268) break;
                    LocalVariableAnalyzer.CheckLocalVariableRangesForIndexInstruction(code, localVariables, (IndexInstruction)instruction);
                    break;
                }
                case 58: {
                    AStore astore = (AStore)instruction;
                    if (astore.valueref.opcode == 270) {
                        LocalVariable lv;
                        ExceptionLoad el = (ExceptionLoad)astore.valueref;
                        if (el.exceptionNameIndex == 0 || (lv = localVariables.getLocalVariableWithIndexAndOffset(astore.index, astore.offset)) != null) break;
                        int nextOffset = ByteCodeUtil.NextInstructionOffset(code, astore.offset);
                        lv = localVariables.getLocalVariableWithIndexAndOffset(astore.index, nextOffset);
                        if (lv == null) {
                            lv = new LocalVariable(astore.offset, 1, -1, el.exceptionNameIndex, astore.index, true);
                            localVariables.add(lv);
                            String signature = constants.getConstantUtf8(el.exceptionNameIndex);
                            boolean appearsOnce = LocalVariableAnalyzer.SignatureAppearsOnceInLocalVariables(localVariables, localVariables.size(), el.exceptionNameIndex);
                            String name = variableNameGenerator.generateLocalVariableNameFromSignature(signature, appearsOnce);
                            lv.name_index = constants.addConstantUtf8(name);
                            break;
                        }
                        lv.updateRange(astore.offset);
                        break;
                    }
                    if (i + 1 < length && astore.valueref.opcode == 263 && listForAnalyze.get((int)(i + 1)).opcode == 194) {
                        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(astore.index, astore.offset);
                        if (lv != null) break;
                        MonitorEnter me = (MonitorEnter)listForAnalyze.get(i + 1);
                        if (me.objectref.opcode == 263 && ((DupLoad)astore.valueref).dupStore == ((DupLoad)me.objectref).dupStore) {
                            int signatureIndex = constants.addConstantUtf8("Ljava/lang/Object;");
                            localVariables.add(new LocalVariable(astore.offset, 1, signatureIndex, signatureIndex, astore.index));
                            break;
                        }
                        LocalVariableAnalyzer.CheckLocalVariableRangesForIndexInstruction(code, localVariables, astore);
                        break;
                    }
                    LocalVariableAnalyzer.CheckLocalVariableRangesForIndexInstruction(code, localVariables, astore);
                    break;
                }
                case 21: 
                case 25: 
                case 54: 
                case 132: 
                case 268: 
                case 269: {
                    LocalVariableAnalyzer.CheckLocalVariableRangesForIndexInstruction(code, localVariables, (IndexInstruction)instruction);
                }
            }
            ++i;
        }
    }

    private static void CheckLocalVariableRangesForIndexInstruction(byte[] code, LocalVariables localVariables, IndexInstruction ii) {
        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(ii.index, ii.offset);
        if (lv == null) {
            int nextOffset = ByteCodeUtil.NextInstructionOffset(code, ii.offset);
            lv = localVariables.getLocalVariableWithIndexAndOffset(ii.index, nextOffset);
            if (lv != null) {
                lv.updateRange(ii.offset);
            } else {
                lv = localVariables.searchLocalVariableWithIndexAndOffset(ii.index, ii.offset);
                if (lv != null) {
                    lv.updateRange(ii.offset);
                }
            }
        } else {
            lv.updateRange(ii.offset);
        }
    }

    private static void AnalyzeMethodCode(ConstantPool constants, LocalVariables localVariables, List<Instruction> list, List<Instruction> listForAnalyze, String returnedSignature) {
        LocalVariable lv;
        boolean change;
        int length = listForAnalyze.size();
        int i = 0;
        while (i < length) {
            Instruction instruction = listForAnalyze.get(i);
            switch (instruction.opcode) {
                case 21: 
                case 25: 
                case 54: 
                case 58: 
                case 132: 
                case 268: 
                case 269: {
                    LocalVariableAnalyzer.SubAnalyzeMethodCode(constants, localVariables, list, listForAnalyze, ((IndexInstruction)instruction).index, i, returnedSignature);
                }
            }
            ++i;
        }
        do {
            change = false;
            int i2 = 0;
            while (i2 < length) {
                Instruction instruction = listForAnalyze.get(i2);
                switch (instruction.opcode) {
                    case 54: {
                        StoreInstruction si = (StoreInstruction)instruction;
                        if (si.valueref.opcode != 21) break;
                        change |= LocalVariableAnalyzer.ReverseAnalyzeIStore(localVariables, si);
                        break;
                    }
                    case 179: {
                        LoadInstruction load;
                        PutStatic ps = (PutStatic)instruction;
                        switch (ps.valueref.opcode) {
                            case 21: 
                            case 25: {
                                load = (LoadInstruction)ps.valueref;
                                change |= LocalVariableAnalyzer.ReverseAnalyzePutStaticPutField(constants, localVariables, ps, load);
                            }
                        }
                        break;
                    }
                    case 181: {
                        LoadInstruction load;
                        PutField pf = (PutField)instruction;
                        switch (pf.valueref.opcode) {
                            case 21: 
                            case 25: {
                                load = (LoadInstruction)pf.valueref;
                                change |= LocalVariableAnalyzer.ReverseAnalyzePutStaticPutField(constants, localVariables, pf, load);
                            }
                        }
                    }
                }
                ++i2;
            }
        } while (change);
        int internalObjectSignatureIndex = constants.addConstantUtf8("Ljava/lang/Object;");
        length = localVariables.size();
        int i3 = 0;
        while (i3 < length) {
            lv = localVariables.getLocalVariableAt(i3);
            switch (lv.signature_index) {
                case -1: {
                    lv.signature_index = constants.addConstantUtf8("Ljava/lang/Object;");
                    break;
                }
                case -2: {
                    lv.signature_index = constants.addConstantUtf8(SignatureUtil.GetSignatureFromTypesBitField(lv.typesBitField));
                    break;
                }
                case -3: {
                    lv.signature_index = internalObjectSignatureIndex;
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < length) {
            lv = localVariables.getLocalVariableAt(i3);
            if (lv.signature_index == internalObjectSignatureIndex) {
                LocalVariableAnalyzer.AddCastInstruction(constants, list, localVariables, lv);
            }
            ++i3;
        }
    }

    private static void SubAnalyzeMethodCode(ConstantPool constants, LocalVariables localVariables, List<Instruction> list, List<Instruction> listForAnalyze, int varIndex, int startIndex, String returnedSignature) {
        IndexInstruction firstInstruction = (IndexInstruction)listForAnalyze.get(startIndex);
        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(firstInstruction.index, firstInstruction.offset);
        if (lv != null) {
            if (firstInstruction.opcode == 58) {
                AStore astore = (AStore)firstInstruction;
                if (astore.valueref.opcode == 270) {
                    lv.exceptionOrReturnAddress = true;
                }
            }
            return;
        }
        int length = listForAnalyze.size();
        int i = startIndex;
        while (i < length) {
            Instruction instruction = listForAnalyze.get(i);
            switch (instruction.opcode) {
                case 54: {
                    if (((IndexInstruction)instruction).index != varIndex) break;
                    LocalVariableAnalyzer.AnalyzeIStore(constants, localVariables, instruction);
                    break;
                }
                case 269: {
                    if (((IndexInstruction)instruction).index != varIndex) break;
                    LocalVariableAnalyzer.AnalyzeStore(constants, localVariables, instruction);
                    break;
                }
                case 58: {
                    if (((IndexInstruction)instruction).index != varIndex) break;
                    LocalVariableAnalyzer.AnalyzeAStore(constants, localVariables, instruction);
                    break;
                }
                case 277: 
                case 278: {
                    instruction = ((IncInstruction)instruction).value;
                    if (instruction.opcode != 21 && instruction.opcode != 268) break;
                }
                case 21: 
                case 132: {
                    if (((IndexInstruction)instruction).index != varIndex) break;
                    LocalVariableAnalyzer.AnalyzeILoad(localVariables, instruction);
                    break;
                }
                case 268: 
                case 270: {
                    if (((IndexInstruction)instruction).index != varIndex) break;
                    LocalVariableAnalyzer.AnalyzeLoad(localVariables, instruction);
                    break;
                }
                case 25: {
                    if (((IndexInstruction)instruction).index != varIndex) break;
                    LocalVariableAnalyzer.AnalyzeALoad(localVariables, instruction);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    LocalVariableAnalyzer.AnalyzeInvokeInstruction(constants, localVariables, instruction, varIndex);
                    break;
                }
                case 267: {
                    BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                    LocalVariableAnalyzer.AnalyzeBinaryOperator(constants, localVariables, instruction, boi.value1, boi.value2, varIndex);
                    break;
                }
                case 261: {
                    IfCmp ic = (IfCmp)instruction;
                    LocalVariableAnalyzer.AnalyzeBinaryOperator(constants, localVariables, instruction, ic.value1, ic.value2, varIndex);
                    break;
                }
                case 273: {
                    LocalVariableAnalyzer.AnalyzeReturnInstruction(constants, localVariables, instruction, varIndex, returnedSignature);
                }
            }
            ++i;
        }
    }

    private static void AnalyzeIStore(ConstantPool constants, LocalVariables localVariables, Instruction instruction) {
        StoreInstruction store = (StoreInstruction)instruction;
        int index = store.index;
        int offset = store.offset;
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        String signature = store.getReturnedSignature(constants, localVariables);
        if (lv == null) {
            int typesBitField;
            if (signature == null) {
                if (store.valueref.opcode == 21) {
                    ILoad iload = (ILoad)store.valueref;
                    lv = localVariables.getLocalVariableWithIndexAndOffset(iload.index, iload.offset);
                    typesBitField = lv == null ? 31 : lv.typesBitField;
                } else {
                    typesBitField = 31;
                }
            } else {
                typesBitField = SignatureUtil.CreateTypesBitField(signature);
            }
            localVariables.add(new LocalVariable(offset, 1, -1, -2, index, typesBitField));
        } else if (signature == null) {
            lv.updateRange(offset);
        } else {
            int typesBitField = SignatureUtil.CreateTypesBitField(signature);
            switch (lv.signature_index) {
                case -2: {
                    if ((typesBitField & lv.typesBitField) != 0) {
                        lv.typesBitField &= typesBitField;
                        lv.updateRange(offset);
                        break;
                    }
                    localVariables.add(new LocalVariable(offset, 1, -1, -2, index, typesBitField));
                    break;
                }
                case -3: 
                case -1: {
                    localVariables.add(new LocalVariable(offset, 1, -1, -2, index, typesBitField));
                    break;
                }
                default: {
                    String signatureLV = constants.getConstantUtf8(lv.signature_index);
                    int typesBitFieldLV = SignatureUtil.CreateTypesBitField(signatureLV);
                    if ((typesBitField & typesBitFieldLV) != 0) {
                        lv.updateRange(offset);
                        break;
                    }
                    localVariables.add(new LocalVariable(offset, 1, -1, -2, index, typesBitField));
                }
            }
        }
    }

    private static void AnalyzeILoad(LocalVariables localVariables, Instruction instruction) {
        IndexInstruction load = (IndexInstruction)instruction;
        int index = load.index;
        int offset = load.offset;
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        if (lv == null) {
            localVariables.add(new LocalVariable(offset, 1, -1, -2, index, 31));
        } else {
            lv.updateRange(offset);
        }
    }

    private static void AnalyzeLoad(LocalVariables localVariables, Instruction instruction) {
        IndexInstruction load = (IndexInstruction)instruction;
        int index = load.index;
        int offset = load.offset;
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        if (lv == null) {
            localVariables.add(new LocalVariable(offset, 1, -1, -1, index));
        } else {
            lv.updateRange(offset);
        }
    }

    private static void AnalyzeALoad(LocalVariables localVariables, Instruction instruction) {
        IndexInstruction load = (IndexInstruction)instruction;
        int index = load.index;
        int offset = load.offset;
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        if (lv == null) {
            localVariables.add(new LocalVariable(offset, 1, -1, -1, index));
        } else {
            lv.updateRange(offset);
        }
    }

    private static void AnalyzeInvokeInstruction(ConstantPool constants, LocalVariables localVariables, Instruction instruction, int varIndex) {
        InvokeInstruction invokeInstruction = (InvokeInstruction)instruction;
        List<Instruction> args = invokeInstruction.args;
        List<String> argSignatures = invokeInstruction.getListOfParameterSignatures(constants);
        int nbrOfArgs = args.size();
        int j = 0;
        while (j < nbrOfArgs) {
            LocalVariableAnalyzer.AnalyzeArgOrReturnedInstruction(constants, localVariables, args.get(j), varIndex, argSignatures.get(j));
            ++j;
        }
    }

    private static void AnalyzeArgOrReturnedInstruction(ConstantPool constants, LocalVariables localVariables, Instruction instruction, int varIndex, String signature) {
        block0 : switch (instruction.opcode) {
            case 21: {
                LocalVariable lv;
                LoadInstruction li = (LoadInstruction)instruction;
                if (li.index != varIndex || (lv = localVariables.searchLocalVariableWithIndexAndOffset(li.index, li.offset)) == null) break;
                lv.typesBitField &= SignatureUtil.CreateArgOrReturnBitFields(signature);
                break;
            }
            case 25: {
                LocalVariable lv;
                LoadInstruction li = (LoadInstruction)instruction;
                if (li.index != varIndex || (lv = localVariables.searchLocalVariableWithIndexAndOffset(li.index, li.offset)) == null) break;
                switch (lv.signature_index) {
                    case -1: {
                        lv.signature_index = constants.addConstantUtf8(signature);
                        break block0;
                    }
                    case -2: {
                        new Throwable("type inattendu").printStackTrace();
                    }
                }
            }
        }
    }

    private static void AnalyzeBinaryOperator(ConstantPool constants, LocalVariables localVariables, Instruction instruction, Instruction i1, Instruction i2, int varIndex) {
        LocalVariable lv2;
        if (!(i1.opcode == 21 && ((ILoad)i1).index == varIndex || i2.opcode == 21 && ((ILoad)i2).index == varIndex)) {
            return;
        }
        LocalVariable lv1 = i1.opcode == 21 ? localVariables.searchLocalVariableWithIndexAndOffset(((ILoad)i1).index, i1.offset) : null;
        LocalVariable localVariable = lv2 = i2.opcode == 21 ? localVariables.searchLocalVariableWithIndexAndOffset(((ILoad)i2).index, i2.offset) : null;
        if (lv1 != null) {
            lv1.updateRange(instruction.offset);
            if (lv2 != null) {
                lv2.updateRange(instruction.offset);
            }
            if (lv1.signature_index == -2) {
                if (lv2 != null) {
                    if (lv2.signature_index == -2) {
                        lv1.typesBitField &= lv2.typesBitField;
                        lv2.typesBitField &= lv1.typesBitField;
                    } else {
                        lv1.signature_index = lv2.signature_index;
                    }
                } else {
                    int type;
                    String signature = i2.getReturnedSignature(constants, localVariables);
                    if (SignatureUtil.IsIntegerSignature(signature) && (type = SignatureUtil.CreateTypesBitField(signature)) != 0) {
                        lv1.typesBitField &= type;
                    }
                }
            } else if (lv2 != null && lv2.signature_index == -2) {
                lv2.signature_index = lv1.signature_index;
            }
        } else if (lv2 != null) {
            int type;
            String signature;
            lv2.updateRange(instruction.offset);
            if (lv2.signature_index == -2 && SignatureUtil.IsIntegerSignature(signature = i1.getReturnedSignature(constants, localVariables)) && (type = SignatureUtil.CreateTypesBitField(signature)) != 0) {
                lv2.typesBitField &= type;
            }
        }
    }

    private static void AnalyzeReturnInstruction(ConstantPool constants, LocalVariables localVariables, Instruction instruction, int varIndex, String returnedSignature) {
        ReturnInstruction ri = (ReturnInstruction)instruction;
        LocalVariableAnalyzer.AnalyzeArgOrReturnedInstruction(constants, localVariables, ri.valueref, varIndex, returnedSignature);
    }

    private static void AnalyzeStore(ConstantPool constants, LocalVariables localVariables, Instruction instruction) {
        int signatureIndex;
        StoreInstruction store = (StoreInstruction)instruction;
        int index = store.index;
        int offset = store.offset;
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        String signature = instruction.getReturnedSignature(constants, localVariables);
        int n = signatureIndex = signature != null ? constants.addConstantUtf8(signature) : -1;
        if (lv == null) {
            localVariables.add(new LocalVariable(offset, 1, -1, signatureIndex, index));
        } else if (lv.signature_index == signatureIndex) {
            lv.updateRange(offset);
        } else {
            localVariables.add(new LocalVariable(offset, 1, -1, signatureIndex, index));
        }
    }

    private static void AnalyzeAStore(ConstantPool constants, LocalVariables localVariables, Instruction instruction) {
        boolean isExceptionOrReturnAddress;
        StoreInstruction store = (StoreInstruction)instruction;
        int index = store.index;
        int offset = store.offset;
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        String signatureInstruction = instruction.getReturnedSignature(constants, localVariables);
        int signatureInstructionIndex = signatureInstruction != null ? constants.addConstantUtf8(signatureInstruction) : -1;
        boolean bl = isExceptionOrReturnAddress = store.valueref.opcode == 270 || store.valueref.opcode == 279;
        if (lv == null || lv.exceptionOrReturnAddress || isExceptionOrReturnAddress && lv.start_pc + lv.length < offset) {
            localVariables.add(new LocalVariable(offset, 1, -1, signatureInstructionIndex, index, isExceptionOrReturnAddress));
        } else if (!isExceptionOrReturnAddress) {
            if (lv.signature_index == -1) {
                lv.signature_index = signatureInstructionIndex;
                lv.updateRange(offset);
            } else if (lv.signature_index == -2) {
                localVariables.add(new LocalVariable(offset, 1, -1, signatureInstructionIndex, index));
            } else if (lv.signature_index == signatureInstructionIndex || lv.signature_index == -3) {
                lv.updateRange(offset);
            } else {
                String signatureLV = constants.getConstantUtf8(lv.signature_index);
                if (SignatureUtil.IsPrimitiveSignature(signatureLV)) {
                    localVariables.add(new LocalVariable(offset, 1, -1, signatureInstructionIndex, index));
                } else if (signatureInstructionIndex != -1) {
                    lv.signature_index = -3;
                    lv.updateRange(offset);
                } else {
                    lv.updateRange(offset);
                }
            }
        }
    }

    private static void SetConstantTypes(ClassFile classFile, ConstantPool constants, Method method, LocalVariables localVariables, List<Instruction> list, List<Instruction> listForAnalyze, String returnedSignature) {
        Instruction instruction;
        int length = listForAnalyze.size();
        int i = 0;
        while (i < length) {
            instruction = listForAnalyze.get(i);
            switch (instruction.opcode) {
                case 272: {
                    LocalVariableAnalyzer.SetConstantTypesArrayStore(constants, localVariables, (ArrayStoreInstruction)instruction);
                    break;
                }
                case 267: {
                    BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                    LocalVariableAnalyzer.SetConstantTypesBinaryOperator(constants, localVariables, boi.value1, boi.value2);
                    break;
                }
                case 261: {
                    IfCmp ic = (IfCmp)instruction;
                    LocalVariableAnalyzer.SetConstantTypesBinaryOperator(constants, localVariables, ic.value1, ic.value2);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 274: {
                    LocalVariableAnalyzer.SetConstantTypesInvokeInstruction(constants, instruction);
                    break;
                }
                case 54: {
                    LocalVariableAnalyzer.SetConstantTypesIStore(constants, localVariables, instruction);
                    break;
                }
                case 181: {
                    PutField putField = (PutField)instruction;
                    LocalVariableAnalyzer.SetConstantTypesPutFieldAndPutStatic(constants, localVariables, putField.valueref, putField.index);
                    break;
                }
                case 179: {
                    PutStatic putStatic = (PutStatic)instruction;
                    LocalVariableAnalyzer.SetConstantTypesPutFieldAndPutStatic(constants, localVariables, putStatic.valueref, putStatic.index);
                    break;
                }
                case 273: {
                    LocalVariableAnalyzer.SetConstantTypesXReturn(instruction, returnedSignature);
                }
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            instruction = listForAnalyze.get(i);
            if (instruction.opcode == 280) {
                TernaryOpStore tos = (TernaryOpStore)instruction;
                LocalVariableAnalyzer.SetConstantTypesTernaryOpStore(constants, localVariables, list, tos);
            }
            ++i;
        }
    }

    private static void SetConstantTypesInvokeInstruction(ConstantPool constants, Instruction instruction) {
        InvokeInstruction invokeInstruction = (InvokeInstruction)instruction;
        List<Instruction> args = invokeInstruction.args;
        List<String> types = invokeInstruction.getListOfParameterSignatures(constants);
        int nbrOfArgs = args.size();
        int j = 0;
        while (j < nbrOfArgs) {
            Instruction arg = args.get(j);
            switch (arg.opcode) {
                case 16: 
                case 17: 
                case 256: {
                    ((IConst)arg).setReturnedSignature(types.get(j));
                }
            }
            ++j;
        }
    }

    private static void SetConstantTypesPutFieldAndPutStatic(ConstantPool constants, LocalVariables localVariables, Instruction valueref, int index) {
        switch (valueref.opcode) {
            case 16: 
            case 17: 
            case 256: {
                ConstantFieldref cfr = constants.getConstantFieldref(index);
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                String signature = constants.getConstantUtf8(cnat.descriptor_index);
                ((IConst)valueref).setReturnedSignature(signature);
            }
        }
    }

    private static void SetConstantTypesTernaryOpStore(ConstantPool constants, LocalVariables localVariables, List<Instruction> list, TernaryOpStore tos) {
        block0 : switch (tos.objectref.opcode) {
            case 16: 
            case 17: 
            case 256: {
                int index = InstructionUtil.getIndexForOffset(list, tos.ternaryOp2ndValueOffset);
                if (index == -1) break;
                int length = list.size();
                while (index < length) {
                    Instruction result = SearchInstructionByOffsetVisitor.visit(list.get(index), tos.ternaryOp2ndValueOffset);
                    if (result != null) {
                        String signature = result.getReturnedSignature(constants, localVariables);
                        ((IConst)tos.objectref).setReturnedSignature(signature);
                        break block0;
                    }
                    ++index;
                }
                break;
            }
        }
    }

    private static void SetConstantTypesArrayStore(ConstantPool constants, LocalVariables localVariables, ArrayStoreInstruction asi) {
        block0 : switch (asi.valueref.opcode) {
            case 16: 
            case 17: 
            case 256: {
                switch (asi.arrayref.opcode) {
                    case 25: {
                        ALoad aload = (ALoad)asi.arrayref;
                        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(aload.index, aload.offset);
                        if (lv == null) {
                            new Throwable("lv is null. index=" + aload.index).printStackTrace();
                            return;
                        }
                        String signature = constants.getConstantUtf8(lv.signature_index);
                        ((IConst)asi.valueref).setReturnedSignature(SignatureUtil.CutArrayDimensionPrefix(signature));
                        break block0;
                    }
                    case 178: 
                    case 180: {
                        IndexInstruction ii = (IndexInstruction)asi.arrayref;
                        ConstantFieldref cfr = constants.getConstantFieldref(ii.index);
                        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                        String signature = constants.getConstantUtf8(cnat.descriptor_index);
                        ((IConst)asi.valueref).setReturnedSignature(SignatureUtil.CutArrayDimensionPrefix(signature));
                    }
                }
            }
        }
    }

    private static void SetConstantTypesIStore(ConstantPool constants, LocalVariables localVariables, Instruction instruction) {
        StoreInstruction store = (StoreInstruction)instruction;
        switch (store.valueref.opcode) {
            case 16: 
            case 17: 
            case 256: {
                LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(store.index, store.offset);
                String signature = constants.getConstantUtf8(lv.signature_index);
                ((IConst)store.valueref).setReturnedSignature(signature);
            }
        }
    }

    private static void SetConstantTypesBinaryOperator(ConstantPool constants, LocalVariables localVariables, Instruction i1, Instruction i2) {
        block0 : switch (i1.opcode) {
            case 16: 
            case 17: 
            case 256: {
                switch (i2.opcode) {
                    case 16: 
                    case 17: 
                    case 256: {
                        break block0;
                    }
                }
                String signature = i2.getReturnedSignature(constants, localVariables);
                if (signature == null) break;
                ((IConst)i1).setReturnedSignature(signature);
                break;
            }
            default: {
                switch (i2.opcode) {
                    case 16: 
                    case 17: 
                    case 256: {
                        String signature = i1.getReturnedSignature(constants, localVariables);
                        if (signature == null) break block0;
                        ((IConst)i2).setReturnedSignature(signature);
                    }
                }
            }
        }
    }

    private static void SetConstantTypesXReturn(Instruction instruction, String returnedSignature) {
        ReturnInstruction ri = (ReturnInstruction)instruction;
        int opcode = ri.valueref.opcode;
        if (opcode != 17 && opcode != 16 && opcode != 256) {
            return;
        }
        ((IConst)ri.valueref).signature = returnedSignature;
    }

    private static String GetReturnedSignature(ClassFile classFile, Method method) {
        AttributeSignature as = method.getAttributeSignature();
        int signatureIndex = as == null ? method.descriptor_index : as.signature_index;
        String signature = classFile.getConstantPool().getConstantUtf8(signatureIndex);
        return SignatureUtil.GetMethodReturnedSignature(signature);
    }

    private static void InitialyzeExceptionLoad(List<Instruction> listForAnalyze, LocalVariables localVariables) {
        Instruction i;
        int length = listForAnalyze.size();
        int index = 0;
        while (index < length) {
            i = listForAnalyze.get(index);
            if (i.opcode == 58) {
                AStore as = (AStore)i;
                if (as.valueref.opcode == 270) {
                    ExceptionLoad el = (ExceptionLoad)as.valueref;
                    if (el.index == -1) {
                        el.index = as.index;
                    }
                }
            }
            ++index;
        }
        index = 0;
        while (index < length) {
            i = listForAnalyze.get(index);
            if (i.opcode == 270) {
                ExceptionLoad el = (ExceptionLoad)i;
                if (el.index == -1 && el.exceptionNameIndex > 0) {
                    int varIndex = localVariables.size();
                    LocalVariable localVariable = new LocalVariable(el.offset, 1, -1, el.exceptionNameIndex, varIndex, true);
                    localVariables.add(localVariable);
                    el.index = varIndex;
                }
            }
            ++index;
        }
    }

    private static void GenerateLocalVariableNames(ConstantPool constants, LocalVariables localVariables, DefaultVariableNameGenerator variableNameGenerator) {
        int length = localVariables.size();
        int i = localVariables.getIndexOfFirstLocalVariable();
        while (i < length) {
            LocalVariable lv = localVariables.getLocalVariableAt(i);
            if (lv != null && lv.name_index <= 0) {
                String signature = constants.getConstantUtf8(lv.signature_index);
                boolean appearsOnce = LocalVariableAnalyzer.SignatureAppearsOnceInLocalVariables(localVariables, length, lv.signature_index);
                String name = variableNameGenerator.generateLocalVariableNameFromSignature(signature, appearsOnce);
                lv.name_index = constants.addConstantUtf8(name);
            }
            ++i;
        }
    }

    private static boolean SignatureAppearsOnceInParameters(List<String> parameterTypes, int firstIndex, int length, String signature) {
        int counter = 0;
        int i = firstIndex;
        while (i < length && counter < 2) {
            if (signature.equals(parameterTypes.get(i))) {
                ++counter;
            }
            ++i;
        }
        return counter <= 1;
    }

    private static boolean SignatureAppearsOnceInLocalVariables(LocalVariables localVariables, int length, int signature_index) {
        int counter = 0;
        int i = localVariables.getIndexOfFirstLocalVariable();
        while (i < length && counter < 2) {
            LocalVariable lv = localVariables.getLocalVariableAt(i);
            if (lv != null && lv.signature_index == signature_index) {
                ++counter;
            }
            ++i;
        }
        return counter == 1;
    }

    private static boolean ReverseAnalyzeIStore(LocalVariables localVariables, StoreInstruction si) {
        LoadInstruction load = (LoadInstruction)si.valueref;
        LocalVariable lvLoad = localVariables.getLocalVariableWithIndexAndOffset(load.index, load.offset);
        if (lvLoad == null || lvLoad.signature_index != -2) {
            return false;
        }
        LocalVariable lvStore = localVariables.getLocalVariableWithIndexAndOffset(si.index, si.offset);
        if (lvStore == null) {
            return false;
        }
        if (lvStore.signature_index == -2) {
            int old = lvLoad.typesBitField;
            lvLoad.typesBitField &= lvStore.typesBitField;
            return old != lvLoad.typesBitField;
        }
        if (lvStore.signature_index >= 0 && lvStore.signature_index != lvLoad.signature_index) {
            lvLoad.signature_index = lvStore.signature_index;
            return true;
        }
        return false;
    }

    private static boolean ReverseAnalyzePutStaticPutField(ConstantPool constants, LocalVariables localVariables, IndexInstruction ii, LoadInstruction load) {
        LocalVariable lvLoad = localVariables.getLocalVariableWithIndexAndOffset(load.index, load.offset);
        if (lvLoad != null) {
            ConstantFieldref cfr = constants.getConstantFieldref(ii.index);
            ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
            if (lvLoad.signature_index == -2) {
                String descriptor = constants.getConstantUtf8(cnat.descriptor_index);
                int typesBitField = SignatureUtil.CreateArgOrReturnBitFields(descriptor);
                int old = lvLoad.typesBitField;
                lvLoad.typesBitField &= typesBitField;
                return old != lvLoad.typesBitField;
            }
            if (lvLoad.signature_index == -1) {
                lvLoad.signature_index = cnat.descriptor_index;
                return true;
            }
        }
        return false;
    }

    private static void AddCastInstruction(ConstantPool constants, List<Instruction> list, LocalVariables localVariables, LocalVariable lv) {
        AddCheckCastVisitor visitor = new AddCheckCastVisitor(constants, localVariables, lv);
        int length = list.size();
        int i = 0;
        while (i < length) {
            visitor.visit(list.get(i));
            ++i;
        }
    }
}

