/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.restest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.wiztools.restclient.bean.TestResult;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.restest.FailureTableModel;
import org.wiztools.restclient.ui.restest.ResTestPanel;

class ResTestPanelImpl
extends JPanel
implements ResTestPanel {
    private TestResult lastTestResult;
    private final JLabel jl_runCount = new JLabel("");
    private final JLabel jl_failureCount = new JLabel("");
    private final JLabel jl_errorCount = new JLabel("");
    private final FailureTableModel tm_failures = new FailureTableModel();
    private final FailureTableModel tm_errors = new FailureTableModel();
    private JScrollPane jsp_jt_failures;
    private JScrollPane jsp_jt_errors;
    private final JTextArea jta_trace = new JTextArea();
    private JScrollPane jsp_jta_trace;
    private final JLabel jl_status = new JLabel();
    private final JLabel jl_icon = new JLabel();
    private final Icon ICON_DEFAULT = UIUtil.getIconFromClasspath("org/wiztools/restclient/test/eye.png");
    private final Icon ICON_SUCCESS = UIUtil.getIconFromClasspath("org/wiztools/restclient/test/accept.png");
    private final Icon ICON_FAILURE = UIUtil.getIconFromClasspath("org/wiztools/restclient/test/cross.png");

    ResTestPanelImpl() {
    }

    @PostConstruct
    protected void init() {
        ResTestPanelImpl jp = this;
        jp.setLayout(new BorderLayout(5, 5));
        JPanel jp_north = new JPanel();
        jp_north.setLayout(new BorderLayout(5, 5));
        this.jl_icon.setIcon(this.ICON_DEFAULT);
        jp_north.add((Component)this.jl_icon, "West");
        jp_north.add((Component)this.jl_status, "Center");
        jp.add((Component)jp_north, "North");
        JTabbedPane jtp = new JTabbedPane();
        JPanel jp_summary = new JPanel();
        jp_summary.setLayout(new GridLayout(3, 1));
        this.jl_runCount.setFont(UIUtil.FONT_BIG);
        this.jl_failureCount.setFont(UIUtil.FONT_BIG);
        this.jl_errorCount.setFont(UIUtil.FONT_BIG);
        JPanel jp_t = new JPanel();
        jp_t.setLayout(new BorderLayout());
        JLabel jl_t = new JLabel("Tests Run: ");
        jl_t.setFont(UIUtil.FONT_BIG);
        jp_t.add((Component)jl_t, "Center");
        jp_t.add((Component)this.jl_runCount, "East");
        jp_summary.add(jp_t);
        jp_t = new JPanel();
        jp_t.setLayout(new BorderLayout());
        jl_t = new JLabel("Tests Failures: ");
        jl_t.setFont(UIUtil.FONT_BIG);
        jp_t.add((Component)jl_t, "Center");
        jp_t.add((Component)this.jl_failureCount, "East");
        jp_summary.add(jp_t);
        jp_t = new JPanel();
        jp_t.setLayout(new BorderLayout());
        jl_t = new JLabel("Tests Errors: ");
        jl_t.setFont(UIUtil.FONT_BIG);
        jp_t.add((Component)jl_t, "Center");
        jp_t.add((Component)this.jl_errorCount, "East");
        jp_summary.add(jp_t);
        jp_t = new JPanel();
        jp_t.setLayout(new FlowLayout(0));
        jp_t.add(jp_summary);
        jtp.add("Summary", jp_t);
        JTable jt = new JTable(this.tm_failures);
        Dimension d = jt.getPreferredSize();
        d.height /= 2;
        jt.setPreferredScrollableViewportSize(d);
        this.jsp_jt_failures = new JScrollPane(jt);
        jtp.add("Failures", this.jsp_jt_failures);
        jt = new JTable(this.tm_errors);
        d = jt.getPreferredSize();
        d.height /= 2;
        jt.setPreferredScrollableViewportSize(d);
        this.jsp_jt_errors = new JScrollPane(jt);
        jtp.add("Errors", this.jsp_jt_errors);
        this.jta_trace.setEditable(false);
        this.jsp_jta_trace = new JScrollPane(this.jta_trace);
        jtp.add("Trace", this.jsp_jta_trace);
        jp.add((Component)jtp, "Center");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setTestResult(TestResult result) {
        if (result == null) {
            return;
        }
        this.lastTestResult = result;
        int runCount = result.getRunCount();
        int failureCount = result.getFailureCount();
        int errorCount = result.getErrorCount();
        if (failureCount > 0 || errorCount > 0) {
            this.jl_icon.setIcon(this.ICON_FAILURE);
        } else {
            this.jl_icon.setIcon(this.ICON_SUCCESS);
        }
        this.jl_status.setText("Tests run: " + runCount + ", Failures: " + failureCount + ", Errors: " + errorCount);
        this.jl_runCount.setText(String.valueOf(runCount));
        this.jl_failureCount.setText(String.valueOf(failureCount));
        this.jl_errorCount.setText(String.valueOf(errorCount));
        this.tm_failures.setData(result.getFailures());
        this.tm_errors.setData(result.getErrors());
        Dimension d = this.jsp_jta_trace.getPreferredSize();
        this.jta_trace.setText(result.toString());
        this.jta_trace.setCaretPosition(0);
        this.jsp_jta_trace.setPreferredSize(d);
    }

    @Override
    public TestResult getTestResult() {
        return this.lastTestResult;
    }

    @Override
    public void clear() {
        this.jl_icon.setIcon(this.ICON_DEFAULT);
        this.jl_runCount.setText("");
        this.jl_failureCount.setText("");
        this.jl_errorCount.setText("");
        this.jl_status.setText("");
        this.tm_failures.setData(Collections.emptyList());
        this.tm_errors.setData(Collections.emptyList());
        this.jta_trace.setText("");
    }
}

