/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import edu.umd.marbl.mhap.impl.SequenceId;
import edu.umd.marbl.mhap.utils.Utils;

public final class Sequence {
    private final String sequence;
    private final SequenceId id;

    public Sequence(int[] sequence, SequenceId id) {
        this.id = id;
        StringBuilder s = new StringBuilder();
        block6: for (int iter = 0; iter < sequence.length; ++iter) {
            switch (sequence[iter]) {
                case 0: {
                    s.append("U");
                    continue block6;
                }
                case 1: {
                    s.append("C");
                    continue block6;
                }
                case 2: {
                    s.append("G");
                    continue block6;
                }
                case 3: {
                    s.append("T");
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Uknown integer value.");
                }
            }
        }
        this.sequence = s.toString();
    }

    public Sequence(String sequence, SequenceId id) {
        this.sequence = sequence;
        this.id = id;
    }

    public String getSquenceString() {
        return this.sequence;
    }

    public SequenceId getId() {
        return this.id;
    }

    public Sequence getReverseCompliment() {
        return new Sequence(Utils.rc(this.sequence), this.id.complimentId());
    }

    public String getKmer(int index, int kmerSize) {
        return this.sequence.substring(index, index + kmerSize);
    }

    public int numKmers(int kmerSize) {
        return this.sequence.length() - kmerSize + 1;
    }

    public int length() {
        return this.sequence.length();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(">" + this.id + "\n");
        str.append(this.sequence);
        return str.toString();
    }
}

