/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.main;

import edu.umd.marbl.mhap.impl.FastaData;
import edu.umd.marbl.mhap.impl.Sequence;
import edu.umd.marbl.mhap.utils.IntervalTree;
import edu.umd.marbl.mhap.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import ssw.Aligner;
import ssw.Alignment;

public class EstimateROC {
    private static final boolean ALIGN_SW = true;
    private static final boolean ALIGN_JALIGN = false;
    private static int[][] MATCH_MATRIX = new int[128][128];
    private static final double MIN_REF_OVERLAP_DIFFERENCE = 0.8;
    private static double MIN_IDENTITY = 0.7;
    private static final double REF_IDENTITY_ADJUSTMENT = 0.1;
    private static double MIN_REF_IDENTITY = MIN_IDENTITY + 0.1;
    private static double MIN_ALIGNMENT_IDENTITY = MIN_IDENTITY - 0.1;
    private static double MIN_OVERLAP_DIFFERENCE = 0.3;
    private static final int DEFAULT_NUM_TRIALS = 10000;
    private static final int DEFAULT_MIN_OVL = 2000;
    private static final boolean DEFAULT_DO_DP = false;
    private static boolean LOAD_ALL = false;
    private static boolean DEBUG = false;
    private static Random generator = null;
    public static int seed = 0;
    private HashMap<String, IntervalTree<Integer>> clusters = new HashMap();
    private HashMap<String, String> seqToChr = new HashMap(10000000);
    private HashMap<String, Integer> seqToScore = new HashMap(10000000);
    private HashMap<String, Pair> seqToPosition = new HashMap(10000000);
    private HashMap<Integer, String> seqToName = new HashMap(10000000);
    private HashMap<String, Integer> seqNameToIndex = new HashMap(10000000);
    private HashMap<String, Integer> ovlNames = new HashMap(100000000);
    private HashMap<String, Overlap> ovlInfo = new HashMap(100000000);
    private HashMap<Integer, String> ovlToName = new HashMap(100000000);
    private int minOvlLen = 2000;
    private int numTrials = 10000;
    private boolean doDP = false;
    private long tp = 0L;
    private long fn = 0L;
    private long tn = 0L;
    private long fp = 0L;
    private double ppv = 0.0;
    private Sequence[] dataSeq = null;

    public static void printUsage() {
        System.err.println("This program uses random sampling to estimate PPV/Sensitivity/Specificity");
        System.err.println("The sequences in the fasta file used to generate the truth must be sequentially numbered from 1 to N!");
        System.err.println("\t1. A blasr M4 file mapping sequences to a reference (or reference subset)");
        System.err.println("\t2. All-vs-all mappings of same sequences in CA ovl format");
        System.err.println("\t3. Fasta sequences sequentially numbered from 1 to N.");
        System.err.println("\t4. Minimum overlap length (default: 2000");
        System.err.println("\t5. Number of random trials, 0 means full compute (default : 10000");
        System.err.println("\t6. Compute DP during PPV true/false");
        System.err.println("\t7. Debug output true/false");
    }

    public static void main(String[] args) throws Exception {
        long startTime;
        if (args.length < 3) {
            EstimateROC.printUsage();
            System.exit(1);
        }
        EstimateROC g = null;
        g = args.length > 5 ? new EstimateROC(Integer.parseInt(args[3]), Integer.parseInt(args[4]), Boolean.parseBoolean(args[5])) : (args.length > 4 ? new EstimateROC(Integer.parseInt(args[3]), Integer.parseInt(args[4])) : (args.length > 3 ? new EstimateROC(Integer.parseInt(args[3])) : new EstimateROC()));
        if (args.length > 6) {
            DEBUG = Boolean.parseBoolean(args[6]);
        }
        if (args.length > 7) {
            MIN_IDENTITY = Double.parseDouble(args[7]);
            MIN_REF_IDENTITY = MIN_IDENTITY + 0.1;
            MIN_ALIGNMENT_IDENTITY = MIN_IDENTITY - 0.05;
        }
        if (args.length > 8) {
            MIN_OVERLAP_DIFFERENCE = Double.parseDouble(args[8]);
        }
        if (args.length > 9) {
            LOAD_ALL = Boolean.parseBoolean(args[9]);
        }
        System.err.println("Running, reference: " + args[0] + " matches: " + args[1]);
        System.err.println("Number trials:  " + (g.numTrials == 0 ? "all" : Integer.valueOf(g.numTrials)));
        System.err.println("Minimum ovl:  " + g.minOvlLen);
        System.err.println("Minimum acceptable %" + MIN_IDENTITY);
        System.err.println("Minimum acceptable shift " + MIN_OVERLAP_DIFFERENCE);
        System.err.println("Minimum overlap to ref %" + MIN_REF_IDENTITY);
        System.err.println("Minimum acceptable overlap for dp check %" + MIN_ALIGNMENT_IDENTITY);
        System.err.print("Loading reference...");
        long totalTime = startTime = System.nanoTime();
        g.processReference(args[0]);
        System.err.println("done " + (double)(System.nanoTime() - startTime) * 1.0E-9 + "s.");
        System.err.print("Loading fasta...");
        startTime = System.nanoTime();
        g.loadFasta(args[2]);
        System.err.println("done " + (double)(System.nanoTime() - startTime) * 1.0E-9 + "s.");
        System.err.print("Loading matches...");
        startTime = System.nanoTime();
        g.processOverlaps(args[1]);
        System.err.println("done " + (double)(System.nanoTime() - startTime) * 1.0E-9 + "s.");
        if (g.numTrials == 0) {
            System.err.print("Computing full statistics O(" + g.seqToName.size() + "^2) operations!...");
            startTime = System.nanoTime();
            g.fullEstimate();
            System.err.println("done " + (double)(System.nanoTime() - startTime) * 1.0E-9 + "s.");
        } else {
            System.err.print("Computing sensitivity...");
            startTime = System.nanoTime();
            g.estimateSensitivity();
            System.err.println("done " + (double)(System.nanoTime() - startTime) * 1.0E-9 + "s.");
            System.err.print("Computing specificity...");
            startTime = System.nanoTime();
            g.estimateSpecificity();
            System.err.println("done " + (double)(System.nanoTime() - startTime) * 1.0E-9 + "s.");
            System.err.print("Computing PPV...");
            startTime = System.nanoTime();
            g.estimatePPV();
            System.err.println("done " + (double)(System.nanoTime() - startTime) * 1.0E-9 + "s.");
        }
        System.err.println("Total time: " + (double)(System.nanoTime() - totalTime) * 1.0E-9 + "s.");
        System.out.println("Estimated sensitivity:\t" + Utils.DECIMAL_FORMAT.format((double)g.tp / (double)(g.tp + g.fn)));
        System.out.println("Estimated specificity:\t" + Utils.DECIMAL_FORMAT.format((double)g.tn / (double)(g.fp + g.tn)));
        System.out.println("Estimated PPV:\t " + Utils.DECIMAL_FORMAT.format(g.ppv));
    }

    public EstimateROC() {
        this(2000, 10000);
    }

    public EstimateROC(int minOvlLen) {
        this(minOvlLen, 10000);
    }

    public EstimateROC(int minOvlLen, int numTrials) {
        this(minOvlLen, numTrials, false);
    }

    public EstimateROC(int minOvlLen, int numTrials, boolean doDP) {
        this.minOvlLen = minOvlLen;
        this.numTrials = numTrials;
        this.doDP = doDP;
        generator = new Random(seed);
        try {
            File f = new File(System.getProperty("java.class.path"));
            File dir = f.getAbsoluteFile().getParentFile();
            String path = dir.toString();
            System.err.println("Loaded file from path " + path);
            System.load(path + File.separator + "lib" + File.separator + "libsswjni.so");
            for (int i = 0; i < 128; ++i) {
                for (int j = 0; j < 128; ++j) {
                    EstimateROC.MATCH_MATRIX[i][j] = i == j ? 2 : -2;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: could not load DP library: " + e);
            System.exit(1);
        }
    }

    private static int getSequenceId(String id) {
        return Integer.parseInt(id) - 1;
    }

    private static String getOvlName(String id, String id2) {
        return id.compareTo(id2) <= 0 ? id + "_" + id2 : id2 + "_" + id;
    }

    private String pickRandomSequence() {
        int val = generator.nextInt(this.seqToName.size());
        return this.seqToName.get(val);
    }

    private String pickRandomMatch() {
        int val = generator.nextInt(this.ovlToName.size());
        return this.ovlToName.get(val);
    }

    private int getOverlapSize(String id, String id2) {
        String chr = this.seqToChr.get(id);
        String chr2 = this.seqToChr.get(id2);
        Pair p1 = this.seqToPosition.get(id);
        Pair p2 = this.seqToPosition.get(id2);
        if (!chr.equalsIgnoreCase(chr2)) {
            System.err.println("Error: comparing wrong chromosomes betweeen sequences " + id + " and sequence " + id2);
            System.exit(1);
        }
        return Utils.getRangeOverlap(p1.first, p1.second, p2.first, p2.second);
    }

    private HashSet<String> getSequenceMatches(String id, int min) {
        String chr = this.seqToChr.get(id);
        Pair p1 = this.seqToPosition.get(id);
        if (chr == null || p1 == null) {
            return null;
        }
        List<Integer> intersect = this.clusters.get(chr).get(p1.first, p1.second);
        HashSet<String> result = new HashSet<String>();
        Iterator<Integer> it = intersect.iterator();
        while (it.hasNext()) {
            int overlap;
            String id2 = this.seqToName.get(it.next());
            Pair p2 = this.seqToPosition.get(id2);
            String chr2 = this.seqToChr.get(id2);
            if (!chr.equalsIgnoreCase(chr2)) {
                System.err.println("Error: comparing wrong chromosomes betweeen sequences " + id + " and sequence in its cluster " + id2);
                System.exit(1);
            }
            if ((overlap = Utils.getRangeOverlap(p1.first, p1.second, p2.first, p2.second)) < min || id.equalsIgnoreCase(id2)) continue;
            result.add(id2);
        }
        return result;
    }

    private Overlap getOverlapInfo(String line) {
        Overlap overlap = new Overlap();
        String[] splitLine = line.trim().split("\\s+");
        try {
            if (splitLine.length == 7 || splitLine.length == 6) {
                overlap.id1 = splitLine[0];
                overlap.id2 = splitLine[1];
                double score = Double.parseDouble(splitLine[5]) * 5.0;
                int aoffset = Integer.parseInt(splitLine[3]);
                int boffset = Integer.parseInt(splitLine[4]);
                overlap.isFwd = "N".equalsIgnoreCase(splitLine[2]);
                if (this.dataSeq != null) {
                    int alen = this.dataSeq[Integer.parseInt(overlap.id1) - 1].length();
                    int blen = this.dataSeq[Integer.parseInt(overlap.id2) - 1].length();
                    overlap.afirst = Math.max(0, aoffset);
                    overlap.asecond = Math.min(alen, alen + boffset);
                    overlap.bfirst = -1 * Math.min(0, aoffset);
                    overlap.bsecond = Math.min(blen, blen - boffset);
                }
            } else if (splitLine.length == 12) {
                overlap.id1 = splitLine[0];
                overlap.id2 = splitLine[1];
                double score = Double.parseDouble(splitLine[2]);
                boolean bl = overlap.isFwd = Integer.parseInt(splitLine[8]) == 0;
                if (this.dataSeq != null) {
                    int alen = this.dataSeq[EstimateROC.getSequenceId(overlap.id1)].length();
                    int blen = this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].length();
                    overlap.afirst = Integer.parseInt(splitLine[5]);
                    overlap.asecond = Integer.parseInt(splitLine[6]);
                    overlap.bfirst = Integer.parseInt(splitLine[9]);
                    overlap.bsecond = Integer.parseInt(splitLine[10]);
                    if (overlap.asecond > alen) {
                        overlap.asecond = alen;
                    }
                    if (overlap.bsecond > blen) {
                        overlap.bsecond = blen;
                    }
                }
            } else if (splitLine.length == 13 && !line.contains("[")) {
                overlap.afirst = Integer.parseInt(splitLine[5]);
                overlap.asecond = Integer.parseInt(splitLine[6]);
                overlap.bfirst = Integer.parseInt(splitLine[9]);
                overlap.bsecond = Integer.parseInt(splitLine[10]);
                boolean bl = overlap.isFwd = Integer.parseInt(splitLine[8]) == 0;
                if (!overlap.isFwd) {
                    overlap.bsecond = Integer.parseInt(splitLine[11]) - Integer.parseInt(splitLine[9]);
                    overlap.bfirst = Integer.parseInt(splitLine[11]) - Integer.parseInt(splitLine[10]);
                }
                overlap.id1 = splitLine[0];
                if (overlap.id1.indexOf("/") != -1) {
                    overlap.id1 = overlap.id1.substring(0, splitLine[0].indexOf("/"));
                }
                if (overlap.id1.indexOf(",") != -1) {
                    overlap.id1 = overlap.id1.split(",")[1];
                }
                overlap.id2 = splitLine[1];
                if (overlap.id2.indexOf(",") != -1) {
                    overlap.id2 = overlap.id2.split(",")[1];
                }
                if (this.dataSeq != null) {
                    int alen = this.dataSeq[EstimateROC.getSequenceId(overlap.id1)].length();
                    int blen = this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].length();
                    if (overlap.asecond > alen) {
                        overlap.asecond = alen;
                    }
                    if (overlap.bsecond > blen) {
                        overlap.bsecond = blen;
                    }
                }
            } else if (splitLine.length >= 13 && splitLine.length <= 18) {
                overlap.id1 = splitLine[0].replaceAll(",", "");
                overlap.id2 = splitLine[1].replaceAll(",", "");
                overlap.isFwd = splitLine[2].equalsIgnoreCase("n");
                String[] splitTwo = line.split("\\[");
                String aInfo = splitTwo[1].substring(0, splitTwo[1].indexOf("]"));
                String bInfo = splitTwo[2].substring(0, splitTwo[2].indexOf("]"));
                String[] aSplit = aInfo.replaceAll(",", "").split("\\.\\.");
                String[] bSplit = bInfo.replaceAll(",", "").split("\\.\\.");
                overlap.afirst = Integer.parseInt(aSplit[0].trim());
                overlap.asecond = Integer.parseInt(aSplit[1].trim());
                overlap.bfirst = Integer.parseInt(bSplit[0].trim());
                overlap.bsecond = Integer.parseInt(bSplit[1].trim());
                if (!overlap.isFwd) {
                    overlap.bsecond = this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].length() - Integer.parseInt(bSplit[0].trim());
                    overlap.bfirst = this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].length() - Integer.parseInt(bSplit[1].trim());
                }
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Warning: could not parse input line: " + line + " " + e.getMessage());
        }
        return overlap;
    }

    private void loadFasta(String file) throws IOException {
        FastaData data = new FastaData(file, 0L);
        data.enqueueFullFile();
        this.dataSeq = new Sequence[data.getNumberProcessed()];
        int i = 0;
        while (!data.isEmpty()) {
            this.dataSeq[i++] = data.dequeue();
        }
    }

    private void processOverlaps(String file) throws Exception {
        BufferedReader bf = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        int counter = 0;
        while ((line = bf.readLine()) != null) {
            String ovlName;
            Overlap ovl = this.getOverlapInfo(line);
            int ovlLen = ovl.getSize();
            String id = ovl.id1;
            String id2 = ovl.id2;
            if (id == null || id2 == null || id.equalsIgnoreCase(id2) || !LOAD_ALL && (this.seqToChr.get(id) == null || this.seqToChr.get(id2) == null) || this.ovlNames.containsKey(ovlName = EstimateROC.getOvlName(id, id2)) && ovlLen < this.ovlNames.get(ovlName)) continue;
            if (this.ovlNames.containsKey(ovlName)) {
                this.ovlNames.put(ovlName, ovlLen);
                this.ovlInfo.put(ovlName, ovl);
            } else {
                this.ovlNames.put(ovlName, ovlLen);
                this.ovlToName.put(counter, ovlName);
                this.ovlInfo.put(ovlName, ovl);
                ++counter;
            }
            if (counter % 100000 != 0) continue;
            System.err.println("Loaded " + counter);
        }
        System.err.print("Processed " + this.ovlNames.size() + " overlaps");
        if (this.ovlNames.isEmpty()) {
            System.err.println("Error: No sequence matches to reference loaded!");
            System.exit(1);
        }
        bf.close();
    }

    private void processReference(String file) throws Exception {
        BufferedReader bf = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        int counter = 0;
        while ((line = bf.readLine()) != null) {
            double diff;
            String[] splitLine = line.trim().split("\\s+");
            String id = splitLine[0];
            if (id.indexOf("/") != -1) {
                id = id.substring(0, splitLine[0].indexOf("/"));
            }
            if (id.indexOf(",") != -1) {
                id = id.split(",")[1];
            }
            double idy = Double.parseDouble(splitLine[3]);
            int start = Integer.parseInt(splitLine[5]);
            int end = Integer.parseInt(splitLine[6]);
            int length = Integer.parseInt(splitLine[7]);
            int seqIsFwd = Integer.parseInt(splitLine[4]);
            if (seqIsFwd != 0) {
                System.err.println("Error: malformed line, first sequences should always be in fwd orientation");
                System.exit(1);
            }
            int startInRef = Integer.parseInt(splitLine[9]);
            int endInRef = Integer.parseInt(splitLine[10]);
            int refLen = Integer.parseInt(splitLine[11]);
            int isRev = Integer.parseInt(splitLine[8]);
            int score = Integer.parseInt(splitLine[2]);
            if (isRev == 1) {
                int tmp = refLen - endInRef;
                endInRef = refLen - startInRef;
                startInRef = tmp;
            }
            if (idy < MIN_REF_IDENTITY * 100.0 || (diff = (double)(end - start) / (double)(endInRef - startInRef)) < 0.8) continue;
            String chr = splitLine[1];
            if (!this.clusters.containsKey(chr)) {
                this.clusters.put(chr, new IntervalTree());
            }
            if (this.seqToPosition.containsKey(id)) {
                if (score >= this.seqToScore.get(id)) continue;
                this.seqToPosition.put(id, new Pair(startInRef, endInRef));
                this.seqToChr.put(id, chr);
                this.seqToScore.put(id, score);
                continue;
            }
            this.seqToPosition.put(id, new Pair(startInRef, endInRef));
            this.seqToChr.put(id, chr);
            this.seqToName.put(counter, id);
            this.seqNameToIndex.put(id, counter);
            this.seqToScore.put(id, score);
            ++counter;
        }
        bf.close();
        for (String id : this.seqToPosition.keySet()) {
            String chr = this.seqToChr.get(id);
            if (!this.clusters.containsKey(chr)) {
                this.clusters.put(chr, new IntervalTree());
            }
            Pair p = this.seqToPosition.get(id);
            this.clusters.get(chr).addInterval(p.first, p.second, this.seqNameToIndex.get(id));
        }
        System.err.print("Processed " + this.clusters.size() + " chromosomes, " + this.seqToPosition.size() + " sequences matching ref");
        if (this.seqToPosition.isEmpty()) {
            System.err.println("Error: No sequence matches to reference loaded!");
            System.exit(1);
        }
    }

    private boolean overlapExists(String id, String id2) {
        return this.ovlNames.containsKey(EstimateROC.getOvlName(id, id2));
    }

    private boolean overlapMatches(String id, String m) {
        int refOverlap = this.getOverlapSize(id, m);
        Overlap ovl = this.ovlInfo.get(EstimateROC.getOvlName(id, m));
        if (ovl == null) {
            return false;
        }
        int diff = Math.abs(ovl.getSize() - refOverlap);
        double diffPercent = (double)diff / (double)refOverlap;
        if (DEBUG) {
            System.err.println("Overlap " + ovl + " " + ovl.getSize() + " versus ref " + refOverlap + " " + " diff is " + diff + "(" + diffPercent + ")");
        }
        return !(diffPercent > MIN_OVERLAP_DIFFERENCE);
    }

    private void checkMatches(String id, HashSet<String> matches) {
        for (String m : matches) {
            if (this.overlapMatches(id, m)) {
                ++this.tp;
                continue;
            }
            ++this.fn;
            if (!DEBUG) continue;
            System.err.println("Overlap between sequences: " + id + ", " + m + " is missing.");
            System.err.println(">" + id + " reference location " + this.seqToChr.get(id) + " " + this.seqToPosition.get((Object)id).first + ", " + this.seqToPosition.get((Object)id).second);
            System.err.println(this.dataSeq[Integer.parseInt(id) - 1].getSquenceString());
            System.err.println(">" + m + " reference location " + this.seqToChr.get(m) + " " + this.seqToPosition.get((Object)m).first + ", " + this.seqToPosition.get((Object)m).second);
            System.err.println(this.dataSeq[Integer.parseInt(m) - 1].getSquenceString());
        }
    }

    private static double getScore(jaligner.Alignment alignment, String qry, String ref) {
        char[] sequence1 = alignment.getSequence1();
        char[] sequence2 = alignment.getSequence2();
        int length = Math.max(sequence1.length, sequence2.length);
        int GAP = 45;
        int errors = 0;
        int matches = 0;
        for (int i = 0; i <= length; ++i) {
            int c1 = GAP;
            int c2 = GAP;
            if (i < sequence1.length) {
                c1 = sequence1[i];
            }
            if (i < sequence2.length) {
                c2 = sequence2[i];
            }
            if (c1 != c2 || c1 == GAP || c2 == GAP) {
                ++errors;
                continue;
            }
            ++matches;
        }
        return (double)matches / (double)length;
    }

    private static double getScore(Alignment alignment, String qry, String ref) {
        Pattern cigarPattern = Pattern.compile("[\\d]+[a-zA-Z|=]");
        Matcher matcher = cigarPattern.matcher(alignment.cigar);
        int errors = 0;
        int len = 0;
        int qryPos = alignment.read_begin1;
        int refPos = alignment.ref_begin1;
        block7: while (matcher.find()) {
            String cVal = matcher.group();
            int cLen = Integer.parseInt(cVal.substring(0, cVal.length() - 1));
            char cLetter = cVal.toUpperCase().charAt(cVal.length() - 1);
            switch (cLetter) {
                case 'H': {
                    continue block7;
                }
                case '=': 
                case 'S': {
                    len += cLen;
                    continue block7;
                }
                case 'M': {
                    for (int i = 0; i < cLen; ++i) {
                        if (ref.toUpperCase().charAt(refPos) != qry.toUpperCase().charAt(qryPos)) {
                            ++errors;
                        }
                        ++refPos;
                        ++qryPos;
                    }
                    len += cLen;
                    continue block7;
                }
                case 'I': {
                    errors += cLen;
                    qryPos += cLen;
                    len += cLen;
                    continue block7;
                }
                case 'D': {
                    errors += cLen;
                    refPos += cLen;
                    len += cLen;
                    continue block7;
                }
            }
            System.err.println("Error, unknown base " + cLetter);
            System.exit(1);
        }
        return 1.0 - (double)errors / (double)len;
    }

    private boolean computeDP(String id, String id2) {
        if (!this.doDP) {
            return false;
        }
        Overlap ovl = this.ovlInfo.get(EstimateROC.getOvlName(id, id2));
        if (DEBUG) {
            System.err.println("Aligning sequence " + ovl.id1 + " to " + ovl.id2 + " " + ovl.bfirst + " to " + ovl.bsecond + " and " + ovl.isFwd + " and " + ovl.afirst + " " + ovl.asecond);
        }
        String s1 = this.dataSeq[EstimateROC.getSequenceId(ovl.id1)].getSquenceString().substring(ovl.afirst, ovl.asecond);
        String s2 = null;
        s2 = ovl.isFwd ? this.dataSeq[EstimateROC.getSequenceId(ovl.id2)].getSquenceString().substring(ovl.bfirst, ovl.bsecond) : Utils.rc(this.dataSeq[EstimateROC.getSequenceId(ovl.id2)].getSquenceString().substring(ovl.bfirst, ovl.bsecond));
        int ovlLen = Math.min(s1.length(), s2.length());
        double score = 0.0;
        int length = 0;
        Alignment alignment = Aligner.align(s1.getBytes(), s2.getBytes(), MATCH_MATRIX, 2, 1, true);
        length = Math.max(alignment.read_end1 - alignment.read_begin1, alignment.ref_end1 - alignment.ref_begin1);
        score = EstimateROC.getScore(alignment, s1, s2);
        if (DEBUG) {
            System.err.println(alignment.toString());
            System.err.println(alignment.read_end1 + " " + alignment.read_begin1 + " " + alignment.ref_end1 + " " + alignment.ref_begin1 + " " + length);
            System.err.println("My score: " + score);
        }
        return score > MIN_ALIGNMENT_IDENTITY && length > this.minOvlLen && (double)(1.0f - (float)length / (float)ovlLen) < MIN_OVERLAP_DIFFERENCE;
    }

    private void estimateSensitivity() {
        for (int i = 0; i < this.numTrials; ++i) {
            String id = null;
            HashSet<String> matches = null;
            while (matches == null || matches.size() == 0) {
                id = this.pickRandomSequence();
                matches = this.getSequenceMatches(id, this.minOvlLen);
            }
            if (DEBUG) {
                System.err.println("Estimated sensitivity trial #" + i + " " + id + " matches " + matches);
            }
            this.checkMatches(id, matches);
        }
    }

    private void estimateSpecificity() {
        for (int i = 0; i < this.numTrials; ++i) {
            String id = this.pickRandomSequence();
            String other = this.pickRandomSequence();
            while (id.equalsIgnoreCase(other)) {
                other = this.pickRandomSequence();
            }
            HashSet<String> matches = this.getSequenceMatches(id, 0);
            if (this.overlapExists(id, other)) {
                if (matches.contains(other)) continue;
                ++this.fp;
                continue;
            }
            if (matches.contains(other)) continue;
            ++this.tn;
        }
    }

    private void estimatePPV() throws InterruptedException, ExecutionException {
        AtomicInteger numTP = new AtomicInteger();
        ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
        ((ForkJoinTask)forkJoinPool.submit(() -> ((Stream)Stream.iterate(0, i -> i + 1).limit(this.numTrials).parallel()).forEach(i -> {
            int ovlLen = 0;
            String[] ovl = null;
            String ovlName = null;
            while (ovlLen < this.minOvlLen) {
                ovlName = this.pickRandomMatch();
                Overlap o = this.ovlInfo.get(ovlName);
                ovlLen = Utils.getRangeOverlap(o.afirst, o.asecond, o.bfirst, o.bsecond);
            }
            if (ovlName == null) {
                System.err.println("Could not find any computed overlaps > " + this.minOvlLen);
                System.exit(1);
            } else {
                ovl = ovlName.split("_");
                String id = ovl[0];
                String id2 = ovl[1];
                HashSet<String> matches = this.getSequenceMatches(id, 0);
                if (matches != null && matches.contains(id2)) {
                    numTP.getAndIncrement();
                } else if (this.computeDP(id, id2)) {
                    numTP.getAndIncrement();
                } else if (DEBUG) {
                    System.err.println("Overlap between sequences: " + id + ", " + id2 + " is not correct.");
                }
            }
        }))).get();
        this.ppv = numTP.doubleValue() / (double)this.numTrials;
    }

    private void fullEstimate() {
        for (int i = 0; i < this.seqToName.size(); ++i) {
            String id = this.seqToName.get(i);
            for (int j = i + 1; j < this.seqToName.size(); ++j) {
                String id2 = this.seqToName.get(j);
                if (id == null || id2 == null) continue;
                HashSet<String> matches = this.getSequenceMatches(id, 0);
                if (!this.overlapMatches(id, id2)) {
                    if (!matches.contains(id2)) {
                        ++this.tn;
                        continue;
                    }
                    if (this.getOverlapSize(id, id2) <= this.minOvlLen) continue;
                    ++this.fn;
                    continue;
                }
                if (matches.contains(id2)) {
                    ++this.tp;
                    continue;
                }
                if (this.computeDP(id, id2)) {
                    ++this.tp;
                    continue;
                }
                ++this.fp;
            }
        }
        this.ppv = (double)this.tp / ((double)this.tp + (double)this.fp);
    }

    private static class Overlap {
        public int afirst;
        public int bfirst;
        public int asecond;
        public int bsecond;
        public boolean isFwd;
        public String id1;
        public String id2;

        public int getSize() {
            double first = (double)Math.max(this.asecond, this.afirst) - (double)Math.min(this.asecond, this.afirst);
            return (int)Math.round((first += (double)Math.max(this.bsecond, this.bfirst) - (double)Math.min(this.bsecond, this.bfirst)) / 2.0);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Overlap Fwd=" + this.isFwd);
            stringBuilder.append(" Aid=");
            stringBuilder.append(this.id1);
            stringBuilder.append(" (");
            stringBuilder.append(this.afirst);
            stringBuilder.append(", ");
            stringBuilder.append(this.asecond);
            stringBuilder.append("), Bid=");
            stringBuilder.append(this.id2);
            stringBuilder.append(" (");
            stringBuilder.append(this.bfirst);
            stringBuilder.append(", ");
            stringBuilder.append(this.bsecond);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class Pair {
        public int first;
        public int second;

        public Pair(int startInRef, int endInRef) {
            this.first = startInRef;
            this.second = endInRef;
        }

        public int size() {
            return Math.max(this.first, this.second) - Math.min(this.first, this.second) + 1;
        }
    }
}

