/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.spdy.ByteBufferPool;

public class StandardByteBufferPool
implements ByteBufferPool {
    private final ConcurrentMap<Integer, Queue<ByteBuffer>> directBuffers = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
    private final ConcurrentMap<Integer, Queue<ByteBuffer>> heapBuffers = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
    private final int factor;

    public StandardByteBufferPool() {
        this(1024);
    }

    public StandardByteBufferPool(int factor) {
        this.factor = factor;
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        int bucket = this.bucketFor(size);
        ConcurrentMap<Integer, Queue<ByteBuffer>> buffers = this.buffersFor(direct);
        ByteBuffer result = null;
        Queue byteBuffers = (Queue)buffers.get(bucket);
        if (byteBuffers != null) {
            result = (ByteBuffer)byteBuffers.poll();
        }
        if (result == null) {
            int capacity = bucket * this.factor;
            result = direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        }
        result.clear();
        result.limit(size);
        return result;
    }

    @Override
    public void release(ByteBuffer buffer) {
        int bucket = this.bucketFor(buffer.capacity());
        ConcurrentMap<Integer, Queue<ByteBuffer>> buffers = this.buffersFor(buffer.isDirect());
        Queue<ByteBuffer> byteBuffers = (ConcurrentLinkedQueue<ByteBuffer>)buffers.get(bucket);
        if (byteBuffers == null) {
            byteBuffers = new ConcurrentLinkedQueue<ByteBuffer>();
            Queue existing = buffers.putIfAbsent(bucket, byteBuffers);
            if (existing != null) {
                byteBuffers = existing;
            }
        }
        buffer.clear();
        byteBuffers.offer(buffer);
    }

    public void clear() {
        this.directBuffers.clear();
        this.heapBuffers.clear();
    }

    private int bucketFor(int size) {
        int bucket = size / this.factor;
        if (size % this.factor > 0) {
            ++bucket;
        }
        return bucket;
    }

    private ConcurrentMap<Integer, Queue<ByteBuffer>> buffersFor(boolean direct) {
        return direct ? this.directBuffers : this.heapBuffers;
    }
}

