/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidScrollButton;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class LiquidScrollBarUI
extends BasicScrollBarUI {
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    private static Skin skinTrackVert;
    private static Skin skinTrackHoriz;
    private static Skin skinThumbVert;
    private static Skin skinThumbHoriz;
    private int orientation = -1;
    private int minExtent;
    private int minValue;
    private final int MIN_THUMB_SIZE;
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    private boolean freeStanding = false;
    int scrollBarWidth;
    private Skin skinTrack;
    private Skin skinThumb;
    private SkinSimpleButtonIndexModel skinThumbIndexModel = new SkinSimpleButtonIndexModel();
    JButton decreaseButton;
    JButton increaseButton;

    protected void installDefaults() {
        this.scrollBarWidth = LiquidScrollButton.getSkinUp().getHsize();
        super.installDefaults();
        this.scrollbar.setBorder(null);
    }

    public static ComponentUI createUI(JComponent c) {
        return new LiquidScrollBarUI();
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new LiquidScrollButton(orientation, this.scrollBarWidth, this.freeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new LiquidScrollButton(orientation, this.scrollBarWidth, this.freeStanding);
        return this.increaseButton;
    }

    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int decrButtonH = this.decrButton.getPreferredSize().height;
        int decrButtonY = sbInsets.top;
        int incrButtonH = this.incrButton.getPreferredSize().height;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        if ((thumbH = Math.min(thumbH, this.getMaximumThumbSize().height)) < 14) {
            thumbH = 14;
        }
        int thumbY = incrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = incrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY) {
                thumbY = incrButtonY - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        boolean ltr;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        int leftButtonW = ((ltr = sb.getComponentOrientation().isLeftToRight()) ? this.decrButton : this.incrButton).getPreferredSize().width;
        int rightButtonW = (ltr ? this.incrButton : this.decrButton).getPreferredSize().width;
        int leftButtonX = sbInsets.left;
        int rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = leftButtonW + rightButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        if ((thumbW = Math.min(thumbW, this.getMaximumThumbSize().width)) < 14) {
            thumbW = 14;
        }
        int n = thumbX = ltr ? rightButtonX - thumbW : leftButtonX + leftButtonW;
        if ((float)sb.getValue() < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = ltr ? (int)(0.5f + thumbRange * ((value - min) / (range - extent))) : (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
            thumbX += leftButtonX + leftButtonW;
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            rightButtonW = leftButtonW = sbAvailButtonW / 2;
            rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
        }
        (ltr ? this.decrButton : this.incrButton).setBounds(leftButtonX, itemY, leftButtonW, itemH);
        (ltr ? this.incrButton : this.decrButton).setBounds(rightButtonX, itemY, rightButtonW, itemH);
        int itrackX = leftButtonX + leftButtonW;
        int itrackW = rightButtonX - itrackX;
        this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbX + thumbW > rightButtonX) {
                thumbX = rightButtonX - thumbW;
            }
            if (thumbX < leftButtonX + leftButtonW) {
                thumbX = leftButtonX + leftButtonW + 1;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    public void paint(Graphics g, JComponent c) {
        if (this.orientation == -1) {
            this.orientation = this.scrollbar.getOrientation();
        }
        Rectangle trackBounds = this.getTrackBounds();
        this.getSkinTrack().draw(g, 0, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        Rectangle thumbBounds = this.getThumbBounds();
        int index = this.skinThumbIndexModel.getIndexForState(c.isEnabled(), this.isRollover, this.isDragging);
        int x = this.orientation == 1 ? thumbBounds.x + 1 : thumbBounds.x;
        int y = this.orientation == 1 ? thumbBounds.y : thumbBounds.y + 1;
        int width = this.orientation == 1 ? thumbBounds.width - 2 : thumbBounds.width;
        int height = this.orientation == 1 ? thumbBounds.height : thumbBounds.height - 2;
        this.getSkinThumb().draw(g, index, x, y, width, height);
    }

    public boolean isThumbVisible() {
        if (this.scrollbar.getOrientation() == 1) {
            return this.getThumbBounds().height != 0;
        }
        return this.getThumbBounds().width != 0;
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener(this);
    }

    public static Skin getSkinThumbHoriz() {
        if (skinThumbHoriz == null) {
            skinThumbHoriz = new Skin("scrollbarthumbhoriz.png", 4, 8, 6, 8, 8);
        }
        return skinThumbHoriz;
    }

    public static Skin getSkinThumbVert() {
        if (skinThumbVert == null) {
            skinThumbVert = new Skin("scrollbarthumbvert.png", 4, 6, 8, 8, 7);
        }
        return skinThumbVert;
    }

    public static Skin getSkinTrackHoriz() {
        if (skinTrackHoriz == null) {
            skinTrackHoriz = new Skin("scrollbartrackhoriz.png", 1, 7);
        }
        return skinTrackHoriz;
    }

    public static Skin getSkinTrackVert() {
        if (skinTrackVert == null) {
            skinTrackVert = new Skin("scrollbartrackvert.png", 1, 7);
        }
        return skinTrackVert;
    }

    public Skin getSkinTrack() {
        if (this.skinTrack == null) {
            this.skinTrack = this.scrollbar.getOrientation() == 1 ? LiquidScrollBarUI.getSkinTrackVert() : LiquidScrollBarUI.getSkinTrackHoriz();
        }
        return this.skinTrack;
    }

    public Skin getSkinThumb() {
        if (this.skinThumb == null) {
            this.skinThumb = this.scrollbar.getOrientation() == 1 ? LiquidScrollBarUI.getSkinThumbVert() : LiquidScrollBarUI.getSkinThumbHoriz();
        }
        return this.skinThumb;
    }

    public LiquidScrollBarUI() {
        this.MIN_THUMB_SIZE = 14;
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        private final /* synthetic */ LiquidScrollBarUI this$0;

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.this$0.scrollbar.repaint();
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.this$0.scrollbar.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            this.this$0.isRollover = false;
            this.this$0.wasRollover = false;
            if (LiquidScrollBarUI.super.getThumbBounds().contains(e.getX(), e.getY())) {
                this.this$0.isRollover = true;
            }
        }

        public void mouseExited(MouseEvent e) {
            this.this$0.isRollover = false;
            if (this.this$0.isRollover != this.this$0.wasRollover) {
                this.this$0.scrollbar.repaint();
                this.this$0.wasRollover = this.this$0.isRollover;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (LiquidScrollBarUI.super.getThumbBounds().contains(e.getX(), e.getY())) {
                this.this$0.isRollover = true;
            }
            super.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (LiquidScrollBarUI.super.getThumbBounds().contains(e.getX(), e.getY())) {
                this.this$0.isRollover = true;
                if (this.this$0.isRollover != this.this$0.wasRollover) {
                    this.this$0.scrollbar.repaint();
                    this.this$0.wasRollover = this.this$0.isRollover;
                }
            } else {
                this.this$0.isRollover = false;
                if (this.this$0.isRollover != this.this$0.wasRollover) {
                    this.this$0.scrollbar.repaint();
                    this.this$0.wasRollover = this.this$0.isRollover;
                }
            }
        }

        MyTrackListener(LiquidScrollBarUI liquidScrollBarUI) {
            LiquidScrollBarUI liquidScrollBarUI2 = liquidScrollBarUI;
            if (liquidScrollBarUI2 == null) {
                throw null;
            }
            super(liquidScrollBarUI2);
            this.this$0 = liquidScrollBarUI;
        }
    }
}

