/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.CreateReplStageStateAction;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.daemon.KotlinJvmReplServiceBase;
import org.jetbrains.kotlin.daemon.KotlinRemoteReplServiceKt;
import org.jetbrains.kotlin.daemon.RemoteReplStateFacadeServer;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0014J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0014J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0007J \u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010\tH\u0007J\u0010\u0010/\u001a\u00020\u001d2\b\b\u0002\u00100\u001a\u00020\u0005J2\u00101\u001a\b\u0012\u0004\u0012\u0002H302\"\u0004\b\u0000\u001032\u0006\u00104\u001a\u00020\u00052\u0016\u00105\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u000307\u0012\u0004\u0012\u0002H306R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R!\u0010!\u001a\u00020\u001d8DX\u0085\u0084\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010'\u0012\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplServiceBase;", "disposable", "Lcom/intellij/openapi/Disposable;", "portForServers", "", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "templateClasspath", "", "Ljava/io/File;", "templateClassName", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "<init>", "(Lcom/intellij/openapi/Disposable;ILorg/jetbrains/kotlin/daemon/common/CompilerId;Ljava/util/List;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)V", "getPortForServers", "()I", "getOperationsTracer", "()Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "before", "", "s", "after", "states", "Ljava/util/WeakHashMap;", "Lorg/jetbrains/kotlin/daemon/RemoteReplStateFacadeServer;", "", "getStates", "()Ljava/util/WeakHashMap;", "defaultStateFacade", "getDefaultStateFacade$annotations", "()V", "getDefaultStateFacade", "()Lorg/jetbrains/kotlin/daemon/RemoteReplStateFacadeServer;", "defaultStateFacade$delegate", "Lkotlin/Lazy;", "check", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "compile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "verifyHistory", "createRemoteState", "port", "withValidReplState", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "R", "stateId", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nKotlinRemoteReplService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRemoteReplService.kt\norg/jetbrains/kotlin/daemon/KotlinJvmReplService\n+ 2 KotlinRemoteReplService.kt\norg/jetbrains/kotlin/daemon/KotlinRemoteReplServiceKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n200#2,3:242\n203#2,7:248\n554#3,3:245\n295#4,2:255\n*S KotlinDebug\n*F\n+ 1 KotlinRemoteReplService.kt\norg/jetbrains/kotlin/daemon/KotlinJvmReplService\n*L\n161#1:242,3\n161#1:248,7\n161#1:245,3\n168#1:255,2\n*E\n"})
public class KotlinJvmReplService
extends KotlinJvmReplServiceBase {
    private final int portForServers;
    @Nullable
    private final RemoteOperationsTracer operationsTracer;
    @NotNull
    private final WeakHashMap<RemoteReplStateFacadeServer, Boolean> states;
    @NotNull
    private final Lazy defaultStateFacade$delegate;

    public KotlinJvmReplService(@NotNull Disposable disposable, int portForServers, @NotNull CompilerId compilerId, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName, @NotNull MessageCollector messageCollector, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        super(disposable, compilerId, templateClasspath, templateClassName, messageCollector);
        this.portForServers = portForServers;
        this.operationsTracer = operationsTracer;
        this.states = new WeakHashMap();
        this.defaultStateFacade$delegate = LazyKt.lazy(() -> KotlinJvmReplService.defaultStateFacade_delegate$lambda$0(this));
    }

    public final int getPortForServers() {
        return this.portForServers;
    }

    @Nullable
    protected final RemoteOperationsTracer getOperationsTracer() {
        return this.operationsTracer;
    }

    @Override
    protected void before(@NotNull String s) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            RemoteOperationsTracer remoteOperationsTracer = this.operationsTracer;
            if (remoteOperationsTracer == null) break block0;
            remoteOperationsTracer.before(s);
        }
    }

    @Override
    protected void after(@NotNull String s) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            RemoteOperationsTracer remoteOperationsTracer = this.operationsTracer;
            if (remoteOperationsTracer == null) break block0;
            remoteOperationsTracer.after(s);
        }
    }

    @NotNull
    protected final WeakHashMap<RemoteReplStateFacadeServer, Boolean> getStates() {
        return this.states;
    }

    @NotNull
    protected final RemoteReplStateFacadeServer getDefaultStateFacade() {
        Lazy lazy = this.defaultStateFacade$delegate;
        return (RemoteReplStateFacadeServer)lazy.getValue();
    }

    @Deprecated(message="remove after removal state-less check/compile/eval methods")
    protected static /* synthetic */ void getDefaultStateFacade$annotations() {
    }

    @Deprecated(message="Use check(state, line) instead")
    @NotNull
    public final ReplCheckResult check(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        return this.check(this.getDefaultStateFacade().getState(), codeLine);
    }

    @Deprecated(message="Use compile(state, line) instead")
    @NotNull
    public final ReplCompileResult compile(@NotNull ReplCodeLine codeLine, @Nullable List<ReplCodeLine> verifyHistory) {
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        return this.compile(this.getDefaultStateFacade().getState(), codeLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RemoteReplStateFacadeServer createRemoteState(int port) {
        RemoteReplStateFacadeServer remoteReplStateFacadeServer;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getStatesLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            AtomicInteger counter$iv = this.getStateIdCounter();
            boolean $i$f$getValidId = false;
            int newId$iv = counter$iv.incrementAndGet();
            int attemptsLeft$iv = 100;
            while (true) {
                boolean bl2;
                block10: {
                    int id = newId$iv;
                    boolean bl3 = false;
                    Map $this$none$iv = this.states;
                    boolean $i$f$none = false;
                    if ($this$none$iv.isEmpty()) {
                        bl2 = true;
                    } else {
                        Iterator iterator = $this$none$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry it = element$iv = iterator.next();
                            boolean bl4 = false;
                            if (!(((RemoteReplStateFacadeServer)it.getKey()).getId() == id)) continue;
                            bl2 = false;
                            break block10;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) break;
                if (--attemptsLeft$iv <= 0) {
                    throw new IllegalStateException("Invalid state or algorithm error");
                }
                newId$iv = counter$iv.addAndGet(KotlinRemoteReplServiceKt.getInternalRng().nextInt());
            }
            int id = newId$iv;
            RemoteReplStateFacadeServer stateFacade = new RemoteReplStateFacadeServer(id, CreateReplStageStateAction.createState$default((CreateReplStageStateAction)this, null, (int)1, null), port);
            this.states.put(stateFacade, true);
            remoteReplStateFacadeServer = stateFacade;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return remoteReplStateFacadeServer;
    }

    public static /* synthetic */ RemoteReplStateFacadeServer createRemoteState$default(KotlinJvmReplService kotlinJvmReplService, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createRemoteState");
        }
        if ((n2 & 1) != 0) {
            n = kotlinJvmReplService.portForServers;
        }
        return kotlinJvmReplService.createRemoteState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <R> CompileService.CallResult<R> withValidReplState(int stateId, @NotNull Function1<? super IReplStageState<?>, ? extends R> body) {
        CompileService.CallResult callResult;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ReentrantReadWriteLock.ReadLock readLock = this.getStatesLock().readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            Object v1;
            block6: {
                boolean bl = false;
                Set<RemoteReplStateFacadeServer> set = this.states.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                Iterable $this$firstOrNull$iv = set;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RemoteReplStateFacadeServer it = (RemoteReplStateFacadeServer)element$iv;
                    boolean bl2 = false;
                    if (!(it.getId() == stateId)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            RemoteReplStateFacadeServer remoteReplStateFacadeServer = v1;
            if (remoteReplStateFacadeServer != null) {
                RemoteReplStateFacadeServer it = remoteReplStateFacadeServer;
                boolean bl = false;
                callResult2 = new CompileService.CallResult.Good<Object>(body.invoke(it.getState()));
            } else {
                callResult2 = new CompileService.CallResult.Error("No REPL state with id " + stateId + " found");
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    private static final RemoteReplStateFacadeServer defaultStateFacade_delegate$lambda$0(KotlinJvmReplService this$0) {
        return KotlinJvmReplService.createRemoteState$default(this$0, 0, 1, null);
    }
}

