/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management.client;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.opensolaris.opengrok.management.OGAgent;
import org.opensolaris.opengrok.management.client.SettingsPersistence;

public class SettingsFrame
extends JFrame {
    private static final long serialVersionUID = -5229330170574558105L;
    private final SettingsPersistence properties;
    private JTextField agentURLField;
    private JLabel agentURLLabel;
    private JButton closeButton;
    private JTextField connTimeoutField;
    private JLabel headerLabel;
    private JTextField indexingTimeoutField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPasswordField passwordField;
    private JLabel seconds;
    private JTextField userTextField;

    public SettingsFrame(SettingsPersistence sp) {
        this.properties = sp;
        URL imageUrl = OGAgent.class.getResource("opengrok.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(imageUrl);
        this.setIconImage(image);
        this.initComponents();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = this.getPreferredSize();
        this.setLocation(screenSize.width / 2 - mySize.width / 2, screenSize.height / 2 - mySize.height / 2);
        this.loadSettings();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SettingsFrame.this.doClose();
            }
        });
    }

    private void loadSettings() {
        this.agentURLField.setText(this.properties.getAgentUrl());
        this.indexingTimeoutField.setText(this.properties.getProperty("org.opensolaris.opengrok.management.indextimeout"));
        this.connTimeoutField.setText(this.properties.getProperty("org.opensolaris.opengrok.management.connectiontimeout"));
    }

    private void saveSettings() {
        this.properties.setProperty("org.opensolaris.opengrok.management.url", this.agentURLField.getText());
        this.properties.setProperty("org.opensolaris.opengrok.management.indextimeout", this.indexingTimeoutField.getText());
        this.properties.setProperty("org.opensolaris.opengrok.management.connectiontimeout", this.connTimeoutField.getText());
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.headerLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.agentURLLabel = new JLabel();
        this.agentURLField = new JTextField();
        this.jLabel1 = new JLabel();
        this.userTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.passwordField = new JPasswordField();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.indexingTimeoutField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.connTimeoutField = new JTextField();
        this.seconds = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("OpenGrok");
        this.setIconImages(null);
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Close and save settings");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.headerLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/opensolaris/opengrok/management/client/opengrok.gif")));
        this.headerLabel.setText("OpenGrok Client Settings");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.agentURLLabel.setText("Agent URL");
        this.agentURLField.setText("localhost:9296");
        this.agentURLField.setToolTipText("Agent URL: <hostname>:<port>");
        this.jLabel1.setText("User Name");
        this.userTextField.setEditable(false);
        this.userTextField.setToolTipText("Username for connecting to the agent");
        this.jLabel2.setText("Password");
        this.passwordField.setEditable(false);
        this.passwordField.setText("jPasswordField1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.agentURLLabel).addComponent(this.jLabel2)).addGap(43, 43, 43).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordField, -1, 178, Short.MAX_VALUE).addComponent(this.userTextField, -1, 178, Short.MAX_VALUE).addComponent(this.agentURLField, -1, 178, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.agentURLField, -2, -1, -2).addComponent(this.agentURLLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordField, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel4.setText("Indexing Warning Timeout");
        this.indexingTimeoutField.setHorizontalAlignment(4);
        this.indexingTimeoutField.setText("10");
        this.jLabel5.setText("seconds");
        this.jLabel6.setText("Connection Timeout");
        this.connTimeoutField.setHorizontalAlignment(4);
        this.connTimeoutField.setText("120");
        this.seconds.setText("seconds");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.connTimeoutField, 0, 0, Short.MAX_VALUE).addComponent(this.indexingTimeoutField, -1, 32, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.seconds)).addContainerGap(44, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.indexingTimeoutField, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connTimeoutField, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.seconds, -2, 25, -2)).addContainerGap(47, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.headerLabel, -1, 313, Short.MAX_VALUE).addComponent(this.closeButton, GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.headerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.closeButton).addContainerGap()));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.saveSettings();
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new SettingsFrame(new SettingsPersistence(null)).setVisible(true);
                }
                catch (IOException ex) {
                    Logger.getLogger(SettingsFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }
}

