/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.CompatibleAnalyser;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.search.Hit;
import org.opensolaris.opengrok.search.QueryBuilder;
import org.opensolaris.opengrok.search.Summarizer;
import org.opensolaris.opengrok.search.Summary;
import org.opensolaris.opengrok.search.context.Context;
import org.opensolaris.opengrok.search.context.HistoryContext;

public class SearchEngine {
    private static final String SEARCH_EXCEPTION_MSG = "Exception searching {0}";
    public static final Version LUCENE_VERSION = Version.LUCENE_47;
    private String definition;
    private String file;
    private String freetext;
    private String history;
    private String symbol;
    private String type;
    private Query query;
    private final CompatibleAnalyser analyzer = new CompatibleAnalyser();
    private Context sourceContext;
    private HistoryContext historyContext;
    private Summarizer summarizer;
    private final List<Document> docs;
    private final char[] content = new char[8192];
    private String source;
    private String data;
    private static final boolean docsScoredInOrder = false;
    int hitsPerPage = RuntimeEnvironment.getInstance().getHitsPerPage();
    int cachePages = RuntimeEnvironment.getInstance().getCachePages();
    int totalHits = 0;
    private ScoreDoc[] hits;
    private TopScoreDocCollector collector;
    private IndexSearcher searcher;
    boolean allCollected;

    public SearchEngine() {
        this.docs = new ArrayList<Document>();
    }

    private QueryBuilder createQueryBuilder() {
        return new QueryBuilder().setFreetext(this.freetext).setDefs(this.definition).setRefs(this.symbol).setPath(this.file).setHist(this.history).setType(this.type);
    }

    public boolean isValidQuery() {
        boolean ret;
        try {
            this.query = this.createQueryBuilder().build();
            ret = this.query != null;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private void searchSingleDatabase(File root, boolean paging) throws IOException {
        DirectoryReader ireader = DirectoryReader.open((Directory)FSDirectory.open((File)root));
        this.searcher = new IndexSearcher((IndexReader)ireader);
        this.collector = TopScoreDocCollector.create((int)(this.hitsPerPage * this.cachePages), (boolean)false);
        this.searcher.search(this.query, (Collector)this.collector);
        this.totalHits = this.collector.getTotalHits();
        if (!paging && this.totalHits > 0) {
            this.collector = TopScoreDocCollector.create((int)this.totalHits, (boolean)false);
            this.searcher.search(this.query, (Collector)this.collector);
        }
        this.hits = this.collector.topDocs().scoreDocs;
        for (int i = 0; i < this.hits.length; ++i) {
            int docId = this.hits[i].doc;
            Document d = this.searcher.doc(docId);
            this.docs.add(d);
        }
    }

    private void searchMultiDatabase(List<Project> root, boolean paging) throws IOException {
        IndexReader[] subreaders = new IndexReader[root.size()];
        File droot = new File(RuntimeEnvironment.getInstance().getDataRootFile(), "index");
        int ii = 0;
        for (Project project : root) {
            DirectoryReader ireader = DirectoryReader.open((Directory)FSDirectory.open((File)new File(droot, project.getPath())));
            subreaders[ii++] = ireader;
        }
        MultiReader searchables = new MultiReader(subreaders, true);
        if (Runtime.getRuntime().availableProcessors() > 1) {
            int noThreads = 2 + 2 * Runtime.getRuntime().availableProcessors();
            ExecutorService executor = Executors.newFixedThreadPool(noThreads);
            this.searcher = new IndexSearcher((IndexReader)searchables, executor);
        } else {
            this.searcher = new IndexSearcher((IndexReader)searchables);
        }
        this.collector = TopScoreDocCollector.create((int)(this.hitsPerPage * this.cachePages), (boolean)false);
        this.searcher.search(this.query, (Collector)this.collector);
        this.totalHits = this.collector.getTotalHits();
        if (!paging && this.totalHits > 0) {
            this.collector = TopScoreDocCollector.create((int)this.totalHits, (boolean)false);
            this.searcher.search(this.query, (Collector)this.collector);
        }
        this.hits = this.collector.topDocs().scoreDocs;
        for (int i = 0; i < this.hits.length; ++i) {
            int docId = this.hits[i].doc;
            Document d = this.searcher.doc(docId);
            this.docs.add(d);
        }
    }

    public String getQuery() {
        return this.query.toString();
    }

    public int search() {
        this.source = RuntimeEnvironment.getInstance().getSourceRootPath();
        this.data = RuntimeEnvironment.getInstance().getDataRootPath();
        this.docs.clear();
        QueryBuilder queryBuilder = this.createQueryBuilder();
        try {
            this.query = queryBuilder.build();
            if (this.query != null) {
                RuntimeEnvironment env = RuntimeEnvironment.getInstance();
                File root = new File(env.getDataRootFile(), "index");
                if (env.hasProjects()) {
                    this.searchMultiDatabase(env.getProjects(), false);
                } else {
                    this.searchSingleDatabase(root, true);
                }
            }
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, SEARCH_EXCEPTION_MSG, e);
        }
        if (!this.docs.isEmpty()) {
            this.sourceContext = null;
            this.summarizer = null;
            try {
                this.sourceContext = new Context(this.query, queryBuilder.getQueries());
                if (this.sourceContext.isEmpty()) {
                    this.sourceContext = null;
                }
                this.summarizer = new Summarizer(this.query, this.analyzer);
            }
            catch (Exception e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while creating summary", e);
            }
            this.historyContext = null;
            try {
                this.historyContext = new HistoryContext(this.query);
                if (this.historyContext.isEmpty()) {
                    this.historyContext = null;
                }
            }
            catch (Exception e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while getting history context", e);
            }
        }
        int count = this.hits == null ? 0 : this.hits.length;
        return count;
    }

    public void results(int start, int end, List<Hit> ret) {
        if (this.hits == null || end < start) {
            ret.clear();
            return;
        }
        ret.clear();
        if (end > this.hits.length & !this.allCollected) {
            this.collector = TopScoreDocCollector.create((int)this.totalHits, (boolean)false);
            try {
                this.searcher.search(this.query, (Collector)this.collector);
            }
            catch (Exception e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, SEARCH_EXCEPTION_MSG, e);
            }
            this.hits = this.collector.topDocs().scoreDocs;
            Document d = null;
            for (int i = start; i < this.hits.length; ++i) {
                int docId = this.hits[i].doc;
                try {
                    d = this.searcher.doc(docId);
                }
                catch (Exception e) {
                    OpenGrokLogger.getLogger().log(Level.SEVERE, SEARCH_EXCEPTION_MSG, e);
                }
                this.docs.add(d);
            }
            this.allCollected = true;
        }
        for (int ii = start; ii < end; ++ii) {
            boolean alt = ii % 2 == 0;
            boolean hasContext = false;
            try {
                String filename;
                block33: {
                    Document doc = this.docs.get(ii);
                    filename = doc.get("path");
                    FileAnalyzer.Genre genre = FileAnalyzer.Genre.get(doc.get("t"));
                    Definitions tags = null;
                    IndexableField tagsField = doc.getField("tags");
                    if (tagsField != null) {
                        tags = Definitions.deserialize(tagsField.binaryValue().bytes);
                    }
                    int nhits = this.docs.size();
                    if (this.sourceContext != null) {
                        try {
                            if (FileAnalyzer.Genre.PLAIN == genre && this.source != null) {
                                hasContext = this.sourceContext.getContext(new InputStreamReader(new FileInputStream(this.source + filename)), null, null, null, filename, tags, nhits > 100, false, ret);
                                break block33;
                            }
                            if (FileAnalyzer.Genre.XREFABLE == genre && this.data != null && this.summarizer != null) {
                                int l = 0;
                                try (HTMLStripCharFilter r = RuntimeEnvironment.getInstance().isCompressXref() ? new HTMLStripCharFilter((Reader)new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.data + "/xref" + filename + ".gz"))))) : new HTMLStripCharFilter((Reader)new BufferedReader(new FileReader(this.data + "/xref" + filename)));){
                                    l = r.read(this.content);
                                }
                                Summary sum = this.summarizer.getSummary(new String(this.content, 0, l));
                                Summary.Fragment[] fragments = sum.getFragments();
                                for (int jj = 0; jj < fragments.length; ++jj) {
                                    String match = fragments[jj].toString();
                                    if (match.length() <= 0) continue;
                                    if (!fragments[jj].isEllipsis()) {
                                        Hit hit = new Hit(filename, fragments[jj].toString(), "", true, alt);
                                        ret.add(hit);
                                    }
                                    hasContext = true;
                                }
                                break block33;
                            }
                            OpenGrokLogger.getLogger().log(Level.WARNING, "Unknown genre: {0} for {1}", new Object[]{genre, filename});
                            hasContext |= this.sourceContext.getContext(null, null, null, null, filename, tags, false, false, ret);
                        }
                        catch (FileNotFoundException exp) {
                            OpenGrokLogger.getLogger().log(Level.WARNING, "Couldn''t read summary from {0} ({1})", new Object[]{filename, exp.getMessage()});
                            hasContext |= this.sourceContext.getContext(null, null, null, null, filename, tags, false, false, ret);
                        }
                    }
                }
                if (this.historyContext != null) {
                    hasContext |= this.historyContext.getContext(this.source + filename, filename, ret);
                }
                if (hasContext) continue;
                ret.add(new Hit(filename, "...", "", false, alt));
                continue;
            }
            catch (IOException e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, SEARCH_EXCEPTION_MSG, e);
                continue;
            }
            catch (ClassNotFoundException e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, SEARCH_EXCEPTION_MSG, e);
                continue;
            }
            catch (HistoryException e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, SEARCH_EXCEPTION_MSG, e);
            }
        }
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFreetext() {
        return this.freetext;
    }

    public void setFreetext(String freetext) {
        this.freetext = freetext;
    }

    public String getHistory() {
        return this.history;
    }

    public void setHistory(String history) {
        this.history = history;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String fileType) {
        this.type = fileType;
    }
}

