package FusionInventory::Agent::Tools::Standards::MobileCountryCode;

use strict;
use warnings;

use parent 'Exporter';

# Extracted from ITU List of terrestrial trunk radio mobile country codes
# See: http://www.itu.int/dms_pub/itu-t/opb/sp/T-SP-E.218-2017-MSW-E.docx
# Source date: June 2017

our @EXPORT = qw(
    getCountryMCC
);

my %MobileCountryCodes = (
    202 => "Greece",
    204 => "Netherlands",
    206 => "Belgium",
    208 => "France",
    212 => "Monaco",
    213 => "Andorra",
    214 => "Spain",
    216 => "Hungary",
    218 => "Bosnia and Herzegovina",
    219 => "Croatia",
    220 => "Serbia",
    221 => "Kosovo",
    222 => "Italy",
    225 => "Vatican",
    226 => "Romania",
    228 => "Switzerland",
    230 => "Czechia",
    231 => "Slovakia",
    232 => "Austria",
    234 => "Great Britain",
    235 => "Great Britain",
    238 => "Denmark",
    240 => "Sweden",
    242 => "Norway",
    244 => "Finland",
    246 => "Lithuania",
    247 => "Latvia",
    248 => "Estonia",
    250 => "Russia",
    255 => "Ukraine",
    257 => "Belarus",
    259 => "Moldova",
    260 => "Poland",
    262 => "Germany",
    266 => "Gibraltar",
    268 => "Portugal",
    270 => "Luxembourg",
    272 => "Ireland",
    274 => "Iceland",
    276 => "Albania",
    278 => "Malta",
    280 => "Cyprus",
    282 => "Georgia",
    283 => "Armenia",
    284 => "Bulgaria",
    286 => "Turkey",
    288 => "Faroe Islands",
    290 => "Greenland",
    292 => "San Marino",
    293 => "Slovenia",
    294 => "Macedonia",
    295 => "Liechtenstein",
    297 => "Montenegro",
    302 => "Canada",
    308 => "Saint Pierre and Miquelon",
    310 => "USA",
    311 => "USA",
    312 => "USA",
    313 => "USA",
    314 => "USA",
    315 => "USA",
    316 => "USA",
    330 => "Puerto Rico",
    332 => "Virgin Islands",
    334 => "Mexico",
    338 => "Jamaica",
    340 => "Guadeloupe",
    340 => "Martinique",
    342 => "Barbados",
    344 => "Antigua and Barbuda",
    346 => "Cayman Islands",
    348 => "British Virgin Islands",
    350 => "Bermuda",
    352 => "Grenada",
    354 => "Montserrat",
    356 => "Saint Kitts and Nevis",
    358 => "Saint Lucia",
    360 => "Saint Vincent and the Grenadines",
    362 => "Curaçao",
    362 => "Sint Maarten",
    362 => "Bonaire, Sint Eustatius and Saba",
    363 => "Aruba",
    364 => "Bahamas",
    365 => "Anguilla",
    366 => "Dominica",
    368 => "Cuba",
    370 => "Dominican Republic",
    372 => "Haiti",
    374 => "Trinidad and Tobago",
    376 => "Turks and Caicos Islands",
    400 => "Azerbaijan",
    401 => "Kazakhstan",
    402 => "Bhutan",
    404 => "India",
    405 => "India",
    406 => "India",
    410 => "Pakistan",
    412 => "Afghanistan",
    413 => "Sri Lanka",
    414 => "Myanmar",
    415 => "Lebanon",
    416 => "Jordan",
    417 => "Syria",
    418 => "Iraq",
    419 => "Kuwait",
    420 => "Saudi Arabia",
    421 => "Yemen",
    422 => "Oman",
    424 => "Emirates",
    425 => "Israel",
    426 => "Bahrain",
    427 => "Qatar",
    428 => "Mongolia",
    429 => "Nepal",
    430 => "Emirates",
    431 => "Emirates",
    432 => "Iran",
    434 => "Uzbekistan",
    436 => "Tajikistan",
    437 => "Kyrgyz Republic",
    438 => "Turkmenistan",
    440 => "Japan",
    441 => "Japan",
    450 => "Korea",
    452 => "Viet Nam",
    454 => "Hong Kong",
    455 => "Macao",
    456 => "Cambodia",
    457 => "Lao",
    460 => "China",
    461 => "China",
    466 => "Taiwan",
    467 => "North Korea",
    470 => "Bangladesh",
    472 => "Maldives",
    502 => "Malaysia",
    505 => "Australia",
    510 => "Indonesia",
    514 => "Timor-Leste",
    515 => "Philippines",
    520 => "Thailand",
    525 => "Singapore",
    528 => "Brunei",
    530 => "New Zealand",
    536 => "Nauru",
    537 => "Papua New Guinea",
    539 => "Tonga",
    540 => "Solomon Islands",
    541 => "Vanuatu",
    542 => "Fiji",
    543 => "Wallis and Futuna",
    544 => "American Samoa",
    545 => "Kiribati",
    546 => "New Caledonia",
    547 => "French Polynesia",
    548 => "Cook Islands",
    549 => "Samoa",
    550 => "Micronesia",
    551 => "Marshall Islands",
    552 => "Palau",
    553 => "Tuvalu",
    554 => "Tokelau",
    555 => "Niue",
    602 => "Egypt",
    603 => "Algeria",
    604 => "Morocco",
    605 => "Tunisia",
    606 => "Libya",
    607 => "Gambia",
    608 => "Senegal",
    609 => "Mauritania",
    610 => "Mali",
    611 => "Guinea",
    612 => "Ivory Coast",
    613 => "Burkina Faso",
    614 => "Niger",
    615 => "Togo",
    616 => "Benin",
    617 => "Mauritius",
    618 => "Liberia",
    619 => "Sierra Leone",
    620 => "Ghana",
    621 => "Nigeria",
    622 => "Chad",
    623 => "Central African Republic",
    624 => "Cameroon",
    625 => "Cabo Verde",
    626 => "Sao Tome and Principe",
    627 => "Equatorial Guinea",
    628 => "Gabon",
    629 => "Congo",
    630 => "Democratic Republic of the Congo",
    631 => "Angola",
    632 => "Guinea-Bissau",
    633 => "Seychelles",
    634 => "Sudan",
    635 => "Rwanda",
    636 => "Ethiopia",
    637 => "Somalia",
    638 => "Djibouti",
    639 => "Kenya",
    640 => "Tanzania",
    641 => "Uganda",
    642 => "Burundi",
    643 => "Mozambique",
    645 => "Zambia",
    646 => "Madagascar",
    647 => "French Departments and Territories in the Indian Ocean",
    648 => "Zimbabwe",
    649 => "Namibia",
    650 => "Malawi",
    651 => "Lesotho",
    652 => "Botswana",
    653 => "Swaziland",
    654 => "Comoros",
    655 => "South Africa",
    657 => "Eritrea",
    658 => "Saint Helena",
    659 => "South Sudan",
    702 => "Belize",
    704 => "Guatemala",
    706 => "El Salvador",
    708 => "Honduras",
    710 => "Nicaragua",
    712 => "Costa Rica",
    714 => "Panama",
    716 => "Peru",
    722 => "Argentine",
    724 => "Brazil",
    730 => "Chile",
    732 => "Colombia",
    734 => "Venezuela",
    736 => "Bolivia",
    738 => "Guyana",
    740 => "Ecuador",
    742 => "French Guiana",
    744 => "Paraguay",
    746 => "Suriname",
    748 => "Uruguay",
    750 => "Falkland Islands",
    901 => "International Mobile",
);

sub getCountryMCC {
    my ($mcc) = @_;

    return unless $mcc;

    return $MobileCountryCodes{$mcc} if $MobileCountryCodes{$mcc};

    return unless ($mcc =~ /^[128]\d\d$/);

    return 'Reserved';
}

1;
