<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'framasoft/framadate';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'doctrine/deprecations' => '1.1.5@459c2f5dd3d6a4633d3b5f46ee2b1c40f57d3f38',
  'doctrine/lexer' => '2.1.1@861c870e8b75f7c8f69c146c7f89cc1c0f1b49b6',
  'egulias/email-validator' => '3.2.6@e5997fa97e8790cdae03a9cbd5e78e45e3c7bda7',
  'erusev/parsedown' => '1.7.4@cb17b6477dfff935958ba01325f2e8a2bfa6dab3',
  'ircmaxell/password-compat' => 'dev-master@dfdbc467fba0d1db4c2f51fda58e1717046f3284',
  'o80/i18n' => 'dev-develop@7b59cf9b2bc47b1084ac7e754d41ca595ff6c33d',
  'phpmailer/phpmailer' => 'v6.9.3@2f5c94fe7493efc213f643c23b1b1c249d40f47e',
  'roave/security-advisories' => 'dev-master@3d61806715a2f1e173f722f77260b837ebc3a9d3',
  'sabre/uri' => '2.2.4@c0c9af9f7754e60a49ebd760e1708adc6d1510c0',
  'sabre/vobject' => '4.5.6@900266bb3bd448a9f7f41f82344ad0aba237cb27',
  'sabre/xml' => '2.2.11@01a7927842abf3e10df3d9c2d9b0cc9d813a3fcc',
  'smarty/smarty' => 'v4.5.5@c4851c12e34ff80073ddeb7d98b059d57dea9de2',
  'symfony/polyfill-intl-idn' => 'v1.31.0@c36586dcf89a12315939e00ec9b4474adcb1d773',
  'symfony/polyfill-intl-normalizer' => 'v1.31.0@3833d7255cc303546435cb650316bff708a1c75c',
  'amphp/amp' => 'v2.6.4@ded3d9be08f526089eb7ee8d9f16a9768f9dec2d',
  'amphp/byte-stream' => 'v1.8.2@4f0e968ba3798a423730f567b1b50d3441c16ddc',
  'composer/package-versions-deprecated' => '1.11.99.5@b4f54f74ef3453349c24a845d22392cd31e65f1d',
  'composer/pcre' => '1.0.1@67a32d7d6f9f560b726ab25a061b38ff3a80c560',
  'composer/semver' => '3.4.3@4313d26ada5e0c4edfbd1dc481a92ff7bff91f12',
  'composer/xdebug-handler' => '2.0.5@9e36aeed4616366d2b690bdce11f71e9178c579a',
  'dnoegel/php-xdg-base-dir' => 'v0.1.1@8f8a6e48c5ecb0f991c2fdcf5f154a47d85f9ffd',
  'doctrine/annotations' => '1.14.4@253dca476f70808a5aeed3a47cc2cc88c5cab915',
  'doctrine/instantiator' => '1.5.0@0a0fa9780f5d4e507415a065172d26a98d02047b',
  'felixfbecker/advanced-json-rpc' => 'v3.2.1@b5f37dbff9a8ad360ca341f3240dc1c168b45447',
  'felixfbecker/language-server-protocol' => 'v1.5.3@a9e113dbc7d849e35b8776da39edaf4313b7b6c9',
  'friendsofphp/php-cs-fixer' => 'v3.4.0@47177af1cfb9dab5d1cc4daf91b7179c2efe7fad',
  'myclabs/deep-copy' => '1.13.0@024473a478be9df5fdaca2c793f2232fe788e414',
  'netresearch/jsonmapper' => 'v4.5.0@8e76efb98ee8b6afc54687045e1b8dba55ac76e5',
  'nikic/php-parser' => 'v4.19.4@715f4d25e225bc47b293a8b997fe6ce99bf987d2',
  'openlss/lib-array2xml' => '1.0.0@a91f18a8dfc69ffabe5f9b068bc39bb202c81d90',
  'phar-io/manifest' => '2.0.4@54750ef60c58e43759730615a392c31c80e23176',
  'phar-io/version' => '3.2.1@4f7fd7836c6f332bb2933569e566a0d6c4cbed74',
  'php-cs-fixer/diff' => 'v2.0.2@29dc0d507e838c4580d018bd8b5cb412474f7ec3',
  'phpdocumentor/reflection-common' => '2.2.0@1d01c49d4ed62f25aa84a747ad35d5a16924662b',
  'phpdocumentor/reflection-docblock' => '5.3.0@622548b623e81ca6d78b721c5e029f4ce664f170',
  'phpdocumentor/type-resolver' => '1.10.0@679e3ce485b99e84c775d28e2e96fade9a7fb50a',
  'phpstan/phpdoc-parser' => '1.33.0@82a311fd3690fb2bf7b64d5c98f912b3dd746140',
  'phpunit/php-code-coverage' => '9.2.32@85402a822d1ecf1db1096959413d35e1c37cf1a5',
  'phpunit/php-file-iterator' => '3.0.6@cf1c2e7c203ac650e352f4cc675a7021e7d1b3cf',
  'phpunit/php-invoker' => '3.1.1@5a10147d0aaf65b58940a0b72f71c9ac0423cc67',
  'phpunit/php-text-template' => '2.0.4@5da5f67fc95621df9ff4c4e5a84d6a8a2acf7c28',
  'phpunit/php-timer' => '5.0.3@5a63ce20ed1b5bf577850e2c4e87f4aa902afbd2',
  'phpunit/phpunit' => '9.6.22@f80235cb4d3caa59ae09be3adf1ded27521d1a9c',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.1@8622567409010282b7aeebe4bb841fe98b58dcaf',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'sebastian/cli-parser' => '1.0.2@2b56bea83a09de3ac06bb18b92f068e60cc6f50b',
  'sebastian/code-unit' => '1.0.8@1fc9f64c0927627ef78ba436c9b17d967e68e120',
  'sebastian/code-unit-reverse-lookup' => '2.0.3@ac91f01ccec49fb77bdc6fd1e548bc70f7faa3e5',
  'sebastian/comparator' => '4.0.8@fa0f136dd2334583309d32b62544682ee972b51a',
  'sebastian/complexity' => '2.0.3@25f207c40d62b8b7aa32f5ab026c53561964053a',
  'sebastian/diff' => '4.0.6@ba01945089c3a293b01ba9badc29ad55b106b0bc',
  'sebastian/environment' => '5.1.5@830c43a844f1f8d5b7a1f6d6076b784454d8b7ed',
  'sebastian/exporter' => '4.0.6@78c00df8f170e02473b682df15bfcdacc3d32d72',
  'sebastian/global-state' => '5.0.7@bca7df1f32ee6fe93b4d4a9abbf69e13a4ada2c9',
  'sebastian/lines-of-code' => '1.0.4@e1e4a170560925c26d424b6a03aed157e7dcc5c5',
  'sebastian/object-enumerator' => '4.0.4@5c9eeac41b290a3712d88851518825ad78f45c71',
  'sebastian/object-reflector' => '2.0.4@b4f479ebdbf63ac605d183ece17d8d7fe49c15c7',
  'sebastian/recursion-context' => '4.0.5@e75bd0f07204fec2a0af9b0f3cfe97d05f92efc1',
  'sebastian/resource-operations' => '3.0.4@05d5692a7993ecccd56a03e40cd7e5b09b1d404e',
  'sebastian/type' => '3.2.1@75e2c2a32f5e0b3aef905b9ed0b179b953b3d7c7',
  'sebastian/version' => '3.0.2@c6c1022351a901512170118436c764e473f6de8c',
  'symfony/console' => 'v5.4.47@c4ba980ca61a9eb18ee6bcc73f28e475852bb1ed',
  'symfony/deprecation-contracts' => 'v2.5.4@605389f2a7e5625f273b53960dc46aeaf9c62918',
  'symfony/event-dispatcher' => 'v5.4.45@72982eb416f61003e9bb6e91f8b3213600dcf9e9',
  'symfony/event-dispatcher-contracts' => 'v2.5.4@e0fe3d79b516eb75126ac6fa4cbf19b79b08c99f',
  'symfony/filesystem' => 'v5.4.45@57c8294ed37d4a055b77057827c67f9558c95c54',
  'symfony/finder' => 'v5.4.45@63741784cd7b9967975eec610b256eed3ede022b',
  'symfony/options-resolver' => 'v5.4.45@74e5b6f0db3e8589e6cfd5efb317a1fc2bb52fb6',
  'symfony/polyfill-ctype' => 'v1.31.0@a3cc8b044a6ea513310cbd48ef7333b384945638',
  'symfony/polyfill-intl-grapheme' => 'v1.31.0@b9123926e3b7bc2f98c02ad54f6a4b02b91a8abe',
  'symfony/polyfill-mbstring' => 'v1.31.0@85181ba99b2345b0ef10ce42ecac37612d9fd341',
  'symfony/polyfill-php73' => 'v1.31.0@0f68c03565dcaaf25a890667542e8bd75fe7e5bb',
  'symfony/polyfill-php80' => 'v1.31.0@60328e362d4c2c802a54fcbf04f9d3fb892b4cf8',
  'symfony/polyfill-php81' => 'v1.31.0@4a4cfc2d253c21a5ad0e53071df248ed48c6ce5c',
  'symfony/process' => 'v5.4.47@5d1662fb32ebc94f17ddb8d635454a776066733d',
  'symfony/service-contracts' => 'v2.5.4@f37b419f7aea2e9abf10abd261832cace12e3300',
  'symfony/stopwatch' => 'v5.4.45@fb2c199cf302eb207f8c23e7ee174c1c31a5c004',
  'symfony/string' => 'v5.4.47@136ca7d72f72b599f2631aca474a4f8e26719799',
  'theseer/tokenizer' => '1.2.3@737eda637ed5e28c3413cb1ebe8bb52cbf1ca7a2',
  'vimeo/psalm' => '4.30.0@d0bc6e25d89f649e4f36a534f330f8bb4643dd69',
  'webmozart/assert' => '1.11.0@11cb2199493b2f8a3b53e7f19068fc6aac760991',
  'webmozart/path-util' => '2.3.0@d939f7edc24c9a1bb9c0dee5cb05d8e859490725',
  'framasoft/framadate' => '0.9.0@',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
