/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.net.URI;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.Internal;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTHyperlink;

public class XSLFHyperlink {
    final XSLFTextRun _r;
    final CTHyperlink _link;

    XSLFHyperlink(CTHyperlink link, XSLFTextRun r) {
        this._r = r;
        this._link = link;
    }

    @Internal
    public CTHyperlink getXmlObject() {
        return this._link;
    }

    public void setAddress(String address) {
        XSLFSheet sheet = this._r.getParentParagraph().getParentShape().getSheet();
        PackageRelationship rel = sheet.getPackagePart().addExternalRelationship(address, XSLFRelation.HYPERLINK.getRelation());
        this._link.setId(rel.getId());
    }

    public void setAddress(XSLFSlide slide) {
        XSLFSheet sheet = this._r.getParentParagraph().getParentShape().getSheet();
        PackageRelationship rel = sheet.getPackagePart().addRelationship(slide.getPackagePart().getPartName(), TargetMode.INTERNAL, XSLFRelation.SLIDE.getRelation());
        this._link.setId(rel.getId());
        this._link.setAction("ppaction://hlinksldjump");
    }

    @Internal
    public URI getTargetURI() {
        XSLFSheet sheet = this._r.getParentParagraph().getParentShape().getSheet();
        String id = this._link.getId();
        return sheet.getPackagePart().getRelationship(id).getTargetURI();
    }
}

