/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpstatistics;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.gtpstatistics.CommandStatistics;
import net.sf.gogui.gtpstatistics.Plot;
import net.sf.gogui.gtpstatistics.PositionStatistics;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.FileUtils;
import net.sf.gogui.utils.Histogram;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.utils.Table;
import net.sf.gogui.utils.TableUtils;
import net.sf.gogui.version.Version;

public class Analyze {
    private static final Color[] PLOT_COLOR = new Color[]{Color.decode("#ff0000"), Color.decode("#ff9800"), Color.decode("#009800"), Color.decode("#00c0c0"), Color.decode("#0000ff"), Color.decode("#980098")};
    private static final int m_imgHeight = 100;
    private int m_maxMove;
    private int m_movePrintInterval;
    private int m_precision;
    private static final String COLOR_HEADER = "#b5c8f0";
    private static final String COLOR_INFO = "#e0e0e0";
    private final String m_output;
    private Table m_table;
    private Table m_tableFinal;
    private ArrayList m_commandStatistics;
    private ArrayList m_commands;
    private ArrayList m_gameGlobalCommands;
    private ArrayList m_gameInfo;

    public Analyze(String string, String string2, int n) throws Exception {
        Object object;
        int n2;
        if (string2.equals("")) {
            this.m_output = FileUtils.removeExtension(new File(string), "dat");
        } else if (new File(string2).isDirectory()) {
            File file = new File(new File(string).getName());
            this.m_output = string2 + File.separator + FileUtils.removeExtension(file, "dat");
        } else {
            this.m_output = string2;
        }
        this.m_precision = n;
        this.m_table = new Table();
        this.m_table.read(new File(string));
        if (this.m_table.getNumberColumns() < 2 || !this.m_table.getColumnTitle(0).equals("File") || !this.m_table.getColumnTitle(1).equals("Move")) {
            throw new ErrorMessage("Invalid table format");
        }
        this.m_commands = new ArrayList();
        for (int i = 2; i < this.m_table.getNumberColumns(); ++i) {
            this.m_commands.add(this.m_table.getColumnTitle(i));
        }
        this.m_commandStatistics = new ArrayList(this.m_commands.size());
        File file = new File(this.m_output + ".html");
        this.initGameInfo();
        this.findGameGlobalCommands();
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        this.startHtml(printStream, "Statistics Summary");
        this.startInfo(printStream, "Statistics Summary");
        this.writeInfo(printStream);
        this.endInfo(printStream);
        printStream.print("<table border=\"0\">\n<tr><td>\n");
        this.writePlot(printStream, "<small>positions</small>", this.getCountFile().getName(), "<a href=\"" + this.getCountDataFile().getName() + "\"><small>data</small></a>");
        printStream.print("</td></tr>\n");
        for (n2 = 0; n2 < this.m_commands.size(); ++n2) {
            CommandStatistics commandStatistics = this.computeCommandStatistics(n2);
            this.m_commandStatistics.add(commandStatistics);
            if (commandStatistics.getCount() <= 0 || commandStatistics.m_isBeginCommand) continue;
            object = this.getCommand(n2);
            Table table = commandStatistics.m_tableAtMove;
            Plot plot = this.generatePlotMove(this.getImgWidth(this.m_maxMove), this.getColor((String)object));
            plot.setFormatY(commandStatistics.m_format);
            File file2 = this.getAvgPlotFile(n2);
            File file3 = this.getAvgDataFile(n2);
            plot.setPlotStyleNoLines();
            plot.plot(file2, table, "Move", "Mean", "Error");
            FileWriter fileWriter = new FileWriter(file3);
            table.save(fileWriter, false);
            fileWriter.close();
            printStream.print("<tr><td>\n");
            this.writePlot(printStream, this.getCommandLink(n2), file2.getName(), "<a href=\"" + file3.getName() + "\"><small>data</small></a>");
            printStream.print("</td></tr>\n");
        }
        printStream.print("</table>\n<hr>\n<table border=\"0\" cellpadding=\"0\">\n<tr>\n");
        n2 = 0;
        for (int i = 0; i < this.m_commands.size(); ++i) {
            object = this.getCommandStatistics(i);
            if (((CommandStatistics)object).getCount() == 0) continue;
            printStream.print("<td valign=\"bottom\" bgcolor=\"#b5c8f0\">\n");
            this.writePlot(printStream, this.getCommandLink(i), this.getHistoFile(i).getName(), "");
            printStream.print("</td>\n");
            if (++n2 % 5 != 0) continue;
            printStream.print("</tr><tr>\n");
        }
        printStream.print("</tr>\n</table>\n<hr>\n");
        this.writeCommandsTable(printStream);
        printStream.print("<hr>\n");
        this.writeGameTable(printStream);
        this.finishHtml(printStream);
        printStream.close();
    }

    private void endInfo(PrintStream printStream) {
        printStream.print("</table></td></tr>\n</table>\n<hr>\n");
    }

    private void findGameGlobalCommands() {
        this.m_gameGlobalCommands = new ArrayList();
        for (int i = 0; i < this.m_commands.size(); ++i) {
            String string = this.getCommand(i);
            boolean bl = true;
            ArrayList arrayList = new ArrayList();
            for (int j = 0; j < this.m_gameInfo.size(); ++j) {
                GameInfo gameInfo = (GameInfo)this.m_gameInfo.get(j);
                Table table = TableUtils.select(this.m_table, "File", gameInfo.m_file, string);
                ArrayList arrayList2 = TableUtils.getColumnNotEmpty(table, string);
                if (arrayList2.size() > 1) {
                    bl = false;
                    break;
                }
                if (arrayList2.size() == 1) {
                    arrayList.add(arrayList2.get(0));
                    continue;
                }
                arrayList.add("");
            }
            if (!bl) continue;
            GameGlobalCommand gameGlobalCommand = new GameGlobalCommand(string, arrayList);
            this.m_gameGlobalCommands.add(gameGlobalCommand);
        }
    }

    private void finishHtml(PrintStream printStream) {
        printStream.print("<hr>\n<address><small>Generated on " + StringUtils.getDateShort() + " by GtpStatistics " + Version.get() + " (<a href=\"http://gogui.sf.net\">" + "http://gogui.sf.net</a>)</small></address>\n" + "</body>\n" + "</html>\n");
    }

    private File getAvgDataFile(int n) {
        return new File(this.m_output + ".command-" + n + ".avg.dat");
    }

    private File getAvgPlotFile(int n) {
        return new File(this.m_output + ".command-" + n + ".avg.png");
    }

    private String getCommand(int n) {
        return (String)this.m_commands.get(n);
    }

    private File getCommandFile(int n) {
        return new File(this.m_output + ".command-" + n + ".html");
    }

    private CommandStatistics getCommandStatistics(int n) {
        return (CommandStatistics)this.m_commandStatistics.get(n);
    }

    private File getCountFile() {
        return new File(this.m_output + ".count.png");
    }

    private File getCountDataFile() {
        return new File(this.m_output + ".count.dat");
    }

    private File getGameFile(int n) {
        return new File(this.m_output + ".game-" + n + ".html");
    }

    private GameGlobalCommand getGameGlobalCommand(int n) {
        return (GameGlobalCommand)this.m_gameGlobalCommands.get(n);
    }

    private File getHistoFile(int n) {
        return new File(this.m_output + ".command-" + n + ".histo.png");
    }

    private File getHistoFile(int n, int n2) {
        return new File(this.m_output + ".command-" + n + ".interval-" + n2 + ".histo.png");
    }

    private File getHistoFinalFile(int n) {
        return new File(this.m_output + ".command-" + n + ".final.png");
    }

    private File getPlotFile(int n, int n2) {
        return new File(this.m_output + ".game-" + n + ".command-" + n2 + ".png");
    }

    private String getCommandLink(int n) {
        String string = "<small>" + this.getCommand(n) + "</small>";
        CommandStatistics commandStatistics = this.getCommandStatistics(n);
        if (commandStatistics.getCount() == 0 || commandStatistics.m_isBeginCommand) {
            return string;
        }
        return "<a href=\"" + this.getCommandFile(n).getName() + "\">" + string + "</a>";
    }

    private CommandStatistics computeCommandStatistics(int n) throws Exception {
        String string = this.getCommand(n);
        return new CommandStatistics(string, this.m_table, this.m_tableFinal, this.getHistoFile(n), this.getHistoFinalFile(n), this.getColor(string), this.m_precision);
    }

    private Plot generatePlotMove(int n, Color color) {
        Plot plot = new Plot(n, 100, color, this.m_precision);
        plot.setSolidLineInterval(10.0);
        plot.setXMin(0.0);
        plot.setXMax(this.m_maxMove);
        plot.setXTics(5.0);
        plot.setXLabelPerTic(2);
        return plot;
    }

    private void generatePlot(int n, DecimalFormat decimalFormat, int n2, String string) throws Exception {
        String string2 = this.getCommand(n);
        Table table = TableUtils.select(this.m_table, "File", string, "Move", string2);
        File file = this.getPlotFile(n2, n);
        Plot plot = this.generatePlotMove(this.getImgWidth(this.m_maxMove), this.getColor(string2));
        plot.setFormatY(decimalFormat);
        plot.plot(file, table, "Move", string2, null);
    }

    private Color getColor(String string) {
        int n = this.m_table.getColumnIndex(string);
        return PLOT_COLOR[(n - 2) % PLOT_COLOR.length];
    }

    private String getGameLink(File file, int n, boolean bl) {
        GameInfo gameInfo = (GameInfo)this.m_gameInfo.get(n);
        File file2 = new File(gameInfo.m_file);
        if (!file2.exists()) {
            return bl ? file2.getName() : file2.toString();
        }
        String string = FileUtils.getRelativeURI(file, file2);
        return "<a href=\"" + string + "\">" + (bl ? file2.getName() : string) + "</a>";
    }

    private int getImgWidth(int n) {
        return Math.max(10, Math.min(n * 9, 1040));
    }

    private void initGameInfo() throws IOException {
        Object object;
        int n;
        this.m_gameInfo = new ArrayList();
        String string = null;
        GameInfo gameInfo = null;
        this.m_maxMove = 0;
        int[] nArray = new int[]{};
        for (n = 0; n < this.m_table.getNumberRows(); ++n) {
            object = this.m_table.get("File", n);
            int n2 = Integer.parseInt(this.m_table.get("Move", n));
            if (n2 >= nArray.length) {
                int[] nArray2 = new int[n2 + 1];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray2[i] = nArray[i];
                }
                nArray = nArray2;
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
            this.m_maxMove = Math.max(this.m_maxMove, n2);
            if (string == null || !((String)object).equals(string)) {
                if (gameInfo != null) {
                    this.m_gameInfo.add(gameInfo);
                }
                gameInfo = new GameInfo();
                gameInfo.m_file = object;
                gameInfo.m_name = new File((String)object).getName();
            }
            ++gameInfo.m_numberPositions;
            gameInfo.m_finalPosition = n2;
            string = object;
        }
        this.m_movePrintInterval = 1;
        while (this.m_movePrintInterval < this.m_maxMove / 30) {
            this.m_movePrintInterval *= 5;
            if (this.m_movePrintInterval >= this.m_maxMove / 30) break;
            this.m_movePrintInterval *= 2;
        }
        this.m_gameInfo.add(gameInfo);
        this.m_tableFinal = new Table(this.m_table.getColumnTitles());
        for (n = 0; n < this.m_gameInfo.size(); ++n) {
            gameInfo = (GameInfo)this.m_gameInfo.get(n);
            object = gameInfo.m_file;
            String string2 = Integer.toString(gameInfo.m_finalPosition);
            int n4 = TableUtils.findRow(this.m_table, "File", (String)object, "Move", string2);
            TableUtils.appendRow(this.m_tableFinal, this.m_table, n4);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Move");
        arrayList.add("Count");
        object = new Table(arrayList);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            ((Table)object).startRow();
            ((Table)object).set("Move", i);
            ((Table)object).set("Count", nArray[i]);
        }
        Plot plot = this.generatePlotMove(this.getImgWidth(this.m_maxMove), Color.DARK_GRAY);
        plot.setNoPlotYZero();
        plot.plot(this.getCountFile(), (Table)object, "Move", "Count", null);
        FileWriter fileWriter = new FileWriter(this.getCountDataFile());
        ((Table)object).save(fileWriter, false);
        fileWriter.close();
    }

    private boolean isGameGlobalCommand(String string) {
        for (int i = 0; i < this.m_gameGlobalCommands.size(); ++i) {
            if (!this.getGameGlobalCommand(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void startHtml(PrintStream printStream, String string) {
        String string2 = StringUtils.getDefaultEncoding();
        printStream.print("<html>\n<head>\n<title>" + string + "</title>\n" + "<meta http-equiv=\"Content-Type\"" + " content=\"text/html; charset=" + string2 + "\">\n" + "<meta name=\"generator\" content=\"GtpStatistics " + Version.get() + "\">\n" + "<style type=\"text/css\">\n" + "<!--\n" + "a:link { color:#0000ee }\n" + "a:visited { color:#551a8b }\n" + ".smalltable { font-size:80%; }\n" + ".smalltable td { background-color:" + COLOR_INFO + "; text-align:center; }\n" + ".smalltable th { background-color:" + COLOR_HEADER + ";  vertical-align:top; }\n" + ".smalltable table { border:0; cellpadding:0; }\n" + "-->\n" + "</style>\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\">\n");
    }

    private void startInfo(PrintStream printStream, String string) {
        printStream.print("<table border=\"0\" width=\"100%\" bgcolor=\"#b5c8f0\">\n<tr><td>\n<h1>" + string + "</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + COLOR_INFO + "\" >\n" + "<tr><td><table style=\"font-size:80%\"" + " cellpadding=\"0\">\n");
    }

    private void writeCommandPage(int n) throws Exception {
        String string = this.getCommand(n);
        CommandStatistics commandStatistics = this.getCommandStatistics(n);
        File file = this.getCommandFile(n);
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        this.startHtml(printStream, string);
        this.startInfo(printStream, string);
        this.writeInfoBasics(printStream);
        this.writeHtmlRow(printStream, "Command Index", n);
        this.endInfo(printStream);
        if (!commandStatistics.m_isBeginCommand) {
            printStream.print("<p><img src=\"" + this.getAvgPlotFile(n).getName() + "\"></p>\n");
        }
        this.writeCommandStatistics(printStream, n);
        printStream.print("<hr>\n");
        printStream.print("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">\n");
        printStream.print("<tr><td><small>All</small><br><img src=\"" + this.getHistoFile(n).getName() + "\"></td>\n");
        if (commandStatistics.m_statisticsFinal.getCount() > 0) {
            printStream.print("<td><small>Final</small><br><img src=\"" + this.getHistoFinalFile(n).getName() + "\"></td>");
        }
        printStream.print("</tr>\n</table>\n");
        for (int i = 0; i < this.m_maxMove; i += this.m_movePrintInterval) {
            Histogram histogram = commandStatistics.getStatistics((int)i).m_histogram;
            if (commandStatistics.getStatistics(i).getCount() == 0) continue;
            Table table = TableUtils.fromHistogram(histogram, string);
            File file2 = this.getHistoFile(n, i);
            Color color = this.getColor(string);
            Plot plot = new Plot(180, 135, color, this.m_precision);
            commandStatistics.setHistogramProperties(plot);
            plot.plot(file2, table, string, "Count", null);
            printStream.print("<table align=\"left\" border=\"0\"><tr><td align=\"center\"><small>" + i + "</small><br><img src=\"" + this.getHistoFile(n, i).getName() + "\"></td></tr></table>\n");
        }
        printStream.print("<br clear=\"left\">\n<hr>\n");
        this.writeGamePlots(printStream, n);
        this.finishHtml(printStream);
        printStream.close();
    }

    private void writeCommandStatistics(PrintStream printStream, int n) throws Exception {
        CommandStatistics commandStatistics = this.getCommandStatistics(n);
        String string = this.getCommand(n);
        PositionStatistics positionStatistics = commandStatistics.m_statisticsAll;
        PositionStatistics positionStatistics2 = commandStatistics.m_statisticsFinal;
        printStream.print("<table class=\"smalltable\">\n");
        printStream.print("<tr>");
        printStream.print("<th>Move</th>");
        this.writeStatisticsTableHeader(printStream);
        printStream.print("</tr>\n");
        DecimalFormat decimalFormat = commandStatistics.m_format;
        for (int i = 0; i < this.m_maxMove; i += this.m_movePrintInterval) {
            PositionStatistics positionStatistics3 = commandStatistics.getStatistics(i);
            printStream.print("<tr><td>" + i + "</td>");
            this.writeStatisticsTableData(printStream, positionStatistics3, decimalFormat, false);
            printStream.print("</tr>\n");
        }
        printStream.print("<tr style=\"font-weight:bold\"><td>Final</td>");
        this.writeStatisticsTableData(printStream, positionStatistics2, decimalFormat, false);
        printStream.print("</tr>\n");
        printStream.print("<tr style=\"font-weight:bold\"><td>All</td>");
        this.writeStatisticsTableData(printStream, positionStatistics, decimalFormat, !this.isGameGlobalCommand(string));
        printStream.print("</tr>\n");
        printStream.print("</table>\n");
    }

    private void writeCommandsTable(PrintStream printStream) throws Exception {
        printStream.print("<table class=\"smalltable\">\n<thead><tr><th>Command</th>");
        this.writeStatisticsTableHeader(printStream);
        printStream.print("</tr></thead>\n");
        for (int i = 0; i < this.m_commands.size(); ++i) {
            CommandStatistics commandStatistics = this.getCommandStatistics(i);
            int n = commandStatistics.getCount();
            if (n > 0 && !commandStatistics.m_isBeginCommand) {
                this.writeCommandPage(i);
            }
            PositionStatistics positionStatistics = commandStatistics.m_statisticsAll;
            printStream.print("<tr><td style=\"background-color:#b5c8f0\">" + this.getCommandLink(i) + "</td>");
            this.writeStatisticsTableData(printStream, positionStatistics, commandStatistics.m_format, !this.isGameGlobalCommand(this.getCommand(i)));
            printStream.print("</tr>\n");
        }
        printStream.print("</table>\n");
    }

    private void writeGamePage(String string, String string2, int n) throws Exception {
        int n2;
        String string3;
        String string4;
        Object object;
        Object object2;
        File file = this.getGameFile(n);
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        String string5 = "Game " + (n + 1) + " (" + string2 + ")";
        this.startHtml(printStream, string5);
        this.startInfo(printStream, string5);
        this.writeInfoBasics(printStream);
        this.writeHtmlRow(printStream, "Game Index", n);
        this.writeHtmlRow(printStream, "File", this.getGameLink(file, n, false));
        try {
            String string6;
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            object2 = new SgfReader(fileInputStream, string, null, 0L);
            object = ((SgfReader)object2).getGameTree().getGameInformation();
            string4 = ((GameInformation)object).m_playerBlack;
            if (string4 == null) {
                string4 = "?";
            }
            if ((string3 = ((GameInformation)object).m_playerWhite) == null) {
                string3 = "?";
            }
            if ((string6 = ((GameInformation)object).m_result) == null) {
                string6 = "?";
            }
            this.writeHtmlRow(printStream, "Black", string4);
            this.writeHtmlRow(printStream, "White", string3);
            this.writeHtmlRow(printStream, "Result", string6);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            StringUtils.printException(exception);
        }
        this.endInfo(printStream);
        printStream.print("<table border=\"0\">\n");
        for (int i = 0; i < this.m_commands.size(); ++i) {
            object2 = this.getCommandStatistics(i);
            if (((CommandStatistics)object2).getCount() <= 0 || ((CommandStatistics)object2).m_isBeginCommand) continue;
            this.generatePlot(i, ((CommandStatistics)object2).m_format, n, string);
            printStream.print("<tr><td align=\"center\">" + this.getCommandLink(i) + "<br><img src=\"" + this.getPlotFile(n, i).getName() + "\"></td></tr>\n");
        }
        printStream.print("</table>\n<hr>\n");
        Table table = TableUtils.select(this.m_table, "File", string);
        printStream.print("<table class=\"smalltable\">\n<thead><tr>");
        for (n2 = 1; n2 < table.getNumberColumns(); ++n2) {
            object = table.getColumnTitle(n2);
            if (TableUtils.allEmpty(table, (String)object)) continue;
            printStream.print("<th>" + (String)object + "</th>");
        }
        printStream.print("</tr></thead>\n");
        for (n2 = 0; n2 < table.getNumberRows(); ++n2) {
            printStream.print("<tr>");
            for (int i = 1; i < table.getNumberColumns(); ++i) {
                string4 = table.getColumnTitle(i);
                if (TableUtils.allEmpty(table, string4)) continue;
                string3 = table.get(string4, n2);
                if (string3 == null) {
                    string3 = "";
                }
                printStream.print("<td>" + string3 + "</td>");
            }
            printStream.print("</tr>\n");
        }
        printStream.print("</table>\n");
        this.finishHtml(printStream);
        printStream.close();
    }

    private void writeGamePlots(PrintStream printStream, int n) throws Exception {
        printStream.print("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
        for (int i = 0; i < this.m_gameInfo.size(); ++i) {
            String string = this.getPlotFile(i, n).getName();
            File file = this.getGameFile(i);
            printStream.print("<tr><td align=\"left\"><small><a href=\"" + file.getName() + "\">Game " + (i + 1) + "</a> (" + this.getGameLink(file, i, true) + "):</small><br>\n" + "<img src=\"" + string + "\"></td></tr>\n");
        }
        printStream.print("</table>\n");
    }

    private void writeGameTable(PrintStream printStream) throws Exception {
        int n;
        printStream.print("<table class=\"smalltable\">\n<thead><tr><th>Game</th><th>File</th><th>Positions</th>");
        for (n = 0; n < this.m_gameGlobalCommands.size(); ++n) {
            if (this.getGameGlobalCommand(n).allEmpty()) continue;
            printStream.print("<th>" + this.getGameGlobalCommand(n).m_name + "</th>");
        }
        printStream.print("</tr></thead>\n");
        for (n = 0; n < this.m_gameInfo.size(); ++n) {
            GameInfo gameInfo = (GameInfo)this.m_gameInfo.get(n);
            String string = this.getGameFile(n).getName();
            printStream.print("<tr><td style=\"background-color:#b5c8f0\"><a href=\"" + string + "\">Game " + (n + 1) + "</a></td><td>" + gameInfo.m_name + "</td><td>" + gameInfo.m_numberPositions + "</td>");
            for (int i = 0; i < this.m_gameGlobalCommands.size(); ++i) {
                if (this.getGameGlobalCommand(i).allEmpty()) continue;
                printStream.print("<td>" + this.getGameGlobalCommand(i).getResult(n) + "</td>");
            }
            printStream.print("</tr>\n");
            this.writeGamePage(gameInfo.m_file, gameInfo.m_name, n);
        }
        printStream.print("</table>\n");
    }

    private void writeHtmlRow(PrintStream printStream, String string, String string2) throws Exception {
        printStream.print("<tr><th align=\"left\">" + string + ":</th>" + "<td align=\"left\">" + string2 + "</td></tr>\n");
    }

    private void writeHtmlRow(PrintStream printStream, String string, int n) throws Exception {
        this.writeHtmlRow(printStream, string, Integer.toString(n));
    }

    private void writeInfoBasics(PrintStream printStream) throws Exception {
        this.writeTableProperty(printStream, "Name");
        this.writeTableProperty(printStream, "Version");
        this.writeTableProperty(printStream, "Date");
        this.writeTableProperty(printStream, "Host");
        this.writeTableProperty(printStream, "Program");
    }

    private void writeInfo(PrintStream printStream) throws Exception {
        this.writeInfoBasics(printStream);
        this.writeTableProperty(printStream, "Size");
        this.writeTableProperty(printStream, "Games");
        this.writeHtmlRow(printStream, "Positions", this.m_table.getNumberRows());
        this.writeTableProperty(printStream, "Backward");
    }

    private void writePlot(PrintStream printStream, String string, String string2, String string3) {
        printStream.print("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n<tr><td><table width=\"100%\" border=\"0\" cellpadding=\"0\" bgcolor=\"#b5c8f0\">\n<tr><td");
        if (!string3.equals("")) {
            printStream.print(" width=\"90%\"");
        }
        printStream.print(" align=\"center\">\n" + string + "\n" + "</td>");
        if (!string3.equals("")) {
            printStream.print("<td align=\"right\">\n" + string3 + "\n</td>");
        }
        printStream.print("</tr></table></td></tr>\n<tr><td bgcolor=\"#e0e0e0\">\n<img src=\"" + string2 + "\"></td></tr>\n" + "</table>\n");
    }

    private void writeStatisticsTableData(PrintStream printStream, PositionStatistics positionStatistics, DecimalFormat decimalFormat, boolean bl) {
        boolean bl2 = positionStatistics.getCount() == 0;
        boolean bl3 = positionStatistics.getCount() > 1;
        printStream.print("<td>");
        if (!bl2) {
            printStream.print(decimalFormat.format(positionStatistics.getMean()));
        }
        printStream.print("</td><td>");
        if (bl3) {
            printStream.print(decimalFormat.format(positionStatistics.getDeviation()));
        } else if (!bl2) {
            printStream.print("");
        }
        printStream.print("</td><td>");
        if (bl3) {
            printStream.print(decimalFormat.format(positionStatistics.getError()));
        } else if (!bl2) {
            printStream.print("");
        }
        printStream.print("</td><td>");
        if (bl3 && bl) {
            int n = this.m_table.getNumberRows() / this.m_gameInfo.size();
            printStream.print(decimalFormat.format(positionStatistics.getMaxError(n)));
        } else if (!bl2) {
            printStream.print("");
        }
        printStream.print("</td><td>");
        if (bl3) {
            printStream.print(decimalFormat.format(positionStatistics.getMin()));
        } else if (!bl2) {
            printStream.print("");
        }
        printStream.print("</td><td>");
        if (bl3) {
            printStream.print(decimalFormat.format(positionStatistics.getMax()));
        } else if (!bl2) {
            printStream.print("");
        }
        printStream.print("</td><td>");
        if (bl3) {
            printStream.print(decimalFormat.format(positionStatistics.getSum()));
        } else if (!bl2) {
            printStream.print("");
        }
        printStream.print("</td><td>");
        printStream.print(positionStatistics.getCount());
        printStream.print("</td><td>");
        printStream.print(positionStatistics.m_numberNoResult);
        printStream.print("</td>");
    }

    private void writeStatisticsTableHeader(PrintStream printStream) {
        printStream.print("<th>Mean</th><th>Deviation</th><th>Error</th><th>MaxError</th><th>Min</th><th>Max</th><th>Sum</th><th>Count</th><th>Unknown</th>");
    }

    private void writeTableProperty(PrintStream printStream, String string) throws Exception {
        this.writeHtmlRow(printStream, string, this.m_table.getProperty(string, "?"));
    }

    private static class GameInfo {
        public String m_file;
        public String m_name;
        public int m_finalPosition;
        public int m_numberPositions;

        private GameInfo() {
        }
    }

    private static class GameGlobalCommand {
        private boolean m_allEmpty;
        private final String m_name;
        private final ArrayList m_results;

        public GameGlobalCommand(String string, ArrayList arrayList) {
            this.m_name = string;
            this.m_results = arrayList;
            this.initAllEmpty();
        }

        public boolean allEmpty() {
            return this.m_allEmpty;
        }

        public String getName() {
            return this.m_name;
        }

        public String getResult(int n) {
            return (String)this.m_results.get(n);
        }

        private void initAllEmpty() {
            this.m_allEmpty = false;
            for (int i = 0; i < this.m_results.size(); ++i) {
                String string = this.getResult(i);
                if (string == null || string.trim().equals("")) continue;
                return;
            }
            this.m_allEmpty = true;
        }
    }
}

