/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.EchoStream;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Readtable;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class peek_char
extends Primitive {
    private static LispObject internalEOF = new LispObject();
    private static final Primitive PEEK_CHAR = new peek_char();

    private peek_char() {
        super("peek-char", "&optional peek-type input-stream eof-error-p eof-value recursive-p");
    }

    @Override
    public LispObject execute(LispObject[] args) {
        Symbol eofValue;
        Stream stream;
        int length = args.length;
        if (length > 5) {
            Lisp.error(new WrongNumberOfArgumentsException((Operator)this, -1, 5));
        }
        Symbol peekType = length > 0 ? args[0] : Lisp.NIL;
        Stream stream2 = stream = length > 1 ? Lisp.inSynonymOf(args[1]) : Lisp.getStandardInput();
        boolean eofError = length > 2 ? args[2] != Lisp.NIL : true;
        LispObject lispObject = eofValue = length > 3 ? args[3] : Lisp.NIL;
        if (peekType == Lisp.NIL) {
            Stream in = stream instanceof EchoStream ? ((EchoStream)stream).getInputStream() : stream;
            LispObject result = in.readChar(eofError, internalEOF);
            if (result == internalEOF) {
                return eofValue;
            }
            if (result instanceof LispCharacter) {
                in.unreadChar((LispCharacter)result);
            }
            return result;
        }
        if (peekType == Lisp.T) {
            LispObject result;
            block10: {
                char c;
                Readtable rt = Lisp.currentReadtable();
                do {
                    if ((result = stream.readChar(eofError, internalEOF)) == internalEOF) {
                        return eofValue;
                    }
                    if (!(result instanceof LispCharacter)) break block10;
                } while (rt.isWhitespace(c = ((LispCharacter)result).value));
                stream.unreadChar((LispCharacter)result);
                return result;
            }
            return result;
        }
        if (peekType instanceof LispCharacter) {
            LispObject result;
            block11: {
                char c = ((LispCharacter)((Object)peekType)).value;
                do {
                    if ((result = stream.readChar(eofError, internalEOF)) == internalEOF) {
                        return eofValue;
                    }
                    if (!(result instanceof LispCharacter)) break block11;
                } while (((LispCharacter)result).value != c);
                stream.unreadChar((LispCharacter)result);
                return result;
            }
            return result;
        }
        return Lisp.error(new SimpleError(String.valueOf(peekType) + " is an illegal peek-type."));
    }
}

