/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RangePtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.eval.ConcatEval;
import org.apache.poi.hssf.record.formula.eval.FunctionEval;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.PercentEval;
import org.apache.poi.hssf.record.formula.eval.RangeEval;
import org.apache.poi.hssf.record.formula.eval.RelationalOperationEval;
import org.apache.poi.hssf.record.formula.eval.TwoOperandNumericOperation;
import org.apache.poi.hssf.record.formula.eval.UnaryMinusEval;
import org.apache.poi.hssf.record.formula.eval.UnaryPlusEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.ss.formula.OperationEvaluationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OperationEvaluatorFactory {
    private static final Map<Class<? extends Ptg>, OperationEval> _instancesByPtgClass = OperationEvaluatorFactory.initialiseInstancesMap();

    private OperationEvaluatorFactory() {
    }

    private static Map<Class<? extends Ptg>, OperationEval> initialiseInstancesMap() {
        HashMap<Class<? extends Ptg>, OperationEval> m = new HashMap<Class<? extends Ptg>, OperationEval>(32);
        OperationEvaluatorFactory.put(m, 2, EqualPtg.class, RelationalOperationEval.EqualEval);
        OperationEvaluatorFactory.put(m, 2, GreaterEqualPtg.class, RelationalOperationEval.GreaterEqualEval);
        OperationEvaluatorFactory.put(m, 2, GreaterThanPtg.class, RelationalOperationEval.GreaterThanEval);
        OperationEvaluatorFactory.put(m, 2, LessEqualPtg.class, RelationalOperationEval.LessEqualEval);
        OperationEvaluatorFactory.put(m, 2, LessThanPtg.class, RelationalOperationEval.LessThanEval);
        OperationEvaluatorFactory.put(m, 2, NotEqualPtg.class, RelationalOperationEval.NotEqualEval);
        OperationEvaluatorFactory.put(m, 2, ConcatPtg.class, ConcatEval.instance);
        OperationEvaluatorFactory.put(m, 2, AddPtg.class, TwoOperandNumericOperation.AddEval);
        OperationEvaluatorFactory.put(m, 2, DividePtg.class, TwoOperandNumericOperation.DivideEval);
        OperationEvaluatorFactory.put(m, 2, MultiplyPtg.class, TwoOperandNumericOperation.MultiplyEval);
        OperationEvaluatorFactory.put(m, 1, PercentPtg.class, PercentEval.instance);
        OperationEvaluatorFactory.put(m, 2, PowerPtg.class, TwoOperandNumericOperation.PowerEval);
        OperationEvaluatorFactory.put(m, 2, SubtractPtg.class, TwoOperandNumericOperation.SubtractEval);
        OperationEvaluatorFactory.put(m, 1, UnaryMinusPtg.class, UnaryMinusEval.instance);
        OperationEvaluatorFactory.put(m, 1, UnaryPlusPtg.class, UnaryPlusEval.instance);
        OperationEvaluatorFactory.put(m, 2, RangePtg.class, RangeEval.instance);
        return m;
    }

    private static void put(Map<Class<? extends Ptg>, OperationEval> m, int argCount, Class<? extends Ptg> ptgClass, Function instance) {
        m.put(ptgClass, new OperationFunctionEval(instance, argCount));
    }

    public static OperationEval create(OperationPtg ptg) {
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        Class<?> ptgClass = ptg.getClass();
        OperationEval result = _instancesByPtgClass.get(ptgClass);
        if (result != null) {
            return result;
        }
        if (ptg instanceof AbstractFunctionPtg) {
            return new FunctionEval((AbstractFunctionPtg)ptg);
        }
        throw new RuntimeException("Unexpected operation ptg class (" + ptgClass.getName() + ")");
    }

    private static final class OperationFunctionEval
    implements OperationEval {
        private final Function _function;
        private final int _numberOfOperands;

        public OperationFunctionEval(Function function, int argCount) {
            this._function = function;
            this._numberOfOperands = argCount;
        }

        public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
            return this._function.evaluate(args, ec.getRowIndex(), (short)ec.getColumnIndex());
        }

        public int getNumberOfOperands() {
            return this._numberOfOperands;
        }
    }
}

