/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import java.util.ArrayList;
import net.sf.gogui.utils.StringUtils;

public final class GoPoint
implements Comparable {
    public static final int MAXSIZE = 25;
    public static final int DEFAULT_SIZE = 19;
    private static int s_size;
    private static GoPoint[][] s_points;
    private final int m_x;
    private final int m_y;
    private final String m_string;
    private static String[] s_xString;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int compareTo(Object object) {
        GoPoint goPoint = (GoPoint)object;
        if (this.m_y < goPoint.m_y) {
            return -1;
        }
        if (this.m_y > goPoint.m_y) {
            return 1;
        }
        if (!$assertionsDisabled && this.m_y != goPoint.m_y) {
            throw new AssertionError();
        }
        if (this.m_x < goPoint.m_x) {
            return -1;
        }
        if (this.m_x > goPoint.m_x) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static GoPoint get(int n, int n2) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= 25) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 >= 25) {
            throw new AssertionError();
        }
        int n3 = Math.max(n, n2);
        if (n3 >= s_size) {
            GoPoint.grow(n3 + 1);
        }
        GoPoint goPoint = s_points[n][n2];
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        return goPoint;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isOnBoard(int n) {
        return this.m_x < n && this.m_y < n;
    }

    public GoPoint down() {
        if (this.m_y > 0) {
            return GoPoint.get(this.m_x, this.m_y - 1);
        }
        return this;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public GoPoint left() {
        if (this.m_x > 0) {
            return GoPoint.get(this.m_x - 1, this.m_y);
        }
        return this;
    }

    public static GoPoint parsePoint(String string, int n) throws InvalidPoint {
        int n2;
        if ((string = string.trim().toUpperCase()).equals("PASS")) {
            return null;
        }
        if (string.length() < 2) {
            throw new InvalidPoint(string);
        }
        char c = string.charAt(0);
        if (c >= 'J') {
            c = (char)(c - '\u0001');
        }
        int n3 = c - 65;
        try {
            n2 = Integer.parseInt(string.substring(1)) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPoint(string);
        }
        if (n3 < 0 || n3 >= n || n2 < 0 || n2 >= n) {
            throw new InvalidPoint(string);
        }
        return GoPoint.get(n3, n2);
    }

    public static GoPoint[] parsePointList(String string, int n) throws InvalidPoint {
        ArrayList arrayList = GoPoint.parsePointListArrayList(string, n);
        GoPoint[] goPointArray = new GoPoint[arrayList.size()];
        for (int i = 0; i < goPointArray.length; ++i) {
            goPointArray[i] = (GoPoint)arrayList.get(i);
        }
        return goPointArray;
    }

    public static ArrayList parsePointListArrayList(String string, int n) throws InvalidPoint {
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>();
        String[] stringArray = StringUtils.splitArguments(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            arrayList.add(GoPoint.parsePoint(stringArray[i], n));
        }
        return arrayList;
    }

    public GoPoint right(int n) {
        if (this.m_x < n - 1) {
            return GoPoint.get(this.m_x + 1, this.m_y);
        }
        return this;
    }

    public String toString() {
        return this.m_string;
    }

    public static String toString(GoPoint goPoint) {
        if (goPoint == null) {
            return "PASS";
        }
        return goPoint.toString();
    }

    public static String toString(ArrayList arrayList) {
        if (arrayList == null) {
            return "(null)";
        }
        int n = arrayList.size();
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((GoPoint)arrayList.get(i)).toString());
            if (i >= n - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public GoPoint up(int n) {
        if (this.m_y < n - 1) {
            return GoPoint.get(this.m_x, this.m_y + 1);
        }
        return this;
    }

    private static void grow(int n) {
        if (!$assertionsDisabled && n <= s_size) {
            throw new AssertionError();
        }
        GoPoint[][] goPointArray = new GoPoint[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                goPointArray[i][j] = i < s_size && j < s_size ? s_points[i][j] : new GoPoint(i, j);
            }
        }
        s_points = goPointArray;
        s_size = n;
    }

    private GoPoint(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        this.m_string = s_xString[this.m_x] + Integer.toString(this.m_y + 1);
    }

    static {
        $assertionsDisabled = !GoPoint.class.desiredAssertionStatus();
        s_xString = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        if (!$assertionsDisabled && s_xString.length != 25) {
            throw new AssertionError();
        }
        s_size = 0;
        GoPoint.grow(19);
    }

    public static class InvalidPoint
    extends Exception {
        private static final long serialVersionUID = 0L;

        public InvalidPoint(String string) {
            super("Invalid point: " + string);
        }
    }
}

