/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SimpleFormDialog
extends JDialog {
    boolean canceled = false;
    public Map<String, JTextField> textComponents;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel panel1;
    private JLabel promptLabel;

    public SimpleFormDialog(Frame owner, String prompt, List<String> labels) {
        super(owner);
        this.initComponents();
        this.initContentPanel(labels);
        this.promptLabel.setText(prompt);
    }

    public SimpleFormDialog(Dialog owner, String prompt, List<String> labels) {
        super(owner);
        this.initComponents();
        this.initContentPanel(labels);
        this.promptLabel.setText(prompt);
    }

    private void initContentPanel(List<String> labels) {
        this.textComponents = new HashMap<String, JTextField>(labels.size());
        this.contentPanel.setLayout(new GridLayout(labels.size(), 2, 5, 5));
        int width = 0;
        int height = 0;
        for (String l : labels) {
            JTextField field = new JTextField();
            this.textComponents.put(l, field);
            JLabel jlabel = new JLabel(l);
            this.contentPanel.add(jlabel);
            this.contentPanel.add(field);
            Dimension d = jlabel.getPreferredSize();
            width = Math.max(width, (int)d.getWidth());
            double h2 = (int)field.getPreferredSize().getHeight();
            height += (int)Math.max(h2, d.getHeight()) + 5;
        }
        width = width * 2 + 20;
        this.contentPanel.setSize(width, height += 20);
        this.contentPanel.setPreferredSize(new Dimension(width, height));
        this.pack();
    }

    public String getValue(String label) {
        return this.textComponents.get(label).getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.canceled = false;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.panel1 = new JPanel();
        this.promptLabel = new JLabel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(null);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.contentPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleFormDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleFormDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.panel1.setBorder(new EmptyBorder(5, 0, 15, 5));
        this.panel1.setLayout(new BorderLayout());
        this.promptLabel.setFont(new Font("Lucida Grande", 1, 13));
        this.panel1.add((Component)this.promptLabel, "Center");
        this.dialogPane.add((Component)this.panel1, "North");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) {
        List<String> labels = Arrays.asList("The first field", "F2", "The third field");
        SimpleFormDialog dlg = new SimpleFormDialog((Frame)null, "Prompt", labels);
        dlg.setVisible(true);
    }
}

