/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.serialization.Serde;

public class Joined<K, V, VO> {
    private Serde<K> keySerde;
    private Serde<V> valueSerde;
    private Serde<VO> otherValueSerde;

    private Joined(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.otherValueSerde = otherValueSerde;
    }

    public static <K, V, VO> Joined<K, V, VO> with(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde) {
        return new Joined<K, V, VO>(keySerde, valueSerde, otherValueSerde);
    }

    public static <K, V, VO> Joined<K, V, VO> keySerde(Serde<K> keySerde) {
        return Joined.with(keySerde, null, null);
    }

    public static <K, V, VO> Joined<K, V, VO> valueSerde(Serde<V> valueSerde) {
        return Joined.with(null, valueSerde, null);
    }

    public static <K, V, VO> Joined<K, V, VO> otherValueSerde(Serde<VO> otherValueSerde) {
        return Joined.with(null, null, otherValueSerde);
    }

    public Joined<K, V, VO> withKeySerde(Serde<K> keySerde) {
        this.keySerde = keySerde;
        return this;
    }

    public Joined<K, V, VO> withValueSerde(Serde<V> valueSerde) {
        this.valueSerde = valueSerde;
        return this;
    }

    public Joined<K, V, VO> withOtherValueSerde(Serde<VO> otherValueSerde) {
        this.otherValueSerde = otherValueSerde;
        return this;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public Serde<VO> otherValueSerde() {
        return this.otherValueSerde;
    }
}

