/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ArticleId_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_ARTICLEID_BASE_HPP
#define OBJECTS_BIBLIO_ARTICLEID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/biblio/DOI.hpp>
#include <objects/biblio/MedlineUID.hpp>
#include <objects/biblio/PII.hpp>
#include <objects/biblio/PmPid.hpp>
#include <objects/biblio/PmcID.hpp>
#include <objects/biblio/PmcPid.hpp>
#include <objects/biblio/PubMedId.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Article Ids
/// can be many ids for an article
class NCBI_BIBLIO_EXPORT CArticleId_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CArticleId_Base(void);
    // destructor
    virtual ~CArticleId_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Pubmed,       ///< see types below
        e_Medline,
        e_Doi,
        e_Pii,
        e_Pmcid,
        e_Pmcpid,
        e_Pmpid,
        e_Other         ///< generic catch all
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 9 ///< == e_Other+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CPubMedId TPubmed;
    typedef CMedlineUID TMedline;
    typedef CDOI TDoi;
    typedef CPII TPii;
    typedef CPmcID TPmcid;
    typedef CPmcPid TPmcpid;
    typedef CPmPid TPmpid;
    typedef CDbtag TOther;

    // getters
    // setters

    // typedef CPubMedId TPubmed
    bool IsPubmed(void) const;
    const TPubmed& GetPubmed(void) const;
    TPubmed& SetPubmed(void);
    void SetPubmed(const TPubmed& value);

    // typedef CMedlineUID TMedline
    bool IsMedline(void) const;
    const TMedline& GetMedline(void) const;
    TMedline& SetMedline(void);
    void SetMedline(const TMedline& value);

    // typedef CDOI TDoi
    bool IsDoi(void) const;
    const TDoi& GetDoi(void) const;
    TDoi& SetDoi(void);
    void SetDoi(const TDoi& value);

    // typedef CPII TPii
    bool IsPii(void) const;
    const TPii& GetPii(void) const;
    TPii& SetPii(void);
    void SetPii(const TPii& value);

    // typedef CPmcID TPmcid
    bool IsPmcid(void) const;
    const TPmcid& GetPmcid(void) const;
    TPmcid& SetPmcid(void);
    void SetPmcid(const TPmcid& value);

    // typedef CPmcPid TPmcpid
    bool IsPmcpid(void) const;
    const TPmcpid& GetPmcpid(void) const;
    TPmcpid& SetPmcpid(void);
    void SetPmcpid(const TPmcpid& value);

    // typedef CPmPid TPmpid
    bool IsPmpid(void) const;
    const TPmpid& GetPmpid(void) const;
    TPmpid& SetPmpid(void);
    void SetPmpid(const TPmpid& value);

    // typedef CDbtag TOther
    bool IsOther(void) const;
    const TOther& GetOther(void) const;
    TOther& SetOther(void);
    void SetOther(TOther& value);


private:
    // copy constructor and assignment operator
    CArticleId_Base(const CArticleId_Base& );
    CArticleId_Base& operator=(const CArticleId_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TPubmed> m_Pubmed;
        NCBI_NS_NCBI::CUnionBuffer<TMedline> m_Medline;
        NCBI_NS_NCBI::CUnionBuffer<TDoi> m_Doi;
        NCBI_NS_NCBI::CUnionBuffer<TPii> m_Pii;
        NCBI_NS_NCBI::CUnionBuffer<TPmcid> m_Pmcid;
        NCBI_NS_NCBI::CUnionBuffer<TPmcpid> m_Pmcpid;
        NCBI_NS_NCBI::CUnionBuffer<TPmpid> m_Pmpid;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CArticleId_Base::E_Choice CArticleId_Base::Which(void) const
{
    return m_choice;
}

inline
void CArticleId_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CArticleId_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CArticleId_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CArticleId_Base::IsPubmed(void) const
{
    return m_choice == e_Pubmed;
}

inline
const CArticleId_Base::TPubmed& CArticleId_Base::GetPubmed(void) const
{
    CheckSelected(e_Pubmed);
    return *m_Pubmed;
}

inline
CArticleId_Base::TPubmed& CArticleId_Base::SetPubmed(void)
{
    Select(e_Pubmed, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pubmed;
}

inline
bool CArticleId_Base::IsMedline(void) const
{
    return m_choice == e_Medline;
}

inline
const CArticleId_Base::TMedline& CArticleId_Base::GetMedline(void) const
{
    CheckSelected(e_Medline);
    return *m_Medline;
}

inline
CArticleId_Base::TMedline& CArticleId_Base::SetMedline(void)
{
    Select(e_Medline, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Medline;
}

inline
bool CArticleId_Base::IsDoi(void) const
{
    return m_choice == e_Doi;
}

inline
const CArticleId_Base::TDoi& CArticleId_Base::GetDoi(void) const
{
    CheckSelected(e_Doi);
    return *m_Doi;
}

inline
CArticleId_Base::TDoi& CArticleId_Base::SetDoi(void)
{
    Select(e_Doi, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Doi;
}

inline
bool CArticleId_Base::IsPii(void) const
{
    return m_choice == e_Pii;
}

inline
const CArticleId_Base::TPii& CArticleId_Base::GetPii(void) const
{
    CheckSelected(e_Pii);
    return *m_Pii;
}

inline
CArticleId_Base::TPii& CArticleId_Base::SetPii(void)
{
    Select(e_Pii, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pii;
}

inline
bool CArticleId_Base::IsPmcid(void) const
{
    return m_choice == e_Pmcid;
}

inline
const CArticleId_Base::TPmcid& CArticleId_Base::GetPmcid(void) const
{
    CheckSelected(e_Pmcid);
    return *m_Pmcid;
}

inline
CArticleId_Base::TPmcid& CArticleId_Base::SetPmcid(void)
{
    Select(e_Pmcid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pmcid;
}

inline
bool CArticleId_Base::IsPmcpid(void) const
{
    return m_choice == e_Pmcpid;
}

inline
const CArticleId_Base::TPmcpid& CArticleId_Base::GetPmcpid(void) const
{
    CheckSelected(e_Pmcpid);
    return *m_Pmcpid;
}

inline
CArticleId_Base::TPmcpid& CArticleId_Base::SetPmcpid(void)
{
    Select(e_Pmcpid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pmcpid;
}

inline
bool CArticleId_Base::IsPmpid(void) const
{
    return m_choice == e_Pmpid;
}

inline
const CArticleId_Base::TPmpid& CArticleId_Base::GetPmpid(void) const
{
    CheckSelected(e_Pmpid);
    return *m_Pmpid;
}

inline
CArticleId_Base::TPmpid& CArticleId_Base::SetPmpid(void)
{
    Select(e_Pmpid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pmpid;
}

inline
bool CArticleId_Base::IsOther(void) const
{
    return m_choice == e_Other;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_ARTICLEID_BASE_HPP
