/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Imprint_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_IMPRINT_BASE_HPP
#define OBJECTS_BIBLIO_IMPRINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/biblio/PubStatus.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAffil;
class CCitRetract;
class CDate;
class CPubStatusDateSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Imprint group
class NCBI_BIBLIO_EXPORT CImprint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CImprint_Base(void);
    // destructor
    virtual ~CImprint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// for prepublication citations
    enum EPrepub {
        ePrepub_submitted =   1,  ///< submitted, not accepted
        ePrepub_in_press  =   2,  ///< accepted, not published
        ePrepub_other     = 255
    };
    
    /// Access to EPrepub's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EPrepub)(void);
    
    // types
    typedef CDate TDate;
    typedef string TVolume;
    typedef string TIssue;
    typedef string TPages;
    typedef string TSection;
    typedef CAffil TPub;
    typedef CDate TCprt;
    typedef string TPart_sup;
    typedef string TLanguage;
    typedef EPrepub TPrepub;
    typedef string TPart_supi;
    typedef CCitRetract TRetract;
    typedef int TPubstatus;
    typedef CPubStatusDateSet THistory;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_date,
        e_volume,
        e_issue,
        e_pages,
        e_section,
        e_pub,
        e_cprt,
        e_part_sup,
        e_language,
        e_prepub,
        e_part_supi,
        e_retract,
        e_pubstatus,
        e_history
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 15> TmemberIndex;

    // getters
    // setters

    /// date of publication
    /// mandatory
    /// typedef CDate TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(TDate& value);
    TDate& SetDate(void);

    /// optional
    /// typedef string TVolume
    ///  Check whether the Volume data member has been assigned a value.
    bool IsSetVolume(void) const;
    /// Check whether it is safe or not to call GetVolume method.
    bool CanGetVolume(void) const;
    void ResetVolume(void);
    const TVolume& GetVolume(void) const;
    void SetVolume(const TVolume& value);
    void SetVolume(TVolume&& value);
    TVolume& SetVolume(void);

    /// optional
    /// typedef string TIssue
    ///  Check whether the Issue data member has been assigned a value.
    bool IsSetIssue(void) const;
    /// Check whether it is safe or not to call GetIssue method.
    bool CanGetIssue(void) const;
    void ResetIssue(void);
    const TIssue& GetIssue(void) const;
    void SetIssue(const TIssue& value);
    void SetIssue(TIssue&& value);
    TIssue& SetIssue(void);

    /// optional
    /// typedef string TPages
    ///  Check whether the Pages data member has been assigned a value.
    bool IsSetPages(void) const;
    /// Check whether it is safe or not to call GetPages method.
    bool CanGetPages(void) const;
    void ResetPages(void);
    const TPages& GetPages(void) const;
    void SetPages(const TPages& value);
    void SetPages(TPages&& value);
    TPages& SetPages(void);

    /// optional
    /// typedef string TSection
    ///  Check whether the Section data member has been assigned a value.
    bool IsSetSection(void) const;
    /// Check whether it is safe or not to call GetSection method.
    bool CanGetSection(void) const;
    void ResetSection(void);
    const TSection& GetSection(void) const;
    void SetSection(const TSection& value);
    void SetSection(TSection&& value);
    TSection& SetSection(void);

    /// publisher, required for book
    /// optional
    /// typedef CAffil TPub
    ///  Check whether the Pub data member has been assigned a value.
    bool IsSetPub(void) const;
    /// Check whether it is safe or not to call GetPub method.
    bool CanGetPub(void) const;
    void ResetPub(void);
    const TPub& GetPub(void) const;
    void SetPub(TPub& value);
    TPub& SetPub(void);

    /// copyright date, "    "   "
    /// optional
    /// typedef CDate TCprt
    ///  Check whether the Cprt data member has been assigned a value.
    bool IsSetCprt(void) const;
    /// Check whether it is safe or not to call GetCprt method.
    bool CanGetCprt(void) const;
    void ResetCprt(void);
    const TCprt& GetCprt(void) const;
    void SetCprt(TCprt& value);
    TCprt& SetCprt(void);

    /// part/sup of volume
    /// optional
    /// typedef string TPart_sup
    ///  Check whether the Part_sup data member has been assigned a value.
    bool IsSetPart_sup(void) const;
    /// Check whether it is safe or not to call GetPart_sup method.
    bool CanGetPart_sup(void) const;
    void ResetPart_sup(void);
    const TPart_sup& GetPart_sup(void) const;
    void SetPart_sup(const TPart_sup& value);
    void SetPart_sup(TPart_sup&& value);
    TPart_sup& SetPart_sup(void);

    /// put here for simplicity
    /// optional with default "ENG"
    /// typedef string TLanguage
    ///  Check whether the Language data member has been assigned a value.
    bool IsSetLanguage(void) const;
    /// Check whether it is safe or not to call GetLanguage method.
    bool CanGetLanguage(void) const;
    void ResetLanguage(void);
    void SetDefaultLanguage(void);
    const TLanguage& GetLanguage(void) const;
    void SetLanguage(const TLanguage& value);
    void SetLanguage(TLanguage&& value);
    TLanguage& SetLanguage(void);

    /// optional
    /// typedef EPrepub TPrepub
    ///  Check whether the Prepub data member has been assigned a value.
    bool IsSetPrepub(void) const;
    /// Check whether it is safe or not to call GetPrepub method.
    bool CanGetPrepub(void) const;
    void ResetPrepub(void);
    TPrepub GetPrepub(void) const;
    void SetPrepub(TPrepub value);
    TPrepub& SetPrepub(void);

    /// part/sup on issue
    /// optional
    /// typedef string TPart_supi
    ///  Check whether the Part_supi data member has been assigned a value.
    bool IsSetPart_supi(void) const;
    /// Check whether it is safe or not to call GetPart_supi method.
    bool CanGetPart_supi(void) const;
    void ResetPart_supi(void);
    const TPart_supi& GetPart_supi(void) const;
    void SetPart_supi(const TPart_supi& value);
    void SetPart_supi(TPart_supi&& value);
    TPart_supi& SetPart_supi(void);

    /// retraction info
    /// optional
    /// typedef CCitRetract TRetract
    ///  Check whether the Retract data member has been assigned a value.
    bool IsSetRetract(void) const;
    /// Check whether it is safe or not to call GetRetract method.
    bool CanGetRetract(void) const;
    void ResetRetract(void);
    const TRetract& GetRetract(void) const;
    void SetRetract(TRetract& value);
    TRetract& SetRetract(void);

    /// current status of this publication
    /// optional
    /// typedef int TPubstatus
    ///  Check whether the Pubstatus data member has been assigned a value.
    bool IsSetPubstatus(void) const;
    /// Check whether it is safe or not to call GetPubstatus method.
    bool CanGetPubstatus(void) const;
    void ResetPubstatus(void);
    TPubstatus GetPubstatus(void) const;
    void SetPubstatus(TPubstatus value);
    TPubstatus& SetPubstatus(void);

    /// dates for this record
    /// optional
    /// typedef CPubStatusDateSet THistory
    ///  Check whether the History data member has been assigned a value.
    bool IsSetHistory(void) const;
    /// Check whether it is safe or not to call GetHistory method.
    bool CanGetHistory(void) const;
    void ResetHistory(void);
    const THistory& GetHistory(void) const;
    void SetHistory(THistory& value);
    THistory& SetHistory(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CImprint_Base(const CImprint_Base&);
    CImprint_Base& operator=(const CImprint_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDate > m_Date;
    string m_Volume;
    string m_Issue;
    string m_Pages;
    string m_Section;
    CRef< TPub > m_Pub;
    CRef< TCprt > m_Cprt;
    string m_Part_sup;
    string m_Language;
    EPrepub m_Prepub;
    string m_Part_supi;
    CRef< TRetract > m_Retract;
    int m_Pubstatus;
    CRef< THistory > m_History;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CImprint_Base::IsSetDate(void) const
{
    return m_Date.NotEmpty();
}

inline
bool CImprint_Base::CanGetDate(void) const
{
    return true;
}

inline
const CImprint_Base::TDate& CImprint_Base::GetDate(void) const
{
    if ( !m_Date ) {
        const_cast<CImprint_Base*>(this)->ResetDate();
    }
    return (*m_Date);
}

inline
CImprint_Base::TDate& CImprint_Base::SetDate(void)
{
    if ( !m_Date ) {
        ResetDate();
    }
    return (*m_Date);
}

inline
bool CImprint_Base::IsSetVolume(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CImprint_Base::CanGetVolume(void) const
{
    return IsSetVolume();
}

inline
const CImprint_Base::TVolume& CImprint_Base::GetVolume(void) const
{
    if (!CanGetVolume()) {
        ThrowUnassigned(1);
    }
    return m_Volume;
}

inline
void CImprint_Base::SetVolume(const CImprint_Base::TVolume& value)
{
    m_Volume = value;
    m_set_State[0] |= 0xc;
}

inline
void CImprint_Base::SetVolume(CImprint_Base::TVolume&& value)
{
    m_Volume = std::forward<CImprint_Base::TVolume>(value);
    m_set_State[0] |= 0xc;
}

inline
CImprint_Base::TVolume& CImprint_Base::SetVolume(void)
{
#ifdef _DEBUG
    if (!IsSetVolume()) {
        m_Volume = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Volume;
}

inline
bool CImprint_Base::IsSetIssue(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CImprint_Base::CanGetIssue(void) const
{
    return IsSetIssue();
}

inline
const CImprint_Base::TIssue& CImprint_Base::GetIssue(void) const
{
    if (!CanGetIssue()) {
        ThrowUnassigned(2);
    }
    return m_Issue;
}

inline
void CImprint_Base::SetIssue(const CImprint_Base::TIssue& value)
{
    m_Issue = value;
    m_set_State[0] |= 0x30;
}

inline
void CImprint_Base::SetIssue(CImprint_Base::TIssue&& value)
{
    m_Issue = std::forward<CImprint_Base::TIssue>(value);
    m_set_State[0] |= 0x30;
}

inline
CImprint_Base::TIssue& CImprint_Base::SetIssue(void)
{
#ifdef _DEBUG
    if (!IsSetIssue()) {
        m_Issue = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Issue;
}

inline
bool CImprint_Base::IsSetPages(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CImprint_Base::CanGetPages(void) const
{
    return IsSetPages();
}

inline
const CImprint_Base::TPages& CImprint_Base::GetPages(void) const
{
    if (!CanGetPages()) {
        ThrowUnassigned(3);
    }
    return m_Pages;
}

inline
void CImprint_Base::SetPages(const CImprint_Base::TPages& value)
{
    m_Pages = value;
    m_set_State[0] |= 0xc0;
}

inline
void CImprint_Base::SetPages(CImprint_Base::TPages&& value)
{
    m_Pages = std::forward<CImprint_Base::TPages>(value);
    m_set_State[0] |= 0xc0;
}

inline
CImprint_Base::TPages& CImprint_Base::SetPages(void)
{
#ifdef _DEBUG
    if (!IsSetPages()) {
        m_Pages = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Pages;
}

inline
bool CImprint_Base::IsSetSection(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CImprint_Base::CanGetSection(void) const
{
    return IsSetSection();
}

inline
const CImprint_Base::TSection& CImprint_Base::GetSection(void) const
{
    if (!CanGetSection()) {
        ThrowUnassigned(4);
    }
    return m_Section;
}

inline
void CImprint_Base::SetSection(const CImprint_Base::TSection& value)
{
    m_Section = value;
    m_set_State[0] |= 0x300;
}

inline
void CImprint_Base::SetSection(CImprint_Base::TSection&& value)
{
    m_Section = std::forward<CImprint_Base::TSection>(value);
    m_set_State[0] |= 0x300;
}

inline
CImprint_Base::TSection& CImprint_Base::SetSection(void)
{
#ifdef _DEBUG
    if (!IsSetSection()) {
        m_Section = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Section;
}

inline
bool CImprint_Base::IsSetPub(void) const
{
    return m_Pub.NotEmpty();
}

inline
bool CImprint_Base::CanGetPub(void) const
{
    return IsSetPub();
}

inline
const CImprint_Base::TPub& CImprint_Base::GetPub(void) const
{
    if (!CanGetPub()) {
        ThrowUnassigned(5);
    }
    return (*m_Pub);
}

inline
bool CImprint_Base::IsSetCprt(void) const
{
    return m_Cprt.NotEmpty();
}

inline
bool CImprint_Base::CanGetCprt(void) const
{
    return IsSetCprt();
}

inline
const CImprint_Base::TCprt& CImprint_Base::GetCprt(void) const
{
    if (!CanGetCprt()) {
        ThrowUnassigned(6);
    }
    return (*m_Cprt);
}

inline
bool CImprint_Base::IsSetPart_sup(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CImprint_Base::CanGetPart_sup(void) const
{
    return IsSetPart_sup();
}

inline
const CImprint_Base::TPart_sup& CImprint_Base::GetPart_sup(void) const
{
    if (!CanGetPart_sup()) {
        ThrowUnassigned(7);
    }
    return m_Part_sup;
}

inline
void CImprint_Base::SetPart_sup(const CImprint_Base::TPart_sup& value)
{
    m_Part_sup = value;
    m_set_State[0] |= 0xc000;
}

inline
void CImprint_Base::SetPart_sup(CImprint_Base::TPart_sup&& value)
{
    m_Part_sup = std::forward<CImprint_Base::TPart_sup>(value);
    m_set_State[0] |= 0xc000;
}

inline
CImprint_Base::TPart_sup& CImprint_Base::SetPart_sup(void)
{
#ifdef _DEBUG
    if (!IsSetPart_sup()) {
        m_Part_sup = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Part_sup;
}

inline
bool CImprint_Base::IsSetLanguage(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CImprint_Base::CanGetLanguage(void) const
{
    return true;
}

inline
void CImprint_Base::ResetLanguage(void)
{
    m_Language = "ENG";
    m_set_State[0] &= ~0x30000;
}

inline
void CImprint_Base::SetDefaultLanguage(void)
{
    ResetLanguage();
}

inline
const CImprint_Base::TLanguage& CImprint_Base::GetLanguage(void) const
{
    return m_Language;
}

inline
void CImprint_Base::SetLanguage(const CImprint_Base::TLanguage& value)
{
    m_Language = value;
    m_set_State[0] |= 0x30000;
}

inline
void CImprint_Base::SetLanguage(CImprint_Base::TLanguage&& value)
{
    m_Language = std::forward<CImprint_Base::TLanguage>(value);
    m_set_State[0] |= 0x30000;
}

inline
CImprint_Base::TLanguage& CImprint_Base::SetLanguage(void)
{
#ifdef _DEBUG
    if (!IsSetLanguage()) {
        m_Language = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Language;
}

inline
bool CImprint_Base::IsSetPrepub(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CImprint_Base::CanGetPrepub(void) const
{
    return IsSetPrepub();
}

inline
void CImprint_Base::ResetPrepub(void)
{
    m_Prepub = (EPrepub)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CImprint_Base::TPrepub CImprint_Base::GetPrepub(void) const
{
    if (!CanGetPrepub()) {
        ThrowUnassigned(9);
    }
    return m_Prepub;
}

inline
void CImprint_Base::SetPrepub(CImprint_Base::TPrepub value)
{
    m_Prepub = value;
    m_set_State[0] |= 0xc0000;
}

inline
CImprint_Base::TPrepub& CImprint_Base::SetPrepub(void)
{
#ifdef _DEBUG
    if (!IsSetPrepub()) {
        memset(&m_Prepub,UnassignedByte(),sizeof(m_Prepub));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Prepub;
}

inline
bool CImprint_Base::IsSetPart_supi(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CImprint_Base::CanGetPart_supi(void) const
{
    return IsSetPart_supi();
}

inline
const CImprint_Base::TPart_supi& CImprint_Base::GetPart_supi(void) const
{
    if (!CanGetPart_supi()) {
        ThrowUnassigned(10);
    }
    return m_Part_supi;
}

inline
void CImprint_Base::SetPart_supi(const CImprint_Base::TPart_supi& value)
{
    m_Part_supi = value;
    m_set_State[0] |= 0x300000;
}

inline
void CImprint_Base::SetPart_supi(CImprint_Base::TPart_supi&& value)
{
    m_Part_supi = std::forward<CImprint_Base::TPart_supi>(value);
    m_set_State[0] |= 0x300000;
}

inline
CImprint_Base::TPart_supi& CImprint_Base::SetPart_supi(void)
{
#ifdef _DEBUG
    if (!IsSetPart_supi()) {
        m_Part_supi = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Part_supi;
}

inline
bool CImprint_Base::IsSetRetract(void) const
{
    return m_Retract.NotEmpty();
}

inline
bool CImprint_Base::CanGetRetract(void) const
{
    return IsSetRetract();
}

inline
const CImprint_Base::TRetract& CImprint_Base::GetRetract(void) const
{
    if (!CanGetRetract()) {
        ThrowUnassigned(11);
    }
    return (*m_Retract);
}

inline
bool CImprint_Base::IsSetPubstatus(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CImprint_Base::CanGetPubstatus(void) const
{
    return IsSetPubstatus();
}

inline
void CImprint_Base::ResetPubstatus(void)
{
    m_Pubstatus = (int)(0);
    m_set_State[0] &= ~0x3000000;
}

inline
CImprint_Base::TPubstatus CImprint_Base::GetPubstatus(void) const
{
    if (!CanGetPubstatus()) {
        ThrowUnassigned(12);
    }
    return m_Pubstatus;
}

inline
void CImprint_Base::SetPubstatus(CImprint_Base::TPubstatus value)
{
    m_Pubstatus = value;
    m_set_State[0] |= 0x3000000;
}

inline
CImprint_Base::TPubstatus& CImprint_Base::SetPubstatus(void)
{
#ifdef _DEBUG
    if (!IsSetPubstatus()) {
        memset(&m_Pubstatus,UnassignedByte(),sizeof(m_Pubstatus));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Pubstatus;
}

inline
bool CImprint_Base::IsSetHistory(void) const
{
    return m_History.NotEmpty();
}

inline
bool CImprint_Base::CanGetHistory(void) const
{
    return IsSetHistory();
}

inline
const CImprint_Base::THistory& CImprint_Base::GetHistory(void) const
{
    if (!CanGetHistory()) {
        ThrowUnassigned(13);
    }
    return (*m_History);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_IMPRINT_BASE_HPP
