/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BioTreeContainer_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biotree.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIOTREE_BIOTREECONTAINER_BASE_HPP
#define OBJECTS_BIOTREE_BIOTREECONTAINER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFeatureDictSet;
class CNodeSet;
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BIOTREE_EXPORT CBioTreeContainer_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBioTreeContainer_Base(void);
    // destructor
    virtual ~CBioTreeContainer_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTreetype;
    typedef CFeatureDictSet TFdict;
    typedef CNodeSet TNodes;
    typedef string TLabel;
    typedef CUser_object TUser;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_treetype,
        e_fdict,
        e_nodes,
        e_label,
        e_user
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// hint on what kind of tree this is
    /// optional
    /// typedef string TTreetype
    ///  Check whether the Treetype data member has been assigned a value.
    bool IsSetTreetype(void) const;
    /// Check whether it is safe or not to call GetTreetype method.
    bool CanGetTreetype(void) const;
    void ResetTreetype(void);
    const TTreetype& GetTreetype(void) const;
    void SetTreetype(const TTreetype& value);
    void SetTreetype(TTreetype&& value);
    TTreetype& SetTreetype(void);

    /// features dictionary 
    /// mandatory
    /// typedef CFeatureDictSet TFdict
    ///  Check whether the Fdict data member has been assigned a value.
    bool IsSetFdict(void) const;
    /// Check whether it is safe or not to call GetFdict method.
    bool CanGetFdict(void) const;
    void ResetFdict(void);
    const TFdict& GetFdict(void) const;
    void SetFdict(TFdict& value);
    TFdict& SetFdict(void);

    /// set of nodes with encoded topology   
    /// mandatory
    /// typedef CNodeSet TNodes
    ///  Check whether the Nodes data member has been assigned a value.
    bool IsSetNodes(void) const;
    /// Check whether it is safe or not to call GetNodes method.
    bool CanGetNodes(void) const;
    void ResetNodes(void);
    const TNodes& GetNodes(void) const;
    void SetNodes(TNodes& value);
    TNodes& SetNodes(void);

    /// bio-tree label (short name)
    /// optional
    /// typedef string TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    void SetLabel(const TLabel& value);
    void SetLabel(TLabel&& value);
    TLabel& SetLabel(void);

    /// user defined object
    /// optional
    /// typedef CUser_object TUser
    ///  Check whether the User data member has been assigned a value.
    bool IsSetUser(void) const;
    /// Check whether it is safe or not to call GetUser method.
    bool CanGetUser(void) const;
    void ResetUser(void);
    const TUser& GetUser(void) const;
    void SetUser(TUser& value);
    TUser& SetUser(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBioTreeContainer_Base(const CBioTreeContainer_Base&);
    CBioTreeContainer_Base& operator=(const CBioTreeContainer_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Treetype;
    CRef< TFdict > m_Fdict;
    CRef< TNodes > m_Nodes;
    string m_Label;
    CRef< TUser > m_User;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBioTreeContainer_Base::IsSetTreetype(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBioTreeContainer_Base::CanGetTreetype(void) const
{
    return IsSetTreetype();
}

inline
const CBioTreeContainer_Base::TTreetype& CBioTreeContainer_Base::GetTreetype(void) const
{
    if (!CanGetTreetype()) {
        ThrowUnassigned(0);
    }
    return m_Treetype;
}

inline
void CBioTreeContainer_Base::SetTreetype(const CBioTreeContainer_Base::TTreetype& value)
{
    m_Treetype = value;
    m_set_State[0] |= 0x3;
}

inline
void CBioTreeContainer_Base::SetTreetype(CBioTreeContainer_Base::TTreetype&& value)
{
    m_Treetype = std::forward<CBioTreeContainer_Base::TTreetype>(value);
    m_set_State[0] |= 0x3;
}

inline
CBioTreeContainer_Base::TTreetype& CBioTreeContainer_Base::SetTreetype(void)
{
#ifdef _DEBUG
    if (!IsSetTreetype()) {
        m_Treetype = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Treetype;
}

inline
bool CBioTreeContainer_Base::IsSetFdict(void) const
{
    return m_Fdict.NotEmpty();
}

inline
bool CBioTreeContainer_Base::CanGetFdict(void) const
{
    return true;
}

inline
const CBioTreeContainer_Base::TFdict& CBioTreeContainer_Base::GetFdict(void) const
{
    if ( !m_Fdict ) {
        const_cast<CBioTreeContainer_Base*>(this)->ResetFdict();
    }
    return (*m_Fdict);
}

inline
CBioTreeContainer_Base::TFdict& CBioTreeContainer_Base::SetFdict(void)
{
    if ( !m_Fdict ) {
        ResetFdict();
    }
    return (*m_Fdict);
}

inline
bool CBioTreeContainer_Base::IsSetNodes(void) const
{
    return m_Nodes.NotEmpty();
}

inline
bool CBioTreeContainer_Base::CanGetNodes(void) const
{
    return true;
}

inline
const CBioTreeContainer_Base::TNodes& CBioTreeContainer_Base::GetNodes(void) const
{
    if ( !m_Nodes ) {
        const_cast<CBioTreeContainer_Base*>(this)->ResetNodes();
    }
    return (*m_Nodes);
}

inline
CBioTreeContainer_Base::TNodes& CBioTreeContainer_Base::SetNodes(void)
{
    if ( !m_Nodes ) {
        ResetNodes();
    }
    return (*m_Nodes);
}

inline
bool CBioTreeContainer_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBioTreeContainer_Base::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
const CBioTreeContainer_Base::TLabel& CBioTreeContainer_Base::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(3);
    }
    return m_Label;
}

inline
void CBioTreeContainer_Base::SetLabel(const CBioTreeContainer_Base::TLabel& value)
{
    m_Label = value;
    m_set_State[0] |= 0xc0;
}

inline
void CBioTreeContainer_Base::SetLabel(CBioTreeContainer_Base::TLabel&& value)
{
    m_Label = std::forward<CBioTreeContainer_Base::TLabel>(value);
    m_set_State[0] |= 0xc0;
}

inline
CBioTreeContainer_Base::TLabel& CBioTreeContainer_Base::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        m_Label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Label;
}

inline
bool CBioTreeContainer_Base::IsSetUser(void) const
{
    return m_User.NotEmpty();
}

inline
bool CBioTreeContainer_Base::CanGetUser(void) const
{
    return IsSetUser();
}

inline
const CBioTreeContainer_Base::TUser& CBioTreeContainer_Base::GetUser(void) const
{
    if (!CanGetUser()) {
        ThrowUnassigned(4);
    }
    return (*m_User);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIOTREE_BIOTREECONTAINER_BASE_HPP
