/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_archive_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_ARCHIVE_BASE_HPP
#define OBJECTS_BLAST_BLAST4_ARCHIVE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_error;
class CBlast4_get_search_results_reply;
class CBlast4_request;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// An archive format for results.  the results can be reformatted from
/// this format also.
class NCBI_BLAST_EXPORT CBlast4_archive_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_archive_Base(void);
    // destructor
    virtual ~CBlast4_archive_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBlast4_request TRequest;
    typedef CBlast4_get_search_results_reply TResults;
    typedef list< CRef< CBlast4_error > > TMessages;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_request,
        e_results,
        e_messages
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// Query and options
    /// mandatory
    /// typedef CBlast4_request TRequest
    ///  Check whether the Request data member has been assigned a value.
    bool IsSetRequest(void) const;
    /// Check whether it is safe or not to call GetRequest method.
    bool CanGetRequest(void) const;
    void ResetRequest(void);
    const TRequest& GetRequest(void) const;
    void SetRequest(TRequest& value);
    TRequest& SetRequest(void);

    /// Results of search
    /// mandatory
    /// typedef CBlast4_get_search_results_reply TResults
    ///  Check whether the Results data member has been assigned a value.
    bool IsSetResults(void) const;
    /// Check whether it is safe or not to call GetResults method.
    bool CanGetResults(void) const;
    void ResetResults(void);
    const TResults& GetResults(void) const;
    void SetResults(TResults& value);
    TResults& SetResults(void);

    /// optional
    /// typedef list< CRef< CBlast4_error > > TMessages
    ///  Check whether the Messages data member has been assigned a value.
    bool IsSetMessages(void) const;
    /// Check whether it is safe or not to call GetMessages method.
    bool CanGetMessages(void) const;
    void ResetMessages(void);
    const TMessages& GetMessages(void) const;
    TMessages& SetMessages(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_archive_Base(const CBlast4_archive_Base&);
    CBlast4_archive_Base& operator=(const CBlast4_archive_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TRequest > m_Request;
    CRef< TResults > m_Results;
    list< CRef< CBlast4_error > > m_Messages;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_archive_Base::IsSetRequest(void) const
{
    return m_Request.NotEmpty();
}

inline
bool CBlast4_archive_Base::CanGetRequest(void) const
{
    return true;
}

inline
const CBlast4_archive_Base::TRequest& CBlast4_archive_Base::GetRequest(void) const
{
    if ( !m_Request ) {
        const_cast<CBlast4_archive_Base*>(this)->ResetRequest();
    }
    return (*m_Request);
}

inline
CBlast4_archive_Base::TRequest& CBlast4_archive_Base::SetRequest(void)
{
    if ( !m_Request ) {
        ResetRequest();
    }
    return (*m_Request);
}

inline
bool CBlast4_archive_Base::IsSetResults(void) const
{
    return m_Results.NotEmpty();
}

inline
bool CBlast4_archive_Base::CanGetResults(void) const
{
    return true;
}

inline
const CBlast4_archive_Base::TResults& CBlast4_archive_Base::GetResults(void) const
{
    if ( !m_Results ) {
        const_cast<CBlast4_archive_Base*>(this)->ResetResults();
    }
    return (*m_Results);
}

inline
CBlast4_archive_Base::TResults& CBlast4_archive_Base::SetResults(void)
{
    if ( !m_Results ) {
        ResetResults();
    }
    return (*m_Results);
}

inline
bool CBlast4_archive_Base::IsSetMessages(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast4_archive_Base::CanGetMessages(void) const
{
    return true;
}

inline
const CBlast4_archive_Base::TMessages& CBlast4_archive_Base::GetMessages(void) const
{
    return m_Messages;
}

inline
CBlast4_archive_Base::TMessages& CBlast4_archive_Base::SetMessages(void)
{
    m_set_State[0] |= 0x10;
    return m_Messages;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_ARCHIVE_BASE_HPP
