/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_ka_block_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_KA_BLOCK_BASE_HPP
#define OBJECTS_BLAST_BLAST4_KA_BLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_ka_block_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_ka_block_Base(void);
    // destructor
    virtual ~CBlast4_ka_block_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef double TLambda;
    typedef double TK;
    typedef double TH;
    typedef bool TGapped;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_lambda,
        e_k,
        e_h,
        e_gapped
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef double TLambda
    ///  Check whether the Lambda data member has been assigned a value.
    bool IsSetLambda(void) const;
    /// Check whether it is safe or not to call GetLambda method.
    bool CanGetLambda(void) const;
    void ResetLambda(void);
    TLambda GetLambda(void) const;
    void SetLambda(TLambda value);
    TLambda& SetLambda(void);

    /// mandatory
    /// typedef double TK
    ///  Check whether the K data member has been assigned a value.
    bool IsSetK(void) const;
    /// Check whether it is safe or not to call GetK method.
    bool CanGetK(void) const;
    void ResetK(void);
    TK GetK(void) const;
    void SetK(TK value);
    TK& SetK(void);

    /// mandatory
    /// typedef double TH
    ///  Check whether the H data member has been assigned a value.
    bool IsSetH(void) const;
    /// Check whether it is safe or not to call GetH method.
    bool CanGetH(void) const;
    void ResetH(void);
    TH GetH(void) const;
    void SetH(TH value);
    TH& SetH(void);

    /// mandatory
    /// typedef bool TGapped
    ///  Check whether the Gapped data member has been assigned a value.
    bool IsSetGapped(void) const;
    /// Check whether it is safe or not to call GetGapped method.
    bool CanGetGapped(void) const;
    void ResetGapped(void);
    TGapped GetGapped(void) const;
    void SetGapped(TGapped value);
    TGapped& SetGapped(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_ka_block_Base(const CBlast4_ka_block_Base&);
    CBlast4_ka_block_Base& operator=(const CBlast4_ka_block_Base&);

    // data
    Uint4 m_set_State[1];
    double m_Lambda;
    double m_K;
    double m_H;
    bool m_Gapped;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_ka_block_Base::IsSetLambda(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_ka_block_Base::CanGetLambda(void) const
{
    return IsSetLambda();
}

inline
void CBlast4_ka_block_Base::ResetLambda(void)
{
    m_Lambda = 0;
    m_set_State[0] &= ~0x3;
}

inline
CBlast4_ka_block_Base::TLambda CBlast4_ka_block_Base::GetLambda(void) const
{
    if (!CanGetLambda()) {
        ThrowUnassigned(0);
    }
    return m_Lambda;
}

inline
void CBlast4_ka_block_Base::SetLambda(CBlast4_ka_block_Base::TLambda value)
{
    m_Lambda = value;
    m_set_State[0] |= 0x3;
}

inline
CBlast4_ka_block_Base::TLambda& CBlast4_ka_block_Base::SetLambda(void)
{
#ifdef _DEBUG
    if (!IsSetLambda()) {
        memset(&m_Lambda,UnassignedByte(),sizeof(m_Lambda));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Lambda;
}

inline
bool CBlast4_ka_block_Base::IsSetK(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_ka_block_Base::CanGetK(void) const
{
    return IsSetK();
}

inline
void CBlast4_ka_block_Base::ResetK(void)
{
    m_K = 0;
    m_set_State[0] &= ~0xc;
}

inline
CBlast4_ka_block_Base::TK CBlast4_ka_block_Base::GetK(void) const
{
    if (!CanGetK()) {
        ThrowUnassigned(1);
    }
    return m_K;
}

inline
void CBlast4_ka_block_Base::SetK(CBlast4_ka_block_Base::TK value)
{
    m_K = value;
    m_set_State[0] |= 0xc;
}

inline
CBlast4_ka_block_Base::TK& CBlast4_ka_block_Base::SetK(void)
{
#ifdef _DEBUG
    if (!IsSetK()) {
        memset(&m_K,UnassignedByte(),sizeof(m_K));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_K;
}

inline
bool CBlast4_ka_block_Base::IsSetH(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast4_ka_block_Base::CanGetH(void) const
{
    return IsSetH();
}

inline
void CBlast4_ka_block_Base::ResetH(void)
{
    m_H = 0;
    m_set_State[0] &= ~0x30;
}

inline
CBlast4_ka_block_Base::TH CBlast4_ka_block_Base::GetH(void) const
{
    if (!CanGetH()) {
        ThrowUnassigned(2);
    }
    return m_H;
}

inline
void CBlast4_ka_block_Base::SetH(CBlast4_ka_block_Base::TH value)
{
    m_H = value;
    m_set_State[0] |= 0x30;
}

inline
CBlast4_ka_block_Base::TH& CBlast4_ka_block_Base::SetH(void)
{
#ifdef _DEBUG
    if (!IsSetH()) {
        memset(&m_H,UnassignedByte(),sizeof(m_H));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_H;
}

inline
bool CBlast4_ka_block_Base::IsSetGapped(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBlast4_ka_block_Base::CanGetGapped(void) const
{
    return IsSetGapped();
}

inline
void CBlast4_ka_block_Base::ResetGapped(void)
{
    m_Gapped = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CBlast4_ka_block_Base::TGapped CBlast4_ka_block_Base::GetGapped(void) const
{
    if (!CanGetGapped()) {
        ThrowUnassigned(3);
    }
    return m_Gapped;
}

inline
void CBlast4_ka_block_Base::SetGapped(CBlast4_ka_block_Base::TGapped value)
{
    m_Gapped = value;
    m_set_State[0] |= 0xc0;
}

inline
CBlast4_ka_block_Base::TGapped& CBlast4_ka_block_Base::SetGapped(void)
{
#ifdef _DEBUG
    if (!IsSetGapped()) {
        memset(&m_Gapped,UnassignedByte(),sizeof(m_Gapped));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Gapped;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_KA_BLOCK_BASE_HPP
