/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_matrix_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_MATRIX_ID_BASE_HPP
#define OBJECTS_BLAST_BLAST4_MATRIX_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/blast/Blast4_residue_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_matrix_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_matrix_id_Base(void);
    // destructor
    virtual ~CBlast4_matrix_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EBlast4_residue_type TResidue_type;
    typedef string TName;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_residue_type,
        e_name
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EBlast4_residue_type TResidue_type
    ///  Check whether the Residue_type data member has been assigned a value.
    bool IsSetResidue_type(void) const;
    /// Check whether it is safe or not to call GetResidue_type method.
    bool CanGetResidue_type(void) const;
    void ResetResidue_type(void);
    TResidue_type GetResidue_type(void) const;
    void SetResidue_type(TResidue_type value);
    TResidue_type& SetResidue_type(void);

    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_matrix_id_Base(const CBlast4_matrix_id_Base&);
    CBlast4_matrix_id_Base& operator=(const CBlast4_matrix_id_Base&);

    // data
    Uint4 m_set_State[1];
    EBlast4_residue_type m_Residue_type;
    string m_Name;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_matrix_id_Base::IsSetResidue_type(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_matrix_id_Base::CanGetResidue_type(void) const
{
    return IsSetResidue_type();
}

inline
void CBlast4_matrix_id_Base::ResetResidue_type(void)
{
    m_Residue_type = (ncbi::objects::EBlast4_residue_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CBlast4_matrix_id_Base::TResidue_type CBlast4_matrix_id_Base::GetResidue_type(void) const
{
    if (!CanGetResidue_type()) {
        ThrowUnassigned(0);
    }
    return m_Residue_type;
}

inline
void CBlast4_matrix_id_Base::SetResidue_type(CBlast4_matrix_id_Base::TResidue_type value)
{
    m_Residue_type = value;
    m_set_State[0] |= 0x3;
}

inline
CBlast4_matrix_id_Base::TResidue_type& CBlast4_matrix_id_Base::SetResidue_type(void)
{
#ifdef _DEBUG
    if (!IsSetResidue_type()) {
        memset(&m_Residue_type,UnassignedByte(),sizeof(m_Residue_type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Residue_type;
}

inline
bool CBlast4_matrix_id_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_matrix_id_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CBlast4_matrix_id_Base::TName& CBlast4_matrix_id_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CBlast4_matrix_id_Base::SetName(const CBlast4_matrix_id_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CBlast4_matrix_id_Base::SetName(CBlast4_matrix_id_Base::TName&& value)
{
    m_Name = std::forward<CBlast4_matrix_id_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CBlast4_matrix_id_Base::TName& CBlast4_matrix_id_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_MATRIX_ID_BASE_HPP
