/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_simple_alignment_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_SIMPLE_ALIGNMENT_BASE_HPP
#define OBJECTS_BLAST_BLAST4_SIMPLE_ALIGNMENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_range;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A single alignment
class NCBI_BLAST_EXPORT CBlast4_simple_alignment_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_simple_alignment_Base(void);
    // destructor
    virtual ~CBlast4_simple_alignment_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TSubject_id;
    typedef double TE_value;
    typedef double TBit_score;
    typedef int TNum_identities;
    typedef int TNum_indels;
    typedef CBlast4_range TFull_query_range;
    typedef CBlast4_range TFull_subject_range;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_subject_id,
        e_e_value,
        e_bit_score,
        e_num_identities,
        e_num_indels,
        e_full_query_range,
        e_full_subject_range
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// Subject sequence identifier
    /// (normally a GI from the SeqAlign)
    /// mandatory
    /// typedef string TSubject_id
    ///  Check whether the Subject_id data member has been assigned a value.
    bool IsSetSubject_id(void) const;
    /// Check whether it is safe or not to call GetSubject_id method.
    bool CanGetSubject_id(void) const;
    void ResetSubject_id(void);
    const TSubject_id& GetSubject_id(void) const;
    void SetSubject_id(const TSubject_id& value);
    void SetSubject_id(TSubject_id&& value);
    TSubject_id& SetSubject_id(void);

    /// E-Value
    /// mandatory
    /// typedef double TE_value
    ///  Check whether the E_value data member has been assigned a value.
    bool IsSetE_value(void) const;
    /// Check whether it is safe or not to call GetE_value method.
    bool CanGetE_value(void) const;
    void ResetE_value(void);
    TE_value GetE_value(void) const;
    void SetE_value(TE_value value);
    TE_value& SetE_value(void);

    /// Bit score
    /// mandatory
    /// typedef double TBit_score
    ///  Check whether the Bit_score data member has been assigned a value.
    bool IsSetBit_score(void) const;
    /// Check whether it is safe or not to call GetBit_score method.
    bool CanGetBit_score(void) const;
    void ResetBit_score(void);
    TBit_score GetBit_score(void) const;
    void SetBit_score(TBit_score value);
    TBit_score& SetBit_score(void);

    /// Number of identities
    /// optional
    /// typedef int TNum_identities
    ///  Check whether the Num_identities data member has been assigned a value.
    bool IsSetNum_identities(void) const;
    /// Check whether it is safe or not to call GetNum_identities method.
    bool CanGetNum_identities(void) const;
    void ResetNum_identities(void);
    TNum_identities GetNum_identities(void) const;
    void SetNum_identities(TNum_identities value);
    TNum_identities& SetNum_identities(void);

    /// Number of insertions/deletions
    /// optional
    /// typedef int TNum_indels
    ///  Check whether the Num_indels data member has been assigned a value.
    bool IsSetNum_indels(void) const;
    /// Check whether it is safe or not to call GetNum_indels method.
    bool CanGetNum_indels(void) const;
    void ResetNum_indels(void);
    TNum_indels GetNum_indels(void) const;
    void SetNum_indels(TNum_indels value);
    TNum_indels& SetNum_indels(void);

    /// Full query range covered by this HSP
    /// mandatory
    /// typedef CBlast4_range TFull_query_range
    ///  Check whether the Full_query_range data member has been assigned a value.
    bool IsSetFull_query_range(void) const;
    /// Check whether it is safe or not to call GetFull_query_range method.
    bool CanGetFull_query_range(void) const;
    void ResetFull_query_range(void);
    const TFull_query_range& GetFull_query_range(void) const;
    void SetFull_query_range(TFull_query_range& value);
    TFull_query_range& SetFull_query_range(void);

    /// Full subject range covered by this HSP
    /// mandatory
    /// typedef CBlast4_range TFull_subject_range
    ///  Check whether the Full_subject_range data member has been assigned a value.
    bool IsSetFull_subject_range(void) const;
    /// Check whether it is safe or not to call GetFull_subject_range method.
    bool CanGetFull_subject_range(void) const;
    void ResetFull_subject_range(void);
    const TFull_subject_range& GetFull_subject_range(void) const;
    void SetFull_subject_range(TFull_subject_range& value);
    TFull_subject_range& SetFull_subject_range(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_simple_alignment_Base(const CBlast4_simple_alignment_Base&);
    CBlast4_simple_alignment_Base& operator=(const CBlast4_simple_alignment_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Subject_id;
    double m_E_value;
    double m_Bit_score;
    int m_Num_identities;
    int m_Num_indels;
    CRef< TFull_query_range > m_Full_query_range;
    CRef< TFull_subject_range > m_Full_subject_range;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_simple_alignment_Base::IsSetSubject_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_simple_alignment_Base::CanGetSubject_id(void) const
{
    return IsSetSubject_id();
}

inline
const CBlast4_simple_alignment_Base::TSubject_id& CBlast4_simple_alignment_Base::GetSubject_id(void) const
{
    if (!CanGetSubject_id()) {
        ThrowUnassigned(0);
    }
    return m_Subject_id;
}

inline
void CBlast4_simple_alignment_Base::SetSubject_id(const CBlast4_simple_alignment_Base::TSubject_id& value)
{
    m_Subject_id = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast4_simple_alignment_Base::SetSubject_id(CBlast4_simple_alignment_Base::TSubject_id&& value)
{
    m_Subject_id = std::forward<CBlast4_simple_alignment_Base::TSubject_id>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast4_simple_alignment_Base::TSubject_id& CBlast4_simple_alignment_Base::SetSubject_id(void)
{
#ifdef _DEBUG
    if (!IsSetSubject_id()) {
        m_Subject_id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Subject_id;
}

inline
bool CBlast4_simple_alignment_Base::IsSetE_value(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_simple_alignment_Base::CanGetE_value(void) const
{
    return IsSetE_value();
}

inline
void CBlast4_simple_alignment_Base::ResetE_value(void)
{
    m_E_value = 0;
    m_set_State[0] &= ~0xc;
}

inline
CBlast4_simple_alignment_Base::TE_value CBlast4_simple_alignment_Base::GetE_value(void) const
{
    if (!CanGetE_value()) {
        ThrowUnassigned(1);
    }
    return m_E_value;
}

inline
void CBlast4_simple_alignment_Base::SetE_value(CBlast4_simple_alignment_Base::TE_value value)
{
    m_E_value = value;
    m_set_State[0] |= 0xc;
}

inline
CBlast4_simple_alignment_Base::TE_value& CBlast4_simple_alignment_Base::SetE_value(void)
{
#ifdef _DEBUG
    if (!IsSetE_value()) {
        memset(&m_E_value,UnassignedByte(),sizeof(m_E_value));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_E_value;
}

inline
bool CBlast4_simple_alignment_Base::IsSetBit_score(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast4_simple_alignment_Base::CanGetBit_score(void) const
{
    return IsSetBit_score();
}

inline
void CBlast4_simple_alignment_Base::ResetBit_score(void)
{
    m_Bit_score = 0;
    m_set_State[0] &= ~0x30;
}

inline
CBlast4_simple_alignment_Base::TBit_score CBlast4_simple_alignment_Base::GetBit_score(void) const
{
    if (!CanGetBit_score()) {
        ThrowUnassigned(2);
    }
    return m_Bit_score;
}

inline
void CBlast4_simple_alignment_Base::SetBit_score(CBlast4_simple_alignment_Base::TBit_score value)
{
    m_Bit_score = value;
    m_set_State[0] |= 0x30;
}

inline
CBlast4_simple_alignment_Base::TBit_score& CBlast4_simple_alignment_Base::SetBit_score(void)
{
#ifdef _DEBUG
    if (!IsSetBit_score()) {
        memset(&m_Bit_score,UnassignedByte(),sizeof(m_Bit_score));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Bit_score;
}

inline
bool CBlast4_simple_alignment_Base::IsSetNum_identities(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBlast4_simple_alignment_Base::CanGetNum_identities(void) const
{
    return IsSetNum_identities();
}

inline
void CBlast4_simple_alignment_Base::ResetNum_identities(void)
{
    m_Num_identities = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CBlast4_simple_alignment_Base::TNum_identities CBlast4_simple_alignment_Base::GetNum_identities(void) const
{
    if (!CanGetNum_identities()) {
        ThrowUnassigned(3);
    }
    return m_Num_identities;
}

inline
void CBlast4_simple_alignment_Base::SetNum_identities(CBlast4_simple_alignment_Base::TNum_identities value)
{
    m_Num_identities = value;
    m_set_State[0] |= 0xc0;
}

inline
CBlast4_simple_alignment_Base::TNum_identities& CBlast4_simple_alignment_Base::SetNum_identities(void)
{
#ifdef _DEBUG
    if (!IsSetNum_identities()) {
        memset(&m_Num_identities,UnassignedByte(),sizeof(m_Num_identities));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Num_identities;
}

inline
bool CBlast4_simple_alignment_Base::IsSetNum_indels(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBlast4_simple_alignment_Base::CanGetNum_indels(void) const
{
    return IsSetNum_indels();
}

inline
void CBlast4_simple_alignment_Base::ResetNum_indels(void)
{
    m_Num_indels = 0;
    m_set_State[0] &= ~0x300;
}

inline
CBlast4_simple_alignment_Base::TNum_indels CBlast4_simple_alignment_Base::GetNum_indels(void) const
{
    if (!CanGetNum_indels()) {
        ThrowUnassigned(4);
    }
    return m_Num_indels;
}

inline
void CBlast4_simple_alignment_Base::SetNum_indels(CBlast4_simple_alignment_Base::TNum_indels value)
{
    m_Num_indels = value;
    m_set_State[0] |= 0x300;
}

inline
CBlast4_simple_alignment_Base::TNum_indels& CBlast4_simple_alignment_Base::SetNum_indels(void)
{
#ifdef _DEBUG
    if (!IsSetNum_indels()) {
        memset(&m_Num_indels,UnassignedByte(),sizeof(m_Num_indels));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Num_indels;
}

inline
bool CBlast4_simple_alignment_Base::IsSetFull_query_range(void) const
{
    return m_Full_query_range.NotEmpty();
}

inline
bool CBlast4_simple_alignment_Base::CanGetFull_query_range(void) const
{
    return true;
}

inline
const CBlast4_simple_alignment_Base::TFull_query_range& CBlast4_simple_alignment_Base::GetFull_query_range(void) const
{
    if ( !m_Full_query_range ) {
        const_cast<CBlast4_simple_alignment_Base*>(this)->ResetFull_query_range();
    }
    return (*m_Full_query_range);
}

inline
CBlast4_simple_alignment_Base::TFull_query_range& CBlast4_simple_alignment_Base::SetFull_query_range(void)
{
    if ( !m_Full_query_range ) {
        ResetFull_query_range();
    }
    return (*m_Full_query_range);
}

inline
bool CBlast4_simple_alignment_Base::IsSetFull_subject_range(void) const
{
    return m_Full_subject_range.NotEmpty();
}

inline
bool CBlast4_simple_alignment_Base::CanGetFull_subject_range(void) const
{
    return true;
}

inline
const CBlast4_simple_alignment_Base::TFull_subject_range& CBlast4_simple_alignment_Base::GetFull_subject_range(void) const
{
    if ( !m_Full_subject_range ) {
        const_cast<CBlast4_simple_alignment_Base*>(this)->ResetFull_subject_range();
    }
    return (*m_Full_subject_range);
}

inline
CBlast4_simple_alignment_Base::TFull_subject_range& CBlast4_simple_alignment_Base::SetFull_subject_range(void)
{
    if ( !m_Full_subject_range ) {
        ResetFull_subject_range();
    }
    return (*m_Full_subject_range);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_SIMPLE_ALIGNMENT_BASE_HPP
