/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_simple_results_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_SIMPLE_RESULTS_BASE_HPP
#define OBJECTS_BLAST_BLAST4_SIMPLE_RESULTS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_alignments_for_query;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Complete set of simple Blast results
class NCBI_BLAST_EXPORT CBlast4_simple_results_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_simple_results_Base(void);
    // destructor
    virtual ~CBlast4_simple_results_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBlast4_alignments_for_query C_E;
    typedef list< CRef< CBlast4_alignments_for_query > > TAll_alignments;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_all_alignments
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< CBlast4_alignments_for_query > > TAll_alignments
    ///  Check whether the All_alignments data member has been assigned a value.
    bool IsSetAll_alignments(void) const;
    /// Check whether it is safe or not to call GetAll_alignments method.
    bool CanGetAll_alignments(void) const;
    void ResetAll_alignments(void);
    const TAll_alignments& GetAll_alignments(void) const;
    TAll_alignments& SetAll_alignments(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_simple_results_Base(const CBlast4_simple_results_Base&);
    CBlast4_simple_results_Base& operator=(const CBlast4_simple_results_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CBlast4_alignments_for_query > > m_All_alignments;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_simple_results_Base::IsSetAll_alignments(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_simple_results_Base::CanGetAll_alignments(void) const
{
    return true;
}

inline
const CBlast4_simple_results_Base::TAll_alignments& CBlast4_simple_results_Base::GetAll_alignments(void) const
{
    return m_All_alignments;
}

inline
CBlast4_simple_results_Base::TAll_alignments& CBlast4_simple_results_Base::SetAll_alignments(void)
{
    m_set_State[0] |= 0x1;
    return m_All_alignments;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_SIMPLE_RESULTS_BASE_HPP
