/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast_db_metadata_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastdb.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTDB_BLAST_DB_METADATA_BASE_HPP
#define OBJECTS_BLASTDB_BLAST_DB_METADATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTDB_EXPORT CBlast_db_metadata_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast_db_metadata_Base(void);
    // destructor
    virtual ~CBlast_db_metadata_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TVersion;
    typedef string TDbname;
    typedef string TDbtype;
    typedef int TDb_version;
    typedef string TDescription;
    typedef Uint8 TNumber_of_letters;
    typedef Int8 TNumber_of_sequences;
    typedef string TLast_updated;
    typedef int TNumber_of_volumes;
    typedef int TNumber_of_taxids;
    typedef Uint8 TBytes_total;
    typedef Uint8 TBytes_to_cache;
    typedef Uint8 TBytes_total_compressed;
    typedef vector< string > TFiles;
    typedef vector< string > TCompressed_files;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_version,
        e_dbname,
        e_dbtype,
        e_db_version,
        e_description,
        e_number_of_letters,
        e_number_of_sequences,
        e_last_updated,
        e_number_of_volumes,
        e_number_of_taxids,
        e_bytes_total,
        e_bytes_to_cache,
        e_bytes_total_compressed,
        e_files,
        e_compressed_files
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 16> TmemberIndex;

    // getters
    // setters

    /// Default indicates the starting version
    /// optional with default "1.2"
    /// typedef string TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    void SetDefaultVersion(void);
    const TVersion& GetVersion(void) const;
    void SetVersion(const TVersion& value);
    void SetVersion(TVersion&& value);
    TVersion& SetVersion(void);

    /// mandatory
    /// typedef string TDbname
    ///  Check whether the Dbname data member has been assigned a value.
    bool IsSetDbname(void) const;
    /// Check whether it is safe or not to call GetDbname method.
    bool CanGetDbname(void) const;
    void ResetDbname(void);
    const TDbname& GetDbname(void) const;
    void SetDbname(const TDbname& value);
    void SetDbname(TDbname&& value);
    TDbname& SetDbname(void);

    /// mandatory
    /// typedef string TDbtype
    ///  Check whether the Dbtype data member has been assigned a value.
    bool IsSetDbtype(void) const;
    /// Check whether it is safe or not to call GetDbtype method.
    bool CanGetDbtype(void) const;
    void ResetDbtype(void);
    const TDbtype& GetDbtype(void) const;
    void SetDbtype(const TDbtype& value);
    void SetDbtype(TDbtype&& value);
    TDbtype& SetDbtype(void);

    /// Default indicates the starting version
    /// optional with default 5
    /// typedef int TDb_version
    ///  Check whether the Db_version data member has been assigned a value.
    bool IsSetDb_version(void) const;
    /// Check whether it is safe or not to call GetDb_version method.
    bool CanGetDb_version(void) const;
    void ResetDb_version(void);
    void SetDefaultDb_version(void);
    TDb_version GetDb_version(void) const;
    void SetDb_version(TDb_version value);
    TDb_version& SetDb_version(void);

    /// optional
    /// typedef string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// mandatory
    /// typedef Uint8 TNumber_of_letters
    ///  Check whether the Number_of_letters data member has been assigned a value.
    bool IsSetNumber_of_letters(void) const;
    /// Check whether it is safe or not to call GetNumber_of_letters method.
    bool CanGetNumber_of_letters(void) const;
    void ResetNumber_of_letters(void);
    TNumber_of_letters GetNumber_of_letters(void) const;
    void SetNumber_of_letters(TNumber_of_letters value);
    TNumber_of_letters& SetNumber_of_letters(void);

    /// mandatory
    /// typedef Int8 TNumber_of_sequences
    ///  Check whether the Number_of_sequences data member has been assigned a value.
    bool IsSetNumber_of_sequences(void) const;
    /// Check whether it is safe or not to call GetNumber_of_sequences method.
    bool CanGetNumber_of_sequences(void) const;
    void ResetNumber_of_sequences(void);
    TNumber_of_sequences GetNumber_of_sequences(void) const;
    void SetNumber_of_sequences(TNumber_of_sequences value);
    TNumber_of_sequences& SetNumber_of_sequences(void);

    /// mandatory
    /// typedef string TLast_updated
    ///  Check whether the Last_updated data member has been assigned a value.
    bool IsSetLast_updated(void) const;
    /// Check whether it is safe or not to call GetLast_updated method.
    bool CanGetLast_updated(void) const;
    void ResetLast_updated(void);
    const TLast_updated& GetLast_updated(void) const;
    void SetLast_updated(const TLast_updated& value);
    void SetLast_updated(TLast_updated&& value);
    TLast_updated& SetLast_updated(void);

    /// mandatory
    /// typedef int TNumber_of_volumes
    ///  Check whether the Number_of_volumes data member has been assigned a value.
    bool IsSetNumber_of_volumes(void) const;
    /// Check whether it is safe or not to call GetNumber_of_volumes method.
    bool CanGetNumber_of_volumes(void) const;
    void ResetNumber_of_volumes(void);
    TNumber_of_volumes GetNumber_of_volumes(void) const;
    void SetNumber_of_volumes(TNumber_of_volumes value);
    TNumber_of_volumes& SetNumber_of_volumes(void);

    /// optional
    /// typedef int TNumber_of_taxids
    ///  Check whether the Number_of_taxids data member has been assigned a value.
    bool IsSetNumber_of_taxids(void) const;
    /// Check whether it is safe or not to call GetNumber_of_taxids method.
    bool CanGetNumber_of_taxids(void) const;
    void ResetNumber_of_taxids(void);
    TNumber_of_taxids GetNumber_of_taxids(void) const;
    void SetNumber_of_taxids(TNumber_of_taxids value);
    TNumber_of_taxids& SetNumber_of_taxids(void);

    /// mandatory
    /// typedef Uint8 TBytes_total
    ///  Check whether the Bytes_total data member has been assigned a value.
    bool IsSetBytes_total(void) const;
    /// Check whether it is safe or not to call GetBytes_total method.
    bool CanGetBytes_total(void) const;
    void ResetBytes_total(void);
    TBytes_total GetBytes_total(void) const;
    void SetBytes_total(TBytes_total value);
    TBytes_total& SetBytes_total(void);

    /// mandatory
    /// typedef Uint8 TBytes_to_cache
    ///  Check whether the Bytes_to_cache data member has been assigned a value.
    bool IsSetBytes_to_cache(void) const;
    /// Check whether it is safe or not to call GetBytes_to_cache method.
    bool CanGetBytes_to_cache(void) const;
    void ResetBytes_to_cache(void);
    TBytes_to_cache GetBytes_to_cache(void) const;
    void SetBytes_to_cache(TBytes_to_cache value);
    TBytes_to_cache& SetBytes_to_cache(void);

    /// optional
    /// typedef Uint8 TBytes_total_compressed
    ///  Check whether the Bytes_total_compressed data member has been assigned a value.
    bool IsSetBytes_total_compressed(void) const;
    /// Check whether it is safe or not to call GetBytes_total_compressed method.
    bool CanGetBytes_total_compressed(void) const;
    void ResetBytes_total_compressed(void);
    TBytes_total_compressed GetBytes_total_compressed(void) const;
    void SetBytes_total_compressed(TBytes_total_compressed value);
    TBytes_total_compressed& SetBytes_total_compressed(void);

    /// optional
    /// typedef vector< string > TFiles
    ///  Check whether the Files data member has been assigned a value.
    bool IsSetFiles(void) const;
    /// Check whether it is safe or not to call GetFiles method.
    bool CanGetFiles(void) const;
    void ResetFiles(void);
    const TFiles& GetFiles(void) const;
    TFiles& SetFiles(void);

    /// optional
    /// typedef vector< string > TCompressed_files
    ///  Check whether the Compressed_files data member has been assigned a value.
    bool IsSetCompressed_files(void) const;
    /// Check whether it is safe or not to call GetCompressed_files method.
    bool CanGetCompressed_files(void) const;
    void ResetCompressed_files(void);
    const TCompressed_files& GetCompressed_files(void) const;
    TCompressed_files& SetCompressed_files(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast_db_metadata_Base(const CBlast_db_metadata_Base&);
    CBlast_db_metadata_Base& operator=(const CBlast_db_metadata_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Version;
    string m_Dbname;
    string m_Dbtype;
    int m_Db_version;
    string m_Description;
    Uint8 m_Number_of_letters;
    Int8 m_Number_of_sequences;
    string m_Last_updated;
    int m_Number_of_volumes;
    int m_Number_of_taxids;
    Uint8 m_Bytes_total;
    Uint8 m_Bytes_to_cache;
    Uint8 m_Bytes_total_compressed;
    vector< string > m_Files;
    vector< string > m_Compressed_files;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast_db_metadata_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetVersion(void) const
{
    return true;
}

inline
void CBlast_db_metadata_Base::ResetVersion(void)
{
    m_Version = "1.2";
    m_set_State[0] &= ~0x3;
}

inline
void CBlast_db_metadata_Base::SetDefaultVersion(void)
{
    ResetVersion();
}

inline
const CBlast_db_metadata_Base::TVersion& CBlast_db_metadata_Base::GetVersion(void) const
{
    return m_Version;
}

inline
void CBlast_db_metadata_Base::SetVersion(const CBlast_db_metadata_Base::TVersion& value)
{
    m_Version = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast_db_metadata_Base::SetVersion(CBlast_db_metadata_Base::TVersion&& value)
{
    m_Version = std::forward<CBlast_db_metadata_Base::TVersion>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast_db_metadata_Base::TVersion& CBlast_db_metadata_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        m_Version = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Version;
}

inline
bool CBlast_db_metadata_Base::IsSetDbname(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetDbname(void) const
{
    return IsSetDbname();
}

inline
const CBlast_db_metadata_Base::TDbname& CBlast_db_metadata_Base::GetDbname(void) const
{
    if (!CanGetDbname()) {
        ThrowUnassigned(1);
    }
    return m_Dbname;
}

inline
void CBlast_db_metadata_Base::SetDbname(const CBlast_db_metadata_Base::TDbname& value)
{
    m_Dbname = value;
    m_set_State[0] |= 0xc;
}

inline
void CBlast_db_metadata_Base::SetDbname(CBlast_db_metadata_Base::TDbname&& value)
{
    m_Dbname = std::forward<CBlast_db_metadata_Base::TDbname>(value);
    m_set_State[0] |= 0xc;
}

inline
CBlast_db_metadata_Base::TDbname& CBlast_db_metadata_Base::SetDbname(void)
{
#ifdef _DEBUG
    if (!IsSetDbname()) {
        m_Dbname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Dbname;
}

inline
bool CBlast_db_metadata_Base::IsSetDbtype(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetDbtype(void) const
{
    return IsSetDbtype();
}

inline
const CBlast_db_metadata_Base::TDbtype& CBlast_db_metadata_Base::GetDbtype(void) const
{
    if (!CanGetDbtype()) {
        ThrowUnassigned(2);
    }
    return m_Dbtype;
}

inline
void CBlast_db_metadata_Base::SetDbtype(const CBlast_db_metadata_Base::TDbtype& value)
{
    m_Dbtype = value;
    m_set_State[0] |= 0x30;
}

inline
void CBlast_db_metadata_Base::SetDbtype(CBlast_db_metadata_Base::TDbtype&& value)
{
    m_Dbtype = std::forward<CBlast_db_metadata_Base::TDbtype>(value);
    m_set_State[0] |= 0x30;
}

inline
CBlast_db_metadata_Base::TDbtype& CBlast_db_metadata_Base::SetDbtype(void)
{
#ifdef _DEBUG
    if (!IsSetDbtype()) {
        m_Dbtype = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Dbtype;
}

inline
bool CBlast_db_metadata_Base::IsSetDb_version(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetDb_version(void) const
{
    return true;
}

inline
void CBlast_db_metadata_Base::ResetDb_version(void)
{
    m_Db_version = 5;
    m_set_State[0] &= ~0xc0;
}

inline
void CBlast_db_metadata_Base::SetDefaultDb_version(void)
{
    ResetDb_version();
}

inline
CBlast_db_metadata_Base::TDb_version CBlast_db_metadata_Base::GetDb_version(void) const
{
    return m_Db_version;
}

inline
void CBlast_db_metadata_Base::SetDb_version(CBlast_db_metadata_Base::TDb_version value)
{
    m_Db_version = value;
    m_set_State[0] |= 0xc0;
}

inline
CBlast_db_metadata_Base::TDb_version& CBlast_db_metadata_Base::SetDb_version(void)
{
#ifdef _DEBUG
    if (!IsSetDb_version()) {
        memset(&m_Db_version,UnassignedByte(),sizeof(m_Db_version));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Db_version;
}

inline
bool CBlast_db_metadata_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CBlast_db_metadata_Base::TDescription& CBlast_db_metadata_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(4);
    }
    return m_Description;
}

inline
void CBlast_db_metadata_Base::SetDescription(const CBlast_db_metadata_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0x300;
}

inline
void CBlast_db_metadata_Base::SetDescription(CBlast_db_metadata_Base::TDescription&& value)
{
    m_Description = std::forward<CBlast_db_metadata_Base::TDescription>(value);
    m_set_State[0] |= 0x300;
}

inline
CBlast_db_metadata_Base::TDescription& CBlast_db_metadata_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Description;
}

inline
bool CBlast_db_metadata_Base::IsSetNumber_of_letters(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetNumber_of_letters(void) const
{
    return IsSetNumber_of_letters();
}

inline
void CBlast_db_metadata_Base::ResetNumber_of_letters(void)
{
    m_Number_of_letters = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CBlast_db_metadata_Base::TNumber_of_letters CBlast_db_metadata_Base::GetNumber_of_letters(void) const
{
    if (!CanGetNumber_of_letters()) {
        ThrowUnassigned(5);
    }
    return m_Number_of_letters;
}

inline
void CBlast_db_metadata_Base::SetNumber_of_letters(CBlast_db_metadata_Base::TNumber_of_letters value)
{
    m_Number_of_letters = value;
    m_set_State[0] |= 0xc00;
}

inline
CBlast_db_metadata_Base::TNumber_of_letters& CBlast_db_metadata_Base::SetNumber_of_letters(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_letters()) {
        memset(&m_Number_of_letters,UnassignedByte(),sizeof(m_Number_of_letters));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Number_of_letters;
}

inline
bool CBlast_db_metadata_Base::IsSetNumber_of_sequences(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetNumber_of_sequences(void) const
{
    return IsSetNumber_of_sequences();
}

inline
void CBlast_db_metadata_Base::ResetNumber_of_sequences(void)
{
    m_Number_of_sequences = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CBlast_db_metadata_Base::TNumber_of_sequences CBlast_db_metadata_Base::GetNumber_of_sequences(void) const
{
    if (!CanGetNumber_of_sequences()) {
        ThrowUnassigned(6);
    }
    return m_Number_of_sequences;
}

inline
void CBlast_db_metadata_Base::SetNumber_of_sequences(CBlast_db_metadata_Base::TNumber_of_sequences value)
{
    m_Number_of_sequences = value;
    m_set_State[0] |= 0x3000;
}

inline
CBlast_db_metadata_Base::TNumber_of_sequences& CBlast_db_metadata_Base::SetNumber_of_sequences(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_sequences()) {
        memset(&m_Number_of_sequences,UnassignedByte(),sizeof(m_Number_of_sequences));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Number_of_sequences;
}

inline
bool CBlast_db_metadata_Base::IsSetLast_updated(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetLast_updated(void) const
{
    return IsSetLast_updated();
}

inline
const CBlast_db_metadata_Base::TLast_updated& CBlast_db_metadata_Base::GetLast_updated(void) const
{
    if (!CanGetLast_updated()) {
        ThrowUnassigned(7);
    }
    return m_Last_updated;
}

inline
void CBlast_db_metadata_Base::SetLast_updated(const CBlast_db_metadata_Base::TLast_updated& value)
{
    m_Last_updated = value;
    m_set_State[0] |= 0xc000;
}

inline
void CBlast_db_metadata_Base::SetLast_updated(CBlast_db_metadata_Base::TLast_updated&& value)
{
    m_Last_updated = std::forward<CBlast_db_metadata_Base::TLast_updated>(value);
    m_set_State[0] |= 0xc000;
}

inline
CBlast_db_metadata_Base::TLast_updated& CBlast_db_metadata_Base::SetLast_updated(void)
{
#ifdef _DEBUG
    if (!IsSetLast_updated()) {
        m_Last_updated = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Last_updated;
}

inline
bool CBlast_db_metadata_Base::IsSetNumber_of_volumes(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetNumber_of_volumes(void) const
{
    return IsSetNumber_of_volumes();
}

inline
void CBlast_db_metadata_Base::ResetNumber_of_volumes(void)
{
    m_Number_of_volumes = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CBlast_db_metadata_Base::TNumber_of_volumes CBlast_db_metadata_Base::GetNumber_of_volumes(void) const
{
    if (!CanGetNumber_of_volumes()) {
        ThrowUnassigned(8);
    }
    return m_Number_of_volumes;
}

inline
void CBlast_db_metadata_Base::SetNumber_of_volumes(CBlast_db_metadata_Base::TNumber_of_volumes value)
{
    m_Number_of_volumes = value;
    m_set_State[0] |= 0x30000;
}

inline
CBlast_db_metadata_Base::TNumber_of_volumes& CBlast_db_metadata_Base::SetNumber_of_volumes(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_volumes()) {
        memset(&m_Number_of_volumes,UnassignedByte(),sizeof(m_Number_of_volumes));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Number_of_volumes;
}

inline
bool CBlast_db_metadata_Base::IsSetNumber_of_taxids(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetNumber_of_taxids(void) const
{
    return IsSetNumber_of_taxids();
}

inline
void CBlast_db_metadata_Base::ResetNumber_of_taxids(void)
{
    m_Number_of_taxids = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CBlast_db_metadata_Base::TNumber_of_taxids CBlast_db_metadata_Base::GetNumber_of_taxids(void) const
{
    if (!CanGetNumber_of_taxids()) {
        ThrowUnassigned(9);
    }
    return m_Number_of_taxids;
}

inline
void CBlast_db_metadata_Base::SetNumber_of_taxids(CBlast_db_metadata_Base::TNumber_of_taxids value)
{
    m_Number_of_taxids = value;
    m_set_State[0] |= 0xc0000;
}

inline
CBlast_db_metadata_Base::TNumber_of_taxids& CBlast_db_metadata_Base::SetNumber_of_taxids(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_taxids()) {
        memset(&m_Number_of_taxids,UnassignedByte(),sizeof(m_Number_of_taxids));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Number_of_taxids;
}

inline
bool CBlast_db_metadata_Base::IsSetBytes_total(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetBytes_total(void) const
{
    return IsSetBytes_total();
}

inline
void CBlast_db_metadata_Base::ResetBytes_total(void)
{
    m_Bytes_total = 0;
    m_set_State[0] &= ~0x300000;
}

inline
CBlast_db_metadata_Base::TBytes_total CBlast_db_metadata_Base::GetBytes_total(void) const
{
    if (!CanGetBytes_total()) {
        ThrowUnassigned(10);
    }
    return m_Bytes_total;
}

inline
void CBlast_db_metadata_Base::SetBytes_total(CBlast_db_metadata_Base::TBytes_total value)
{
    m_Bytes_total = value;
    m_set_State[0] |= 0x300000;
}

inline
CBlast_db_metadata_Base::TBytes_total& CBlast_db_metadata_Base::SetBytes_total(void)
{
#ifdef _DEBUG
    if (!IsSetBytes_total()) {
        memset(&m_Bytes_total,UnassignedByte(),sizeof(m_Bytes_total));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Bytes_total;
}

inline
bool CBlast_db_metadata_Base::IsSetBytes_to_cache(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetBytes_to_cache(void) const
{
    return IsSetBytes_to_cache();
}

inline
void CBlast_db_metadata_Base::ResetBytes_to_cache(void)
{
    m_Bytes_to_cache = 0;
    m_set_State[0] &= ~0xc00000;
}

inline
CBlast_db_metadata_Base::TBytes_to_cache CBlast_db_metadata_Base::GetBytes_to_cache(void) const
{
    if (!CanGetBytes_to_cache()) {
        ThrowUnassigned(11);
    }
    return m_Bytes_to_cache;
}

inline
void CBlast_db_metadata_Base::SetBytes_to_cache(CBlast_db_metadata_Base::TBytes_to_cache value)
{
    m_Bytes_to_cache = value;
    m_set_State[0] |= 0xc00000;
}

inline
CBlast_db_metadata_Base::TBytes_to_cache& CBlast_db_metadata_Base::SetBytes_to_cache(void)
{
#ifdef _DEBUG
    if (!IsSetBytes_to_cache()) {
        memset(&m_Bytes_to_cache,UnassignedByte(),sizeof(m_Bytes_to_cache));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Bytes_to_cache;
}

inline
bool CBlast_db_metadata_Base::IsSetBytes_total_compressed(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetBytes_total_compressed(void) const
{
    return IsSetBytes_total_compressed();
}

inline
void CBlast_db_metadata_Base::ResetBytes_total_compressed(void)
{
    m_Bytes_total_compressed = 0;
    m_set_State[0] &= ~0x3000000;
}

inline
CBlast_db_metadata_Base::TBytes_total_compressed CBlast_db_metadata_Base::GetBytes_total_compressed(void) const
{
    if (!CanGetBytes_total_compressed()) {
        ThrowUnassigned(12);
    }
    return m_Bytes_total_compressed;
}

inline
void CBlast_db_metadata_Base::SetBytes_total_compressed(CBlast_db_metadata_Base::TBytes_total_compressed value)
{
    m_Bytes_total_compressed = value;
    m_set_State[0] |= 0x3000000;
}

inline
CBlast_db_metadata_Base::TBytes_total_compressed& CBlast_db_metadata_Base::SetBytes_total_compressed(void)
{
#ifdef _DEBUG
    if (!IsSetBytes_total_compressed()) {
        memset(&m_Bytes_total_compressed,UnassignedByte(),sizeof(m_Bytes_total_compressed));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Bytes_total_compressed;
}

inline
bool CBlast_db_metadata_Base::IsSetFiles(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetFiles(void) const
{
    return true;
}

inline
const CBlast_db_metadata_Base::TFiles& CBlast_db_metadata_Base::GetFiles(void) const
{
    return m_Files;
}

inline
CBlast_db_metadata_Base::TFiles& CBlast_db_metadata_Base::SetFiles(void)
{
    m_set_State[0] |= 0x4000000;
    return m_Files;
}

inline
bool CBlast_db_metadata_Base::IsSetCompressed_files(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CBlast_db_metadata_Base::CanGetCompressed_files(void) const
{
    return true;
}

inline
const CBlast_db_metadata_Base::TCompressed_files& CBlast_db_metadata_Base::GetCompressed_files(void) const
{
    return m_Compressed_files;
}

inline
CBlast_db_metadata_Base::TCompressed_files& CBlast_db_metadata_Base::SetCompressed_files(void)
{
    m_set_State[0] |= 0x10000000;
    return m_Compressed_files;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTDB_BLAST_DB_METADATA_BASE_HPP
