/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Parameters_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML_PARAMETERS_BASE_HPP
#define OBJECTS_BLASTXML_PARAMETERS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTXML_EXPORT CParameters_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CParameters_Base(void);
    // destructor
    virtual ~CParameters_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TMatrix;
    typedef double TExpect;
    typedef double TInclude;
    typedef int TSc_match;
    typedef int TSc_mismatch;
    typedef int TGap_open;
    typedef int TGap_extend;
    typedef string TFilter;
    typedef string TPattern;
    typedef string TEntrez_query;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_matrix,
        e_expect,
        e_include,
        e_sc_match,
        e_sc_mismatch,
        e_gap_open,
        e_gap_extend,
        e_filter,
        e_pattern,
        e_entrez_query
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// Matrix used (-M)
    /// optional
    /// typedef string TMatrix
    ///  Check whether the Matrix data member has been assigned a value.
    bool IsSetMatrix(void) const;
    /// Check whether it is safe or not to call GetMatrix method.
    bool CanGetMatrix(void) const;
    void ResetMatrix(void);
    const TMatrix& GetMatrix(void) const;
    void SetMatrix(const TMatrix& value);
    void SetMatrix(TMatrix&& value);
    TMatrix& SetMatrix(void);

    /// Expectation threshold (-e)
    /// mandatory
    /// typedef double TExpect
    ///  Check whether the Expect data member has been assigned a value.
    bool IsSetExpect(void) const;
    /// Check whether it is safe or not to call GetExpect method.
    bool CanGetExpect(void) const;
    void ResetExpect(void);
    TExpect GetExpect(void) const;
    void SetExpect(TExpect value);
    TExpect& SetExpect(void);

    /// Inclusion threshold (-h)
    /// optional
    /// typedef double TInclude
    ///  Check whether the Include data member has been assigned a value.
    bool IsSetInclude(void) const;
    /// Check whether it is safe or not to call GetInclude method.
    bool CanGetInclude(void) const;
    void ResetInclude(void);
    TInclude GetInclude(void) const;
    void SetInclude(TInclude value);
    TInclude& SetInclude(void);

    /// match score for NT (-r)
    /// optional
    /// typedef int TSc_match
    ///  Check whether the Sc_match data member has been assigned a value.
    bool IsSetSc_match(void) const;
    /// Check whether it is safe or not to call GetSc_match method.
    bool CanGetSc_match(void) const;
    void ResetSc_match(void);
    TSc_match GetSc_match(void) const;
    void SetSc_match(TSc_match value);
    TSc_match& SetSc_match(void);

    /// mismatch score for NT (-q)
    /// optional
    /// typedef int TSc_mismatch
    ///  Check whether the Sc_mismatch data member has been assigned a value.
    bool IsSetSc_mismatch(void) const;
    /// Check whether it is safe or not to call GetSc_mismatch method.
    bool CanGetSc_mismatch(void) const;
    void ResetSc_mismatch(void);
    TSc_mismatch GetSc_mismatch(void) const;
    void SetSc_mismatch(TSc_mismatch value);
    TSc_mismatch& SetSc_mismatch(void);

    /// Gap opening cost (-G)
    /// mandatory
    /// typedef int TGap_open
    ///  Check whether the Gap_open data member has been assigned a value.
    bool IsSetGap_open(void) const;
    /// Check whether it is safe or not to call GetGap_open method.
    bool CanGetGap_open(void) const;
    void ResetGap_open(void);
    TGap_open GetGap_open(void) const;
    void SetGap_open(TGap_open value);
    TGap_open& SetGap_open(void);

    /// Gap extension cost (-E)
    /// mandatory
    /// typedef int TGap_extend
    ///  Check whether the Gap_extend data member has been assigned a value.
    bool IsSetGap_extend(void) const;
    /// Check whether it is safe or not to call GetGap_extend method.
    bool CanGetGap_extend(void) const;
    void ResetGap_extend(void);
    TGap_extend GetGap_extend(void) const;
    void SetGap_extend(TGap_extend value);
    TGap_extend& SetGap_extend(void);

    /// Filtering options (-F)
    /// optional
    /// typedef string TFilter
    ///  Check whether the Filter data member has been assigned a value.
    bool IsSetFilter(void) const;
    /// Check whether it is safe or not to call GetFilter method.
    bool CanGetFilter(void) const;
    void ResetFilter(void);
    const TFilter& GetFilter(void) const;
    void SetFilter(const TFilter& value);
    void SetFilter(TFilter&& value);
    TFilter& SetFilter(void);

    /// PHI-BLAST pattern
    /// optional
    /// typedef string TPattern
    ///  Check whether the Pattern data member has been assigned a value.
    bool IsSetPattern(void) const;
    /// Check whether it is safe or not to call GetPattern method.
    bool CanGetPattern(void) const;
    void ResetPattern(void);
    const TPattern& GetPattern(void) const;
    void SetPattern(const TPattern& value);
    void SetPattern(TPattern&& value);
    TPattern& SetPattern(void);

    /// Limit of request to Entrez query
    /// optional
    /// typedef string TEntrez_query
    ///  Check whether the Entrez_query data member has been assigned a value.
    bool IsSetEntrez_query(void) const;
    /// Check whether it is safe or not to call GetEntrez_query method.
    bool CanGetEntrez_query(void) const;
    void ResetEntrez_query(void);
    const TEntrez_query& GetEntrez_query(void) const;
    void SetEntrez_query(const TEntrez_query& value);
    void SetEntrez_query(TEntrez_query&& value);
    TEntrez_query& SetEntrez_query(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CParameters_Base(const CParameters_Base&);
    CParameters_Base& operator=(const CParameters_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Matrix;
    double m_Expect;
    double m_Include;
    int m_Sc_match;
    int m_Sc_mismatch;
    int m_Gap_open;
    int m_Gap_extend;
    string m_Filter;
    string m_Pattern;
    string m_Entrez_query;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CParameters_Base::IsSetMatrix(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CParameters_Base::CanGetMatrix(void) const
{
    return IsSetMatrix();
}

inline
const CParameters_Base::TMatrix& CParameters_Base::GetMatrix(void) const
{
    if (!CanGetMatrix()) {
        ThrowUnassigned(0);
    }
    return m_Matrix;
}

inline
void CParameters_Base::SetMatrix(const CParameters_Base::TMatrix& value)
{
    m_Matrix = value;
    m_set_State[0] |= 0x3;
}

inline
void CParameters_Base::SetMatrix(CParameters_Base::TMatrix&& value)
{
    m_Matrix = std::forward<CParameters_Base::TMatrix>(value);
    m_set_State[0] |= 0x3;
}

inline
CParameters_Base::TMatrix& CParameters_Base::SetMatrix(void)
{
#ifdef _DEBUG
    if (!IsSetMatrix()) {
        m_Matrix = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Matrix;
}

inline
bool CParameters_Base::IsSetExpect(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CParameters_Base::CanGetExpect(void) const
{
    return IsSetExpect();
}

inline
void CParameters_Base::ResetExpect(void)
{
    m_Expect = 0;
    m_set_State[0] &= ~0xc;
}

inline
CParameters_Base::TExpect CParameters_Base::GetExpect(void) const
{
    if (!CanGetExpect()) {
        ThrowUnassigned(1);
    }
    return m_Expect;
}

inline
void CParameters_Base::SetExpect(CParameters_Base::TExpect value)
{
    m_Expect = value;
    m_set_State[0] |= 0xc;
}

inline
CParameters_Base::TExpect& CParameters_Base::SetExpect(void)
{
#ifdef _DEBUG
    if (!IsSetExpect()) {
        memset(&m_Expect,UnassignedByte(),sizeof(m_Expect));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Expect;
}

inline
bool CParameters_Base::IsSetInclude(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CParameters_Base::CanGetInclude(void) const
{
    return IsSetInclude();
}

inline
void CParameters_Base::ResetInclude(void)
{
    m_Include = 0;
    m_set_State[0] &= ~0x30;
}

inline
CParameters_Base::TInclude CParameters_Base::GetInclude(void) const
{
    if (!CanGetInclude()) {
        ThrowUnassigned(2);
    }
    return m_Include;
}

inline
void CParameters_Base::SetInclude(CParameters_Base::TInclude value)
{
    m_Include = value;
    m_set_State[0] |= 0x30;
}

inline
CParameters_Base::TInclude& CParameters_Base::SetInclude(void)
{
#ifdef _DEBUG
    if (!IsSetInclude()) {
        memset(&m_Include,UnassignedByte(),sizeof(m_Include));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Include;
}

inline
bool CParameters_Base::IsSetSc_match(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CParameters_Base::CanGetSc_match(void) const
{
    return IsSetSc_match();
}

inline
void CParameters_Base::ResetSc_match(void)
{
    m_Sc_match = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CParameters_Base::TSc_match CParameters_Base::GetSc_match(void) const
{
    if (!CanGetSc_match()) {
        ThrowUnassigned(3);
    }
    return m_Sc_match;
}

inline
void CParameters_Base::SetSc_match(CParameters_Base::TSc_match value)
{
    m_Sc_match = value;
    m_set_State[0] |= 0xc0;
}

inline
CParameters_Base::TSc_match& CParameters_Base::SetSc_match(void)
{
#ifdef _DEBUG
    if (!IsSetSc_match()) {
        memset(&m_Sc_match,UnassignedByte(),sizeof(m_Sc_match));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Sc_match;
}

inline
bool CParameters_Base::IsSetSc_mismatch(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CParameters_Base::CanGetSc_mismatch(void) const
{
    return IsSetSc_mismatch();
}

inline
void CParameters_Base::ResetSc_mismatch(void)
{
    m_Sc_mismatch = 0;
    m_set_State[0] &= ~0x300;
}

inline
CParameters_Base::TSc_mismatch CParameters_Base::GetSc_mismatch(void) const
{
    if (!CanGetSc_mismatch()) {
        ThrowUnassigned(4);
    }
    return m_Sc_mismatch;
}

inline
void CParameters_Base::SetSc_mismatch(CParameters_Base::TSc_mismatch value)
{
    m_Sc_mismatch = value;
    m_set_State[0] |= 0x300;
}

inline
CParameters_Base::TSc_mismatch& CParameters_Base::SetSc_mismatch(void)
{
#ifdef _DEBUG
    if (!IsSetSc_mismatch()) {
        memset(&m_Sc_mismatch,UnassignedByte(),sizeof(m_Sc_mismatch));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Sc_mismatch;
}

inline
bool CParameters_Base::IsSetGap_open(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CParameters_Base::CanGetGap_open(void) const
{
    return IsSetGap_open();
}

inline
void CParameters_Base::ResetGap_open(void)
{
    m_Gap_open = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CParameters_Base::TGap_open CParameters_Base::GetGap_open(void) const
{
    if (!CanGetGap_open()) {
        ThrowUnassigned(5);
    }
    return m_Gap_open;
}

inline
void CParameters_Base::SetGap_open(CParameters_Base::TGap_open value)
{
    m_Gap_open = value;
    m_set_State[0] |= 0xc00;
}

inline
CParameters_Base::TGap_open& CParameters_Base::SetGap_open(void)
{
#ifdef _DEBUG
    if (!IsSetGap_open()) {
        memset(&m_Gap_open,UnassignedByte(),sizeof(m_Gap_open));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Gap_open;
}

inline
bool CParameters_Base::IsSetGap_extend(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CParameters_Base::CanGetGap_extend(void) const
{
    return IsSetGap_extend();
}

inline
void CParameters_Base::ResetGap_extend(void)
{
    m_Gap_extend = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CParameters_Base::TGap_extend CParameters_Base::GetGap_extend(void) const
{
    if (!CanGetGap_extend()) {
        ThrowUnassigned(6);
    }
    return m_Gap_extend;
}

inline
void CParameters_Base::SetGap_extend(CParameters_Base::TGap_extend value)
{
    m_Gap_extend = value;
    m_set_State[0] |= 0x3000;
}

inline
CParameters_Base::TGap_extend& CParameters_Base::SetGap_extend(void)
{
#ifdef _DEBUG
    if (!IsSetGap_extend()) {
        memset(&m_Gap_extend,UnassignedByte(),sizeof(m_Gap_extend));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Gap_extend;
}

inline
bool CParameters_Base::IsSetFilter(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CParameters_Base::CanGetFilter(void) const
{
    return IsSetFilter();
}

inline
const CParameters_Base::TFilter& CParameters_Base::GetFilter(void) const
{
    if (!CanGetFilter()) {
        ThrowUnassigned(7);
    }
    return m_Filter;
}

inline
void CParameters_Base::SetFilter(const CParameters_Base::TFilter& value)
{
    m_Filter = value;
    m_set_State[0] |= 0xc000;
}

inline
void CParameters_Base::SetFilter(CParameters_Base::TFilter&& value)
{
    m_Filter = std::forward<CParameters_Base::TFilter>(value);
    m_set_State[0] |= 0xc000;
}

inline
CParameters_Base::TFilter& CParameters_Base::SetFilter(void)
{
#ifdef _DEBUG
    if (!IsSetFilter()) {
        m_Filter = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Filter;
}

inline
bool CParameters_Base::IsSetPattern(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CParameters_Base::CanGetPattern(void) const
{
    return IsSetPattern();
}

inline
const CParameters_Base::TPattern& CParameters_Base::GetPattern(void) const
{
    if (!CanGetPattern()) {
        ThrowUnassigned(8);
    }
    return m_Pattern;
}

inline
void CParameters_Base::SetPattern(const CParameters_Base::TPattern& value)
{
    m_Pattern = value;
    m_set_State[0] |= 0x30000;
}

inline
void CParameters_Base::SetPattern(CParameters_Base::TPattern&& value)
{
    m_Pattern = std::forward<CParameters_Base::TPattern>(value);
    m_set_State[0] |= 0x30000;
}

inline
CParameters_Base::TPattern& CParameters_Base::SetPattern(void)
{
#ifdef _DEBUG
    if (!IsSetPattern()) {
        m_Pattern = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Pattern;
}

inline
bool CParameters_Base::IsSetEntrez_query(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CParameters_Base::CanGetEntrez_query(void) const
{
    return IsSetEntrez_query();
}

inline
const CParameters_Base::TEntrez_query& CParameters_Base::GetEntrez_query(void) const
{
    if (!CanGetEntrez_query()) {
        ThrowUnassigned(9);
    }
    return m_Entrez_query;
}

inline
void CParameters_Base::SetEntrez_query(const CParameters_Base::TEntrez_query& value)
{
    m_Entrez_query = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CParameters_Base::SetEntrez_query(CParameters_Base::TEntrez_query&& value)
{
    m_Entrez_query = std::forward<CParameters_Base::TEntrez_query>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CParameters_Base::TEntrez_query& CParameters_Base::SetEntrez_query(void)
{
#ifdef _DEBUG
    if (!IsSetEntrez_query()) {
        m_Entrez_query = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Entrez_query;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML_PARAMETERS_BASE_HPP
