/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Search_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML2_SEARCH_BASE_HPP
#define OBJECTS_BLASTXML2_SEARCH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_blastxml2_SCOPE
#  define BEGIN_blastxml2_SCOPE BEGIN_SCOPE(blastxml2)
#  define END_blastxml2_SCOPE END_SCOPE(blastxml2)
#endif
BEGIN_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::


// forward declarations
class CHit;
class CRange;
class CStatistics;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTXML2_EXPORT CSearch_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSearch_Base(void);
    // destructor
    virtual ~CSearch_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TQuery_id;
    typedef string TQuery_title;
    typedef int TQuery_len;
    typedef list< CRef< CRange > > TQuery_masking;
    typedef list< CRef< CHit > > THits;
    typedef CStatistics TStat;
    typedef string TMessage;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_query_id,
        e_query_title,
        e_query_len,
        e_query_masking,
        e_hits,
        e_stat,
        e_message
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// SeqId of query
    /// optional
    /// typedef string TQuery_id
    ///  Check whether the Query_id data member has been assigned a value.
    bool IsSetQuery_id(void) const;
    /// Check whether it is safe or not to call GetQuery_id method.
    bool CanGetQuery_id(void) const;
    void ResetQuery_id(void);
    const TQuery_id& GetQuery_id(void) const;
    void SetQuery_id(const TQuery_id& value);
    void SetQuery_id(TQuery_id&& value);
    TQuery_id& SetQuery_id(void);

    /// Definition line of query
    /// optional
    /// typedef string TQuery_title
    ///  Check whether the Query_title data member has been assigned a value.
    bool IsSetQuery_title(void) const;
    /// Check whether it is safe or not to call GetQuery_title method.
    bool CanGetQuery_title(void) const;
    void ResetQuery_title(void);
    const TQuery_title& GetQuery_title(void) const;
    void SetQuery_title(const TQuery_title& value);
    void SetQuery_title(TQuery_title&& value);
    TQuery_title& SetQuery_title(void);

    /// length of query sequence
    /// optional
    /// typedef int TQuery_len
    ///  Check whether the Query_len data member has been assigned a value.
    bool IsSetQuery_len(void) const;
    /// Check whether it is safe or not to call GetQuery_len method.
    bool CanGetQuery_len(void) const;
    void ResetQuery_len(void);
    TQuery_len GetQuery_len(void) const;
    void SetQuery_len(TQuery_len value);
    TQuery_len& SetQuery_len(void);

    /// Masked offsets.
    /// optional
    /// typedef list< CRef< CRange > > TQuery_masking
    ///  Check whether the Query_masking data member has been assigned a value.
    bool IsSetQuery_masking(void) const;
    /// Check whether it is safe or not to call GetQuery_masking method.
    bool CanGetQuery_masking(void) const;
    void ResetQuery_masking(void);
    const TQuery_masking& GetQuery_masking(void) const;
    TQuery_masking& SetQuery_masking(void);

    /// Hits one for every db sequence
    /// optional
    /// typedef list< CRef< CHit > > THits
    ///  Check whether the Hits data member has been assigned a value.
    bool IsSetHits(void) const;
    /// Check whether it is safe or not to call GetHits method.
    bool CanGetHits(void) const;
    void ResetHits(void);
    const THits& GetHits(void) const;
    THits& SetHits(void);

    /// search statistics            
    /// optional
    /// typedef CStatistics TStat
    ///  Check whether the Stat data member has been assigned a value.
    bool IsSetStat(void) const;
    /// Check whether it is safe or not to call GetStat method.
    bool CanGetStat(void) const;
    void ResetStat(void);
    const TStat& GetStat(void) const;
    void SetStat(TStat& value);
    TStat& SetStat(void);

    /// Some (error?) information
    /// optional
    /// typedef string TMessage
    ///  Check whether the Message data member has been assigned a value.
    bool IsSetMessage(void) const;
    /// Check whether it is safe or not to call GetMessage method.
    bool CanGetMessage(void) const;
    void ResetMessage(void);
    const TMessage& GetMessage(void) const;
    void SetMessage(const TMessage& value);
    void SetMessage(TMessage&& value);
    TMessage& SetMessage(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSearch_Base(const CSearch_Base&);
    CSearch_Base& operator=(const CSearch_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Query_id;
    string m_Query_title;
    int m_Query_len;
    list< CRef< CRange > > m_Query_masking;
    list< CRef< CHit > > m_Hits;
    CRef< TStat > m_Stat;
    string m_Message;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSearch_Base::IsSetQuery_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSearch_Base::CanGetQuery_id(void) const
{
    return IsSetQuery_id();
}

inline
const CSearch_Base::TQuery_id& CSearch_Base::GetQuery_id(void) const
{
    if (!CanGetQuery_id()) {
        ThrowUnassigned(0);
    }
    return m_Query_id;
}

inline
void CSearch_Base::SetQuery_id(const CSearch_Base::TQuery_id& value)
{
    m_Query_id = value;
    m_set_State[0] |= 0x3;
}

inline
void CSearch_Base::SetQuery_id(CSearch_Base::TQuery_id&& value)
{
    m_Query_id = std::forward<CSearch_Base::TQuery_id>(value);
    m_set_State[0] |= 0x3;
}

inline
CSearch_Base::TQuery_id& CSearch_Base::SetQuery_id(void)
{
#ifdef _DEBUG
    if (!IsSetQuery_id()) {
        m_Query_id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Query_id;
}

inline
bool CSearch_Base::IsSetQuery_title(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSearch_Base::CanGetQuery_title(void) const
{
    return IsSetQuery_title();
}

inline
const CSearch_Base::TQuery_title& CSearch_Base::GetQuery_title(void) const
{
    if (!CanGetQuery_title()) {
        ThrowUnassigned(1);
    }
    return m_Query_title;
}

inline
void CSearch_Base::SetQuery_title(const CSearch_Base::TQuery_title& value)
{
    m_Query_title = value;
    m_set_State[0] |= 0xc;
}

inline
void CSearch_Base::SetQuery_title(CSearch_Base::TQuery_title&& value)
{
    m_Query_title = std::forward<CSearch_Base::TQuery_title>(value);
    m_set_State[0] |= 0xc;
}

inline
CSearch_Base::TQuery_title& CSearch_Base::SetQuery_title(void)
{
#ifdef _DEBUG
    if (!IsSetQuery_title()) {
        m_Query_title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Query_title;
}

inline
bool CSearch_Base::IsSetQuery_len(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSearch_Base::CanGetQuery_len(void) const
{
    return IsSetQuery_len();
}

inline
void CSearch_Base::ResetQuery_len(void)
{
    m_Query_len = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSearch_Base::TQuery_len CSearch_Base::GetQuery_len(void) const
{
    if (!CanGetQuery_len()) {
        ThrowUnassigned(2);
    }
    return m_Query_len;
}

inline
void CSearch_Base::SetQuery_len(CSearch_Base::TQuery_len value)
{
    m_Query_len = value;
    m_set_State[0] |= 0x30;
}

inline
CSearch_Base::TQuery_len& CSearch_Base::SetQuery_len(void)
{
#ifdef _DEBUG
    if (!IsSetQuery_len()) {
        memset(&m_Query_len,UnassignedByte(),sizeof(m_Query_len));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Query_len;
}

inline
bool CSearch_Base::IsSetQuery_masking(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSearch_Base::CanGetQuery_masking(void) const
{
    return true;
}

inline
const CSearch_Base::TQuery_masking& CSearch_Base::GetQuery_masking(void) const
{
    return m_Query_masking;
}

inline
CSearch_Base::TQuery_masking& CSearch_Base::SetQuery_masking(void)
{
    m_set_State[0] |= 0x40;
    return m_Query_masking;
}

inline
bool CSearch_Base::IsSetHits(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSearch_Base::CanGetHits(void) const
{
    return true;
}

inline
const CSearch_Base::THits& CSearch_Base::GetHits(void) const
{
    return m_Hits;
}

inline
CSearch_Base::THits& CSearch_Base::SetHits(void)
{
    m_set_State[0] |= 0x100;
    return m_Hits;
}

inline
bool CSearch_Base::IsSetStat(void) const
{
    return m_Stat.NotEmpty();
}

inline
bool CSearch_Base::CanGetStat(void) const
{
    return IsSetStat();
}

inline
const CSearch_Base::TStat& CSearch_Base::GetStat(void) const
{
    if (!CanGetStat()) {
        ThrowUnassigned(5);
    }
    return (*m_Stat);
}

inline
bool CSearch_Base::IsSetMessage(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSearch_Base::CanGetMessage(void) const
{
    return IsSetMessage();
}

inline
const CSearch_Base::TMessage& CSearch_Base::GetMessage(void) const
{
    if (!CanGetMessage()) {
        ThrowUnassigned(6);
    }
    return m_Message;
}

inline
void CSearch_Base::SetMessage(const CSearch_Base::TMessage& value)
{
    m_Message = value;
    m_set_State[0] |= 0x3000;
}

inline
void CSearch_Base::SetMessage(CSearch_Base::TMessage&& value)
{
    m_Message = std::forward<CSearch_Base::TMessage>(value);
    m_set_State[0] |= 0x3000;
}

inline
CSearch_Base::TMessage& CSearch_Base::SetMessage(void)
{
#ifdef _DEBUG
    if (!IsSetMessage()) {
        m_Message = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Message;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML2_SEARCH_BASE_HPP
