/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cdd_Viewer_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_CDD_VIEWER_BASE_HPP
#define OBJECTS_CDD_CDD_VIEWER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCdd_Viewer_Rect;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_CDD_EXPORT CCdd_Viewer_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCdd_Viewer_Base(void);
    // destructor
    virtual ~CCdd_Viewer_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// viewer type
    enum ECtrl {
        eCtrl_unassigned         =   0,
        eCtrl_cd_info            =   1,
        eCtrl_align_annot        =   2,
        eCtrl_seq_list           =   3,
        eCtrl_seq_tree           =   4,
        eCtrl_merge_preview      =   5,
        eCtrl_cross_hits         =   6,
        eCtrl_notes              =   7,
        eCtrl_tax_tree           =   8,
        eCtrl_dart               =   9,
        eCtrl_dart_selected_rows =  10,
        eCtrl_other              = 255
    };
    
    /// Access to ECtrl's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ECtrl)(void);
    
    // types
    typedef int TCtrl;
    typedef CCdd_Viewer_Rect TRect;
    typedef list< string > TAccessions;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_ctrl,
        e_rect,
        e_accessions
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TCtrl
    ///  Check whether the Ctrl data member has been assigned a value.
    bool IsSetCtrl(void) const;
    /// Check whether it is safe or not to call GetCtrl method.
    bool CanGetCtrl(void) const;
    void ResetCtrl(void);
    TCtrl GetCtrl(void) const;
    void SetCtrl(TCtrl value);
    TCtrl& SetCtrl(void);

    /// viewer rectangle
    /// optional
    /// typedef CCdd_Viewer_Rect TRect
    ///  Check whether the Rect data member has been assigned a value.
    bool IsSetRect(void) const;
    /// Check whether it is safe or not to call GetRect method.
    bool CanGetRect(void) const;
    void ResetRect(void);
    const TRect& GetRect(void) const;
    void SetRect(TRect& value);
    TRect& SetRect(void);

    /// list of accessions associated with a viewer
    /// mandatory
    /// typedef list< string > TAccessions
    ///  Check whether the Accessions data member has been assigned a value.
    bool IsSetAccessions(void) const;
    /// Check whether it is safe or not to call GetAccessions method.
    bool CanGetAccessions(void) const;
    void ResetAccessions(void);
    const TAccessions& GetAccessions(void) const;
    TAccessions& SetAccessions(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCdd_Viewer_Base(const CCdd_Viewer_Base&);
    CCdd_Viewer_Base& operator=(const CCdd_Viewer_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Ctrl;
    CRef< TRect > m_Rect;
    list< string > m_Accessions;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCdd_Viewer_Base::IsSetCtrl(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCdd_Viewer_Base::CanGetCtrl(void) const
{
    return IsSetCtrl();
}

inline
void CCdd_Viewer_Base::ResetCtrl(void)
{
    m_Ctrl = (ECtrl)(0);
    m_set_State[0] &= ~0x3;
}

inline
CCdd_Viewer_Base::TCtrl CCdd_Viewer_Base::GetCtrl(void) const
{
    if (!CanGetCtrl()) {
        ThrowUnassigned(0);
    }
    return m_Ctrl;
}

inline
void CCdd_Viewer_Base::SetCtrl(CCdd_Viewer_Base::TCtrl value)
{
    m_Ctrl = value;
    m_set_State[0] |= 0x3;
}

inline
CCdd_Viewer_Base::TCtrl& CCdd_Viewer_Base::SetCtrl(void)
{
#ifdef _DEBUG
    if (!IsSetCtrl()) {
        memset(&m_Ctrl,UnassignedByte(),sizeof(m_Ctrl));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Ctrl;
}

inline
bool CCdd_Viewer_Base::IsSetRect(void) const
{
    return m_Rect.NotEmpty();
}

inline
bool CCdd_Viewer_Base::CanGetRect(void) const
{
    return IsSetRect();
}

inline
const CCdd_Viewer_Base::TRect& CCdd_Viewer_Base::GetRect(void) const
{
    if (!CanGetRect()) {
        ThrowUnassigned(1);
    }
    return (*m_Rect);
}

inline
bool CCdd_Viewer_Base::IsSetAccessions(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCdd_Viewer_Base::CanGetAccessions(void) const
{
    return true;
}

inline
const CCdd_Viewer_Base::TAccessions& CCdd_Viewer_Base::GetAccessions(void) const
{
    return m_Accessions;
}

inline
CCdd_Viewer_Base::TAccessions& CCdd_Viewer_Base::SetAccessions(void)
{
    m_set_State[0] |= 0x10;
    return m_Accessions;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_CDD_VIEWER_BASE_HPP
