/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Update_align_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_UPDATE_ALIGN_BASE_HPP
#define OBJECTS_CDD_UPDATE_ALIGN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_annot;
class CUpdate_comment;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Both fields are optional, as the Update-align may be a Seq-annot without
/// description, or a suggestion to add a sequence without the corresponding
/// alignment
class NCBI_CDD_EXPORT CUpdate_align_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CUpdate_align_Base(void);
    // destructor
    virtual ~CUpdate_align_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_unassigned =   0,
        eType_update     =   1,
        eType_update_3d  =   2,
        eType_demoted    =  51,
        eType_demoted_3d =  52,
        eType_other      = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef list< CRef< CUpdate_comment > > TDescription;
    typedef CSeq_annot TSeqannot;
    typedef int TType;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_description,
        e_seqannot,
        e_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CUpdate_comment > > TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    TDescription& SetDescription(void);

    /// contains the SeqAlign
    /// optional
    /// typedef CSeq_annot TSeqannot
    ///  Check whether the Seqannot data member has been assigned a value.
    bool IsSetSeqannot(void) const;
    /// Check whether it is safe or not to call GetSeqannot method.
    bool CanGetSeqannot(void) const;
    void ResetSeqannot(void);
    const TSeqannot& GetSeqannot(void) const;
    void SetSeqannot(TSeqannot& value);
    TSeqannot& SetSeqannot(void);

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CUpdate_align_Base(const CUpdate_align_Base&);
    CUpdate_align_Base& operator=(const CUpdate_align_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CUpdate_comment > > m_Description;
    CRef< TSeqannot > m_Seqannot;
    int m_Type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CUpdate_align_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CUpdate_align_Base::CanGetDescription(void) const
{
    return true;
}

inline
const CUpdate_align_Base::TDescription& CUpdate_align_Base::GetDescription(void) const
{
    return m_Description;
}

inline
CUpdate_align_Base::TDescription& CUpdate_align_Base::SetDescription(void)
{
    m_set_State[0] |= 0x1;
    return m_Description;
}

inline
bool CUpdate_align_Base::IsSetSeqannot(void) const
{
    return m_Seqannot.NotEmpty();
}

inline
bool CUpdate_align_Base::CanGetSeqannot(void) const
{
    return IsSetSeqannot();
}

inline
const CUpdate_align_Base::TSeqannot& CUpdate_align_Base::GetSeqannot(void) const
{
    if (!CanGetSeqannot()) {
        ThrowUnassigned(1);
    }
    return (*m_Seqannot);
}

inline
bool CUpdate_align_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CUpdate_align_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CUpdate_align_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x30;
}

inline
CUpdate_align_Base::TType CUpdate_align_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(2);
    }
    return m_Type;
}

inline
void CUpdate_align_Base::SetType(CUpdate_align_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x30;
}

inline
CUpdate_align_Base::TType& CUpdate_align_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_UPDATE_ALIGN_BASE_HPP
