/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_GL_matrix_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_GL_MATRIX_BASE_HPP
#define OBJECTS_CN3D_CN3D_GL_MATRIX_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a GL-ordered transformation matrix
class NCBI_CN3D_EXPORT CCn3d_GL_matrix_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_GL_matrix_Base(void);
    // destructor
    virtual ~CCn3d_GL_matrix_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef double TM0;
    typedef double TM1;
    typedef double TM2;
    typedef double TM3;
    typedef double TM4;
    typedef double TM5;
    typedef double TM6;
    typedef double TM7;
    typedef double TM8;
    typedef double TM9;
    typedef double TM10;
    typedef double TM11;
    typedef double TM12;
    typedef double TM13;
    typedef double TM14;
    typedef double TM15;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_m0,
        e_m1,
        e_m2,
        e_m3,
        e_m4,
        e_m5,
        e_m6,
        e_m7,
        e_m8,
        e_m9,
        e_m10,
        e_m11,
        e_m12,
        e_m13,
        e_m14,
        e_m15
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 17> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef double TM0
    ///  Check whether the M0 data member has been assigned a value.
    bool IsSetM0(void) const;
    /// Check whether it is safe or not to call GetM0 method.
    bool CanGetM0(void) const;
    void ResetM0(void);
    TM0 GetM0(void) const;
    void SetM0(TM0 value);
    TM0& SetM0(void);

    /// mandatory
    /// typedef double TM1
    ///  Check whether the M1 data member has been assigned a value.
    bool IsSetM1(void) const;
    /// Check whether it is safe or not to call GetM1 method.
    bool CanGetM1(void) const;
    void ResetM1(void);
    TM1 GetM1(void) const;
    void SetM1(TM1 value);
    TM1& SetM1(void);

    /// mandatory
    /// typedef double TM2
    ///  Check whether the M2 data member has been assigned a value.
    bool IsSetM2(void) const;
    /// Check whether it is safe or not to call GetM2 method.
    bool CanGetM2(void) const;
    void ResetM2(void);
    TM2 GetM2(void) const;
    void SetM2(TM2 value);
    TM2& SetM2(void);

    /// mandatory
    /// typedef double TM3
    ///  Check whether the M3 data member has been assigned a value.
    bool IsSetM3(void) const;
    /// Check whether it is safe or not to call GetM3 method.
    bool CanGetM3(void) const;
    void ResetM3(void);
    TM3 GetM3(void) const;
    void SetM3(TM3 value);
    TM3& SetM3(void);

    /// mandatory
    /// typedef double TM4
    ///  Check whether the M4 data member has been assigned a value.
    bool IsSetM4(void) const;
    /// Check whether it is safe or not to call GetM4 method.
    bool CanGetM4(void) const;
    void ResetM4(void);
    TM4 GetM4(void) const;
    void SetM4(TM4 value);
    TM4& SetM4(void);

    /// mandatory
    /// typedef double TM5
    ///  Check whether the M5 data member has been assigned a value.
    bool IsSetM5(void) const;
    /// Check whether it is safe or not to call GetM5 method.
    bool CanGetM5(void) const;
    void ResetM5(void);
    TM5 GetM5(void) const;
    void SetM5(TM5 value);
    TM5& SetM5(void);

    /// mandatory
    /// typedef double TM6
    ///  Check whether the M6 data member has been assigned a value.
    bool IsSetM6(void) const;
    /// Check whether it is safe or not to call GetM6 method.
    bool CanGetM6(void) const;
    void ResetM6(void);
    TM6 GetM6(void) const;
    void SetM6(TM6 value);
    TM6& SetM6(void);

    /// mandatory
    /// typedef double TM7
    ///  Check whether the M7 data member has been assigned a value.
    bool IsSetM7(void) const;
    /// Check whether it is safe or not to call GetM7 method.
    bool CanGetM7(void) const;
    void ResetM7(void);
    TM7 GetM7(void) const;
    void SetM7(TM7 value);
    TM7& SetM7(void);

    /// mandatory
    /// typedef double TM8
    ///  Check whether the M8 data member has been assigned a value.
    bool IsSetM8(void) const;
    /// Check whether it is safe or not to call GetM8 method.
    bool CanGetM8(void) const;
    void ResetM8(void);
    TM8 GetM8(void) const;
    void SetM8(TM8 value);
    TM8& SetM8(void);

    /// mandatory
    /// typedef double TM9
    ///  Check whether the M9 data member has been assigned a value.
    bool IsSetM9(void) const;
    /// Check whether it is safe or not to call GetM9 method.
    bool CanGetM9(void) const;
    void ResetM9(void);
    TM9 GetM9(void) const;
    void SetM9(TM9 value);
    TM9& SetM9(void);

    /// mandatory
    /// typedef double TM10
    ///  Check whether the M10 data member has been assigned a value.
    bool IsSetM10(void) const;
    /// Check whether it is safe or not to call GetM10 method.
    bool CanGetM10(void) const;
    void ResetM10(void);
    TM10 GetM10(void) const;
    void SetM10(TM10 value);
    TM10& SetM10(void);

    /// mandatory
    /// typedef double TM11
    ///  Check whether the M11 data member has been assigned a value.
    bool IsSetM11(void) const;
    /// Check whether it is safe or not to call GetM11 method.
    bool CanGetM11(void) const;
    void ResetM11(void);
    TM11 GetM11(void) const;
    void SetM11(TM11 value);
    TM11& SetM11(void);

    /// mandatory
    /// typedef double TM12
    ///  Check whether the M12 data member has been assigned a value.
    bool IsSetM12(void) const;
    /// Check whether it is safe or not to call GetM12 method.
    bool CanGetM12(void) const;
    void ResetM12(void);
    TM12 GetM12(void) const;
    void SetM12(TM12 value);
    TM12& SetM12(void);

    /// mandatory
    /// typedef double TM13
    ///  Check whether the M13 data member has been assigned a value.
    bool IsSetM13(void) const;
    /// Check whether it is safe or not to call GetM13 method.
    bool CanGetM13(void) const;
    void ResetM13(void);
    TM13 GetM13(void) const;
    void SetM13(TM13 value);
    TM13& SetM13(void);

    /// mandatory
    /// typedef double TM14
    ///  Check whether the M14 data member has been assigned a value.
    bool IsSetM14(void) const;
    /// Check whether it is safe or not to call GetM14 method.
    bool CanGetM14(void) const;
    void ResetM14(void);
    TM14 GetM14(void) const;
    void SetM14(TM14 value);
    TM14& SetM14(void);

    /// mandatory
    /// typedef double TM15
    ///  Check whether the M15 data member has been assigned a value.
    bool IsSetM15(void) const;
    /// Check whether it is safe or not to call GetM15 method.
    bool CanGetM15(void) const;
    void ResetM15(void);
    TM15 GetM15(void) const;
    void SetM15(TM15 value);
    TM15& SetM15(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_GL_matrix_Base(const CCn3d_GL_matrix_Base&);
    CCn3d_GL_matrix_Base& operator=(const CCn3d_GL_matrix_Base&);

    // data
    Uint4 m_set_State[1];
    double m_M0;
    double m_M1;
    double m_M2;
    double m_M3;
    double m_M4;
    double m_M5;
    double m_M6;
    double m_M7;
    double m_M8;
    double m_M9;
    double m_M10;
    double m_M11;
    double m_M12;
    double m_M13;
    double m_M14;
    double m_M15;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_GL_matrix_Base::IsSetM0(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM0(void) const
{
    return IsSetM0();
}

inline
void CCn3d_GL_matrix_Base::ResetM0(void)
{
    m_M0 = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCn3d_GL_matrix_Base::TM0 CCn3d_GL_matrix_Base::GetM0(void) const
{
    if (!CanGetM0()) {
        ThrowUnassigned(0);
    }
    return m_M0;
}

inline
void CCn3d_GL_matrix_Base::SetM0(CCn3d_GL_matrix_Base::TM0 value)
{
    m_M0 = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_GL_matrix_Base::TM0& CCn3d_GL_matrix_Base::SetM0(void)
{
#ifdef _DEBUG
    if (!IsSetM0()) {
        memset(&m_M0,UnassignedByte(),sizeof(m_M0));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_M0;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM1(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM1(void) const
{
    return IsSetM1();
}

inline
void CCn3d_GL_matrix_Base::ResetM1(void)
{
    m_M1 = 0;
    m_set_State[0] &= ~0xc;
}

inline
CCn3d_GL_matrix_Base::TM1 CCn3d_GL_matrix_Base::GetM1(void) const
{
    if (!CanGetM1()) {
        ThrowUnassigned(1);
    }
    return m_M1;
}

inline
void CCn3d_GL_matrix_Base::SetM1(CCn3d_GL_matrix_Base::TM1 value)
{
    m_M1 = value;
    m_set_State[0] |= 0xc;
}

inline
CCn3d_GL_matrix_Base::TM1& CCn3d_GL_matrix_Base::SetM1(void)
{
#ifdef _DEBUG
    if (!IsSetM1()) {
        memset(&m_M1,UnassignedByte(),sizeof(m_M1));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_M1;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM2(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM2(void) const
{
    return IsSetM2();
}

inline
void CCn3d_GL_matrix_Base::ResetM2(void)
{
    m_M2 = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCn3d_GL_matrix_Base::TM2 CCn3d_GL_matrix_Base::GetM2(void) const
{
    if (!CanGetM2()) {
        ThrowUnassigned(2);
    }
    return m_M2;
}

inline
void CCn3d_GL_matrix_Base::SetM2(CCn3d_GL_matrix_Base::TM2 value)
{
    m_M2 = value;
    m_set_State[0] |= 0x30;
}

inline
CCn3d_GL_matrix_Base::TM2& CCn3d_GL_matrix_Base::SetM2(void)
{
#ifdef _DEBUG
    if (!IsSetM2()) {
        memset(&m_M2,UnassignedByte(),sizeof(m_M2));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_M2;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM3(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM3(void) const
{
    return IsSetM3();
}

inline
void CCn3d_GL_matrix_Base::ResetM3(void)
{
    m_M3 = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CCn3d_GL_matrix_Base::TM3 CCn3d_GL_matrix_Base::GetM3(void) const
{
    if (!CanGetM3()) {
        ThrowUnassigned(3);
    }
    return m_M3;
}

inline
void CCn3d_GL_matrix_Base::SetM3(CCn3d_GL_matrix_Base::TM3 value)
{
    m_M3 = value;
    m_set_State[0] |= 0xc0;
}

inline
CCn3d_GL_matrix_Base::TM3& CCn3d_GL_matrix_Base::SetM3(void)
{
#ifdef _DEBUG
    if (!IsSetM3()) {
        memset(&m_M3,UnassignedByte(),sizeof(m_M3));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_M3;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM4(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM4(void) const
{
    return IsSetM4();
}

inline
void CCn3d_GL_matrix_Base::ResetM4(void)
{
    m_M4 = 0;
    m_set_State[0] &= ~0x300;
}

inline
CCn3d_GL_matrix_Base::TM4 CCn3d_GL_matrix_Base::GetM4(void) const
{
    if (!CanGetM4()) {
        ThrowUnassigned(4);
    }
    return m_M4;
}

inline
void CCn3d_GL_matrix_Base::SetM4(CCn3d_GL_matrix_Base::TM4 value)
{
    m_M4 = value;
    m_set_State[0] |= 0x300;
}

inline
CCn3d_GL_matrix_Base::TM4& CCn3d_GL_matrix_Base::SetM4(void)
{
#ifdef _DEBUG
    if (!IsSetM4()) {
        memset(&m_M4,UnassignedByte(),sizeof(m_M4));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_M4;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM5(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM5(void) const
{
    return IsSetM5();
}

inline
void CCn3d_GL_matrix_Base::ResetM5(void)
{
    m_M5 = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CCn3d_GL_matrix_Base::TM5 CCn3d_GL_matrix_Base::GetM5(void) const
{
    if (!CanGetM5()) {
        ThrowUnassigned(5);
    }
    return m_M5;
}

inline
void CCn3d_GL_matrix_Base::SetM5(CCn3d_GL_matrix_Base::TM5 value)
{
    m_M5 = value;
    m_set_State[0] |= 0xc00;
}

inline
CCn3d_GL_matrix_Base::TM5& CCn3d_GL_matrix_Base::SetM5(void)
{
#ifdef _DEBUG
    if (!IsSetM5()) {
        memset(&m_M5,UnassignedByte(),sizeof(m_M5));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_M5;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM6(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM6(void) const
{
    return IsSetM6();
}

inline
void CCn3d_GL_matrix_Base::ResetM6(void)
{
    m_M6 = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CCn3d_GL_matrix_Base::TM6 CCn3d_GL_matrix_Base::GetM6(void) const
{
    if (!CanGetM6()) {
        ThrowUnassigned(6);
    }
    return m_M6;
}

inline
void CCn3d_GL_matrix_Base::SetM6(CCn3d_GL_matrix_Base::TM6 value)
{
    m_M6 = value;
    m_set_State[0] |= 0x3000;
}

inline
CCn3d_GL_matrix_Base::TM6& CCn3d_GL_matrix_Base::SetM6(void)
{
#ifdef _DEBUG
    if (!IsSetM6()) {
        memset(&m_M6,UnassignedByte(),sizeof(m_M6));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_M6;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM7(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM7(void) const
{
    return IsSetM7();
}

inline
void CCn3d_GL_matrix_Base::ResetM7(void)
{
    m_M7 = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CCn3d_GL_matrix_Base::TM7 CCn3d_GL_matrix_Base::GetM7(void) const
{
    if (!CanGetM7()) {
        ThrowUnassigned(7);
    }
    return m_M7;
}

inline
void CCn3d_GL_matrix_Base::SetM7(CCn3d_GL_matrix_Base::TM7 value)
{
    m_M7 = value;
    m_set_State[0] |= 0xc000;
}

inline
CCn3d_GL_matrix_Base::TM7& CCn3d_GL_matrix_Base::SetM7(void)
{
#ifdef _DEBUG
    if (!IsSetM7()) {
        memset(&m_M7,UnassignedByte(),sizeof(m_M7));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_M7;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM8(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM8(void) const
{
    return IsSetM8();
}

inline
void CCn3d_GL_matrix_Base::ResetM8(void)
{
    m_M8 = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CCn3d_GL_matrix_Base::TM8 CCn3d_GL_matrix_Base::GetM8(void) const
{
    if (!CanGetM8()) {
        ThrowUnassigned(8);
    }
    return m_M8;
}

inline
void CCn3d_GL_matrix_Base::SetM8(CCn3d_GL_matrix_Base::TM8 value)
{
    m_M8 = value;
    m_set_State[0] |= 0x30000;
}

inline
CCn3d_GL_matrix_Base::TM8& CCn3d_GL_matrix_Base::SetM8(void)
{
#ifdef _DEBUG
    if (!IsSetM8()) {
        memset(&m_M8,UnassignedByte(),sizeof(m_M8));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_M8;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM9(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM9(void) const
{
    return IsSetM9();
}

inline
void CCn3d_GL_matrix_Base::ResetM9(void)
{
    m_M9 = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CCn3d_GL_matrix_Base::TM9 CCn3d_GL_matrix_Base::GetM9(void) const
{
    if (!CanGetM9()) {
        ThrowUnassigned(9);
    }
    return m_M9;
}

inline
void CCn3d_GL_matrix_Base::SetM9(CCn3d_GL_matrix_Base::TM9 value)
{
    m_M9 = value;
    m_set_State[0] |= 0xc0000;
}

inline
CCn3d_GL_matrix_Base::TM9& CCn3d_GL_matrix_Base::SetM9(void)
{
#ifdef _DEBUG
    if (!IsSetM9()) {
        memset(&m_M9,UnassignedByte(),sizeof(m_M9));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_M9;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM10(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM10(void) const
{
    return IsSetM10();
}

inline
void CCn3d_GL_matrix_Base::ResetM10(void)
{
    m_M10 = 0;
    m_set_State[0] &= ~0x300000;
}

inline
CCn3d_GL_matrix_Base::TM10 CCn3d_GL_matrix_Base::GetM10(void) const
{
    if (!CanGetM10()) {
        ThrowUnassigned(10);
    }
    return m_M10;
}

inline
void CCn3d_GL_matrix_Base::SetM10(CCn3d_GL_matrix_Base::TM10 value)
{
    m_M10 = value;
    m_set_State[0] |= 0x300000;
}

inline
CCn3d_GL_matrix_Base::TM10& CCn3d_GL_matrix_Base::SetM10(void)
{
#ifdef _DEBUG
    if (!IsSetM10()) {
        memset(&m_M10,UnassignedByte(),sizeof(m_M10));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_M10;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM11(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM11(void) const
{
    return IsSetM11();
}

inline
void CCn3d_GL_matrix_Base::ResetM11(void)
{
    m_M11 = 0;
    m_set_State[0] &= ~0xc00000;
}

inline
CCn3d_GL_matrix_Base::TM11 CCn3d_GL_matrix_Base::GetM11(void) const
{
    if (!CanGetM11()) {
        ThrowUnassigned(11);
    }
    return m_M11;
}

inline
void CCn3d_GL_matrix_Base::SetM11(CCn3d_GL_matrix_Base::TM11 value)
{
    m_M11 = value;
    m_set_State[0] |= 0xc00000;
}

inline
CCn3d_GL_matrix_Base::TM11& CCn3d_GL_matrix_Base::SetM11(void)
{
#ifdef _DEBUG
    if (!IsSetM11()) {
        memset(&m_M11,UnassignedByte(),sizeof(m_M11));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_M11;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM12(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM12(void) const
{
    return IsSetM12();
}

inline
void CCn3d_GL_matrix_Base::ResetM12(void)
{
    m_M12 = 0;
    m_set_State[0] &= ~0x3000000;
}

inline
CCn3d_GL_matrix_Base::TM12 CCn3d_GL_matrix_Base::GetM12(void) const
{
    if (!CanGetM12()) {
        ThrowUnassigned(12);
    }
    return m_M12;
}

inline
void CCn3d_GL_matrix_Base::SetM12(CCn3d_GL_matrix_Base::TM12 value)
{
    m_M12 = value;
    m_set_State[0] |= 0x3000000;
}

inline
CCn3d_GL_matrix_Base::TM12& CCn3d_GL_matrix_Base::SetM12(void)
{
#ifdef _DEBUG
    if (!IsSetM12()) {
        memset(&m_M12,UnassignedByte(),sizeof(m_M12));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_M12;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM13(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM13(void) const
{
    return IsSetM13();
}

inline
void CCn3d_GL_matrix_Base::ResetM13(void)
{
    m_M13 = 0;
    m_set_State[0] &= ~0xc000000;
}

inline
CCn3d_GL_matrix_Base::TM13 CCn3d_GL_matrix_Base::GetM13(void) const
{
    if (!CanGetM13()) {
        ThrowUnassigned(13);
    }
    return m_M13;
}

inline
void CCn3d_GL_matrix_Base::SetM13(CCn3d_GL_matrix_Base::TM13 value)
{
    m_M13 = value;
    m_set_State[0] |= 0xc000000;
}

inline
CCn3d_GL_matrix_Base::TM13& CCn3d_GL_matrix_Base::SetM13(void)
{
#ifdef _DEBUG
    if (!IsSetM13()) {
        memset(&m_M13,UnassignedByte(),sizeof(m_M13));
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_M13;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM14(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM14(void) const
{
    return IsSetM14();
}

inline
void CCn3d_GL_matrix_Base::ResetM14(void)
{
    m_M14 = 0;
    m_set_State[0] &= ~0x30000000;
}

inline
CCn3d_GL_matrix_Base::TM14 CCn3d_GL_matrix_Base::GetM14(void) const
{
    if (!CanGetM14()) {
        ThrowUnassigned(14);
    }
    return m_M14;
}

inline
void CCn3d_GL_matrix_Base::SetM14(CCn3d_GL_matrix_Base::TM14 value)
{
    m_M14 = value;
    m_set_State[0] |= 0x30000000;
}

inline
CCn3d_GL_matrix_Base::TM14& CCn3d_GL_matrix_Base::SetM14(void)
{
#ifdef _DEBUG
    if (!IsSetM14()) {
        memset(&m_M14,UnassignedByte(),sizeof(m_M14));
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_M14;
}

inline
bool CCn3d_GL_matrix_Base::IsSetM15(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CCn3d_GL_matrix_Base::CanGetM15(void) const
{
    return IsSetM15();
}

inline
void CCn3d_GL_matrix_Base::ResetM15(void)
{
    m_M15 = 0;
    m_set_State[0] &= ~0xc0000000;
}

inline
CCn3d_GL_matrix_Base::TM15 CCn3d_GL_matrix_Base::GetM15(void) const
{
    if (!CanGetM15()) {
        ThrowUnassigned(15);
    }
    return m_M15;
}

inline
void CCn3d_GL_matrix_Base::SetM15(CCn3d_GL_matrix_Base::TM15 value)
{
    m_M15 = value;
    m_set_State[0] |= 0xc0000000;
}

inline
CCn3d_GL_matrix_Base::TM15& CCn3d_GL_matrix_Base::SetM15(void)
{
#ifdef _DEBUG
    if (!IsSetM15()) {
        memset(&m_M15,UnassignedByte(),sizeof(m_M15));
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_M15;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_GL_MATRIX_BASE_HPP
