/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_user_annotations_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_USER_ANNOTATIONS_BASE_HPP
#define OBJECTS_CN3D_CN3D_USER_ANNOTATIONS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCn3d_user_annotation;
class CCn3d_view_settings;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// The list of annotations for a given CDD/mime. If residue regions overlap
/// between annotations that are turned on, the last annotation in this list
/// that contains these residues will be used as the display style for these
/// residues.
///   Also contains the current viewpoint, so that user's camera angle
/// can be stored and reproduced, for illustrations, on-line figures, etc.
class NCBI_CN3D_EXPORT CCn3d_user_annotations_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_user_annotations_Base(void);
    // destructor
    virtual ~CCn3d_user_annotations_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CCn3d_user_annotation > > TAnnotations;
    typedef CCn3d_view_settings TView;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_annotations,
        e_view
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CCn3d_user_annotation > > TAnnotations
    ///  Check whether the Annotations data member has been assigned a value.
    bool IsSetAnnotations(void) const;
    /// Check whether it is safe or not to call GetAnnotations method.
    bool CanGetAnnotations(void) const;
    void ResetAnnotations(void);
    const TAnnotations& GetAnnotations(void) const;
    TAnnotations& SetAnnotations(void);

    /// optional
    /// typedef CCn3d_view_settings TView
    ///  Check whether the View data member has been assigned a value.
    bool IsSetView(void) const;
    /// Check whether it is safe or not to call GetView method.
    bool CanGetView(void) const;
    void ResetView(void);
    const TView& GetView(void) const;
    void SetView(TView& value);
    TView& SetView(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_user_annotations_Base(const CCn3d_user_annotations_Base&);
    CCn3d_user_annotations_Base& operator=(const CCn3d_user_annotations_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CCn3d_user_annotation > > m_Annotations;
    CRef< TView > m_View;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_user_annotations_Base::IsSetAnnotations(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_user_annotations_Base::CanGetAnnotations(void) const
{
    return true;
}

inline
const CCn3d_user_annotations_Base::TAnnotations& CCn3d_user_annotations_Base::GetAnnotations(void) const
{
    return m_Annotations;
}

inline
CCn3d_user_annotations_Base::TAnnotations& CCn3d_user_annotations_Base::SetAnnotations(void)
{
    m_set_State[0] |= 0x1;
    return m_Annotations;
}

inline
bool CCn3d_user_annotations_Base::IsSetView(void) const
{
    return m_View.NotEmpty();
}

inline
bool CCn3d_user_annotations_Base::CanGetView(void) const
{
    return IsSetView();
}

inline
const CCn3d_user_annotations_Base::TView& CCn3d_user_annotations_Base::GetView(void) const
{
    if (!CanGetView()) {
        ThrowUnassigned(1);
    }
    return (*m_View);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_USER_ANNOTATIONS_BASE_HPP
