/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HGVS_Coordinate_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'objcoords.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_COORDS_HGVS_COORDINATE_BASE_HPP
#define OBJECTS_COORDS_HGVS_COORDINATE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_OBJCOORDS_EXPORT CHGVS_Coordinate_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHGVS_Coordinate_Base(void);
    // destructor
    virtual ~CHGVS_Coordinate_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TMarker_pos;
    typedef string TTitle;
    typedef string TObject_id;
    typedef int TPos_mapped;
    typedef string THgvs_position;
    typedef string TSequence;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_marker_pos,
        e_title,
        e_object_id,
        e_pos_mapped,
        e_hgvs_position,
        e_sequence
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// actual marker position
    /// this is supplied because this is the position of the marker in the main
    /// sequence's coordinate space; this is different than the mapped
    /// coordinate space.
    /// mandatory
    /// typedef int TMarker_pos
    ///  Check whether the Marker_pos data member has been assigned a value.
    bool IsSetMarker_pos(void) const;
    /// Check whether it is safe or not to call GetMarker_pos method.
    bool CanGetMarker_pos(void) const;
    void ResetMarker_pos(void);
    TMarker_pos GetMarker_pos(void) const;
    void SetMarker_pos(TMarker_pos value);
    TMarker_pos& SetMarker_pos(void);

    /// pretty-printed name for the object
    /// in general, this should be the "best" seq-id for the product
    /// of a feature represented at a position
    /// mandatory
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// the fingerprint of the object in question
    /// this is a complex reversible hash
    /// optional
    /// typedef string TObject_id
    ///  Check whether the Object_id data member has been assigned a value.
    bool IsSetObject_id(void) const;
    /// Check whether it is safe or not to call GetObject_id method.
    bool CanGetObject_id(void) const;
    void ResetObject_id(void);
    const TObject_id& GetObject_id(void) const;
    void SetObject_id(const TObject_id& value);
    void SetObject_id(TObject_id&& value);
    TObject_id& SetObject_id(void);

    /// the mapped position in the object's coordinate space
    /// it's not valid for DNA coordinate in UTR and intergenic region,
    /// while hgvs-position can be meaningful, that is why OPTIONAL.
    /// optional
    /// typedef int TPos_mapped
    ///  Check whether the Pos_mapped data member has been assigned a value.
    bool IsSetPos_mapped(void) const;
    /// Check whether it is safe or not to call GetPos_mapped method.
    bool CanGetPos_mapped(void) const;
    void ResetPos_mapped(void);
    TPos_mapped GetPos_mapped(void) const;
    void SetPos_mapped(TPos_mapped value);
    TPos_mapped& SetPos_mapped(void);

    /// a label for this position
    /// this shall always be in HGVS nomenclature
    /// mandatory
    /// typedef string THgvs_position
    ///  Check whether the Hgvs_position data member has been assigned a value.
    bool IsSetHgvs_position(void) const;
    /// Check whether it is safe or not to call GetHgvs_position method.
    bool CanGetHgvs_position(void) const;
    void ResetHgvs_position(void);
    const THgvs_position& GetHgvs_position(void) const;
    void SetHgvs_position(const THgvs_position& value);
    void SetHgvs_position(THgvs_position&& value);
    THgvs_position& SetHgvs_position(void);

    /// a sequence for this position
    /// mandatory
    /// typedef string TSequence
    ///  Check whether the Sequence data member has been assigned a value.
    bool IsSetSequence(void) const;
    /// Check whether it is safe or not to call GetSequence method.
    bool CanGetSequence(void) const;
    void ResetSequence(void);
    const TSequence& GetSequence(void) const;
    void SetSequence(const TSequence& value);
    void SetSequence(TSequence&& value);
    TSequence& SetSequence(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHGVS_Coordinate_Base(const CHGVS_Coordinate_Base&);
    CHGVS_Coordinate_Base& operator=(const CHGVS_Coordinate_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Marker_pos;
    string m_Title;
    string m_Object_id;
    int m_Pos_mapped;
    string m_Hgvs_position;
    string m_Sequence;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHGVS_Coordinate_Base::IsSetMarker_pos(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHGVS_Coordinate_Base::CanGetMarker_pos(void) const
{
    return IsSetMarker_pos();
}

inline
void CHGVS_Coordinate_Base::ResetMarker_pos(void)
{
    m_Marker_pos = 0;
    m_set_State[0] &= ~0x3;
}

inline
CHGVS_Coordinate_Base::TMarker_pos CHGVS_Coordinate_Base::GetMarker_pos(void) const
{
    if (!CanGetMarker_pos()) {
        ThrowUnassigned(0);
    }
    return m_Marker_pos;
}

inline
void CHGVS_Coordinate_Base::SetMarker_pos(CHGVS_Coordinate_Base::TMarker_pos value)
{
    m_Marker_pos = value;
    m_set_State[0] |= 0x3;
}

inline
CHGVS_Coordinate_Base::TMarker_pos& CHGVS_Coordinate_Base::SetMarker_pos(void)
{
#ifdef _DEBUG
    if (!IsSetMarker_pos()) {
        memset(&m_Marker_pos,UnassignedByte(),sizeof(m_Marker_pos));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Marker_pos;
}

inline
bool CHGVS_Coordinate_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHGVS_Coordinate_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CHGVS_Coordinate_Base::TTitle& CHGVS_Coordinate_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(1);
    }
    return m_Title;
}

inline
void CHGVS_Coordinate_Base::SetTitle(const CHGVS_Coordinate_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0xc;
}

inline
void CHGVS_Coordinate_Base::SetTitle(CHGVS_Coordinate_Base::TTitle&& value)
{
    m_Title = std::forward<CHGVS_Coordinate_Base::TTitle>(value);
    m_set_State[0] |= 0xc;
}

inline
CHGVS_Coordinate_Base::TTitle& CHGVS_Coordinate_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Title;
}

inline
bool CHGVS_Coordinate_Base::IsSetObject_id(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHGVS_Coordinate_Base::CanGetObject_id(void) const
{
    return IsSetObject_id();
}

inline
const CHGVS_Coordinate_Base::TObject_id& CHGVS_Coordinate_Base::GetObject_id(void) const
{
    if (!CanGetObject_id()) {
        ThrowUnassigned(2);
    }
    return m_Object_id;
}

inline
void CHGVS_Coordinate_Base::SetObject_id(const CHGVS_Coordinate_Base::TObject_id& value)
{
    m_Object_id = value;
    m_set_State[0] |= 0x30;
}

inline
void CHGVS_Coordinate_Base::SetObject_id(CHGVS_Coordinate_Base::TObject_id&& value)
{
    m_Object_id = std::forward<CHGVS_Coordinate_Base::TObject_id>(value);
    m_set_State[0] |= 0x30;
}

inline
CHGVS_Coordinate_Base::TObject_id& CHGVS_Coordinate_Base::SetObject_id(void)
{
#ifdef _DEBUG
    if (!IsSetObject_id()) {
        m_Object_id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Object_id;
}

inline
bool CHGVS_Coordinate_Base::IsSetPos_mapped(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CHGVS_Coordinate_Base::CanGetPos_mapped(void) const
{
    return IsSetPos_mapped();
}

inline
void CHGVS_Coordinate_Base::ResetPos_mapped(void)
{
    m_Pos_mapped = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CHGVS_Coordinate_Base::TPos_mapped CHGVS_Coordinate_Base::GetPos_mapped(void) const
{
    if (!CanGetPos_mapped()) {
        ThrowUnassigned(3);
    }
    return m_Pos_mapped;
}

inline
void CHGVS_Coordinate_Base::SetPos_mapped(CHGVS_Coordinate_Base::TPos_mapped value)
{
    m_Pos_mapped = value;
    m_set_State[0] |= 0xc0;
}

inline
CHGVS_Coordinate_Base::TPos_mapped& CHGVS_Coordinate_Base::SetPos_mapped(void)
{
#ifdef _DEBUG
    if (!IsSetPos_mapped()) {
        memset(&m_Pos_mapped,UnassignedByte(),sizeof(m_Pos_mapped));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Pos_mapped;
}

inline
bool CHGVS_Coordinate_Base::IsSetHgvs_position(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CHGVS_Coordinate_Base::CanGetHgvs_position(void) const
{
    return IsSetHgvs_position();
}

inline
const CHGVS_Coordinate_Base::THgvs_position& CHGVS_Coordinate_Base::GetHgvs_position(void) const
{
    if (!CanGetHgvs_position()) {
        ThrowUnassigned(4);
    }
    return m_Hgvs_position;
}

inline
void CHGVS_Coordinate_Base::SetHgvs_position(const CHGVS_Coordinate_Base::THgvs_position& value)
{
    m_Hgvs_position = value;
    m_set_State[0] |= 0x300;
}

inline
void CHGVS_Coordinate_Base::SetHgvs_position(CHGVS_Coordinate_Base::THgvs_position&& value)
{
    m_Hgvs_position = std::forward<CHGVS_Coordinate_Base::THgvs_position>(value);
    m_set_State[0] |= 0x300;
}

inline
CHGVS_Coordinate_Base::THgvs_position& CHGVS_Coordinate_Base::SetHgvs_position(void)
{
#ifdef _DEBUG
    if (!IsSetHgvs_position()) {
        m_Hgvs_position = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Hgvs_position;
}

inline
bool CHGVS_Coordinate_Base::IsSetSequence(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CHGVS_Coordinate_Base::CanGetSequence(void) const
{
    return IsSetSequence();
}

inline
const CHGVS_Coordinate_Base::TSequence& CHGVS_Coordinate_Base::GetSequence(void) const
{
    if (!CanGetSequence()) {
        ThrowUnassigned(5);
    }
    return m_Sequence;
}

inline
void CHGVS_Coordinate_Base::SetSequence(const CHGVS_Coordinate_Base::TSequence& value)
{
    m_Sequence = value;
    m_set_State[0] |= 0xc00;
}

inline
void CHGVS_Coordinate_Base::SetSequence(CHGVS_Coordinate_Base::TSequence&& value)
{
    m_Sequence = std::forward<CHGVS_Coordinate_Base::TSequence>(value);
    m_set_State[0] |= 0xc00;
}

inline
CHGVS_Coordinate_Base::TSequence& CHGVS_Coordinate_Base::SetSequence(void)
{
#ifdef _DEBUG
    if (!IsSetSequence()) {
        m_Sequence = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Sequence;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_COORDS_HGVS_COORDINATE_BASE_HPP
