/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Rs_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_RS_BASE_HPP
#define OBJECTS_DOCSUM_RS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAssembly;
class CPrimarySequence;
class CRsLinkout;
class CRsStruct;
class CSs;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///defines the docsum structure for refSNP clusters, where a refSNP
///				cluster (rs) is a grouping of individual dbSNP submissions that all refer to the
///				same variation. The refsnp provides a single unified record for annotation of NCBI
///				resources such as reference genome sequence.
class NCBI_DOCSUM_EXPORT CRs_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRs_Base(void);
    // destructor
    virtual ~CRs_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_snpClass {
            eAttlist_snpClass_snp                          = 1,
            eAttlist_snpClass_in_del                       = 2,
            eAttlist_snpClass_heterozygous                 = 3,
            eAttlist_snpClass_microsatellite               = 4,
            eAttlist_snpClass_named_locus                  = 5,
            eAttlist_snpClass_no_variation                 = 6,
            eAttlist_snpClass_mixed                        = 7,
            eAttlist_snpClass_multinucleotide_polymorphism = 8
        };
        
        /// Access to EAttlist_snpClass's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_snpClass)(void);
        
        enum EAttlist_snpType {
            eAttlist_snpType_notwithdrawn         = 1,
            eAttlist_snpType_artifact             = 2,
            eAttlist_snpType_gene_duplication     = 3,
            eAttlist_snpType_duplicate_submission = 4,
            eAttlist_snpType_notspecified         = 5,
            eAttlist_snpType_ambiguous_location   = 6,
            eAttlist_snpType_low_map_quality      = 7
        };
        
        /// Access to EAttlist_snpType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_snpType)(void);
        
        enum EAttlist_molType {
            eAttlist_molType_genomic = 1,
            eAttlist_molType_cDNA    = 2,
            eAttlist_molType_mito    = 3,
            eAttlist_molType_chloro  = 4,
            eAttlist_molType_unknown = 5
        };
        
        /// Access to EAttlist_molType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_molType)(void);
        
        // types
        typedef int TRsId;
        typedef EAttlist_snpClass TSnpClass;
        typedef EAttlist_snpType TSnpType;
        typedef EAttlist_molType TMolType;
        typedef int TValidProbMin;
        typedef int TValidProbMax;
        typedef bool TGenotype;
        typedef string TBitField;
        typedef int TTaxId;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_rsId,
            e_snpClass,
            e_snpType,
            e_molType,
            e_validProbMin,
            e_validProbMax,
            e_genotype,
            e_bitField,
            e_taxId
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;
    
        // getters
        // setters
    
        ///refSNP (rs) number
        /// mandatory
        /// typedef int TRsId
        ///  Check whether the RsId data member has been assigned a value.
        bool IsSetRsId(void) const;
        /// Check whether it is safe or not to call GetRsId method.
        bool CanGetRsId(void) const;
        void ResetRsId(void);
        TRsId GetRsId(void) const;
        void SetRsId(TRsId value);
        TRsId& SetRsId(void);
    
        /// mandatory
        /// typedef EAttlist_snpClass TSnpClass
        ///  Check whether the SnpClass data member has been assigned a value.
        bool IsSetSnpClass(void) const;
        /// Check whether it is safe or not to call GetSnpClass method.
        bool CanGetSnpClass(void) const;
        void ResetSnpClass(void);
        TSnpClass GetSnpClass(void) const;
        void SetSnpClass(TSnpClass value);
        TSnpClass& SetSnpClass(void);
    
        /// mandatory
        /// typedef EAttlist_snpType TSnpType
        ///  Check whether the SnpType data member has been assigned a value.
        bool IsSetSnpType(void) const;
        /// Check whether it is safe or not to call GetSnpType method.
        bool CanGetSnpType(void) const;
        void ResetSnpType(void);
        TSnpType GetSnpType(void) const;
        void SetSnpType(TSnpType value);
        TSnpType& SetSnpType(void);
    
        /// mandatory
        /// typedef EAttlist_molType TMolType
        ///  Check whether the MolType data member has been assigned a value.
        bool IsSetMolType(void) const;
        /// Check whether it is safe or not to call GetMolType method.
        bool CanGetMolType(void) const;
        void ResetMolType(void);
        TMolType GetMolType(void) const;
        void SetMolType(TMolType value);
        TMolType& SetMolType(void);
    
        ///minimum reported success rate of all submissions in
        ///						cluster
        /// optional
        /// typedef int TValidProbMin
        ///  Check whether the ValidProbMin data member has been assigned a value.
        bool IsSetValidProbMin(void) const;
        /// Check whether it is safe or not to call GetValidProbMin method.
        bool CanGetValidProbMin(void) const;
        void ResetValidProbMin(void);
        TValidProbMin GetValidProbMin(void) const;
        void SetValidProbMin(TValidProbMin value);
        TValidProbMin& SetValidProbMin(void);
    
        ///maximum reported success rate of all submissions in
        ///						cluster
        /// optional
        /// typedef int TValidProbMax
        ///  Check whether the ValidProbMax data member has been assigned a value.
        bool IsSetValidProbMax(void) const;
        /// Check whether it is safe or not to call GetValidProbMax method.
        bool CanGetValidProbMax(void) const;
        void ResetValidProbMax(void);
        TValidProbMax GetValidProbMax(void) const;
        void SetValidProbMax(TValidProbMax value);
        TValidProbMax& SetValidProbMax(void);
    
        ///at least one genotype reported for this
        ///						refSNP
        /// optional
        /// typedef bool TGenotype
        ///  Check whether the Genotype data member has been assigned a value.
        bool IsSetGenotype(void) const;
        /// Check whether it is safe or not to call GetGenotype method.
        bool CanGetGenotype(void) const;
        void ResetGenotype(void);
        TGenotype GetGenotype(void) const;
        void SetGenotype(TGenotype value);
        TGenotype& SetGenotype(void);
    
        /// optional
        /// typedef string TBitField
        ///  Check whether the BitField data member has been assigned a value.
        bool IsSetBitField(void) const;
        /// Check whether it is safe or not to call GetBitField method.
        bool CanGetBitField(void) const;
        void ResetBitField(void);
        const TBitField& GetBitField(void) const;
        void SetBitField(const TBitField& value);
        void SetBitField(TBitField&& value);
        TBitField& SetBitField(void);
    
        /// optional
        /// typedef int TTaxId
        ///  Check whether the TaxId data member has been assigned a value.
        bool IsSetTaxId(void) const;
        /// Check whether it is safe or not to call GetTaxId method.
        bool CanGetTaxId(void) const;
        void ResetTaxId(void);
        TTaxId GetTaxId(void) const;
        void SetTaxId(TTaxId value);
        TTaxId& SetTaxId(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        int m_RsId;
        EAttlist_snpClass m_SnpClass;
        EAttlist_snpType m_SnpType;
        EAttlist_molType m_MolType;
        int m_ValidProbMin;
        int m_ValidProbMax;
        bool m_Genotype;
        string m_BitField;
        int m_TaxId;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Het : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Het(void);
        // destructor
        ~C_Het(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            ///Est=Estimated average het from allele
            ///									frequencies, Obs=Observed from genotype data
            enum EHet_attlist_type {
                eHet_attlist_type_est = 1,
                eHet_attlist_type_obs = 2
            };
            
            /// Access to EHet_attlist_type's attributes (values, names) as defined in spec
            static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EHet_attlist_type)(void);
            
            // types
            typedef EHet_attlist_type TType;
            typedef double TValue;
            typedef double TStdError;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_type,
                e_value,
                e_stdError
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef EHet_attlist_type TType
            ///  Check whether the Type data member has been assigned a value.
            bool IsSetType(void) const;
            /// Check whether it is safe or not to call GetType method.
            bool CanGetType(void) const;
            void ResetType(void);
            TType GetType(void) const;
            void SetType(TType value);
            TType& SetType(void);
        
            ///Heterozygosity
            /// mandatory
            /// typedef double TValue
            ///  Check whether the Value data member has been assigned a value.
            bool IsSetValue(void) const;
            /// Check whether it is safe or not to call GetValue method.
            bool CanGetValue(void) const;
            void ResetValue(void);
            TValue GetValue(void) const;
            void SetValue(TValue value);
            TValue& SetValue(void);
        
            ///Standard error of Het
            ///									estimate
            /// optional
            /// typedef double TStdError
            ///  Check whether the StdError data member has been assigned a value.
            bool IsSetStdError(void) const;
            /// Check whether it is safe or not to call GetStdError method.
            bool CanGetStdError(void) const;
            void ResetStdError(void);
            TStdError GetStdError(void) const;
            void SetStdError(TStdError value);
            TStdError& SetStdError(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            EHet_attlist_type m_Type;
            double m_Value;
            double m_StdError;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_het
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        /// mandatory
        ///  Check whether the Het data member has been assigned a value.
        bool IsSetHet(void) const;
        /// Check whether it is safe or not to call GetHet method.
        bool CanGetHet(void) const;
        void ResetHet(void);
        void SetHet(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Het(const C_Het&);
        C_Het& operator=(const C_Het&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Validation : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Validation(void);
        // destructor
        ~C_Validation(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef bool TByCluster;
            typedef bool TByFrequency;
            typedef bool TByOtherPop;
            typedef bool TBy2Hit2Allele;
            typedef bool TByHapMap;
            typedef bool TBy1000G;
            typedef bool TSuspect;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_byCluster,
                e_byFrequency,
                e_byOtherPop,
                e_by2Hit2Allele,
                e_byHapMap,
                e_by1000G,
                e_suspect
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;
        
            // getters
            // setters
        
            ///at least one subsnp in cluster has frequency data
            ///									submitted
            /// optional
            /// typedef bool TByCluster
            ///  Check whether the ByCluster data member has been assigned a value.
            bool IsSetByCluster(void) const;
            /// Check whether it is safe or not to call GetByCluster method.
            bool CanGetByCluster(void) const;
            void ResetByCluster(void);
            TByCluster GetByCluster(void) const;
            void SetByCluster(TByCluster value);
            TByCluster& SetByCluster(void);
        
            ///Validated by allele frequency
            /// optional
            /// typedef bool TByFrequency
            ///  Check whether the ByFrequency data member has been assigned a value.
            bool IsSetByFrequency(void) const;
            /// Check whether it is safe or not to call GetByFrequency method.
            bool CanGetByFrequency(void) const;
            void ResetByFrequency(void);
            TByFrequency GetByFrequency(void) const;
            void SetByFrequency(TByFrequency value);
            TByFrequency& SetByFrequency(void);
        
            /// optional
            /// typedef bool TByOtherPop
            ///  Check whether the ByOtherPop data member has been assigned a value.
            bool IsSetByOtherPop(void) const;
            /// Check whether it is safe or not to call GetByOtherPop method.
            bool CanGetByOtherPop(void) const;
            void ResetByOtherPop(void);
            TByOtherPop GetByOtherPop(void) const;
            void SetByOtherPop(TByOtherPop value);
            TByOtherPop& SetByOtherPop(void);
        
            ///cluster has 2+ submissions, with 1+ submissions
            ///									assayed with a non-computational method
            /// optional
            /// typedef bool TBy2Hit2Allele
            ///  Check whether the By2Hit2Allele data member has been assigned a value.
            bool IsSetBy2Hit2Allele(void) const;
            /// Check whether it is safe or not to call GetBy2Hit2Allele method.
            bool CanGetBy2Hit2Allele(void) const;
            void ResetBy2Hit2Allele(void);
            TBy2Hit2Allele GetBy2Hit2Allele(void) const;
            void SetBy2Hit2Allele(TBy2Hit2Allele value);
            TBy2Hit2Allele& SetBy2Hit2Allele(void);
        
            ///Validated by HapMap Project 
            /// optional
            /// typedef bool TByHapMap
            ///  Check whether the ByHapMap data member has been assigned a value.
            bool IsSetByHapMap(void) const;
            /// Check whether it is safe or not to call GetByHapMap method.
            bool CanGetByHapMap(void) const;
            void ResetByHapMap(void);
            TByHapMap GetByHapMap(void) const;
            void SetByHapMap(TByHapMap value);
            TByHapMap& SetByHapMap(void);
        
            ///Validated by 1000 Genomes Project
            /// optional
            /// typedef bool TBy1000G
            ///  Check whether the By1000G data member has been assigned a value.
            bool IsSetBy1000G(void) const;
            /// Check whether it is safe or not to call GetBy1000G method.
            bool CanGetBy1000G(void) const;
            void ResetBy1000G(void);
            TBy1000G GetBy1000G(void) const;
            void SetBy1000G(TBy1000G value);
            TBy1000G& SetBy1000G(void);
        
            ///Suspected to be false SNP
            /// optional
            /// typedef bool TSuspect
            ///  Check whether the Suspect data member has been assigned a value.
            bool IsSetSuspect(void) const;
            /// Check whether it is safe or not to call GetSuspect method.
            bool CanGetSuspect(void) const;
            void ResetSuspect(void);
            TSuspect GetSuspect(void) const;
            void SetSuspect(TSuspect value);
            TSuspect& SetSuspect(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            bool m_ByCluster;
            bool m_ByFrequency;
            bool m_ByOtherPop;
            bool m_By2Hit2Allele;
            bool m_ByHapMap;
            bool m_By1000G;
            bool m_Suspect;
        };
        // types
        typedef C_Attlist TAttlist;
        typedef list< int > TOtherPopBatchId;
        typedef list< int > TTwoHit2AlleleBatchId;
        typedef list< int > TFrequencyClass;
        typedef list< int > THapMapPhase;
        typedef list< int > TTGPPhase;
        typedef list< string > TSuspectEvidence;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_otherPopBatchId,
            e_twoHit2AlleleBatchId,
            e_frequencyClass,
            e_hapMapPhase,
            e_tGPPhase,
            e_suspectEvidence
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        ///dbSNP batch-id's for other pop snp validation
        ///										data.
        /// optional
        /// typedef list< int > TOtherPopBatchId
        ///  Check whether the OtherPopBatchId data member has been assigned a value.
        bool IsSetOtherPopBatchId(void) const;
        /// Check whether it is safe or not to call GetOtherPopBatchId method.
        bool CanGetOtherPopBatchId(void) const;
        void ResetOtherPopBatchId(void);
        const TOtherPopBatchId& GetOtherPopBatchId(void) const;
        TOtherPopBatchId& SetOtherPopBatchId(void);
    
        ///dbSNP batch-id's for double-hit snp
        ///										validation data. Use batch-id to get methods, etc.
        /// optional
        /// typedef list< int > TTwoHit2AlleleBatchId
        ///  Check whether the TwoHit2AlleleBatchId data member has been assigned a value.
        bool IsSetTwoHit2AlleleBatchId(void) const;
        /// Check whether it is safe or not to call GetTwoHit2AlleleBatchId method.
        bool CanGetTwoHit2AlleleBatchId(void) const;
        void ResetTwoHit2AlleleBatchId(void);
        const TTwoHit2AlleleBatchId& GetTwoHit2AlleleBatchId(void) const;
        TTwoHit2AlleleBatchId& SetTwoHit2AlleleBatchId(void);
    
        ///Frequency validation class (1) low frequency
        ///										variation that is cited in journal and other reputable
        ///										sources (2) greater than 5 percent minor allele freq in each
        ///										and all populations (4) greater than 5 percent minor allele
        ///										freq in 1+ populations (8) if the variant has 2+ minor
        ///										allele count based on freq or genotype data (16) less than 1
        ///										percent minor allele freq in each and all populations (32)
        ///										less than 1 percent minor freq in 1+ populations
        /// optional
        /// typedef list< int > TFrequencyClass
        ///  Check whether the FrequencyClass data member has been assigned a value.
        bool IsSetFrequencyClass(void) const;
        /// Check whether it is safe or not to call GetFrequencyClass method.
        bool CanGetFrequencyClass(void) const;
        void ResetFrequencyClass(void);
        const TFrequencyClass& GetFrequencyClass(void) const;
        TFrequencyClass& SetFrequencyClass(void);
    
        ///alidated by HapMap Project phase1-genotyped
        ///										(1), Phase 1 genotyped; filtered, non-redundant
        ///										phase2-genotyped (2), Phase 2 genotyped; filtered,
        ///										non-redundant phase3-genotyped (4) Phase 3 genotyped;
        ///										filtered, non-redundant 
        /// optional
        /// typedef list< int > THapMapPhase
        ///  Check whether the HapMapPhase data member has been assigned a value.
        bool IsSetHapMapPhase(void) const;
        /// Check whether it is safe or not to call GetHapMapPhase method.
        bool CanGetHapMapPhase(void) const;
        void ResetHapMapPhase(void);
        const THapMapPhase& GetHapMapPhase(void) const;
        THapMapPhase& SetHapMapPhase(void);
    
        ///Validated by 1000 Genomes Project (TGP) pilot
        ///										1 (1), pilot 2 (2), pilot 3 (4) 
        /// optional
        /// typedef list< int > TTGPPhase
        ///  Check whether the TGPPhase data member has been assigned a value.
        bool IsSetTGPPhase(void) const;
        /// Check whether it is safe or not to call GetTGPPhase method.
        bool CanGetTGPPhase(void) const;
        void ResetTGPPhase(void);
        const TTGPPhase& GetTGPPhase(void) const;
        TTGPPhase& SetTGPPhase(void);
    
        ///Suspected to be false SNP evidence Single
        ///										Nucleotide Difference - paralogous genes (1), Genotype or
        ///										base calling errors (2), Submission evidence or errors (4),
        ///										Others (8) 
        /// optional
        /// typedef list< string > TSuspectEvidence
        ///  Check whether the SuspectEvidence data member has been assigned a value.
        bool IsSetSuspectEvidence(void) const;
        /// Check whether it is safe or not to call GetSuspectEvidence method.
        bool CanGetSuspectEvidence(void) const;
        void ResetSuspectEvidence(void);
        const TSuspectEvidence& GetSuspectEvidence(void) const;
        TSuspectEvidence& SetSuspectEvidence(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Validation(const C_Validation&);
        C_Validation& operator=(const C_Validation&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
        list< int > m_OtherPopBatchId;
        list< int > m_TwoHit2AlleleBatchId;
        list< int > m_FrequencyClass;
        list< int > m_HapMapPhase;
        list< int > m_TGPPhase;
        list< string > m_SuspectEvidence;
    };
    /////////////////////////////////////////////////////////////////////////////
    ///date the refsnp cluster was
    ///							instantiated
    ///date the refsnp cluster was
    ///							instantiated
    class NCBI_DOCSUM_EXPORT C_Create : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Create(void);
        // destructor
        ~C_Create(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef int TBuild;
            typedef string TDate;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_build,
                e_date
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            ///build number when the cluster was
            ///									created
            /// optional
            /// typedef int TBuild
            ///  Check whether the Build data member has been assigned a value.
            bool IsSetBuild(void) const;
            /// Check whether it is safe or not to call GetBuild method.
            bool CanGetBuild(void) const;
            void ResetBuild(void);
            TBuild GetBuild(void) const;
            void SetBuild(TBuild value);
            TBuild& SetBuild(void);
        
            ///yyyy-mm-dd
            /// optional
            /// typedef string TDate
            ///  Check whether the Date data member has been assigned a value.
            bool IsSetDate(void) const;
            /// Check whether it is safe or not to call GetDate method.
            bool CanGetDate(void) const;
            void ResetDate(void);
            const TDate& GetDate(void) const;
            void SetDate(const TDate& value);
            void SetDate(TDate&& value);
            TDate& SetDate(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            int m_Build;
            string m_Date;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_create
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        ///date the refsnp cluster was
        ///							instantiated
        /// mandatory
        ///  Check whether the Create data member has been assigned a value.
        bool IsSetCreate(void) const;
        /// Check whether it is safe or not to call GetCreate method.
        bool CanGetCreate(void) const;
        void ResetCreate(void);
        void SetCreate(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Create(const C_Create&);
        C_Create& operator=(const C_Create&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    /////////////////////////////////////////////////////////////////////////////
    ///most recent date the cluster was updated (member added or
    ///							deleted)
    ///most recent date the cluster was updated (member added or
    ///							deleted)
    class NCBI_DOCSUM_EXPORT C_Update : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Update(void);
        // destructor
        ~C_Update(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef int TBuild;
            typedef string TDate;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_build,
                e_date
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            ///build number when the cluster was
            ///									updated
            /// optional
            /// typedef int TBuild
            ///  Check whether the Build data member has been assigned a value.
            bool IsSetBuild(void) const;
            /// Check whether it is safe or not to call GetBuild method.
            bool CanGetBuild(void) const;
            void ResetBuild(void);
            TBuild GetBuild(void) const;
            void SetBuild(TBuild value);
            TBuild& SetBuild(void);
        
            ///yyyy-mm-dd
            /// optional
            /// typedef string TDate
            ///  Check whether the Date data member has been assigned a value.
            bool IsSetDate(void) const;
            /// Check whether it is safe or not to call GetDate method.
            bool CanGetDate(void) const;
            void ResetDate(void);
            const TDate& GetDate(void) const;
            void SetDate(const TDate& value);
            void SetDate(TDate&& value);
            TDate& SetDate(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            int m_Build;
            string m_Date;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_update
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        ///most recent date the cluster was updated (member added or
        ///							deleted)
        /// mandatory
        ///  Check whether the Update data member has been assigned a value.
        bool IsSetUpdate(void) const;
        /// Check whether it is safe or not to call GetUpdate method.
        bool CanGetUpdate(void) const;
        void ResetUpdate(void);
        void SetUpdate(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Update(const C_Update&);
        C_Update& operator=(const C_Update&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Sequence : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Sequence(void);
        // destructor
        ~C_Sequence(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef Int8 TExemplarSs;
            typedef string TAncestralAllele;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_exemplarSs,
                e_ancestralAllele
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            ///dbSNP ss# selected as source of refSNP flanking
            ///									sequence, ss# part of ss-list below 
            /// mandatory
            /// typedef Int8 TExemplarSs
            ///  Check whether the ExemplarSs data member has been assigned a value.
            bool IsSetExemplarSs(void) const;
            /// Check whether it is safe or not to call GetExemplarSs method.
            bool CanGetExemplarSs(void) const;
            void ResetExemplarSs(void);
            TExemplarSs GetExemplarSs(void) const;
            void SetExemplarSs(TExemplarSs value);
            TExemplarSs& SetExemplarSs(void);
        
            /// optional
            /// typedef string TAncestralAllele
            ///  Check whether the AncestralAllele data member has been assigned a value.
            bool IsSetAncestralAllele(void) const;
            /// Check whether it is safe or not to call GetAncestralAllele method.
            bool CanGetAncestralAllele(void) const;
            void ResetAncestralAllele(void);
            const TAncestralAllele& GetAncestralAllele(void) const;
            void SetAncestralAllele(const TAncestralAllele& value);
            void SetAncestralAllele(TAncestralAllele&& value);
            TAncestralAllele& SetAncestralAllele(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            Int8 m_ExemplarSs;
            string m_AncestralAllele;
        };
        // types
        typedef C_Attlist TAttlist;
        typedef string TSeq5;
        typedef string TObserved;
        typedef string TSeq3;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_seq5,
            e_observed,
            e_seq3
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        ///5' sequence that flanks the
        ///										variation
        /// optional
        /// typedef string TSeq5
        ///  Check whether the Seq5 data member has been assigned a value.
        bool IsSetSeq5(void) const;
        /// Check whether it is safe or not to call GetSeq5 method.
        bool CanGetSeq5(void) const;
        void ResetSeq5(void);
        const TSeq5& GetSeq5(void) const;
        void SetSeq5(const TSeq5& value);
        void SetSeq5(TSeq5&& value);
        TSeq5& SetSeq5(void);
    
        ///list of all nucleotide alleles observed in
        ///										ss-list members, correcting for reverse complementation of
        ///										members reported in reverse orientation
        /// mandatory
        /// typedef string TObserved
        ///  Check whether the Observed data member has been assigned a value.
        bool IsSetObserved(void) const;
        /// Check whether it is safe or not to call GetObserved method.
        bool CanGetObserved(void) const;
        void ResetObserved(void);
        const TObserved& GetObserved(void) const;
        void SetObserved(const TObserved& value);
        void SetObserved(TObserved&& value);
        TObserved& SetObserved(void);
    
        ///3' sequence that flanks the
        ///										variation
        /// optional
        /// typedef string TSeq3
        ///  Check whether the Seq3 data member has been assigned a value.
        bool IsSetSeq3(void) const;
        /// Check whether it is safe or not to call GetSeq3 method.
        bool CanGetSeq3(void) const;
        void ResetSeq3(void);
        const TSeq3& GetSeq3(void) const;
        void SetSeq3(const TSeq3& value);
        void SetSeq3(TSeq3&& value);
        TSeq3& SetSeq3(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Sequence(const C_Sequence&);
        C_Sequence& operator=(const C_Sequence&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
        string m_Seq5;
        string m_Observed;
        string m_Seq3;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_E_MergeHistory : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_MergeHistory(void);
        // destructor
        ~C_E_MergeHistory(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef int TRsId;
            typedef int TBuildId;
            typedef bool TOrientFlip;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_rsId,
                e_buildId,
                e_orientFlip
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;
        
            // getters
            // setters
        
            ///previously issued rs id whose member assays have
            ///									now been merged
            /// mandatory
            /// typedef int TRsId
            ///  Check whether the RsId data member has been assigned a value.
            bool IsSetRsId(void) const;
            /// Check whether it is safe or not to call GetRsId method.
            bool CanGetRsId(void) const;
            void ResetRsId(void);
            TRsId GetRsId(void) const;
            void SetRsId(TRsId value);
            TRsId& SetRsId(void);
        
            ///build id when rs id was merged into parent
            ///									rs
            /// optional
            /// typedef int TBuildId
            ///  Check whether the BuildId data member has been assigned a value.
            bool IsSetBuildId(void) const;
            /// Check whether it is safe or not to call GetBuildId method.
            bool CanGetBuildId(void) const;
            void ResetBuildId(void);
            TBuildId GetBuildId(void) const;
            void SetBuildId(TBuildId value);
            TBuildId& SetBuildId(void);
        
            ///TRUE if strand of rs id is reverse to parent
            ///									object's current strand
            /// optional
            /// typedef bool TOrientFlip
            ///  Check whether the OrientFlip data member has been assigned a value.
            bool IsSetOrientFlip(void) const;
            /// Check whether it is safe or not to call GetOrientFlip method.
            bool CanGetOrientFlip(void) const;
            void ResetOrientFlip(void);
            TOrientFlip GetOrientFlip(void) const;
            void SetOrientFlip(TOrientFlip value);
            TOrientFlip& SetOrientFlip(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            int m_RsId;
            int m_BuildId;
            bool m_OrientFlip;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_mergeHistory
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        /// mandatory
        ///  Check whether the MergeHistory data member has been assigned a value.
        bool IsSetMergeHistory(void) const;
        /// Check whether it is safe or not to call GetMergeHistory method.
        bool CanGetMergeHistory(void) const;
        void ResetMergeHistory(void);
        void SetMergeHistory(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_E_MergeHistory(const C_E_MergeHistory&);
        C_E_MergeHistory& operator=(const C_E_MergeHistory&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_E_AlleleOrigin : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_AlleleOrigin(void);
        // destructor
        ~C_E_AlleleOrigin(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef string TAllele;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_allele
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
        
            // getters
            // setters
        
            /// optional
            /// typedef string TAllele
            ///  Check whether the Allele data member has been assigned a value.
            bool IsSetAllele(void) const;
            /// Check whether it is safe or not to call GetAllele method.
            bool CanGetAllele(void) const;
            void ResetAllele(void);
            const TAllele& GetAllele(void) const;
            void SetAllele(const TAllele& value);
            void SetAllele(TAllele&& value);
            TAllele& SetAllele(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            string m_Allele;
        };
        // types
        typedef C_Attlist TAttlist;
        typedef int TAlleleOrigin;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_alleleOrigin
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        ///							origin of this allele, if known
        ///							note that these are powers-of-two, and represent bits; thus, we can
        ///							represent more than one state simultaneously through a bitwise OR
        ///							unknown         (0),
        ///							germline        (1),
        ///							somatic         (2),
        ///							inherited       (4),
        ///							paternal        (8),
        ///							maternal        (16),
        ///							de-novo         (32),
        ///							biparental      (64),
        ///							uniparental     (128),
        ///							not-tested      (256),
        ///							tested-inconclusive (512),
        /// mandatory
        /// typedef int TAlleleOrigin
        ///  Check whether the AlleleOrigin data member has been assigned a value.
        bool IsSetAlleleOrigin(void) const;
        /// Check whether it is safe or not to call GetAlleleOrigin method.
        bool CanGetAlleleOrigin(void) const;
        void ResetAlleleOrigin(void);
        TAlleleOrigin GetAlleleOrigin(void) const;
        void SetAlleleOrigin(TAlleleOrigin value);
        TAlleleOrigin& SetAlleleOrigin(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_E_AlleleOrigin(const C_E_AlleleOrigin&);
        C_E_AlleleOrigin& operator=(const C_E_AlleleOrigin&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
        int m_AlleleOrigin;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_E_Phenotype : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_Phenotype(void);
        // destructor
        ~C_E_Phenotype(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef list< string > TClinicalSignificance;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_clinicalSignificance
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        ///										unknown                 (0),
        ///										untested                (1),
        ///										non-pathogenic          (2),
        ///										probable-non-pathogenic (3),
        ///										probable-pathogenic     (4),
        ///										pathogenic              (5),
        ///										drug response           (6),
        ///										other                   (255)
        /// optional
        /// typedef list< string > TClinicalSignificance
        ///  Check whether the ClinicalSignificance data member has been assigned a value.
        bool IsSetClinicalSignificance(void) const;
        /// Check whether it is safe or not to call GetClinicalSignificance method.
        bool CanGetClinicalSignificance(void) const;
        void ResetClinicalSignificance(void);
        const TClinicalSignificance& GetClinicalSignificance(void) const;
        TClinicalSignificance& SetClinicalSignificance(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_E_Phenotype(const C_E_Phenotype&);
        C_E_Phenotype& operator=(const C_E_Phenotype&);
    
        // data
        Uint4 m_set_State[1];
        list< string > m_ClinicalSignificance;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_E_BioSource : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_BioSource(void);
        // destructor
        ~C_E_BioSource(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef list< string > TGenome;
        typedef list< string > TOrigin;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_genome,
            e_origin
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        ///										unknown (0) ,
        ///										genomic (1) ,
        ///										chloroplast (2) ,
        ///										chromoplast (3) ,
        ///										kinetoplast (4) ,
        ///										mitochondrion (5) ,
        ///										plastid (6) ,
        ///										macronuclear (7) ,
        ///										extrachrom (8) ,
        ///										plasmid (9) ,
        ///										transposon (10) ,
        ///										insertion-seq (11) ,
        ///										cyanelle (12) ,
        ///										proviral (13) ,
        ///										virion (14) ,
        ///										nucleomorph (15) ,
        ///										apicoplast (16) ,
        ///										leucoplast (17) ,
        ///										proplastid (18) ,
        ///										endogenous-virus (19) ,
        ///										hydrogenosome (20) ,
        ///										chromosome (21) ,
        ///										chromatophore (22)
        /// optional
        /// typedef list< string > TGenome
        ///  Check whether the Genome data member has been assigned a value.
        bool IsSetGenome(void) const;
        /// Check whether it is safe or not to call GetGenome method.
        bool CanGetGenome(void) const;
        void ResetGenome(void);
        const TGenome& GetGenome(void) const;
        TGenome& SetGenome(void);
    
        ///										unknown (0) ,
        ///										natural (1) ,                    normal biological entity
        ///										natmut (2) ,                    naturally occurring mutant
        ///										mut (3) ,                        artificially mutagenized
        ///										artificial (4) ,                 artificially engineered
        ///										synthetic (5) ,                 purely synthetic
        ///										other (255)
        /// optional
        /// typedef list< string > TOrigin
        ///  Check whether the Origin data member has been assigned a value.
        bool IsSetOrigin(void) const;
        /// Check whether it is safe or not to call GetOrigin method.
        bool CanGetOrigin(void) const;
        void ResetOrigin(void);
        const TOrigin& GetOrigin(void) const;
        TOrigin& SetOrigin(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_E_BioSource(const C_E_BioSource&);
        C_E_BioSource& operator=(const C_E_BioSource&);
    
        // data
        Uint4 m_set_State[1];
        list< string > m_Genome;
        list< string > m_Origin;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_E_Frequency : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_Frequency(void);
        // destructor
        ~C_E_Frequency(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef double TFreq;
            typedef string TAllele;
            typedef int TPopId;
            typedef int TSampleSize;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_freq,
                e_allele,
                e_popId,
                e_sampleSize
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;
        
            // getters
            // setters
        
            /// optional
            /// typedef double TFreq
            ///  Check whether the Freq data member has been assigned a value.
            bool IsSetFreq(void) const;
            /// Check whether it is safe or not to call GetFreq method.
            bool CanGetFreq(void) const;
            void ResetFreq(void);
            TFreq GetFreq(void) const;
            void SetFreq(TFreq value);
            TFreq& SetFreq(void);
        
            /// optional
            /// typedef string TAllele
            ///  Check whether the Allele data member has been assigned a value.
            bool IsSetAllele(void) const;
            /// Check whether it is safe or not to call GetAllele method.
            bool CanGetAllele(void) const;
            void ResetAllele(void);
            const TAllele& GetAllele(void) const;
            void SetAllele(const TAllele& value);
            void SetAllele(TAllele&& value);
            TAllele& SetAllele(void);
        
            ///dbSNP Populaton ID
            /// optional
            /// typedef int TPopId
            ///  Check whether the PopId data member has been assigned a value.
            bool IsSetPopId(void) const;
            /// Check whether it is safe or not to call GetPopId method.
            bool CanGetPopId(void) const;
            void ResetPopId(void);
            TPopId GetPopId(void) const;
            void SetPopId(TPopId value);
            TPopId& SetPopId(void);
        
            /// optional
            /// typedef int TSampleSize
            ///  Check whether the SampleSize data member has been assigned a value.
            bool IsSetSampleSize(void) const;
            /// Check whether it is safe or not to call GetSampleSize method.
            bool CanGetSampleSize(void) const;
            void ResetSampleSize(void);
            TSampleSize GetSampleSize(void) const;
            void SetSampleSize(TSampleSize value);
            TSampleSize& SetSampleSize(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            double m_Freq;
            string m_Allele;
            int m_PopId;
            int m_SampleSize;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_frequency
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        /// mandatory
        ///  Check whether the Frequency data member has been assigned a value.
        bool IsSetFrequency(void) const;
        /// Check whether it is safe or not to call GetFrequency method.
        bool CanGetFrequency(void) const;
        void ResetFrequency(void);
        void SetFrequency(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_E_Frequency(const C_E_Frequency&);
        C_E_Frequency& operator=(const C_E_Frequency&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_Het THet;
    typedef C_Validation TValidation;
    typedef C_Create TCreate;
    typedef C_Update TUpdate;
    typedef C_Sequence TSequence;
    typedef list< CRef< CSs > > TSs;
    typedef list< CRef< CAssembly > > TAssembly;
    typedef list< CRef< CPrimarySequence > > TPrimarySequence;
    typedef list< CRef< CRsStruct > > TRsStruct;
    typedef list< CRef< CRsLinkout > > TRsLinkout;
    typedef C_E_MergeHistory C_E;
    typedef list< CRef< C_E_MergeHistory > > TMergeHistory;
    typedef list< string > THgvs;
    typedef list< CRef< C_E_AlleleOrigin > > TAlleleOrigin;
    typedef list< CRef< C_E_Phenotype > > TPhenotype;
    typedef list< CRef< C_E_BioSource > > TBioSource;
    typedef list< CRef< C_E_Frequency > > TFrequency;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_het,
        e_validation,
        e_create,
        e_update,
        e_sequence,
        e_ss,
        e_assembly,
        e_primarySequence,
        e_rsStruct,
        e_rsLinkout,
        e_mergeHistory,
        e_hgvs,
        e_alleleOrigin,
        e_phenotype,
        e_bioSource,
        e_frequency
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 18> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef C_Het THet
    ///  Check whether the Het data member has been assigned a value.
    bool IsSetHet(void) const;
    /// Check whether it is safe or not to call GetHet method.
    bool CanGetHet(void) const;
    void ResetHet(void);
    const THet& GetHet(void) const;
    void SetHet(THet& value);
    THet& SetHet(void);

    /// mandatory
    /// typedef C_Validation TValidation
    ///  Check whether the Validation data member has been assigned a value.
    bool IsSetValidation(void) const;
    /// Check whether it is safe or not to call GetValidation method.
    bool CanGetValidation(void) const;
    void ResetValidation(void);
    const TValidation& GetValidation(void) const;
    void SetValidation(TValidation& value);
    TValidation& SetValidation(void);

    /// mandatory
    /// typedef C_Create TCreate
    ///  Check whether the Create data member has been assigned a value.
    bool IsSetCreate(void) const;
    /// Check whether it is safe or not to call GetCreate method.
    bool CanGetCreate(void) const;
    void ResetCreate(void);
    const TCreate& GetCreate(void) const;
    void SetCreate(TCreate& value);
    TCreate& SetCreate(void);

    /// optional
    /// typedef C_Update TUpdate
    ///  Check whether the Update data member has been assigned a value.
    bool IsSetUpdate(void) const;
    /// Check whether it is safe or not to call GetUpdate method.
    bool CanGetUpdate(void) const;
    void ResetUpdate(void);
    const TUpdate& GetUpdate(void) const;
    void SetUpdate(TUpdate& value);
    TUpdate& SetUpdate(void);

    /// mandatory
    /// typedef C_Sequence TSequence
    ///  Check whether the Sequence data member has been assigned a value.
    bool IsSetSequence(void) const;
    /// Check whether it is safe or not to call GetSequence method.
    bool CanGetSequence(void) const;
    void ResetSequence(void);
    const TSequence& GetSequence(void) const;
    void SetSequence(TSequence& value);
    TSequence& SetSequence(void);

    /// mandatory
    /// typedef list< CRef< CSs > > TSs
    ///  Check whether the Ss data member has been assigned a value.
    bool IsSetSs(void) const;
    /// Check whether it is safe or not to call GetSs method.
    bool CanGetSs(void) const;
    void ResetSs(void);
    const TSs& GetSs(void) const;
    TSs& SetSs(void);

    /// optional
    /// typedef list< CRef< CAssembly > > TAssembly
    ///  Check whether the Assembly data member has been assigned a value.
    bool IsSetAssembly(void) const;
    /// Check whether it is safe or not to call GetAssembly method.
    bool CanGetAssembly(void) const;
    void ResetAssembly(void);
    const TAssembly& GetAssembly(void) const;
    TAssembly& SetAssembly(void);

    /// optional
    /// typedef list< CRef< CPrimarySequence > > TPrimarySequence
    ///  Check whether the PrimarySequence data member has been assigned a value.
    bool IsSetPrimarySequence(void) const;
    /// Check whether it is safe or not to call GetPrimarySequence method.
    bool CanGetPrimarySequence(void) const;
    void ResetPrimarySequence(void);
    const TPrimarySequence& GetPrimarySequence(void) const;
    TPrimarySequence& SetPrimarySequence(void);

    /// optional
    /// typedef list< CRef< CRsStruct > > TRsStruct
    ///  Check whether the RsStruct data member has been assigned a value.
    bool IsSetRsStruct(void) const;
    /// Check whether it is safe or not to call GetRsStruct method.
    bool CanGetRsStruct(void) const;
    void ResetRsStruct(void);
    const TRsStruct& GetRsStruct(void) const;
    TRsStruct& SetRsStruct(void);

    /// optional
    /// typedef list< CRef< CRsLinkout > > TRsLinkout
    ///  Check whether the RsLinkout data member has been assigned a value.
    bool IsSetRsLinkout(void) const;
    /// Check whether it is safe or not to call GetRsLinkout method.
    bool CanGetRsLinkout(void) const;
    void ResetRsLinkout(void);
    const TRsLinkout& GetRsLinkout(void) const;
    TRsLinkout& SetRsLinkout(void);

    /// optional
    /// typedef list< CRef< C_E_MergeHistory > > TMergeHistory
    ///  Check whether the MergeHistory data member has been assigned a value.
    bool IsSetMergeHistory(void) const;
    /// Check whether it is safe or not to call GetMergeHistory method.
    bool CanGetMergeHistory(void) const;
    void ResetMergeHistory(void);
    const TMergeHistory& GetMergeHistory(void) const;
    TMergeHistory& SetMergeHistory(void);

    /// HGVS name list 
    /// optional
    /// typedef list< string > THgvs
    ///  Check whether the Hgvs data member has been assigned a value.
    bool IsSetHgvs(void) const;
    /// Check whether it is safe or not to call GetHgvs method.
    bool CanGetHgvs(void) const;
    void ResetHgvs(void);
    const THgvs& GetHgvs(void) const;
    THgvs& SetHgvs(void);

    /// optional
    /// typedef list< CRef< C_E_AlleleOrigin > > TAlleleOrigin
    ///  Check whether the AlleleOrigin data member has been assigned a value.
    bool IsSetAlleleOrigin(void) const;
    /// Check whether it is safe or not to call GetAlleleOrigin method.
    bool CanGetAlleleOrigin(void) const;
    void ResetAlleleOrigin(void);
    const TAlleleOrigin& GetAlleleOrigin(void) const;
    TAlleleOrigin& SetAlleleOrigin(void);

    /// optional
    /// typedef list< CRef< C_E_Phenotype > > TPhenotype
    ///  Check whether the Phenotype data member has been assigned a value.
    bool IsSetPhenotype(void) const;
    /// Check whether it is safe or not to call GetPhenotype method.
    bool CanGetPhenotype(void) const;
    void ResetPhenotype(void);
    const TPhenotype& GetPhenotype(void) const;
    TPhenotype& SetPhenotype(void);

    /// optional
    /// typedef list< CRef< C_E_BioSource > > TBioSource
    ///  Check whether the BioSource data member has been assigned a value.
    bool IsSetBioSource(void) const;
    /// Check whether it is safe or not to call GetBioSource method.
    bool CanGetBioSource(void) const;
    void ResetBioSource(void);
    const TBioSource& GetBioSource(void) const;
    TBioSource& SetBioSource(void);

    /// optional
    /// typedef list< CRef< C_E_Frequency > > TFrequency
    ///  Check whether the Frequency data member has been assigned a value.
    bool IsSetFrequency(void) const;
    /// Check whether it is safe or not to call GetFrequency method.
    bool CanGetFrequency(void) const;
    void ResetFrequency(void);
    const TFrequency& GetFrequency(void) const;
    TFrequency& SetFrequency(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRs_Base(const CRs_Base&);
    CRs_Base& operator=(const CRs_Base&);

    // data
    Uint4 m_set_State[2];
    CRef< TAttlist > m_Attlist;
    CRef< THet > m_Het;
    CRef< TValidation > m_Validation;
    CRef< TCreate > m_Create;
    CRef< TUpdate > m_Update;
    CRef< TSequence > m_Sequence;
    list< CRef< CSs > > m_Ss;
    list< CRef< CAssembly > > m_Assembly;
    list< CRef< CPrimarySequence > > m_PrimarySequence;
    list< CRef< CRsStruct > > m_RsStruct;
    list< CRef< CRsLinkout > > m_RsLinkout;
    list< CRef< C_E_MergeHistory > > m_MergeHistory;
    list< string > m_Hgvs;
    list< CRef< C_E_AlleleOrigin > > m_AlleleOrigin;
    list< CRef< C_E_Phenotype > > m_Phenotype;
    list< CRef< C_E_BioSource > > m_BioSource;
    list< CRef< C_E_Frequency > > m_Frequency;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRs_Base::C_Attlist::IsSetRsId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetRsId(void) const
{
    return IsSetRsId();
}

inline
void CRs_Base::C_Attlist::ResetRsId(void)
{
    m_RsId = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRs_Base::C_Attlist::TRsId CRs_Base::C_Attlist::GetRsId(void) const
{
    if (!CanGetRsId()) {
        ThrowUnassigned(0);
    }
    return m_RsId;
}

inline
void CRs_Base::C_Attlist::SetRsId(CRs_Base::C_Attlist::TRsId value)
{
    m_RsId = value;
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_Attlist::TRsId& CRs_Base::C_Attlist::SetRsId(void)
{
#ifdef _DEBUG
    if (!IsSetRsId()) {
        memset(&m_RsId,UnassignedByte(),sizeof(m_RsId));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_RsId;
}

inline
bool CRs_Base::C_Attlist::IsSetSnpClass(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetSnpClass(void) const
{
    return IsSetSnpClass();
}

inline
void CRs_Base::C_Attlist::ResetSnpClass(void)
{
    m_SnpClass = (EAttlist_snpClass)(0);
    m_set_State[0] &= ~0xc;
}

inline
CRs_Base::C_Attlist::TSnpClass CRs_Base::C_Attlist::GetSnpClass(void) const
{
    if (!CanGetSnpClass()) {
        ThrowUnassigned(1);
    }
    return m_SnpClass;
}

inline
void CRs_Base::C_Attlist::SetSnpClass(CRs_Base::C_Attlist::TSnpClass value)
{
    m_SnpClass = value;
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_Attlist::TSnpClass& CRs_Base::C_Attlist::SetSnpClass(void)
{
#ifdef _DEBUG
    if (!IsSetSnpClass()) {
        memset(&m_SnpClass,UnassignedByte(),sizeof(m_SnpClass));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_SnpClass;
}

inline
bool CRs_Base::C_Attlist::IsSetSnpType(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetSnpType(void) const
{
    return IsSetSnpType();
}

inline
void CRs_Base::C_Attlist::ResetSnpType(void)
{
    m_SnpType = (EAttlist_snpType)(0);
    m_set_State[0] &= ~0x30;
}

inline
CRs_Base::C_Attlist::TSnpType CRs_Base::C_Attlist::GetSnpType(void) const
{
    if (!CanGetSnpType()) {
        ThrowUnassigned(2);
    }
    return m_SnpType;
}

inline
void CRs_Base::C_Attlist::SetSnpType(CRs_Base::C_Attlist::TSnpType value)
{
    m_SnpType = value;
    m_set_State[0] |= 0x30;
}

inline
CRs_Base::C_Attlist::TSnpType& CRs_Base::C_Attlist::SetSnpType(void)
{
#ifdef _DEBUG
    if (!IsSetSnpType()) {
        memset(&m_SnpType,UnassignedByte(),sizeof(m_SnpType));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_SnpType;
}

inline
bool CRs_Base::C_Attlist::IsSetMolType(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetMolType(void) const
{
    return IsSetMolType();
}

inline
void CRs_Base::C_Attlist::ResetMolType(void)
{
    m_MolType = (EAttlist_molType)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CRs_Base::C_Attlist::TMolType CRs_Base::C_Attlist::GetMolType(void) const
{
    if (!CanGetMolType()) {
        ThrowUnassigned(3);
    }
    return m_MolType;
}

inline
void CRs_Base::C_Attlist::SetMolType(CRs_Base::C_Attlist::TMolType value)
{
    m_MolType = value;
    m_set_State[0] |= 0xc0;
}

inline
CRs_Base::C_Attlist::TMolType& CRs_Base::C_Attlist::SetMolType(void)
{
#ifdef _DEBUG
    if (!IsSetMolType()) {
        memset(&m_MolType,UnassignedByte(),sizeof(m_MolType));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_MolType;
}

inline
bool CRs_Base::C_Attlist::IsSetValidProbMin(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetValidProbMin(void) const
{
    return IsSetValidProbMin();
}

inline
void CRs_Base::C_Attlist::ResetValidProbMin(void)
{
    m_ValidProbMin = 0;
    m_set_State[0] &= ~0x300;
}

inline
CRs_Base::C_Attlist::TValidProbMin CRs_Base::C_Attlist::GetValidProbMin(void) const
{
    if (!CanGetValidProbMin()) {
        ThrowUnassigned(4);
    }
    return m_ValidProbMin;
}

inline
void CRs_Base::C_Attlist::SetValidProbMin(CRs_Base::C_Attlist::TValidProbMin value)
{
    m_ValidProbMin = value;
    m_set_State[0] |= 0x300;
}

inline
CRs_Base::C_Attlist::TValidProbMin& CRs_Base::C_Attlist::SetValidProbMin(void)
{
#ifdef _DEBUG
    if (!IsSetValidProbMin()) {
        memset(&m_ValidProbMin,UnassignedByte(),sizeof(m_ValidProbMin));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_ValidProbMin;
}

inline
bool CRs_Base::C_Attlist::IsSetValidProbMax(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetValidProbMax(void) const
{
    return IsSetValidProbMax();
}

inline
void CRs_Base::C_Attlist::ResetValidProbMax(void)
{
    m_ValidProbMax = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CRs_Base::C_Attlist::TValidProbMax CRs_Base::C_Attlist::GetValidProbMax(void) const
{
    if (!CanGetValidProbMax()) {
        ThrowUnassigned(5);
    }
    return m_ValidProbMax;
}

inline
void CRs_Base::C_Attlist::SetValidProbMax(CRs_Base::C_Attlist::TValidProbMax value)
{
    m_ValidProbMax = value;
    m_set_State[0] |= 0xc00;
}

inline
CRs_Base::C_Attlist::TValidProbMax& CRs_Base::C_Attlist::SetValidProbMax(void)
{
#ifdef _DEBUG
    if (!IsSetValidProbMax()) {
        memset(&m_ValidProbMax,UnassignedByte(),sizeof(m_ValidProbMax));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_ValidProbMax;
}

inline
bool CRs_Base::C_Attlist::IsSetGenotype(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetGenotype(void) const
{
    return IsSetGenotype();
}

inline
void CRs_Base::C_Attlist::ResetGenotype(void)
{
    m_Genotype = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CRs_Base::C_Attlist::TGenotype CRs_Base::C_Attlist::GetGenotype(void) const
{
    if (!CanGetGenotype()) {
        ThrowUnassigned(6);
    }
    return m_Genotype;
}

inline
void CRs_Base::C_Attlist::SetGenotype(CRs_Base::C_Attlist::TGenotype value)
{
    m_Genotype = value;
    m_set_State[0] |= 0x3000;
}

inline
CRs_Base::C_Attlist::TGenotype& CRs_Base::C_Attlist::SetGenotype(void)
{
#ifdef _DEBUG
    if (!IsSetGenotype()) {
        memset(&m_Genotype,UnassignedByte(),sizeof(m_Genotype));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Genotype;
}

inline
bool CRs_Base::C_Attlist::IsSetBitField(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetBitField(void) const
{
    return IsSetBitField();
}

inline
const CRs_Base::C_Attlist::TBitField& CRs_Base::C_Attlist::GetBitField(void) const
{
    if (!CanGetBitField()) {
        ThrowUnassigned(7);
    }
    return m_BitField;
}

inline
void CRs_Base::C_Attlist::SetBitField(const CRs_Base::C_Attlist::TBitField& value)
{
    m_BitField = value;
    m_set_State[0] |= 0xc000;
}

inline
void CRs_Base::C_Attlist::SetBitField(CRs_Base::C_Attlist::TBitField&& value)
{
    m_BitField = std::forward<CRs_Base::C_Attlist::TBitField>(value);
    m_set_State[0] |= 0xc000;
}

inline
CRs_Base::C_Attlist::TBitField& CRs_Base::C_Attlist::SetBitField(void)
{
#ifdef _DEBUG
    if (!IsSetBitField()) {
        m_BitField = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_BitField;
}

inline
bool CRs_Base::C_Attlist::IsSetTaxId(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CRs_Base::C_Attlist::CanGetTaxId(void) const
{
    return IsSetTaxId();
}

inline
void CRs_Base::C_Attlist::ResetTaxId(void)
{
    m_TaxId = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CRs_Base::C_Attlist::TTaxId CRs_Base::C_Attlist::GetTaxId(void) const
{
    if (!CanGetTaxId()) {
        ThrowUnassigned(8);
    }
    return m_TaxId;
}

inline
void CRs_Base::C_Attlist::SetTaxId(CRs_Base::C_Attlist::TTaxId value)
{
    m_TaxId = value;
    m_set_State[0] |= 0x30000;
}

inline
CRs_Base::C_Attlist::TTaxId& CRs_Base::C_Attlist::SetTaxId(void)
{
#ifdef _DEBUG
    if (!IsSetTaxId()) {
        memset(&m_TaxId,UnassignedByte(),sizeof(m_TaxId));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_TaxId;
}

inline
bool CRs_Base::C_Het::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_Het::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
void CRs_Base::C_Het::C_Attlist::ResetType(void)
{
    m_Type = (EHet_attlist_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CRs_Base::C_Het::C_Attlist::TType CRs_Base::C_Het::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CRs_Base::C_Het::C_Attlist::SetType(CRs_Base::C_Het::C_Attlist::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_Het::C_Attlist::TType& CRs_Base::C_Het::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CRs_Base::C_Het::C_Attlist::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Het::C_Attlist::CanGetValue(void) const
{
    return IsSetValue();
}

inline
void CRs_Base::C_Het::C_Attlist::ResetValue(void)
{
    m_Value = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRs_Base::C_Het::C_Attlist::TValue CRs_Base::C_Het::C_Attlist::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CRs_Base::C_Het::C_Attlist::SetValue(CRs_Base::C_Het::C_Attlist::TValue value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_Het::C_Attlist::TValue& CRs_Base::C_Het::C_Attlist::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        memset(&m_Value,UnassignedByte(),sizeof(m_Value));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

inline
bool CRs_Base::C_Het::C_Attlist::IsSetStdError(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRs_Base::C_Het::C_Attlist::CanGetStdError(void) const
{
    return IsSetStdError();
}

inline
void CRs_Base::C_Het::C_Attlist::ResetStdError(void)
{
    m_StdError = 0;
    m_set_State[0] &= ~0x30;
}

inline
CRs_Base::C_Het::C_Attlist::TStdError CRs_Base::C_Het::C_Attlist::GetStdError(void) const
{
    if (!CanGetStdError()) {
        ThrowUnassigned(2);
    }
    return m_StdError;
}

inline
void CRs_Base::C_Het::C_Attlist::SetStdError(CRs_Base::C_Het::C_Attlist::TStdError value)
{
    m_StdError = value;
    m_set_State[0] |= 0x30;
}

inline
CRs_Base::C_Het::C_Attlist::TStdError& CRs_Base::C_Het::C_Attlist::SetStdError(void)
{
#ifdef _DEBUG
    if (!IsSetStdError()) {
        memset(&m_StdError,UnassignedByte(),sizeof(m_StdError));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_StdError;
}

inline
bool CRs_Base::C_Het::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::C_Het::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::C_Het::TAttlist& CRs_Base::C_Het::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_Het*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::C_Het::TAttlist& CRs_Base::C_Het::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::C_Het::IsSetHet(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Het::CanGetHet(void) const
{
    return false;
}

inline
void CRs_Base::C_Het::ResetHet(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CRs_Base::C_Het::SetHet(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CRs_Base::C_Validation::C_Attlist::IsSetByCluster(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_Validation::C_Attlist::CanGetByCluster(void) const
{
    return IsSetByCluster();
}

inline
void CRs_Base::C_Validation::C_Attlist::ResetByCluster(void)
{
    m_ByCluster = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRs_Base::C_Validation::C_Attlist::TByCluster CRs_Base::C_Validation::C_Attlist::GetByCluster(void) const
{
    if (!CanGetByCluster()) {
        ThrowUnassigned(0);
    }
    return m_ByCluster;
}

inline
void CRs_Base::C_Validation::C_Attlist::SetByCluster(CRs_Base::C_Validation::C_Attlist::TByCluster value)
{
    m_ByCluster = value;
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_Validation::C_Attlist::TByCluster& CRs_Base::C_Validation::C_Attlist::SetByCluster(void)
{
#ifdef _DEBUG
    if (!IsSetByCluster()) {
        memset(&m_ByCluster,UnassignedByte(),sizeof(m_ByCluster));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_ByCluster;
}

inline
bool CRs_Base::C_Validation::C_Attlist::IsSetByFrequency(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Validation::C_Attlist::CanGetByFrequency(void) const
{
    return IsSetByFrequency();
}

inline
void CRs_Base::C_Validation::C_Attlist::ResetByFrequency(void)
{
    m_ByFrequency = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRs_Base::C_Validation::C_Attlist::TByFrequency CRs_Base::C_Validation::C_Attlist::GetByFrequency(void) const
{
    if (!CanGetByFrequency()) {
        ThrowUnassigned(1);
    }
    return m_ByFrequency;
}

inline
void CRs_Base::C_Validation::C_Attlist::SetByFrequency(CRs_Base::C_Validation::C_Attlist::TByFrequency value)
{
    m_ByFrequency = value;
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_Validation::C_Attlist::TByFrequency& CRs_Base::C_Validation::C_Attlist::SetByFrequency(void)
{
#ifdef _DEBUG
    if (!IsSetByFrequency()) {
        memset(&m_ByFrequency,UnassignedByte(),sizeof(m_ByFrequency));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ByFrequency;
}

inline
bool CRs_Base::C_Validation::C_Attlist::IsSetByOtherPop(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRs_Base::C_Validation::C_Attlist::CanGetByOtherPop(void) const
{
    return IsSetByOtherPop();
}

inline
void CRs_Base::C_Validation::C_Attlist::ResetByOtherPop(void)
{
    m_ByOtherPop = 0;
    m_set_State[0] &= ~0x30;
}

inline
CRs_Base::C_Validation::C_Attlist::TByOtherPop CRs_Base::C_Validation::C_Attlist::GetByOtherPop(void) const
{
    if (!CanGetByOtherPop()) {
        ThrowUnassigned(2);
    }
    return m_ByOtherPop;
}

inline
void CRs_Base::C_Validation::C_Attlist::SetByOtherPop(CRs_Base::C_Validation::C_Attlist::TByOtherPop value)
{
    m_ByOtherPop = value;
    m_set_State[0] |= 0x30;
}

inline
CRs_Base::C_Validation::C_Attlist::TByOtherPop& CRs_Base::C_Validation::C_Attlist::SetByOtherPop(void)
{
#ifdef _DEBUG
    if (!IsSetByOtherPop()) {
        memset(&m_ByOtherPop,UnassignedByte(),sizeof(m_ByOtherPop));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_ByOtherPop;
}

inline
bool CRs_Base::C_Validation::C_Attlist::IsSetBy2Hit2Allele(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRs_Base::C_Validation::C_Attlist::CanGetBy2Hit2Allele(void) const
{
    return IsSetBy2Hit2Allele();
}

inline
void CRs_Base::C_Validation::C_Attlist::ResetBy2Hit2Allele(void)
{
    m_By2Hit2Allele = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CRs_Base::C_Validation::C_Attlist::TBy2Hit2Allele CRs_Base::C_Validation::C_Attlist::GetBy2Hit2Allele(void) const
{
    if (!CanGetBy2Hit2Allele()) {
        ThrowUnassigned(3);
    }
    return m_By2Hit2Allele;
}

inline
void CRs_Base::C_Validation::C_Attlist::SetBy2Hit2Allele(CRs_Base::C_Validation::C_Attlist::TBy2Hit2Allele value)
{
    m_By2Hit2Allele = value;
    m_set_State[0] |= 0xc0;
}

inline
CRs_Base::C_Validation::C_Attlist::TBy2Hit2Allele& CRs_Base::C_Validation::C_Attlist::SetBy2Hit2Allele(void)
{
#ifdef _DEBUG
    if (!IsSetBy2Hit2Allele()) {
        memset(&m_By2Hit2Allele,UnassignedByte(),sizeof(m_By2Hit2Allele));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_By2Hit2Allele;
}

inline
bool CRs_Base::C_Validation::C_Attlist::IsSetByHapMap(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CRs_Base::C_Validation::C_Attlist::CanGetByHapMap(void) const
{
    return IsSetByHapMap();
}

inline
void CRs_Base::C_Validation::C_Attlist::ResetByHapMap(void)
{
    m_ByHapMap = 0;
    m_set_State[0] &= ~0x300;
}

inline
CRs_Base::C_Validation::C_Attlist::TByHapMap CRs_Base::C_Validation::C_Attlist::GetByHapMap(void) const
{
    if (!CanGetByHapMap()) {
        ThrowUnassigned(4);
    }
    return m_ByHapMap;
}

inline
void CRs_Base::C_Validation::C_Attlist::SetByHapMap(CRs_Base::C_Validation::C_Attlist::TByHapMap value)
{
    m_ByHapMap = value;
    m_set_State[0] |= 0x300;
}

inline
CRs_Base::C_Validation::C_Attlist::TByHapMap& CRs_Base::C_Validation::C_Attlist::SetByHapMap(void)
{
#ifdef _DEBUG
    if (!IsSetByHapMap()) {
        memset(&m_ByHapMap,UnassignedByte(),sizeof(m_ByHapMap));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_ByHapMap;
}

inline
bool CRs_Base::C_Validation::C_Attlist::IsSetBy1000G(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CRs_Base::C_Validation::C_Attlist::CanGetBy1000G(void) const
{
    return IsSetBy1000G();
}

inline
void CRs_Base::C_Validation::C_Attlist::ResetBy1000G(void)
{
    m_By1000G = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CRs_Base::C_Validation::C_Attlist::TBy1000G CRs_Base::C_Validation::C_Attlist::GetBy1000G(void) const
{
    if (!CanGetBy1000G()) {
        ThrowUnassigned(5);
    }
    return m_By1000G;
}

inline
void CRs_Base::C_Validation::C_Attlist::SetBy1000G(CRs_Base::C_Validation::C_Attlist::TBy1000G value)
{
    m_By1000G = value;
    m_set_State[0] |= 0xc00;
}

inline
CRs_Base::C_Validation::C_Attlist::TBy1000G& CRs_Base::C_Validation::C_Attlist::SetBy1000G(void)
{
#ifdef _DEBUG
    if (!IsSetBy1000G()) {
        memset(&m_By1000G,UnassignedByte(),sizeof(m_By1000G));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_By1000G;
}

inline
bool CRs_Base::C_Validation::C_Attlist::IsSetSuspect(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CRs_Base::C_Validation::C_Attlist::CanGetSuspect(void) const
{
    return IsSetSuspect();
}

inline
void CRs_Base::C_Validation::C_Attlist::ResetSuspect(void)
{
    m_Suspect = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CRs_Base::C_Validation::C_Attlist::TSuspect CRs_Base::C_Validation::C_Attlist::GetSuspect(void) const
{
    if (!CanGetSuspect()) {
        ThrowUnassigned(6);
    }
    return m_Suspect;
}

inline
void CRs_Base::C_Validation::C_Attlist::SetSuspect(CRs_Base::C_Validation::C_Attlist::TSuspect value)
{
    m_Suspect = value;
    m_set_State[0] |= 0x3000;
}

inline
CRs_Base::C_Validation::C_Attlist::TSuspect& CRs_Base::C_Validation::C_Attlist::SetSuspect(void)
{
#ifdef _DEBUG
    if (!IsSetSuspect()) {
        memset(&m_Suspect,UnassignedByte(),sizeof(m_Suspect));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Suspect;
}

inline
bool CRs_Base::C_Validation::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::C_Validation::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::C_Validation::TAttlist& CRs_Base::C_Validation::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_Validation*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::C_Validation::TAttlist& CRs_Base::C_Validation::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::C_Validation::IsSetOtherPopBatchId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Validation::CanGetOtherPopBatchId(void) const
{
    return true;
}

inline
const CRs_Base::C_Validation::TOtherPopBatchId& CRs_Base::C_Validation::GetOtherPopBatchId(void) const
{
    return m_OtherPopBatchId;
}

inline
CRs_Base::C_Validation::TOtherPopBatchId& CRs_Base::C_Validation::SetOtherPopBatchId(void)
{
    m_set_State[0] |= 0x4;
    return m_OtherPopBatchId;
}

inline
bool CRs_Base::C_Validation::IsSetTwoHit2AlleleBatchId(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRs_Base::C_Validation::CanGetTwoHit2AlleleBatchId(void) const
{
    return true;
}

inline
const CRs_Base::C_Validation::TTwoHit2AlleleBatchId& CRs_Base::C_Validation::GetTwoHit2AlleleBatchId(void) const
{
    return m_TwoHit2AlleleBatchId;
}

inline
CRs_Base::C_Validation::TTwoHit2AlleleBatchId& CRs_Base::C_Validation::SetTwoHit2AlleleBatchId(void)
{
    m_set_State[0] |= 0x10;
    return m_TwoHit2AlleleBatchId;
}

inline
bool CRs_Base::C_Validation::IsSetFrequencyClass(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRs_Base::C_Validation::CanGetFrequencyClass(void) const
{
    return true;
}

inline
const CRs_Base::C_Validation::TFrequencyClass& CRs_Base::C_Validation::GetFrequencyClass(void) const
{
    return m_FrequencyClass;
}

inline
CRs_Base::C_Validation::TFrequencyClass& CRs_Base::C_Validation::SetFrequencyClass(void)
{
    m_set_State[0] |= 0x40;
    return m_FrequencyClass;
}

inline
bool CRs_Base::C_Validation::IsSetHapMapPhase(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CRs_Base::C_Validation::CanGetHapMapPhase(void) const
{
    return true;
}

inline
const CRs_Base::C_Validation::THapMapPhase& CRs_Base::C_Validation::GetHapMapPhase(void) const
{
    return m_HapMapPhase;
}

inline
CRs_Base::C_Validation::THapMapPhase& CRs_Base::C_Validation::SetHapMapPhase(void)
{
    m_set_State[0] |= 0x100;
    return m_HapMapPhase;
}

inline
bool CRs_Base::C_Validation::IsSetTGPPhase(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CRs_Base::C_Validation::CanGetTGPPhase(void) const
{
    return true;
}

inline
const CRs_Base::C_Validation::TTGPPhase& CRs_Base::C_Validation::GetTGPPhase(void) const
{
    return m_TGPPhase;
}

inline
CRs_Base::C_Validation::TTGPPhase& CRs_Base::C_Validation::SetTGPPhase(void)
{
    m_set_State[0] |= 0x400;
    return m_TGPPhase;
}

inline
bool CRs_Base::C_Validation::IsSetSuspectEvidence(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CRs_Base::C_Validation::CanGetSuspectEvidence(void) const
{
    return true;
}

inline
const CRs_Base::C_Validation::TSuspectEvidence& CRs_Base::C_Validation::GetSuspectEvidence(void) const
{
    return m_SuspectEvidence;
}

inline
CRs_Base::C_Validation::TSuspectEvidence& CRs_Base::C_Validation::SetSuspectEvidence(void)
{
    m_set_State[0] |= 0x1000;
    return m_SuspectEvidence;
}

inline
bool CRs_Base::C_Create::C_Attlist::IsSetBuild(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_Create::C_Attlist::CanGetBuild(void) const
{
    return IsSetBuild();
}

inline
void CRs_Base::C_Create::C_Attlist::ResetBuild(void)
{
    m_Build = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRs_Base::C_Create::C_Attlist::TBuild CRs_Base::C_Create::C_Attlist::GetBuild(void) const
{
    if (!CanGetBuild()) {
        ThrowUnassigned(0);
    }
    return m_Build;
}

inline
void CRs_Base::C_Create::C_Attlist::SetBuild(CRs_Base::C_Create::C_Attlist::TBuild value)
{
    m_Build = value;
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_Create::C_Attlist::TBuild& CRs_Base::C_Create::C_Attlist::SetBuild(void)
{
#ifdef _DEBUG
    if (!IsSetBuild()) {
        memset(&m_Build,UnassignedByte(),sizeof(m_Build));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Build;
}

inline
bool CRs_Base::C_Create::C_Attlist::IsSetDate(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Create::C_Attlist::CanGetDate(void) const
{
    return IsSetDate();
}

inline
const CRs_Base::C_Create::C_Attlist::TDate& CRs_Base::C_Create::C_Attlist::GetDate(void) const
{
    if (!CanGetDate()) {
        ThrowUnassigned(1);
    }
    return m_Date;
}

inline
void CRs_Base::C_Create::C_Attlist::SetDate(const CRs_Base::C_Create::C_Attlist::TDate& value)
{
    m_Date = value;
    m_set_State[0] |= 0xc;
}

inline
void CRs_Base::C_Create::C_Attlist::SetDate(CRs_Base::C_Create::C_Attlist::TDate&& value)
{
    m_Date = std::forward<CRs_Base::C_Create::C_Attlist::TDate>(value);
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_Create::C_Attlist::TDate& CRs_Base::C_Create::C_Attlist::SetDate(void)
{
#ifdef _DEBUG
    if (!IsSetDate()) {
        m_Date = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Date;
}

inline
bool CRs_Base::C_Create::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::C_Create::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::C_Create::TAttlist& CRs_Base::C_Create::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_Create*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::C_Create::TAttlist& CRs_Base::C_Create::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::C_Create::IsSetCreate(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Create::CanGetCreate(void) const
{
    return false;
}

inline
void CRs_Base::C_Create::ResetCreate(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CRs_Base::C_Create::SetCreate(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CRs_Base::C_Update::C_Attlist::IsSetBuild(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_Update::C_Attlist::CanGetBuild(void) const
{
    return IsSetBuild();
}

inline
void CRs_Base::C_Update::C_Attlist::ResetBuild(void)
{
    m_Build = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRs_Base::C_Update::C_Attlist::TBuild CRs_Base::C_Update::C_Attlist::GetBuild(void) const
{
    if (!CanGetBuild()) {
        ThrowUnassigned(0);
    }
    return m_Build;
}

inline
void CRs_Base::C_Update::C_Attlist::SetBuild(CRs_Base::C_Update::C_Attlist::TBuild value)
{
    m_Build = value;
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_Update::C_Attlist::TBuild& CRs_Base::C_Update::C_Attlist::SetBuild(void)
{
#ifdef _DEBUG
    if (!IsSetBuild()) {
        memset(&m_Build,UnassignedByte(),sizeof(m_Build));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Build;
}

inline
bool CRs_Base::C_Update::C_Attlist::IsSetDate(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Update::C_Attlist::CanGetDate(void) const
{
    return IsSetDate();
}

inline
const CRs_Base::C_Update::C_Attlist::TDate& CRs_Base::C_Update::C_Attlist::GetDate(void) const
{
    if (!CanGetDate()) {
        ThrowUnassigned(1);
    }
    return m_Date;
}

inline
void CRs_Base::C_Update::C_Attlist::SetDate(const CRs_Base::C_Update::C_Attlist::TDate& value)
{
    m_Date = value;
    m_set_State[0] |= 0xc;
}

inline
void CRs_Base::C_Update::C_Attlist::SetDate(CRs_Base::C_Update::C_Attlist::TDate&& value)
{
    m_Date = std::forward<CRs_Base::C_Update::C_Attlist::TDate>(value);
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_Update::C_Attlist::TDate& CRs_Base::C_Update::C_Attlist::SetDate(void)
{
#ifdef _DEBUG
    if (!IsSetDate()) {
        m_Date = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Date;
}

inline
bool CRs_Base::C_Update::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::C_Update::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::C_Update::TAttlist& CRs_Base::C_Update::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_Update*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::C_Update::TAttlist& CRs_Base::C_Update::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::C_Update::IsSetUpdate(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Update::CanGetUpdate(void) const
{
    return false;
}

inline
void CRs_Base::C_Update::ResetUpdate(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CRs_Base::C_Update::SetUpdate(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CRs_Base::C_Sequence::C_Attlist::IsSetExemplarSs(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_Sequence::C_Attlist::CanGetExemplarSs(void) const
{
    return IsSetExemplarSs();
}

inline
void CRs_Base::C_Sequence::C_Attlist::ResetExemplarSs(void)
{
    m_ExemplarSs = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRs_Base::C_Sequence::C_Attlist::TExemplarSs CRs_Base::C_Sequence::C_Attlist::GetExemplarSs(void) const
{
    if (!CanGetExemplarSs()) {
        ThrowUnassigned(0);
    }
    return m_ExemplarSs;
}

inline
void CRs_Base::C_Sequence::C_Attlist::SetExemplarSs(CRs_Base::C_Sequence::C_Attlist::TExemplarSs value)
{
    m_ExemplarSs = value;
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_Sequence::C_Attlist::TExemplarSs& CRs_Base::C_Sequence::C_Attlist::SetExemplarSs(void)
{
#ifdef _DEBUG
    if (!IsSetExemplarSs()) {
        memset(&m_ExemplarSs,UnassignedByte(),sizeof(m_ExemplarSs));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_ExemplarSs;
}

inline
bool CRs_Base::C_Sequence::C_Attlist::IsSetAncestralAllele(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Sequence::C_Attlist::CanGetAncestralAllele(void) const
{
    return IsSetAncestralAllele();
}

inline
const CRs_Base::C_Sequence::C_Attlist::TAncestralAllele& CRs_Base::C_Sequence::C_Attlist::GetAncestralAllele(void) const
{
    if (!CanGetAncestralAllele()) {
        ThrowUnassigned(1);
    }
    return m_AncestralAllele;
}

inline
void CRs_Base::C_Sequence::C_Attlist::SetAncestralAllele(const CRs_Base::C_Sequence::C_Attlist::TAncestralAllele& value)
{
    m_AncestralAllele = value;
    m_set_State[0] |= 0xc;
}

inline
void CRs_Base::C_Sequence::C_Attlist::SetAncestralAllele(CRs_Base::C_Sequence::C_Attlist::TAncestralAllele&& value)
{
    m_AncestralAllele = std::forward<CRs_Base::C_Sequence::C_Attlist::TAncestralAllele>(value);
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_Sequence::C_Attlist::TAncestralAllele& CRs_Base::C_Sequence::C_Attlist::SetAncestralAllele(void)
{
#ifdef _DEBUG
    if (!IsSetAncestralAllele()) {
        m_AncestralAllele = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_AncestralAllele;
}

inline
bool CRs_Base::C_Sequence::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::C_Sequence::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::C_Sequence::TAttlist& CRs_Base::C_Sequence::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_Sequence*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::C_Sequence::TAttlist& CRs_Base::C_Sequence::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::C_Sequence::IsSetSeq5(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_Sequence::CanGetSeq5(void) const
{
    return IsSetSeq5();
}

inline
const CRs_Base::C_Sequence::TSeq5& CRs_Base::C_Sequence::GetSeq5(void) const
{
    if (!CanGetSeq5()) {
        ThrowUnassigned(1);
    }
    return m_Seq5;
}

inline
void CRs_Base::C_Sequence::SetSeq5(const CRs_Base::C_Sequence::TSeq5& value)
{
    m_Seq5 = value;
    m_set_State[0] |= 0xc;
}

inline
void CRs_Base::C_Sequence::SetSeq5(CRs_Base::C_Sequence::TSeq5&& value)
{
    m_Seq5 = std::forward<CRs_Base::C_Sequence::TSeq5>(value);
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_Sequence::TSeq5& CRs_Base::C_Sequence::SetSeq5(void)
{
#ifdef _DEBUG
    if (!IsSetSeq5()) {
        m_Seq5 = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Seq5;
}

inline
bool CRs_Base::C_Sequence::IsSetObserved(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRs_Base::C_Sequence::CanGetObserved(void) const
{
    return IsSetObserved();
}

inline
const CRs_Base::C_Sequence::TObserved& CRs_Base::C_Sequence::GetObserved(void) const
{
    if (!CanGetObserved()) {
        ThrowUnassigned(2);
    }
    return m_Observed;
}

inline
void CRs_Base::C_Sequence::SetObserved(const CRs_Base::C_Sequence::TObserved& value)
{
    m_Observed = value;
    m_set_State[0] |= 0x30;
}

inline
void CRs_Base::C_Sequence::SetObserved(CRs_Base::C_Sequence::TObserved&& value)
{
    m_Observed = std::forward<CRs_Base::C_Sequence::TObserved>(value);
    m_set_State[0] |= 0x30;
}

inline
CRs_Base::C_Sequence::TObserved& CRs_Base::C_Sequence::SetObserved(void)
{
#ifdef _DEBUG
    if (!IsSetObserved()) {
        m_Observed = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Observed;
}

inline
bool CRs_Base::C_Sequence::IsSetSeq3(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRs_Base::C_Sequence::CanGetSeq3(void) const
{
    return IsSetSeq3();
}

inline
const CRs_Base::C_Sequence::TSeq3& CRs_Base::C_Sequence::GetSeq3(void) const
{
    if (!CanGetSeq3()) {
        ThrowUnassigned(3);
    }
    return m_Seq3;
}

inline
void CRs_Base::C_Sequence::SetSeq3(const CRs_Base::C_Sequence::TSeq3& value)
{
    m_Seq3 = value;
    m_set_State[0] |= 0xc0;
}

inline
void CRs_Base::C_Sequence::SetSeq3(CRs_Base::C_Sequence::TSeq3&& value)
{
    m_Seq3 = std::forward<CRs_Base::C_Sequence::TSeq3>(value);
    m_set_State[0] |= 0xc0;
}

inline
CRs_Base::C_Sequence::TSeq3& CRs_Base::C_Sequence::SetSeq3(void)
{
#ifdef _DEBUG
    if (!IsSetSeq3()) {
        m_Seq3 = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Seq3;
}

inline
bool CRs_Base::C_E_MergeHistory::C_Attlist::IsSetRsId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_E_MergeHistory::C_Attlist::CanGetRsId(void) const
{
    return IsSetRsId();
}

inline
void CRs_Base::C_E_MergeHistory::C_Attlist::ResetRsId(void)
{
    m_RsId = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRs_Base::C_E_MergeHistory::C_Attlist::TRsId CRs_Base::C_E_MergeHistory::C_Attlist::GetRsId(void) const
{
    if (!CanGetRsId()) {
        ThrowUnassigned(0);
    }
    return m_RsId;
}

inline
void CRs_Base::C_E_MergeHistory::C_Attlist::SetRsId(CRs_Base::C_E_MergeHistory::C_Attlist::TRsId value)
{
    m_RsId = value;
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_E_MergeHistory::C_Attlist::TRsId& CRs_Base::C_E_MergeHistory::C_Attlist::SetRsId(void)
{
#ifdef _DEBUG
    if (!IsSetRsId()) {
        memset(&m_RsId,UnassignedByte(),sizeof(m_RsId));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_RsId;
}

inline
bool CRs_Base::C_E_MergeHistory::C_Attlist::IsSetBuildId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_E_MergeHistory::C_Attlist::CanGetBuildId(void) const
{
    return IsSetBuildId();
}

inline
void CRs_Base::C_E_MergeHistory::C_Attlist::ResetBuildId(void)
{
    m_BuildId = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRs_Base::C_E_MergeHistory::C_Attlist::TBuildId CRs_Base::C_E_MergeHistory::C_Attlist::GetBuildId(void) const
{
    if (!CanGetBuildId()) {
        ThrowUnassigned(1);
    }
    return m_BuildId;
}

inline
void CRs_Base::C_E_MergeHistory::C_Attlist::SetBuildId(CRs_Base::C_E_MergeHistory::C_Attlist::TBuildId value)
{
    m_BuildId = value;
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_E_MergeHistory::C_Attlist::TBuildId& CRs_Base::C_E_MergeHistory::C_Attlist::SetBuildId(void)
{
#ifdef _DEBUG
    if (!IsSetBuildId()) {
        memset(&m_BuildId,UnassignedByte(),sizeof(m_BuildId));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_BuildId;
}

inline
bool CRs_Base::C_E_MergeHistory::C_Attlist::IsSetOrientFlip(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRs_Base::C_E_MergeHistory::C_Attlist::CanGetOrientFlip(void) const
{
    return IsSetOrientFlip();
}

inline
void CRs_Base::C_E_MergeHistory::C_Attlist::ResetOrientFlip(void)
{
    m_OrientFlip = 0;
    m_set_State[0] &= ~0x30;
}

inline
CRs_Base::C_E_MergeHistory::C_Attlist::TOrientFlip CRs_Base::C_E_MergeHistory::C_Attlist::GetOrientFlip(void) const
{
    if (!CanGetOrientFlip()) {
        ThrowUnassigned(2);
    }
    return m_OrientFlip;
}

inline
void CRs_Base::C_E_MergeHistory::C_Attlist::SetOrientFlip(CRs_Base::C_E_MergeHistory::C_Attlist::TOrientFlip value)
{
    m_OrientFlip = value;
    m_set_State[0] |= 0x30;
}

inline
CRs_Base::C_E_MergeHistory::C_Attlist::TOrientFlip& CRs_Base::C_E_MergeHistory::C_Attlist::SetOrientFlip(void)
{
#ifdef _DEBUG
    if (!IsSetOrientFlip()) {
        memset(&m_OrientFlip,UnassignedByte(),sizeof(m_OrientFlip));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_OrientFlip;
}

inline
bool CRs_Base::C_E_MergeHistory::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::C_E_MergeHistory::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::C_E_MergeHistory::TAttlist& CRs_Base::C_E_MergeHistory::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_E_MergeHistory*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::C_E_MergeHistory::TAttlist& CRs_Base::C_E_MergeHistory::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::C_E_MergeHistory::IsSetMergeHistory(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_E_MergeHistory::CanGetMergeHistory(void) const
{
    return false;
}

inline
void CRs_Base::C_E_MergeHistory::ResetMergeHistory(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CRs_Base::C_E_MergeHistory::SetMergeHistory(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CRs_Base::C_E_AlleleOrigin::C_Attlist::IsSetAllele(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_E_AlleleOrigin::C_Attlist::CanGetAllele(void) const
{
    return IsSetAllele();
}

inline
const CRs_Base::C_E_AlleleOrigin::C_Attlist::TAllele& CRs_Base::C_E_AlleleOrigin::C_Attlist::GetAllele(void) const
{
    if (!CanGetAllele()) {
        ThrowUnassigned(0);
    }
    return m_Allele;
}

inline
void CRs_Base::C_E_AlleleOrigin::C_Attlist::SetAllele(const CRs_Base::C_E_AlleleOrigin::C_Attlist::TAllele& value)
{
    m_Allele = value;
    m_set_State[0] |= 0x3;
}

inline
void CRs_Base::C_E_AlleleOrigin::C_Attlist::SetAllele(CRs_Base::C_E_AlleleOrigin::C_Attlist::TAllele&& value)
{
    m_Allele = std::forward<CRs_Base::C_E_AlleleOrigin::C_Attlist::TAllele>(value);
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_E_AlleleOrigin::C_Attlist::TAllele& CRs_Base::C_E_AlleleOrigin::C_Attlist::SetAllele(void)
{
#ifdef _DEBUG
    if (!IsSetAllele()) {
        m_Allele = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Allele;
}

inline
bool CRs_Base::C_E_AlleleOrigin::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::C_E_AlleleOrigin::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::C_E_AlleleOrigin::TAttlist& CRs_Base::C_E_AlleleOrigin::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_E_AlleleOrigin*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::C_E_AlleleOrigin::TAttlist& CRs_Base::C_E_AlleleOrigin::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::C_E_AlleleOrigin::IsSetAlleleOrigin(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_E_AlleleOrigin::CanGetAlleleOrigin(void) const
{
    return IsSetAlleleOrigin();
}

inline
void CRs_Base::C_E_AlleleOrigin::ResetAlleleOrigin(void)
{
    m_AlleleOrigin = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRs_Base::C_E_AlleleOrigin::TAlleleOrigin CRs_Base::C_E_AlleleOrigin::GetAlleleOrigin(void) const
{
    if (!CanGetAlleleOrigin()) {
        ThrowUnassigned(1);
    }
    return m_AlleleOrigin;
}

inline
void CRs_Base::C_E_AlleleOrigin::SetAlleleOrigin(CRs_Base::C_E_AlleleOrigin::TAlleleOrigin value)
{
    m_AlleleOrigin = value;
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_E_AlleleOrigin::TAlleleOrigin& CRs_Base::C_E_AlleleOrigin::SetAlleleOrigin(void)
{
#ifdef _DEBUG
    if (!IsSetAlleleOrigin()) {
        memset(&m_AlleleOrigin,UnassignedByte(),sizeof(m_AlleleOrigin));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_AlleleOrigin;
}

inline
bool CRs_Base::C_E_Phenotype::IsSetClinicalSignificance(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_E_Phenotype::CanGetClinicalSignificance(void) const
{
    return true;
}

inline
const CRs_Base::C_E_Phenotype::TClinicalSignificance& CRs_Base::C_E_Phenotype::GetClinicalSignificance(void) const
{
    return m_ClinicalSignificance;
}

inline
CRs_Base::C_E_Phenotype::TClinicalSignificance& CRs_Base::C_E_Phenotype::SetClinicalSignificance(void)
{
    m_set_State[0] |= 0x1;
    return m_ClinicalSignificance;
}

inline
bool CRs_Base::C_E_BioSource::IsSetGenome(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_E_BioSource::CanGetGenome(void) const
{
    return true;
}

inline
const CRs_Base::C_E_BioSource::TGenome& CRs_Base::C_E_BioSource::GetGenome(void) const
{
    return m_Genome;
}

inline
CRs_Base::C_E_BioSource::TGenome& CRs_Base::C_E_BioSource::SetGenome(void)
{
    m_set_State[0] |= 0x1;
    return m_Genome;
}

inline
bool CRs_Base::C_E_BioSource::IsSetOrigin(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_E_BioSource::CanGetOrigin(void) const
{
    return true;
}

inline
const CRs_Base::C_E_BioSource::TOrigin& CRs_Base::C_E_BioSource::GetOrigin(void) const
{
    return m_Origin;
}

inline
CRs_Base::C_E_BioSource::TOrigin& CRs_Base::C_E_BioSource::SetOrigin(void)
{
    m_set_State[0] |= 0x4;
    return m_Origin;
}

inline
bool CRs_Base::C_E_Frequency::C_Attlist::IsSetFreq(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRs_Base::C_E_Frequency::C_Attlist::CanGetFreq(void) const
{
    return IsSetFreq();
}

inline
void CRs_Base::C_E_Frequency::C_Attlist::ResetFreq(void)
{
    m_Freq = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRs_Base::C_E_Frequency::C_Attlist::TFreq CRs_Base::C_E_Frequency::C_Attlist::GetFreq(void) const
{
    if (!CanGetFreq()) {
        ThrowUnassigned(0);
    }
    return m_Freq;
}

inline
void CRs_Base::C_E_Frequency::C_Attlist::SetFreq(CRs_Base::C_E_Frequency::C_Attlist::TFreq value)
{
    m_Freq = value;
    m_set_State[0] |= 0x3;
}

inline
CRs_Base::C_E_Frequency::C_Attlist::TFreq& CRs_Base::C_E_Frequency::C_Attlist::SetFreq(void)
{
#ifdef _DEBUG
    if (!IsSetFreq()) {
        memset(&m_Freq,UnassignedByte(),sizeof(m_Freq));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Freq;
}

inline
bool CRs_Base::C_E_Frequency::C_Attlist::IsSetAllele(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_E_Frequency::C_Attlist::CanGetAllele(void) const
{
    return IsSetAllele();
}

inline
const CRs_Base::C_E_Frequency::C_Attlist::TAllele& CRs_Base::C_E_Frequency::C_Attlist::GetAllele(void) const
{
    if (!CanGetAllele()) {
        ThrowUnassigned(1);
    }
    return m_Allele;
}

inline
void CRs_Base::C_E_Frequency::C_Attlist::SetAllele(const CRs_Base::C_E_Frequency::C_Attlist::TAllele& value)
{
    m_Allele = value;
    m_set_State[0] |= 0xc;
}

inline
void CRs_Base::C_E_Frequency::C_Attlist::SetAllele(CRs_Base::C_E_Frequency::C_Attlist::TAllele&& value)
{
    m_Allele = std::forward<CRs_Base::C_E_Frequency::C_Attlist::TAllele>(value);
    m_set_State[0] |= 0xc;
}

inline
CRs_Base::C_E_Frequency::C_Attlist::TAllele& CRs_Base::C_E_Frequency::C_Attlist::SetAllele(void)
{
#ifdef _DEBUG
    if (!IsSetAllele()) {
        m_Allele = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Allele;
}

inline
bool CRs_Base::C_E_Frequency::C_Attlist::IsSetPopId(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRs_Base::C_E_Frequency::C_Attlist::CanGetPopId(void) const
{
    return IsSetPopId();
}

inline
void CRs_Base::C_E_Frequency::C_Attlist::ResetPopId(void)
{
    m_PopId = 0;
    m_set_State[0] &= ~0x30;
}

inline
CRs_Base::C_E_Frequency::C_Attlist::TPopId CRs_Base::C_E_Frequency::C_Attlist::GetPopId(void) const
{
    if (!CanGetPopId()) {
        ThrowUnassigned(2);
    }
    return m_PopId;
}

inline
void CRs_Base::C_E_Frequency::C_Attlist::SetPopId(CRs_Base::C_E_Frequency::C_Attlist::TPopId value)
{
    m_PopId = value;
    m_set_State[0] |= 0x30;
}

inline
CRs_Base::C_E_Frequency::C_Attlist::TPopId& CRs_Base::C_E_Frequency::C_Attlist::SetPopId(void)
{
#ifdef _DEBUG
    if (!IsSetPopId()) {
        memset(&m_PopId,UnassignedByte(),sizeof(m_PopId));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_PopId;
}

inline
bool CRs_Base::C_E_Frequency::C_Attlist::IsSetSampleSize(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRs_Base::C_E_Frequency::C_Attlist::CanGetSampleSize(void) const
{
    return IsSetSampleSize();
}

inline
void CRs_Base::C_E_Frequency::C_Attlist::ResetSampleSize(void)
{
    m_SampleSize = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CRs_Base::C_E_Frequency::C_Attlist::TSampleSize CRs_Base::C_E_Frequency::C_Attlist::GetSampleSize(void) const
{
    if (!CanGetSampleSize()) {
        ThrowUnassigned(3);
    }
    return m_SampleSize;
}

inline
void CRs_Base::C_E_Frequency::C_Attlist::SetSampleSize(CRs_Base::C_E_Frequency::C_Attlist::TSampleSize value)
{
    m_SampleSize = value;
    m_set_State[0] |= 0xc0;
}

inline
CRs_Base::C_E_Frequency::C_Attlist::TSampleSize& CRs_Base::C_E_Frequency::C_Attlist::SetSampleSize(void)
{
#ifdef _DEBUG
    if (!IsSetSampleSize()) {
        memset(&m_SampleSize,UnassignedByte(),sizeof(m_SampleSize));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_SampleSize;
}

inline
bool CRs_Base::C_E_Frequency::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::C_E_Frequency::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::C_E_Frequency::TAttlist& CRs_Base::C_E_Frequency::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_E_Frequency*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::C_E_Frequency::TAttlist& CRs_Base::C_E_Frequency::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::C_E_Frequency::IsSetFrequency(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRs_Base::C_E_Frequency::CanGetFrequency(void) const
{
    return false;
}

inline
void CRs_Base::C_E_Frequency::ResetFrequency(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CRs_Base::C_E_Frequency::SetFrequency(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CRs_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRs_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CRs_Base::TAttlist& CRs_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CRs_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRs_Base::TAttlist& CRs_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRs_Base::IsSetHet(void) const
{
    return m_Het.NotEmpty();
}

inline
bool CRs_Base::CanGetHet(void) const
{
    return IsSetHet();
}

inline
const CRs_Base::THet& CRs_Base::GetHet(void) const
{
    if (!CanGetHet()) {
        ThrowUnassigned(1);
    }
    return (*m_Het);
}

inline
bool CRs_Base::IsSetValidation(void) const
{
    return m_Validation.NotEmpty();
}

inline
bool CRs_Base::CanGetValidation(void) const
{
    return true;
}

inline
const CRs_Base::TValidation& CRs_Base::GetValidation(void) const
{
    if ( !m_Validation ) {
        const_cast<CRs_Base*>(this)->ResetValidation();
    }
    return (*m_Validation);
}

inline
CRs_Base::TValidation& CRs_Base::SetValidation(void)
{
    if ( !m_Validation ) {
        ResetValidation();
    }
    return (*m_Validation);
}

inline
bool CRs_Base::IsSetCreate(void) const
{
    return m_Create.NotEmpty();
}

inline
bool CRs_Base::CanGetCreate(void) const
{
    return true;
}

inline
const CRs_Base::TCreate& CRs_Base::GetCreate(void) const
{
    if ( !m_Create ) {
        const_cast<CRs_Base*>(this)->ResetCreate();
    }
    return (*m_Create);
}

inline
CRs_Base::TCreate& CRs_Base::SetCreate(void)
{
    if ( !m_Create ) {
        ResetCreate();
    }
    return (*m_Create);
}

inline
bool CRs_Base::IsSetUpdate(void) const
{
    return m_Update.NotEmpty();
}

inline
bool CRs_Base::CanGetUpdate(void) const
{
    return IsSetUpdate();
}

inline
const CRs_Base::TUpdate& CRs_Base::GetUpdate(void) const
{
    if (!CanGetUpdate()) {
        ThrowUnassigned(4);
    }
    return (*m_Update);
}

inline
bool CRs_Base::IsSetSequence(void) const
{
    return m_Sequence.NotEmpty();
}

inline
bool CRs_Base::CanGetSequence(void) const
{
    return true;
}

inline
const CRs_Base::TSequence& CRs_Base::GetSequence(void) const
{
    if ( !m_Sequence ) {
        const_cast<CRs_Base*>(this)->ResetSequence();
    }
    return (*m_Sequence);
}

inline
CRs_Base::TSequence& CRs_Base::SetSequence(void)
{
    if ( !m_Sequence ) {
        ResetSequence();
    }
    return (*m_Sequence);
}

inline
bool CRs_Base::IsSetSs(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CRs_Base::CanGetSs(void) const
{
    return true;
}

inline
const CRs_Base::TSs& CRs_Base::GetSs(void) const
{
    return m_Ss;
}

inline
CRs_Base::TSs& CRs_Base::SetSs(void)
{
    m_set_State[0] |= 0x1000;
    return m_Ss;
}

inline
bool CRs_Base::IsSetAssembly(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CRs_Base::CanGetAssembly(void) const
{
    return true;
}

inline
const CRs_Base::TAssembly& CRs_Base::GetAssembly(void) const
{
    return m_Assembly;
}

inline
CRs_Base::TAssembly& CRs_Base::SetAssembly(void)
{
    m_set_State[0] |= 0x4000;
    return m_Assembly;
}

inline
bool CRs_Base::IsSetPrimarySequence(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CRs_Base::CanGetPrimarySequence(void) const
{
    return true;
}

inline
const CRs_Base::TPrimarySequence& CRs_Base::GetPrimarySequence(void) const
{
    return m_PrimarySequence;
}

inline
CRs_Base::TPrimarySequence& CRs_Base::SetPrimarySequence(void)
{
    m_set_State[0] |= 0x10000;
    return m_PrimarySequence;
}

inline
bool CRs_Base::IsSetRsStruct(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CRs_Base::CanGetRsStruct(void) const
{
    return true;
}

inline
const CRs_Base::TRsStruct& CRs_Base::GetRsStruct(void) const
{
    return m_RsStruct;
}

inline
CRs_Base::TRsStruct& CRs_Base::SetRsStruct(void)
{
    m_set_State[0] |= 0x40000;
    return m_RsStruct;
}

inline
bool CRs_Base::IsSetRsLinkout(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CRs_Base::CanGetRsLinkout(void) const
{
    return true;
}

inline
const CRs_Base::TRsLinkout& CRs_Base::GetRsLinkout(void) const
{
    return m_RsLinkout;
}

inline
CRs_Base::TRsLinkout& CRs_Base::SetRsLinkout(void)
{
    m_set_State[0] |= 0x100000;
    return m_RsLinkout;
}

inline
bool CRs_Base::IsSetMergeHistory(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CRs_Base::CanGetMergeHistory(void) const
{
    return true;
}

inline
const CRs_Base::TMergeHistory& CRs_Base::GetMergeHistory(void) const
{
    return m_MergeHistory;
}

inline
CRs_Base::TMergeHistory& CRs_Base::SetMergeHistory(void)
{
    m_set_State[0] |= 0x400000;
    return m_MergeHistory;
}

inline
bool CRs_Base::IsSetHgvs(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CRs_Base::CanGetHgvs(void) const
{
    return true;
}

inline
const CRs_Base::THgvs& CRs_Base::GetHgvs(void) const
{
    return m_Hgvs;
}

inline
CRs_Base::THgvs& CRs_Base::SetHgvs(void)
{
    m_set_State[0] |= 0x1000000;
    return m_Hgvs;
}

inline
bool CRs_Base::IsSetAlleleOrigin(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CRs_Base::CanGetAlleleOrigin(void) const
{
    return true;
}

inline
const CRs_Base::TAlleleOrigin& CRs_Base::GetAlleleOrigin(void) const
{
    return m_AlleleOrigin;
}

inline
CRs_Base::TAlleleOrigin& CRs_Base::SetAlleleOrigin(void)
{
    m_set_State[0] |= 0x4000000;
    return m_AlleleOrigin;
}

inline
bool CRs_Base::IsSetPhenotype(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CRs_Base::CanGetPhenotype(void) const
{
    return true;
}

inline
const CRs_Base::TPhenotype& CRs_Base::GetPhenotype(void) const
{
    return m_Phenotype;
}

inline
CRs_Base::TPhenotype& CRs_Base::SetPhenotype(void)
{
    m_set_State[0] |= 0x10000000;
    return m_Phenotype;
}

inline
bool CRs_Base::IsSetBioSource(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CRs_Base::CanGetBioSource(void) const
{
    return true;
}

inline
const CRs_Base::TBioSource& CRs_Base::GetBioSource(void) const
{
    return m_BioSource;
}

inline
CRs_Base::TBioSource& CRs_Base::SetBioSource(void)
{
    m_set_State[0] |= 0x40000000;
    return m_BioSource;
}

inline
bool CRs_Base::IsSetFrequency(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CRs_Base::CanGetFrequency(void) const
{
    return true;
}

inline
const CRs_Base::TFrequency& CRs_Base::GetFrequency(void) const
{
    return m_Frequency;
}

inline
CRs_Base::TFrequency& CRs_Base::SetFrequency(void)
{
    m_set_State[1] |= 0x1;
    return m_Frequency;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_RS_BASE_HPP
