/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Ss_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_SS_BASE_HPP
#define OBJECTS_DOCSUM_SS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///data for an individual submission to dbSNP
class NCBI_DOCSUM_EXPORT CSs_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSs_Base(void);
    // destructor
    virtual ~CSs_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        ///SubSNP classification by type of
        ///						variation
        enum EAttlist_subSnpClass {
            eAttlist_subSnpClass_snp                          = 1,
            eAttlist_subSnpClass_in_del                       = 2,
            eAttlist_subSnpClass_heterozygous                 = 3,
            eAttlist_subSnpClass_microsatellite               = 4,
            eAttlist_subSnpClass_named_locus                  = 5,
            eAttlist_subSnpClass_no_variation                 = 6,
            eAttlist_subSnpClass_mixed                        = 7,
            eAttlist_subSnpClass_multinucleotide_polymorphism = 8
        };
        
        /// Access to EAttlist_subSnpClass's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_subSnpClass)(void);
        
        ///orientation of refsnp cluster members to refsnp cluster
        ///						sequence
        enum EAttlist_orient {
            eAttlist_orient_forward = 1,
            eAttlist_orient_reverse = 2
        };
        
        /// Access to EAttlist_orient's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_orient)(void);
        
        ///strand is defined as TOP/BOTTOM by nature of flanking
        ///						nucleotide sequence
        enum EAttlist_strand {
            eAttlist_strand_top    = 1,
            eAttlist_strand_bottom = 2
        };
        
        /// Access to EAttlist_strand's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_strand)(void);
        
        enum EAttlist_molType {
            eAttlist_molType_genomic = 1,
            eAttlist_molType_cDNA    = 2,
            eAttlist_molType_mito    = 3,
            eAttlist_molType_chloro  = 4,
            eAttlist_molType_unknown = 5
        };
        
        /// Access to EAttlist_molType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_molType)(void);
        
        ///class of method used to assay for the
        ///						variation
        enum EAttlist_methodClass {
            eAttlist_methodClass_dHPLC     = 1,
            eAttlist_methodClass_hybridize = 2,
            eAttlist_methodClass_computed  = 3,
            eAttlist_methodClass_sSCP      = 4,
            eAttlist_methodClass_other     = 5,
            eAttlist_methodClass_unknown   = 6,
            eAttlist_methodClass_rFLP      = 7,
            eAttlist_methodClass_sequence  = 8
        };
        
        /// Access to EAttlist_methodClass's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_methodClass)(void);
        
        ///subsnp has been experimentally validated by
        ///									submitter
        enum EAttlist_validated {
            eAttlist_validated_by_submitter = 1,
            eAttlist_validated_by_frequency = 2,
            eAttlist_validated_by_cluster   = 3
        };
        
        /// Access to EAttlist_validated's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_validated)(void);
        
        // types
        typedef Int8 TSsId;
        typedef string THandle;
        typedef int TBatchId;
        typedef string TLocSnpId;
        typedef EAttlist_subSnpClass TSubSnpClass;
        typedef EAttlist_orient TOrient;
        typedef EAttlist_strand TStrand;
        typedef EAttlist_molType TMolType;
        typedef int TBuildId;
        typedef EAttlist_methodClass TMethodClass;
        typedef EAttlist_validated TValidated;
        typedef string TLinkoutUrl;
        typedef string TSsAlias;
        typedef int TAlleleOrigin;
        typedef string TClinicalSignificance;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_ssId,
            e_handle,
            e_batchId,
            e_locSnpId,
            e_subSnpClass,
            e_orient,
            e_strand,
            e_molType,
            e_buildId,
            e_methodClass,
            e_validated,
            e_linkoutUrl,
            e_ssAlias,
            e_alleleOrigin,
            e_clinicalSignificance
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 16> TmemberIndex;
    
        // getters
        // setters
    
        ///dbSNP accession number for submission
        /// mandatory
        /// typedef Int8 TSsId
        ///  Check whether the SsId data member has been assigned a value.
        bool IsSetSsId(void) const;
        /// Check whether it is safe or not to call GetSsId method.
        bool CanGetSsId(void) const;
        void ResetSsId(void);
        TSsId GetSsId(void) const;
        void SetSsId(TSsId value);
        TSsId& SetSsId(void);
    
        ///Tag for the submitting laboratory
        /// mandatory
        /// typedef string THandle
        ///  Check whether the Handle data member has been assigned a value.
        bool IsSetHandle(void) const;
        /// Check whether it is safe or not to call GetHandle method.
        bool CanGetHandle(void) const;
        void ResetHandle(void);
        const THandle& GetHandle(void) const;
        void SetHandle(const THandle& value);
        void SetHandle(THandle&& value);
        THandle& SetHandle(void);
    
        ///dbSNP number for batch submission
        /// mandatory
        /// typedef int TBatchId
        ///  Check whether the BatchId data member has been assigned a value.
        bool IsSetBatchId(void) const;
        /// Check whether it is safe or not to call GetBatchId method.
        bool CanGetBatchId(void) const;
        void ResetBatchId(void);
        TBatchId GetBatchId(void) const;
        void SetBatchId(TBatchId value);
        TBatchId& SetBatchId(void);
    
        ///submission (ss#) submitter ID
        /// optional
        /// typedef string TLocSnpId
        ///  Check whether the LocSnpId data member has been assigned a value.
        bool IsSetLocSnpId(void) const;
        /// Check whether it is safe or not to call GetLocSnpId method.
        bool CanGetLocSnpId(void) const;
        void ResetLocSnpId(void);
        const TLocSnpId& GetLocSnpId(void) const;
        void SetLocSnpId(const TLocSnpId& value);
        void SetLocSnpId(TLocSnpId&& value);
        TLocSnpId& SetLocSnpId(void);
    
        /// optional
        /// typedef EAttlist_subSnpClass TSubSnpClass
        ///  Check whether the SubSnpClass data member has been assigned a value.
        bool IsSetSubSnpClass(void) const;
        /// Check whether it is safe or not to call GetSubSnpClass method.
        bool CanGetSubSnpClass(void) const;
        void ResetSubSnpClass(void);
        TSubSnpClass GetSubSnpClass(void) const;
        void SetSubSnpClass(TSubSnpClass value);
        TSubSnpClass& SetSubSnpClass(void);
    
        /// optional
        /// typedef EAttlist_orient TOrient
        ///  Check whether the Orient data member has been assigned a value.
        bool IsSetOrient(void) const;
        /// Check whether it is safe or not to call GetOrient method.
        bool CanGetOrient(void) const;
        void ResetOrient(void);
        TOrient GetOrient(void) const;
        void SetOrient(TOrient value);
        TOrient& SetOrient(void);
    
        /// optional
        /// typedef EAttlist_strand TStrand
        ///  Check whether the Strand data member has been assigned a value.
        bool IsSetStrand(void) const;
        /// Check whether it is safe or not to call GetStrand method.
        bool CanGetStrand(void) const;
        void ResetStrand(void);
        TStrand GetStrand(void) const;
        void SetStrand(TStrand value);
        TStrand& SetStrand(void);
    
        ///moltype from Batch table
        /// optional
        /// typedef EAttlist_molType TMolType
        ///  Check whether the MolType data member has been assigned a value.
        bool IsSetMolType(void) const;
        /// Check whether it is safe or not to call GetMolType method.
        bool CanGetMolType(void) const;
        void ResetMolType(void);
        TMolType GetMolType(void) const;
        void SetMolType(TMolType value);
        TMolType& SetMolType(void);
    
        ///dbSNP build number when ss# was added to a refSNP (rs#)
        ///						cluster
        /// optional
        /// typedef int TBuildId
        ///  Check whether the BuildId data member has been assigned a value.
        bool IsSetBuildId(void) const;
        /// Check whether it is safe or not to call GetBuildId method.
        bool CanGetBuildId(void) const;
        void ResetBuildId(void);
        TBuildId GetBuildId(void) const;
        void SetBuildId(TBuildId value);
        TBuildId& SetBuildId(void);
    
        /// optional
        /// typedef EAttlist_methodClass TMethodClass
        ///  Check whether the MethodClass data member has been assigned a value.
        bool IsSetMethodClass(void) const;
        /// Check whether it is safe or not to call GetMethodClass method.
        bool CanGetMethodClass(void) const;
        void ResetMethodClass(void);
        TMethodClass GetMethodClass(void) const;
        void SetMethodClass(TMethodClass value);
        TMethodClass& SetMethodClass(void);
    
        /// optional
        /// typedef EAttlist_validated TValidated
        ///  Check whether the Validated data member has been assigned a value.
        bool IsSetValidated(void) const;
        /// Check whether it is safe or not to call GetValidated method.
        bool CanGetValidated(void) const;
        void ResetValidated(void);
        TValidated GetValidated(void) const;
        void SetValidated(TValidated value);
        TValidated& SetValidated(void);
    
        ///append loc-snp-id to this base URL to construct a pointer to
        ///						submitter data.
        /// optional
        /// typedef string TLinkoutUrl
        ///  Check whether the LinkoutUrl data member has been assigned a value.
        bool IsSetLinkoutUrl(void) const;
        /// Check whether it is safe or not to call GetLinkoutUrl method.
        bool CanGetLinkoutUrl(void) const;
        void ResetLinkoutUrl(void);
        const TLinkoutUrl& GetLinkoutUrl(void) const;
        void SetLinkoutUrl(const TLinkoutUrl& value);
        void SetLinkoutUrl(TLinkoutUrl&& value);
        TLinkoutUrl& SetLinkoutUrl(void);
    
        /// optional
        /// typedef string TSsAlias
        ///  Check whether the SsAlias data member has been assigned a value.
        bool IsSetSsAlias(void) const;
        /// Check whether it is safe or not to call GetSsAlias method.
        bool CanGetSsAlias(void) const;
        void ResetSsAlias(void);
        const TSsAlias& GetSsAlias(void) const;
        void SetSsAlias(const TSsAlias& value);
        void SetSsAlias(TSsAlias&& value);
        TSsAlias& SetSsAlias(void);
    
        ///				<xsd:simpleType>
        ///					<xsd:restriction base="xsd:string">
        ///						<xsd:enumeration value="unknown"/>
        ///						<xsd:enumeration value="germline"/>
        ///						<xsd:enumeration value="somatic"/>
        ///						<xsd:enumeration value="inherited"/>
        ///						<xsd:enumeration value="paternal"/>
        ///						<xsd:enumeration value="maternal"/>
        ///						<xsd:enumeration value="de-novo"/>
        ///						<xsd:enumeration value="other"/>
        ///					</xsd:restriction>
        ///				</xsd:simpleType>
        /// optional
        /// typedef int TAlleleOrigin
        ///  Check whether the AlleleOrigin data member has been assigned a value.
        bool IsSetAlleleOrigin(void) const;
        /// Check whether it is safe or not to call GetAlleleOrigin method.
        bool CanGetAlleleOrigin(void) const;
        void ResetAlleleOrigin(void);
        TAlleleOrigin GetAlleleOrigin(void) const;
        void SetAlleleOrigin(TAlleleOrigin value);
        TAlleleOrigin& SetAlleleOrigin(void);
    
        ///				<xsd:simpleType>
        ///					<xsd:restriction base="xsd:string">
        ///						<xsd:enumeration value="unknown"/>
        ///						<xsd:enumeration value="untested"/>
        ///						<xsd:enumeration value="non-pathogenic"/>
        ///						<xsd:enumeration value="probable-non-pathogenic"/>
        ///						<xsd:enumeration value="probable-pathogenic"/>
        ///						<xsd:enumeration value="pathogenic"/>
        ///						<xsd:enumeration value="other"/>
        ///					</xsd:restriction>
        ///				</xsd:simpleType>
        /// optional
        /// typedef string TClinicalSignificance
        ///  Check whether the ClinicalSignificance data member has been assigned a value.
        bool IsSetClinicalSignificance(void) const;
        /// Check whether it is safe or not to call GetClinicalSignificance method.
        bool CanGetClinicalSignificance(void) const;
        void ResetClinicalSignificance(void);
        const TClinicalSignificance& GetClinicalSignificance(void) const;
        void SetClinicalSignificance(const TClinicalSignificance& value);
        void SetClinicalSignificance(TClinicalSignificance&& value);
        TClinicalSignificance& SetClinicalSignificance(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        Int8 m_SsId;
        string m_Handle;
        int m_BatchId;
        string m_LocSnpId;
        EAttlist_subSnpClass m_SubSnpClass;
        EAttlist_orient m_Orient;
        EAttlist_strand m_Strand;
        EAttlist_molType m_MolType;
        int m_BuildId;
        EAttlist_methodClass m_MethodClass;
        EAttlist_validated m_Validated;
        string m_LinkoutUrl;
        string m_SsAlias;
        int m_AlleleOrigin;
        string m_ClinicalSignificance;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Sequence : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Sequence(void);
        // destructor
        ~C_Sequence(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef string TSeq5;
        typedef string TObserved;
        typedef string TSeq3;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_seq5,
            e_observed,
            e_seq3
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;
    
        // getters
        // setters
    
        ///5' sequence that flanks the
        ///										variation
        /// optional
        /// typedef string TSeq5
        ///  Check whether the Seq5 data member has been assigned a value.
        bool IsSetSeq5(void) const;
        /// Check whether it is safe or not to call GetSeq5 method.
        bool CanGetSeq5(void) const;
        void ResetSeq5(void);
        const TSeq5& GetSeq5(void) const;
        void SetSeq5(const TSeq5& value);
        void SetSeq5(TSeq5&& value);
        TSeq5& SetSeq5(void);
    
        ///list of all nucleotide alleles observed in
        ///										ss-list members, correcting for reverse complementation of
        ///										memebers reported in reverse orientation
        /// mandatory
        /// typedef string TObserved
        ///  Check whether the Observed data member has been assigned a value.
        bool IsSetObserved(void) const;
        /// Check whether it is safe or not to call GetObserved method.
        bool CanGetObserved(void) const;
        void ResetObserved(void);
        const TObserved& GetObserved(void) const;
        void SetObserved(const TObserved& value);
        void SetObserved(TObserved&& value);
        TObserved& SetObserved(void);
    
        ///3' sequence that flanks the
        ///										variation
        /// optional
        /// typedef string TSeq3
        ///  Check whether the Seq3 data member has been assigned a value.
        bool IsSetSeq3(void) const;
        /// Check whether it is safe or not to call GetSeq3 method.
        bool CanGetSeq3(void) const;
        void ResetSeq3(void);
        const TSeq3& GetSeq3(void) const;
        void SetSeq3(const TSeq3& value);
        void SetSeq3(TSeq3&& value);
        TSeq3& SetSeq3(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Sequence(const C_Sequence&);
        C_Sequence& operator=(const C_Sequence&);
    
        // data
        Uint4 m_set_State[1];
        string m_Seq5;
        string m_Observed;
        string m_Seq3;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_Sequence TSequence;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_sequence
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_Sequence TSequence
    ///  Check whether the Sequence data member has been assigned a value.
    bool IsSetSequence(void) const;
    /// Check whether it is safe or not to call GetSequence method.
    bool CanGetSequence(void) const;
    void ResetSequence(void);
    const TSequence& GetSequence(void) const;
    void SetSequence(TSequence& value);
    TSequence& SetSequence(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSs_Base(const CSs_Base&);
    CSs_Base& operator=(const CSs_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
    CRef< TSequence > m_Sequence;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSs_Base::C_Attlist::IsSetSsId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetSsId(void) const
{
    return IsSetSsId();
}

inline
void CSs_Base::C_Attlist::ResetSsId(void)
{
    m_SsId = 0;
    m_set_State[0] &= ~0x3;
}

inline
CSs_Base::C_Attlist::TSsId CSs_Base::C_Attlist::GetSsId(void) const
{
    if (!CanGetSsId()) {
        ThrowUnassigned(0);
    }
    return m_SsId;
}

inline
void CSs_Base::C_Attlist::SetSsId(CSs_Base::C_Attlist::TSsId value)
{
    m_SsId = value;
    m_set_State[0] |= 0x3;
}

inline
CSs_Base::C_Attlist::TSsId& CSs_Base::C_Attlist::SetSsId(void)
{
#ifdef _DEBUG
    if (!IsSetSsId()) {
        memset(&m_SsId,UnassignedByte(),sizeof(m_SsId));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_SsId;
}

inline
bool CSs_Base::C_Attlist::IsSetHandle(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetHandle(void) const
{
    return IsSetHandle();
}

inline
const CSs_Base::C_Attlist::THandle& CSs_Base::C_Attlist::GetHandle(void) const
{
    if (!CanGetHandle()) {
        ThrowUnassigned(1);
    }
    return m_Handle;
}

inline
void CSs_Base::C_Attlist::SetHandle(const CSs_Base::C_Attlist::THandle& value)
{
    m_Handle = value;
    m_set_State[0] |= 0xc;
}

inline
void CSs_Base::C_Attlist::SetHandle(CSs_Base::C_Attlist::THandle&& value)
{
    m_Handle = std::forward<CSs_Base::C_Attlist::THandle>(value);
    m_set_State[0] |= 0xc;
}

inline
CSs_Base::C_Attlist::THandle& CSs_Base::C_Attlist::SetHandle(void)
{
#ifdef _DEBUG
    if (!IsSetHandle()) {
        m_Handle = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Handle;
}

inline
bool CSs_Base::C_Attlist::IsSetBatchId(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetBatchId(void) const
{
    return IsSetBatchId();
}

inline
void CSs_Base::C_Attlist::ResetBatchId(void)
{
    m_BatchId = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSs_Base::C_Attlist::TBatchId CSs_Base::C_Attlist::GetBatchId(void) const
{
    if (!CanGetBatchId()) {
        ThrowUnassigned(2);
    }
    return m_BatchId;
}

inline
void CSs_Base::C_Attlist::SetBatchId(CSs_Base::C_Attlist::TBatchId value)
{
    m_BatchId = value;
    m_set_State[0] |= 0x30;
}

inline
CSs_Base::C_Attlist::TBatchId& CSs_Base::C_Attlist::SetBatchId(void)
{
#ifdef _DEBUG
    if (!IsSetBatchId()) {
        memset(&m_BatchId,UnassignedByte(),sizeof(m_BatchId));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_BatchId;
}

inline
bool CSs_Base::C_Attlist::IsSetLocSnpId(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetLocSnpId(void) const
{
    return IsSetLocSnpId();
}

inline
const CSs_Base::C_Attlist::TLocSnpId& CSs_Base::C_Attlist::GetLocSnpId(void) const
{
    if (!CanGetLocSnpId()) {
        ThrowUnassigned(3);
    }
    return m_LocSnpId;
}

inline
void CSs_Base::C_Attlist::SetLocSnpId(const CSs_Base::C_Attlist::TLocSnpId& value)
{
    m_LocSnpId = value;
    m_set_State[0] |= 0xc0;
}

inline
void CSs_Base::C_Attlist::SetLocSnpId(CSs_Base::C_Attlist::TLocSnpId&& value)
{
    m_LocSnpId = std::forward<CSs_Base::C_Attlist::TLocSnpId>(value);
    m_set_State[0] |= 0xc0;
}

inline
CSs_Base::C_Attlist::TLocSnpId& CSs_Base::C_Attlist::SetLocSnpId(void)
{
#ifdef _DEBUG
    if (!IsSetLocSnpId()) {
        m_LocSnpId = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_LocSnpId;
}

inline
bool CSs_Base::C_Attlist::IsSetSubSnpClass(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetSubSnpClass(void) const
{
    return IsSetSubSnpClass();
}

inline
void CSs_Base::C_Attlist::ResetSubSnpClass(void)
{
    m_SubSnpClass = (EAttlist_subSnpClass)(0);
    m_set_State[0] &= ~0x300;
}

inline
CSs_Base::C_Attlist::TSubSnpClass CSs_Base::C_Attlist::GetSubSnpClass(void) const
{
    if (!CanGetSubSnpClass()) {
        ThrowUnassigned(4);
    }
    return m_SubSnpClass;
}

inline
void CSs_Base::C_Attlist::SetSubSnpClass(CSs_Base::C_Attlist::TSubSnpClass value)
{
    m_SubSnpClass = value;
    m_set_State[0] |= 0x300;
}

inline
CSs_Base::C_Attlist::TSubSnpClass& CSs_Base::C_Attlist::SetSubSnpClass(void)
{
#ifdef _DEBUG
    if (!IsSetSubSnpClass()) {
        memset(&m_SubSnpClass,UnassignedByte(),sizeof(m_SubSnpClass));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_SubSnpClass;
}

inline
bool CSs_Base::C_Attlist::IsSetOrient(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetOrient(void) const
{
    return IsSetOrient();
}

inline
void CSs_Base::C_Attlist::ResetOrient(void)
{
    m_Orient = (EAttlist_orient)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CSs_Base::C_Attlist::TOrient CSs_Base::C_Attlist::GetOrient(void) const
{
    if (!CanGetOrient()) {
        ThrowUnassigned(5);
    }
    return m_Orient;
}

inline
void CSs_Base::C_Attlist::SetOrient(CSs_Base::C_Attlist::TOrient value)
{
    m_Orient = value;
    m_set_State[0] |= 0xc00;
}

inline
CSs_Base::C_Attlist::TOrient& CSs_Base::C_Attlist::SetOrient(void)
{
#ifdef _DEBUG
    if (!IsSetOrient()) {
        memset(&m_Orient,UnassignedByte(),sizeof(m_Orient));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Orient;
}

inline
bool CSs_Base::C_Attlist::IsSetStrand(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetStrand(void) const
{
    return IsSetStrand();
}

inline
void CSs_Base::C_Attlist::ResetStrand(void)
{
    m_Strand = (EAttlist_strand)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CSs_Base::C_Attlist::TStrand CSs_Base::C_Attlist::GetStrand(void) const
{
    if (!CanGetStrand()) {
        ThrowUnassigned(6);
    }
    return m_Strand;
}

inline
void CSs_Base::C_Attlist::SetStrand(CSs_Base::C_Attlist::TStrand value)
{
    m_Strand = value;
    m_set_State[0] |= 0x3000;
}

inline
CSs_Base::C_Attlist::TStrand& CSs_Base::C_Attlist::SetStrand(void)
{
#ifdef _DEBUG
    if (!IsSetStrand()) {
        memset(&m_Strand,UnassignedByte(),sizeof(m_Strand));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Strand;
}

inline
bool CSs_Base::C_Attlist::IsSetMolType(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetMolType(void) const
{
    return IsSetMolType();
}

inline
void CSs_Base::C_Attlist::ResetMolType(void)
{
    m_MolType = (EAttlist_molType)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CSs_Base::C_Attlist::TMolType CSs_Base::C_Attlist::GetMolType(void) const
{
    if (!CanGetMolType()) {
        ThrowUnassigned(7);
    }
    return m_MolType;
}

inline
void CSs_Base::C_Attlist::SetMolType(CSs_Base::C_Attlist::TMolType value)
{
    m_MolType = value;
    m_set_State[0] |= 0xc000;
}

inline
CSs_Base::C_Attlist::TMolType& CSs_Base::C_Attlist::SetMolType(void)
{
#ifdef _DEBUG
    if (!IsSetMolType()) {
        memset(&m_MolType,UnassignedByte(),sizeof(m_MolType));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_MolType;
}

inline
bool CSs_Base::C_Attlist::IsSetBuildId(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetBuildId(void) const
{
    return IsSetBuildId();
}

inline
void CSs_Base::C_Attlist::ResetBuildId(void)
{
    m_BuildId = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CSs_Base::C_Attlist::TBuildId CSs_Base::C_Attlist::GetBuildId(void) const
{
    if (!CanGetBuildId()) {
        ThrowUnassigned(8);
    }
    return m_BuildId;
}

inline
void CSs_Base::C_Attlist::SetBuildId(CSs_Base::C_Attlist::TBuildId value)
{
    m_BuildId = value;
    m_set_State[0] |= 0x30000;
}

inline
CSs_Base::C_Attlist::TBuildId& CSs_Base::C_Attlist::SetBuildId(void)
{
#ifdef _DEBUG
    if (!IsSetBuildId()) {
        memset(&m_BuildId,UnassignedByte(),sizeof(m_BuildId));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_BuildId;
}

inline
bool CSs_Base::C_Attlist::IsSetMethodClass(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetMethodClass(void) const
{
    return IsSetMethodClass();
}

inline
void CSs_Base::C_Attlist::ResetMethodClass(void)
{
    m_MethodClass = (EAttlist_methodClass)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CSs_Base::C_Attlist::TMethodClass CSs_Base::C_Attlist::GetMethodClass(void) const
{
    if (!CanGetMethodClass()) {
        ThrowUnassigned(9);
    }
    return m_MethodClass;
}

inline
void CSs_Base::C_Attlist::SetMethodClass(CSs_Base::C_Attlist::TMethodClass value)
{
    m_MethodClass = value;
    m_set_State[0] |= 0xc0000;
}

inline
CSs_Base::C_Attlist::TMethodClass& CSs_Base::C_Attlist::SetMethodClass(void)
{
#ifdef _DEBUG
    if (!IsSetMethodClass()) {
        memset(&m_MethodClass,UnassignedByte(),sizeof(m_MethodClass));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_MethodClass;
}

inline
bool CSs_Base::C_Attlist::IsSetValidated(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetValidated(void) const
{
    return IsSetValidated();
}

inline
void CSs_Base::C_Attlist::ResetValidated(void)
{
    m_Validated = (EAttlist_validated)(0);
    m_set_State[0] &= ~0x300000;
}

inline
CSs_Base::C_Attlist::TValidated CSs_Base::C_Attlist::GetValidated(void) const
{
    if (!CanGetValidated()) {
        ThrowUnassigned(10);
    }
    return m_Validated;
}

inline
void CSs_Base::C_Attlist::SetValidated(CSs_Base::C_Attlist::TValidated value)
{
    m_Validated = value;
    m_set_State[0] |= 0x300000;
}

inline
CSs_Base::C_Attlist::TValidated& CSs_Base::C_Attlist::SetValidated(void)
{
#ifdef _DEBUG
    if (!IsSetValidated()) {
        memset(&m_Validated,UnassignedByte(),sizeof(m_Validated));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Validated;
}

inline
bool CSs_Base::C_Attlist::IsSetLinkoutUrl(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetLinkoutUrl(void) const
{
    return IsSetLinkoutUrl();
}

inline
const CSs_Base::C_Attlist::TLinkoutUrl& CSs_Base::C_Attlist::GetLinkoutUrl(void) const
{
    if (!CanGetLinkoutUrl()) {
        ThrowUnassigned(11);
    }
    return m_LinkoutUrl;
}

inline
void CSs_Base::C_Attlist::SetLinkoutUrl(const CSs_Base::C_Attlist::TLinkoutUrl& value)
{
    m_LinkoutUrl = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CSs_Base::C_Attlist::SetLinkoutUrl(CSs_Base::C_Attlist::TLinkoutUrl&& value)
{
    m_LinkoutUrl = std::forward<CSs_Base::C_Attlist::TLinkoutUrl>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CSs_Base::C_Attlist::TLinkoutUrl& CSs_Base::C_Attlist::SetLinkoutUrl(void)
{
#ifdef _DEBUG
    if (!IsSetLinkoutUrl()) {
        m_LinkoutUrl = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_LinkoutUrl;
}

inline
bool CSs_Base::C_Attlist::IsSetSsAlias(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetSsAlias(void) const
{
    return IsSetSsAlias();
}

inline
const CSs_Base::C_Attlist::TSsAlias& CSs_Base::C_Attlist::GetSsAlias(void) const
{
    if (!CanGetSsAlias()) {
        ThrowUnassigned(12);
    }
    return m_SsAlias;
}

inline
void CSs_Base::C_Attlist::SetSsAlias(const CSs_Base::C_Attlist::TSsAlias& value)
{
    m_SsAlias = value;
    m_set_State[0] |= 0x3000000;
}

inline
void CSs_Base::C_Attlist::SetSsAlias(CSs_Base::C_Attlist::TSsAlias&& value)
{
    m_SsAlias = std::forward<CSs_Base::C_Attlist::TSsAlias>(value);
    m_set_State[0] |= 0x3000000;
}

inline
CSs_Base::C_Attlist::TSsAlias& CSs_Base::C_Attlist::SetSsAlias(void)
{
#ifdef _DEBUG
    if (!IsSetSsAlias()) {
        m_SsAlias = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_SsAlias;
}

inline
bool CSs_Base::C_Attlist::IsSetAlleleOrigin(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetAlleleOrigin(void) const
{
    return IsSetAlleleOrigin();
}

inline
void CSs_Base::C_Attlist::ResetAlleleOrigin(void)
{
    m_AlleleOrigin = 0;
    m_set_State[0] &= ~0xc000000;
}

inline
CSs_Base::C_Attlist::TAlleleOrigin CSs_Base::C_Attlist::GetAlleleOrigin(void) const
{
    if (!CanGetAlleleOrigin()) {
        ThrowUnassigned(13);
    }
    return m_AlleleOrigin;
}

inline
void CSs_Base::C_Attlist::SetAlleleOrigin(CSs_Base::C_Attlist::TAlleleOrigin value)
{
    m_AlleleOrigin = value;
    m_set_State[0] |= 0xc000000;
}

inline
CSs_Base::C_Attlist::TAlleleOrigin& CSs_Base::C_Attlist::SetAlleleOrigin(void)
{
#ifdef _DEBUG
    if (!IsSetAlleleOrigin()) {
        memset(&m_AlleleOrigin,UnassignedByte(),sizeof(m_AlleleOrigin));
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_AlleleOrigin;
}

inline
bool CSs_Base::C_Attlist::IsSetClinicalSignificance(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CSs_Base::C_Attlist::CanGetClinicalSignificance(void) const
{
    return IsSetClinicalSignificance();
}

inline
const CSs_Base::C_Attlist::TClinicalSignificance& CSs_Base::C_Attlist::GetClinicalSignificance(void) const
{
    if (!CanGetClinicalSignificance()) {
        ThrowUnassigned(14);
    }
    return m_ClinicalSignificance;
}

inline
void CSs_Base::C_Attlist::SetClinicalSignificance(const CSs_Base::C_Attlist::TClinicalSignificance& value)
{
    m_ClinicalSignificance = value;
    m_set_State[0] |= 0x30000000;
}

inline
void CSs_Base::C_Attlist::SetClinicalSignificance(CSs_Base::C_Attlist::TClinicalSignificance&& value)
{
    m_ClinicalSignificance = std::forward<CSs_Base::C_Attlist::TClinicalSignificance>(value);
    m_set_State[0] |= 0x30000000;
}

inline
CSs_Base::C_Attlist::TClinicalSignificance& CSs_Base::C_Attlist::SetClinicalSignificance(void)
{
#ifdef _DEBUG
    if (!IsSetClinicalSignificance()) {
        m_ClinicalSignificance = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_ClinicalSignificance;
}

inline
bool CSs_Base::C_Sequence::IsSetSeq5(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSs_Base::C_Sequence::CanGetSeq5(void) const
{
    return IsSetSeq5();
}

inline
const CSs_Base::C_Sequence::TSeq5& CSs_Base::C_Sequence::GetSeq5(void) const
{
    if (!CanGetSeq5()) {
        ThrowUnassigned(0);
    }
    return m_Seq5;
}

inline
void CSs_Base::C_Sequence::SetSeq5(const CSs_Base::C_Sequence::TSeq5& value)
{
    m_Seq5 = value;
    m_set_State[0] |= 0x3;
}

inline
void CSs_Base::C_Sequence::SetSeq5(CSs_Base::C_Sequence::TSeq5&& value)
{
    m_Seq5 = std::forward<CSs_Base::C_Sequence::TSeq5>(value);
    m_set_State[0] |= 0x3;
}

inline
CSs_Base::C_Sequence::TSeq5& CSs_Base::C_Sequence::SetSeq5(void)
{
#ifdef _DEBUG
    if (!IsSetSeq5()) {
        m_Seq5 = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Seq5;
}

inline
bool CSs_Base::C_Sequence::IsSetObserved(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSs_Base::C_Sequence::CanGetObserved(void) const
{
    return IsSetObserved();
}

inline
const CSs_Base::C_Sequence::TObserved& CSs_Base::C_Sequence::GetObserved(void) const
{
    if (!CanGetObserved()) {
        ThrowUnassigned(1);
    }
    return m_Observed;
}

inline
void CSs_Base::C_Sequence::SetObserved(const CSs_Base::C_Sequence::TObserved& value)
{
    m_Observed = value;
    m_set_State[0] |= 0xc;
}

inline
void CSs_Base::C_Sequence::SetObserved(CSs_Base::C_Sequence::TObserved&& value)
{
    m_Observed = std::forward<CSs_Base::C_Sequence::TObserved>(value);
    m_set_State[0] |= 0xc;
}

inline
CSs_Base::C_Sequence::TObserved& CSs_Base::C_Sequence::SetObserved(void)
{
#ifdef _DEBUG
    if (!IsSetObserved()) {
        m_Observed = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Observed;
}

inline
bool CSs_Base::C_Sequence::IsSetSeq3(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSs_Base::C_Sequence::CanGetSeq3(void) const
{
    return IsSetSeq3();
}

inline
const CSs_Base::C_Sequence::TSeq3& CSs_Base::C_Sequence::GetSeq3(void) const
{
    if (!CanGetSeq3()) {
        ThrowUnassigned(2);
    }
    return m_Seq3;
}

inline
void CSs_Base::C_Sequence::SetSeq3(const CSs_Base::C_Sequence::TSeq3& value)
{
    m_Seq3 = value;
    m_set_State[0] |= 0x30;
}

inline
void CSs_Base::C_Sequence::SetSeq3(CSs_Base::C_Sequence::TSeq3&& value)
{
    m_Seq3 = std::forward<CSs_Base::C_Sequence::TSeq3>(value);
    m_set_State[0] |= 0x30;
}

inline
CSs_Base::C_Sequence::TSeq3& CSs_Base::C_Sequence::SetSeq3(void)
{
#ifdef _DEBUG
    if (!IsSetSeq3()) {
        m_Seq3 = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Seq3;
}

inline
bool CSs_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CSs_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CSs_Base::TAttlist& CSs_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CSs_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CSs_Base::TAttlist& CSs_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CSs_Base::IsSetSequence(void) const
{
    return m_Sequence.NotEmpty();
}

inline
bool CSs_Base::CanGetSequence(void) const
{
    return true;
}

inline
const CSs_Base::TSequence& CSs_Base::GetSequence(void) const
{
    if ( !m_Sequence ) {
        const_cast<CSs_Base*>(this)->ResetSequence();
    }
    return (*m_Sequence);
}

inline
CSs_Base::TSequence& CSs_Base::SetSequence(void)
{
    if ( !m_Sequence ) {
        ResetSequence();
    }
    return (*m_Sequence);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_SS_BASE_HPP
